/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.objects;

import jpcsp.GUI.UmdVideoPlayer;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.interpreter.VSMXArray;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNumber;
import jpcsp.format.rco.vsmx.interpreter.VSMXObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXString;
import jpcsp.format.rco.vsmx.interpreter.VSMXUndefined;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;
import jpcsp.format.rco.vsmx.objects.Controller;
import org.apache.log4j.Logger;

public class MoviePlayer
extends BaseNativeObject {
    public static final int DEFAULT_WIDTH = 854;
    public static final int DEFAULT_HEIGHT = 480;
    private static final Logger log = VSMX.log;
    public static final String objectName = "movieplayer";
    private VSMXInterpreter interpreter;
    private UmdVideoPlayer umdVideoPlayer;
    private VSMXNativeObject controller;
    private boolean playing = false;
    private boolean menuMode;
    private int playListNumber;
    private int chapterNumber;
    private int videoNumber;
    private int audioNumber;
    private int audioFlag;
    private int subtitleNumber;
    private int subtitleFlag;
    private int width = 854;
    private int height = 480;
    private int x;
    private int y;

    public static VSMXNativeObject create(VSMXInterpreter interpreter, UmdVideoPlayer umdVideoPlayer, VSMXNativeObject controller) {
        MoviePlayer moviePlayer = new MoviePlayer(interpreter, umdVideoPlayer, controller);
        VSMXNativeObject object = new VSMXNativeObject(interpreter, moviePlayer);
        moviePlayer.setObject(object);
        object.setPropertyValue("audioLanguageCode", (VSMXBaseObject)new VSMXString(interpreter, "en"));
        object.setPropertyValue("subtitleLanguageCode", (VSMXBaseObject)new VSMXString(interpreter, "en"));
        return object;
    }

    private MoviePlayer(VSMXInterpreter interpreter, UmdVideoPlayer umdVideoPlayer, VSMXNativeObject controller) {
        this.interpreter = interpreter;
        this.umdVideoPlayer = umdVideoPlayer;
        this.controller = controller;
        if (umdVideoPlayer != null) {
            umdVideoPlayer.setMoviePlayer(this);
        }
    }

    public void play(VSMXBaseObject object, VSMXBaseObject pauseMode, VSMXBaseObject menuMode, VSMXBaseObject playListNumber, VSMXBaseObject chapterNumber, VSMXBaseObject videoNumber, VSMXBaseObject audioNumber, VSMXBaseObject audioFlag, VSMXBaseObject subtitleNumber, VSMXBaseObject subtitleFlag, VSMXBaseObject unknownBool) {
        VSMXBaseObject callback;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MoviePlayer.play pauseMode=%d, menuMode=%d, playListNumber=%d, chapterNumber=%d, videoNumber=0x%X, audioNumber=0x%X, audioFlag=0x%X, subtitleNumber=%d, subtitleFlag=0x%X, unknownBool=%b", pauseMode.getIntValue(), menuMode.getIntValue(), playListNumber.getIntValue(), chapterNumber.getIntValue(), videoNumber.getIntValue(), audioNumber.getIntValue(), audioFlag.getIntValue(), subtitleNumber.getIntValue(), subtitleFlag.getIntValue(), unknownBool.getBooleanValue()));
        }
        this.playing = true;
        boolean previousMenuMode = this.menuMode;
        this.menuMode = menuMode.getBooleanValue();
        this.playListNumber = playListNumber.getIntValue();
        this.chapterNumber = chapterNumber.getIntValue();
        this.videoNumber = videoNumber.getIntValue();
        this.audioNumber = audioNumber.getIntValue();
        this.audioFlag = audioFlag.getIntValue();
        this.subtitleNumber = subtitleNumber.getIntValue();
        this.subtitleFlag = subtitleFlag.getIntValue();
        if (this.umdVideoPlayer != null) {
            this.umdVideoPlayer.play(this.playListNumber, this.chapterNumber, this.videoNumber, this.audioNumber, this.audioFlag, this.subtitleNumber, this.subtitleFlag);
        }
        if (!previousMenuMode && this.menuMode && (callback = this.controller.getPropertyValue("onMenu")) instanceof VSMXFunction) {
            VSMXBaseObject[] arguments = new VSMXBaseObject[]{};
            this.interpreter.interpretFunction((VSMXFunction)callback, null, arguments);
        }
    }

    public void stop(VSMXBaseObject object, VSMXBaseObject unknownInt, VSMXBaseObject unknownBool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MoviePlayer.stop unknownInt=%d, unknownBool=%b", unknownInt.getIntValue(), unknownBool.getBooleanValue()));
        }
        this.playing = false;
    }

    public void resume(VSMXBaseObject object) {
        this.playing = true;
    }

    public VSMXBaseObject getResumeInfo(VSMXBaseObject object) {
        VSMXBaseObject resumeInfo;
        if (this.playing) {
            resumeInfo = new VSMXObject(this.interpreter, "ResumeInfo");
            resumeInfo.setPropertyValue("playListNumber", (VSMXBaseObject)new VSMXNumber(this.interpreter, this.playListNumber));
        } else {
            resumeInfo = VSMXUndefined.singleton;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MoviePlayer.getResumeInfo() returning %s", resumeInfo));
        }
        return resumeInfo;
    }

    public void changeResumeInfo(VSMXBaseObject object, VSMXBaseObject videoNumber, VSMXBaseObject audioNumber, VSMXBaseObject audioFlag, VSMXBaseObject subtitleNumber, VSMXBaseObject subtitleFlag) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MoviePlayer.changeResumeInfo videoNumber=0x%X, audioNumber=0x%X, audioFlag=0x%X, subtitleNumber=%d, subtitleFlag=0x%X", videoNumber.getIntValue(), audioNumber.getIntValue(), audioFlag.getIntValue(), subtitleNumber.getIntValue(), subtitleFlag.getIntValue()));
        }
        this.videoNumber = videoNumber.getIntValue();
        this.audioNumber = audioNumber.getIntValue();
        this.audioFlag = audioFlag.getIntValue();
        this.subtitleNumber = subtitleNumber.getIntValue();
        this.subtitleFlag = subtitleFlag.getIntValue();
    }

    public VSMXBaseObject getPlayerStatus(VSMXBaseObject object) {
        VSMXBaseObject playerStatus;
        if (this.playing) {
            playerStatus = new VSMXObject(this.interpreter, "PlayerStatus");
            playerStatus.setPropertyValue("playListNumber", (VSMXBaseObject)new VSMXNumber(this.interpreter, this.playListNumber));
            playerStatus.setPropertyValue("chapterNumber", (VSMXBaseObject)new VSMXNumber(this.interpreter, this.chapterNumber));
            playerStatus.setPropertyValue("videoNumber", (VSMXBaseObject)new VSMXNumber(this.interpreter, this.videoNumber));
            playerStatus.setPropertyValue("audioNumber", (VSMXBaseObject)new VSMXNumber(this.interpreter, this.audioNumber));
            playerStatus.setPropertyValue("audioFlag", (VSMXBaseObject)new VSMXNumber(this.interpreter, this.audioFlag));
            playerStatus.setPropertyValue("subtitleNumber", (VSMXBaseObject)new VSMXNumber(this.interpreter, this.subtitleNumber));
            playerStatus.setPropertyValue("subtitleFlag", (VSMXBaseObject)new VSMXNumber(this.interpreter, this.subtitleFlag));
        } else {
            playerStatus = VSMXUndefined.singleton;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MoviePlayer.getPlayerStatus() returning %s", playerStatus));
        }
        return playerStatus;
    }

    public void onPlayListEnd(int playListNumber) {
        VSMXBaseObject callback;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MoviePlayer.onPlayListEnd playListNumber=%d", playListNumber));
        }
        if ((callback = this.getObject().getPropertyValue("onPlayListEnd")) instanceof VSMXFunction) {
            VSMXObject argument = new VSMXObject(this.interpreter, null);
            ((VSMXBaseObject)argument).setPropertyValue("playListNumber", (VSMXBaseObject)new VSMXNumber(this.interpreter, playListNumber));
            VSMXBaseObject[] arguments = new VSMXBaseObject[]{argument};
            this.interpreter.interpretFunction((VSMXFunction)callback, null, arguments);
        }
    }

    public void onChapter(int chapterNumber) {
        VSMXBaseObject callback;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MoviePlayer.onChapter chapterNumber=%d", chapterNumber));
        }
        if ((callback = this.getObject().getPropertyValue("onChapter")) instanceof VSMXFunction) {
            VSMXObject argument = new VSMXObject(this.interpreter, null);
            ((VSMXBaseObject)argument).setPropertyValue("chapterNumber", (VSMXBaseObject)new VSMXNumber(this.interpreter, chapterNumber));
            VSMXBaseObject[] arguments = new VSMXBaseObject[]{argument};
            this.interpreter.interpretFunction((VSMXFunction)callback, null, arguments);
        }
    }

    public VSMXBaseObject getSize(VSMXBaseObject object) {
        VSMXInterpreter interpreter = object.getInterpreter();
        VSMXArray size = new VSMXArray(interpreter, 2);
        size.setPropertyValue(0, (VSMXBaseObject)new VSMXNumber(interpreter, this.width));
        size.setPropertyValue(1, (VSMXBaseObject)new VSMXNumber(interpreter, this.height));
        return size;
    }

    public void setSize(VSMXBaseObject object, VSMXBaseObject width, VSMXBaseObject height) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MoviePlayer.setSize(%s, %s)", width, height));
        }
        this.width = width.getIntValue();
        this.height = height.getIntValue();
    }

    public VSMXBaseObject getPos(VSMXBaseObject object) {
        VSMXInterpreter interpreter = object.getInterpreter();
        VSMXArray pos = new VSMXArray(interpreter, 2);
        pos.setPropertyValue(0, (VSMXBaseObject)new VSMXNumber(interpreter, this.x));
        pos.setPropertyValue(1, (VSMXBaseObject)new VSMXNumber(interpreter, this.y));
        return pos;
    }

    public void setPos(VSMXBaseObject object, VSMXBaseObject x, VSMXBaseObject y) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MoviePlayer.setPos(%s, %s)", x, y));
        }
        this.x = x.getIntValue();
        this.y = y.getIntValue();
    }

    public void onUp() {
        ((Controller)this.controller.getObject()).onUp();
    }

    public void onDown() {
        ((Controller)this.controller.getObject()).onDown();
    }

    public void onLeft() {
        ((Controller)this.controller.getObject()).onLeft();
    }

    public void onRight() {
        ((Controller)this.controller.getObject()).onRight();
    }

    public void onPush() {
        ((Controller)this.controller.getObject()).onPush();
    }
}

