/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.util.Utilities;

public class PixelColor {
    public static final int ONE = 255;
    public static final int ZERO = 0;
    private static final int[][] preMultiply;
    private static final int[] preClamp;

    public static final int getAlpha(int color) {
        return color >>> 24;
    }

    public static final int getRed(int color) {
        return color & 0xFF;
    }

    public static final int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static final int getBlue(int color) {
        return color >> 16 & 0xFF;
    }

    public static final int getColor(float[] color) {
        return PixelColor.getColor(PixelColor.getColor(color[3]), PixelColor.getColor(color[2]), PixelColor.getColor(color[1]), PixelColor.getColor(color[0]));
    }

    public static final int getColor(int[] color) {
        return PixelColor.getColor(color[3], color[2], color[1], color[0]);
    }

    public static final int getColorBGR(int[] color) {
        return PixelColor.getColorBGR(color[2], color[1], color[0]);
    }

    public static final int getColor(float color) {
        return (int)(color * 255.0f);
    }

    public static final int getColor(int a, int b, int g, int r) {
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static final int getColorBGR(int b, int g, int r) {
        return b << 16 | g << 8 | r;
    }

    public static final int multiplyComponent(int component1, int component2) {
        return preMultiply[component1][component2];
    }

    public static final int multiply(int color1, int a2, int b2, int g2, int r2) {
        int a = PixelColor.multiplyComponent(PixelColor.getAlpha(color1), a2);
        int b = PixelColor.multiplyComponent(PixelColor.getBlue(color1), b2);
        int g = PixelColor.multiplyComponent(PixelColor.getGreen(color1), g2);
        int r = PixelColor.multiplyComponent(PixelColor.getRed(color1), r2);
        return PixelColor.getColor(a, b, g, r);
    }

    public static final int multiplyBGR(int color1, int b2, int g2, int r2) {
        int b = PixelColor.multiplyComponent(PixelColor.getBlue(color1), b2);
        int g = PixelColor.multiplyComponent(PixelColor.getGreen(color1), g2);
        int r = PixelColor.multiplyComponent(PixelColor.getRed(color1), r2);
        return PixelColor.getColorBGR(b, g, r);
    }

    public static final int multiply(int color1, int color2) {
        switch (color2) {
            case 0: {
                return 0;
            }
            case 0xFFFFFF: {
                return color1 & color2;
            }
            case -1: {
                return color1;
            }
        }
        switch (color1) {
            case 0: {
                return 0;
            }
            case 0xFFFFFF: {
                return color1 & color2;
            }
            case -1: {
                return color2;
            }
        }
        return PixelColor.multiply(color1, PixelColor.getAlpha(color2), PixelColor.getBlue(color2), PixelColor.getGreen(color2), PixelColor.getRed(color2));
    }

    public static final int multiplyBGR(int color1, int color2) {
        if ((color1 &= 0xFFFFFF) == 0 || (color2 &= 0xFFFFFF) == 0) {
            return 0;
        }
        if (color1 == 0xFFFFFF) {
            return color2;
        }
        if (color2 == 0xFFFFFF) {
            return color1;
        }
        return PixelColor.multiplyBGR(color1, PixelColor.getBlue(color2), PixelColor.getGreen(color2), PixelColor.getRed(color2));
    }

    public static final int multiplyBGR(int color, float factor) {
        if ((color &= 0xFFFFFF) == 0 || factor <= 0.0f) {
            return 0;
        }
        if (factor == 1.0f) {
            return color;
        }
        int b = PixelColor.multiplyComponent(PixelColor.getBlue(color), factor);
        int g = PixelColor.multiplyComponent(PixelColor.getGreen(color), factor);
        int r = PixelColor.multiplyComponent(PixelColor.getRed(color), factor);
        return PixelColor.getColorBGR(b, g, r);
    }

    public static final int multiply(int color, float factor) {
        if (color == 0 || factor <= 0.0f) {
            return 0;
        }
        if (factor == 1.0f) {
            return color;
        }
        if (factor == 0.5f) {
            return PixelColor.divideBy2(color);
        }
        if (factor == 0.25f) {
            return PixelColor.divideBy4(color);
        }
        int a = PixelColor.multiplyComponent(PixelColor.getAlpha(color), factor);
        int b = PixelColor.multiplyComponent(PixelColor.getBlue(color), factor);
        int g = PixelColor.multiplyComponent(PixelColor.getGreen(color), factor);
        int r = PixelColor.multiplyComponent(PixelColor.getRed(color), factor);
        return PixelColor.getColor(a, b, g, r);
    }

    public static final int multiplyComponent(int component, float factor) {
        return Math.max(0, Math.min(255, Utilities.round((float)component * factor)));
    }

    public static final int addComponent(int component1, int component2) {
        return preClamp[component1 + component2];
    }

    public static final int add(int color1, int color2) {
        if (color1 == 0) {
            return color2;
        }
        if (color2 == 0) {
            return color1;
        }
        if (color1 == -1 || color2 == -1) {
            return -1;
        }
        int a = PixelColor.addComponent(PixelColor.getAlpha(color1), PixelColor.getAlpha(color2));
        int b = PixelColor.addComponent(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = PixelColor.addComponent(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = PixelColor.addComponent(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColor(a, b, g, r);
    }

    public static final int addBGR(int color1, int color2) {
        color2 &= 0xFFFFFF;
        if ((color1 &= 0xFFFFFF) == 0) {
            return color2;
        }
        if (color2 == 0) {
            return color1;
        }
        if (color1 == 0xFFFFFF || color2 == 0xFFFFFF) {
            return 0xFFFFFF;
        }
        int b = PixelColor.addComponent(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = PixelColor.addComponent(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = PixelColor.addComponent(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColorBGR(b, g, r);
    }

    public static final int substractComponent(int component1, int component2) {
        return Math.max(component1 - component2, 0);
    }

    public static final int substract(int color1, int color2) {
        int a = PixelColor.substractComponent(PixelColor.getAlpha(color1), PixelColor.getAlpha(color2));
        int b = PixelColor.substractComponent(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = PixelColor.substractComponent(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = PixelColor.substractComponent(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColor(a, b, g, r);
    }

    public static final int substractBGR(int color1, int color2) {
        int b = PixelColor.substractComponent(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = PixelColor.substractComponent(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = PixelColor.substractComponent(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColorBGR(b, g, r);
    }

    public static final int min(int color1, int color2) {
        int a = Math.min(PixelColor.getAlpha(color1), PixelColor.getAlpha(color2));
        int b = Math.min(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = Math.min(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = Math.min(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColor(a, b, g, r);
    }

    public static final int minBGR(int color1, int color2) {
        int b = Math.min(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = Math.min(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = Math.min(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColorBGR(b, g, r);
    }

    public static final int max(int color1, int color2) {
        int a = Math.max(PixelColor.getAlpha(color1), PixelColor.getAlpha(color2));
        int b = Math.max(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = Math.max(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = Math.max(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColor(a, b, g, r);
    }

    public static final int maxBGR(int color1, int color2) {
        int b = Math.max(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = Math.max(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = Math.max(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColorBGR(b, g, r);
    }

    private static final int absComponent(int component1, int component2) {
        if (component1 >= component2) {
            return component1 - component2;
        }
        return component2 - component1;
    }

    public static final int abs(int color1, int color2) {
        int a = PixelColor.absComponent(PixelColor.getAlpha(color1), PixelColor.getAlpha(color2));
        int b = PixelColor.absComponent(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = PixelColor.absComponent(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = PixelColor.absComponent(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColor(a, b, g, r);
    }

    public static final int absBGR(int color1, int color2) {
        int b = PixelColor.absComponent(PixelColor.getBlue(color1), PixelColor.getBlue(color2));
        int g = PixelColor.absComponent(PixelColor.getGreen(color1), PixelColor.getGreen(color2));
        int r = PixelColor.absComponent(PixelColor.getRed(color1), PixelColor.getRed(color2));
        return PixelColor.getColorBGR(b, g, r);
    }

    public static final int combineComponent(int component1, int component2, int factor) {
        return ((255 - factor) * component1 + factor * component2) / 255;
    }

    public static final int setAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static final int setBGR(int color, int bgr) {
        return color & 0xFF000000 | bgr;
    }

    public static final int doubleColor(int color) {
        return PixelColor.addBGR(color, color) | color & 0xFF000000;
    }

    public static final int doubleComponent(int component) {
        return PixelColor.addComponent(component, component);
    }

    public static final int divideBy2(int color) {
        return color >>> 1 & 0x7F7F7F7F;
    }

    public static final int divideBy4(int color) {
        return color >>> 2 & 0x3F3F3F3F;
    }

    static {
        int c1;
        preMultiply = new int[256][256];
        preClamp = new int[511];
        for (c1 = 0; c1 <= 255; ++c1) {
            for (int c2 = 0; c2 <= 255; ++c2) {
                PixelColor.preMultiply[c1][c2] = c1 * c2 / 255;
            }
        }
        for (c1 = 0; c1 < preClamp.length; ++c1) {
            PixelColor.preClamp[c1] = Math.min(c1, 255);
        }
    }
}

