/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import jpcsp.Emulator;
import org.apache.log4j.Logger;

public class Model {
    public static Logger log = Emulator.log;
    public static final int MODEL_PSP_FAT = 0;
    public static final int MODEL_PSP_SLIM = 1;
    public static final int MODEL_PSP_BRITE = 2;
    public static final int MODEL_PSP_BRITE2 = 3;
    public static final int MODEL_PSP_GO = 4;
    public static final int MODEL_PSP_BRITE3 = 5;
    public static final int MODEL_PSP_BRITE4 = 6;
    public static final int MODEL_PSP_STREET = 7;
    private static int model = 0;
    private static final ModelDescriptor[] modelDescriptors = new ModelDescriptor[8];

    public static int getModel() {
        return model;
    }

    public static void setModel(int model) {
        Model.model = model;
    }

    public static String getModelName(int model) {
        return Model.modelDescriptors[model].modelName;
    }

    public static String getModelName() {
        return Model.getModelName(model);
    }

    public static int getGeneration() {
        return Model.modelDescriptors[Model.model].generation;
    }

    public static int getTachyonVersion() {
        return Model.modelDescriptors[Model.model].tachyonVersion;
    }

    public static int getBaryonVersion() {
        return Model.modelDescriptors[Model.model].baryonVersion;
    }

    public static int getPommelVersion() {
        return Model.modelDescriptors[Model.model].pommelVersion;
    }

    static {
        Model.modelDescriptors[0] = new ModelDescriptor("PSP-1000 (Fat)", 1, 0x300000, 263680, 259);
        Model.modelDescriptors[1] = new ModelDescriptor("PSP-2000 (Slim)", 2, 0x500000, 0x22B200, 291);
        Model.modelDescriptors[2] = new ModelDescriptor("PSP-3000 (Brite, 3rd Generation)", 3, 0x600000, 2502912, 306);
        Model.modelDescriptors[3] = new ModelDescriptor("PSP-3000 (Brite, 4th Generation)", 4, 0x810000, 2899968, 321);
        Model.modelDescriptors[4] = new ModelDescriptor("PSP-N1000 (GO)", 5, 0x720000, 0x304000, 307);
        Model.modelDescriptors[5] = new ModelDescriptor("PSP-3000 (Brite, 7th Generation)", 7, 0x810000, 19808256, 340);
        Model.modelDescriptors[6] = new ModelDescriptor("PSP-3000 (Brite, 9th Generation)", 9, 0x820000, 3031040, 340);
        Model.modelDescriptors[7] = new ModelDescriptor("PSP-E1000 (Street)", 11, 0x900000, 0x403000, 340);
    }

    private static class ModelDescriptor {
        public String modelName;
        public int generation;
        public int tachyonVersion;
        public int baryonVersion;
        public int pommelVersion;

        public ModelDescriptor(String modelName, int generation, int tachyonVersion, int baryonVersion, int pommelVersion) {
            this.modelName = modelName;
            this.generation = generation;
            this.tachyonVersion = tachyonVersion;
            this.baryonVersion = baryonVersion;
            this.pommelVersion = pommelVersion;
        }
    }
}

