/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.aac;

import jpcsp.media.codec.util.CodecUtils;

public class AacPsData {
    public static final int NR_ALLPASS_BANDS20 = 30;
    public static final int NR_ALLPASS_BANDS34 = 50;
    public static final int PS_AP_LINKS = 3;
    public static float[] pd_re_smooth = new float[512];
    public static float[] pd_im_smooth = new float[512];
    public static float[][][] HA = new float[46][8][4];
    public static float[][][] HB = new float[46][8][4];
    public static float[][][] f20_0_8 = new float[8][8][2];
    public static float[][][] f34_0_12 = new float[12][8][2];
    public static float[][][] f34_1_8 = new float[8][8][2];
    public static float[][][] f34_2_4 = new float[4][8][2];
    public static float[][][][] Q_fract_allpass = new float[2][50][3][2];
    public static float[][][] phi_fract = new float[2][50][2];
    public static final float[] g0_Q8 = new float[]{0.0074608293f, 0.02270421f, 0.04546866f, 0.07266114f, 0.098851085f, 0.1179371f, 0.125f};
    public static final float[] g0_Q12 = new float[]{0.0408118f, 0.03812811f, 0.051449083f, 0.06399831f, 0.07428314f, 0.08100348f, 0.083333336f};
    public static final float[] g1_Q8 = new float[]{0.015656756f, 0.037527163f, 0.054178912f, 0.08417044f, 0.10307344f, 0.122224525f, 0.125f};
    public static final float[] g2_Q4 = new float[]{-0.059082113f, -0.048714984f, 0.0f, 0.07778724f, 0.16486304f, 0.23279856f, 0.25f};
    static final int[] huff_iid_df1_bits = new int[]{18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 18, 17, 17, 16, 16, 15, 14, 14, 13, 12, 12, 11, 10, 10, 8, 7, 6, 5, 4, 3, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
    static final int[] huff_iid_df1_codes = new int[]{130740, 130741, 130422, 130423, 130420, 130421, 130698, 130699, 130696, 65152, 130742, 65154, 65208, 32578, 32686, 16303, 8145, 8169, 4073, 2026, 2043, 1019, 507, 511, 124, 60, 28, 12, 0, 1, 1, 2, 1, 13, 29, 61, 125, 252, 508, 1020, 1012, 2027, 4074, 8170, 8150, 16336, 32687, 32579, 65209, 65155, 130743, 65153, 130697, 130702, 130703, 130700, 130701, 130738, 130739, 130736, 130737};
    static final int[] huff_iid_dt1_bits = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 15, 14, 14, 13, 13, 13, 12, 12, 11, 10, 9, 9, 7, 6, 5, 3, 1, 2, 5, 6, 7, 8, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    static final int[] huff_iid_dt1_codes = new int[]{20180, 20181, 20174, 20175, 20172, 20182, 20184, 20294, 20320, 10008, 10009, 10084, 10085, 10093, 10161, 5047, 5078, 2503, 2537, 2541, 1262, 1271, 632, 313, 154, 159, 32, 17, 10, 3, 1, 0, 11, 18, 33, 76, 155, 314, 633, 624, 1263, 1250, 2538, 2520, 5079, 5072, 10162, 10146, 10010, 10011, 20326, 20327, 20321, 20295, 20185, 20183, 20173, 20178, 20179, 20176, 20177};
    static final int[] huff_iid_df0_bits = new int[]{17, 17, 17, 17, 16, 15, 13, 10, 9, 7, 6, 5, 4, 3, 1, 3, 4, 5, 6, 6, 8, 11, 13, 14, 14, 15, 17, 18, 18};
    static final int[] huff_iid_df0_codes = new int[]{131067, 131068, 131069, 131066, 65532, 32764, 8189, 1022, 510, 126, 60, 29, 13, 5, 0, 4, 12, 28, 61, 62, 254, 2046, 8188, 16380, 16381, 32765, 131070, 262142, 262143};
    static final int[] huff_iid_dt0_bits = new int[]{19, 19, 19, 20, 20, 20, 17, 15, 12, 10, 8, 6, 4, 2, 1, 3, 5, 7, 9, 11, 13, 14, 17, 19, 20, 20, 20, 20, 20};
    static final int[] huff_iid_dt0_codes = new int[]{524281, 524282, 524283, 1048568, 1048569, 1048570, 131069, 32766, 4094, 1022, 254, 62, 14, 2, 0, 6, 30, 126, 510, 2046, 8190, 16382, 131068, 524280, 1048571, 1048572, 1048573, 1048574, 1048575};
    static final int[] huff_icc_df_bits = new int[]{14, 14, 12, 10, 7, 5, 3, 1, 2, 4, 6, 8, 9, 11, 13};
    static final int[] huff_icc_df_codes = new int[]{16383, 16382, 4094, 1022, 126, 30, 6, 0, 2, 14, 62, 254, 510, 2046, 8190};
    static final int[] huff_icc_dt_bits = new int[]{14, 13, 11, 9, 7, 5, 3, 1, 2, 4, 6, 8, 10, 12, 14};
    static final int[] huff_icc_dt_codes = new int[]{16382, 8190, 2046, 510, 126, 30, 6, 0, 2, 14, 62, 254, 1022, 4094, 16383};
    static final int[] huff_ipd_df_bits = new int[]{1, 3, 4, 4, 4, 4, 4, 4};
    static final int[] huff_ipd_df_codes = new int[]{1, 0, 6, 4, 2, 3, 5, 7};
    static final int[] huff_ipd_dt_bits = new int[]{1, 3, 4, 5, 5, 4, 4, 3};
    static final int[] huff_ipd_dt_codes = new int[]{1, 2, 2, 3, 2, 0, 3, 3};
    static final int[] huff_opd_df_bits = new int[]{1, 3, 4, 4, 5, 5, 4, 3};
    static final int[] huff_opd_df_codes = new int[]{1, 1, 6, 4, 15, 14, 5, 0};
    static final int[] huff_opd_dt_bits = new int[]{1, 3, 4, 5, 5, 4, 4, 3};
    static final int[] huff_opd_dt_codes = new int[]{1, 2, 1, 7, 6, 0, 2, 3};
    static final int[] huff_offset = new int[]{30, 30, 14, 14, 7, 7, 0, 0, 0, 0};
    static final int[] k_to_i_20 = new int[]{1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19};
    static final int[] k_to_i_34 = new int[]{0, 1, 2, 3, 4, 5, 6, 6, 7, 2, 1, 0, 10, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 9, 14, 11, 12, 13, 14, 15, 16, 13, 16, 17, 18, 19, 20, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 27, 28, 28, 28, 29, 29, 29, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32, 32, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33};
    static final float[] g1_Q2 = new float[]{0.0f, 0.018994875f, 0.0f, -0.072931394f, 0.0f, 0.30596632f, 0.5f};
    private static final float[] ipdopd_sin = new float[]{0.0f, 0.70710677f, 1.0f, 0.70710677f, 0.0f, -0.70710677f, -1.0f, -0.70710677f};
    private static final float[] ipdopd_cos = new float[]{1.0f, 0.70710677f, 0.0f, -0.70710677f, -1.0f, -0.70710677f, 0.0f, 0.70710677f};
    private static final float[] iid_par_dequant = new float[]{0.056234132f, 0.12589253f, 0.19952624f, 0.31622776f, 0.4466836f, 0.63095737f, 0.7943282f, 1.0f, 1.2589254f, 1.5848932f, 2.2387211f, 3.1622777f, 5.0118723f, 7.943282f, 17.782795f, 0.0031622776f, 0.0056234132f, 0.01f, 0.017782794f, 0.031622775f, 0.056234132f, 0.07943282f, 0.11220185f, 0.15848932f, 0.22387211f, 0.31622776f, 0.39810717f, 0.5011872f, 0.63095737f, 0.7943282f, 1.0f, 1.2589254f, 1.5848932f, 1.9952623f, 2.5118864f, 3.1622777f, 4.466836f, 6.3095737f, 8.912509f, 12.589254f, 17.782795f, 31.622776f, 56.23413f, 100.0f, 177.82794f, 316.22775f};
    private static final float[] icc_invq = new float[]{1.0f, 0.937f, 0.84118f, 0.60092f, 0.36764f, 0.0f, -0.589f, -1.0f};
    private static final float[] acos_icc_invq = new float[]{0.0f, 0.35685527f, 0.57133466f, 0.9261447f, 1.1943263f, 1.5707964f, 2.200617f, (float)Math.PI};
    private static final int[] f_center_20 = new int[]{-3, -1, 1, 3, 5, 7, 10, 14, 18, 22};
    private static final int[] f_center_34 = new int[]{2, 6, 10, 14, 18, 22, 26, 30, 34, -10, -6, -2, 51, 57, 15, 21, 27, 33, 39, 45, 54, 66, 78, 42, 102, 66, 78, 90, 102, 114, 126, 90};
    private static final float[] fractional_delay_links = new float[]{0.43f, 0.75f, 0.347f};

    private static void make_filters_from_proto(float[][][] filter, float[] proto, int bands) {
        for (int q = 0; q < bands; ++q) {
            for (int n = 0; n < 7; ++n) {
                double theta = Math.PI * 2 * ((double)q + 0.5) * (double)(n - 6) / (double)bands;
                filter[q][n][0] = proto[n] * (float)Math.cos(theta);
                filter[q][n][1] = proto[n] * (float)(-Math.sin(theta));
            }
        }
    }

    public static void tableinit() {
        int k;
        float fractional_delay_gain = 0.39f;
        for (int pd0 = 0; pd0 < 8; ++pd0) {
            float pd0_re = ipdopd_cos[pd0];
            float pd0_im = ipdopd_sin[pd0];
            for (int pd1 = 0; pd1 < 8; ++pd1) {
                float pd1_re = ipdopd_cos[pd1];
                float pd1_im = ipdopd_sin[pd1];
                for (int pd2 = 0; pd2 < 8; ++pd2) {
                    float pd2_re = ipdopd_cos[pd2];
                    float pd2_im = ipdopd_sin[pd2];
                    float re_smooth = 0.25f * pd0_re + 0.5f * pd1_re + pd2_re;
                    float im_smooth = 0.25f * pd0_im + 0.5f * pd1_im + pd2_im;
                    float pd_mag = 1.0f / CodecUtils.sqrtf(im_smooth * im_smooth + re_smooth * re_smooth);
                    AacPsData.pd_re_smooth[pd0 * 64 + pd1 * 8 + pd2] = re_smooth * pd_mag;
                    AacPsData.pd_im_smooth[pd0 * 64 + pd1 * 8 + pd2] = im_smooth * pd_mag;
                }
            }
        }
        for (int iid = 0; iid < 46; ++iid) {
            float c = iid_par_dequant[iid];
            float c1 = 1.4142135f / CodecUtils.sqrtf(1.0f + c * c);
            float c2 = c * c1;
            for (int icc = 0; icc < 8; ++icc) {
                float alpha = 0.5f * acos_icc_invq[icc];
                float beta = alpha * (c1 - c2) * 0.70710677f;
                AacPsData.HA[iid][icc][0] = c2 * CodecUtils.cosf(beta + alpha);
                AacPsData.HA[iid][icc][1] = c1 * CodecUtils.cosf(beta - alpha);
                AacPsData.HA[iid][icc][2] = c2 * CodecUtils.sinf(beta + alpha);
                AacPsData.HA[iid][icc][3] = c1 * CodecUtils.sinf(beta - alpha);
                float rho = Math.max(icc_invq[icc], 0.05f);
                alpha = 0.5f * CodecUtils.atan2f(2.0f * c * rho, c * c - 1.0f);
                float mu = c + 1.0f / c;
                mu = CodecUtils.sqrtf(1.0f + (4.0f * rho * rho - 4.0f) / (mu * mu));
                float gamma = CodecUtils.atanf(CodecUtils.sqrtf((1.0f - mu) / (1.0f + mu)));
                if (alpha < 0.0f) {
                    alpha += 1.5707964f;
                }
                float alpha_c = CodecUtils.cosf(alpha);
                float alpha_s = CodecUtils.sinf(alpha);
                float gamma_c = CodecUtils.cosf(gamma);
                float gamma_s = CodecUtils.sinf(gamma);
                AacPsData.HB[iid][icc][0] = 1.4142135f * alpha_c * gamma_c;
                AacPsData.HB[iid][icc][1] = 1.4142135f * alpha_s * gamma_c;
                AacPsData.HB[iid][icc][2] = -1.4142135f * alpha_s * gamma_s;
                AacPsData.HB[iid][icc][3] = 1.4142135f * alpha_c * gamma_s;
            }
        }
        for (k = 0; k < 30; ++k) {
            double theta;
            double f_center = k < f_center_20.length ? (double)f_center_20[k] * 0.125 : (double)((float)k - 6.5f);
            for (int m = 0; m < 3; ++m) {
                theta = (double)((float)(-Math.PI) * fractional_delay_links[m]) * f_center;
                AacPsData.Q_fract_allpass[0][k][m][0] = (float)Math.cos(theta);
                AacPsData.Q_fract_allpass[0][k][m][1] = (float)Math.sin(theta);
            }
            theta = -1.2252211570739746 * f_center;
            AacPsData.phi_fract[0][k][0] = (float)Math.cos(theta);
            AacPsData.phi_fract[0][k][1] = (float)Math.sin(theta);
        }
        for (k = 0; k < 50; ++k) {
            double theta;
            double f_center = k < f_center_34.length ? (double)f_center_34[k] / 24.0 : (double)((float)k - 26.5f);
            for (int m = 0; m < 3; ++m) {
                theta = (double)((float)(-Math.PI) * fractional_delay_links[m]) * f_center;
                AacPsData.Q_fract_allpass[1][k][m][0] = (float)Math.cos(theta);
                AacPsData.Q_fract_allpass[1][k][m][1] = (float)Math.sin(theta);
            }
            theta = -1.2252211570739746 * f_center;
            AacPsData.phi_fract[1][k][0] = (float)Math.cos(theta);
            AacPsData.phi_fract[1][k][1] = (float)Math.sin(theta);
        }
        AacPsData.make_filters_from_proto(f20_0_8, g0_Q8, 8);
        AacPsData.make_filters_from_proto(f34_0_12, g0_Q12, 12);
        AacPsData.make_filters_from_proto(f34_1_8, g1_Q8, 8);
        AacPsData.make_filters_from_proto(f34_2_4, g2_Q4, 4);
    }
}

