/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.h264;

public class H264Utils {
    private static final int CLAMP_BASE = 512;
    private static final int[] clamp = new int[1280];
    private static final int[][] redMap = new int[256][256];
    private static final int[][] blueMap = new int[256][256];
    private static final int[] lumaYuvjToYuvTable = new int[256];

    private static void initClamp() {
        int i;
        for (i = 0; i < 256; ++i) {
            H264Utils.clamp[512 + i] = i;
        }
        for (i = 0; i < 512; ++i) {
            H264Utils.clamp[i] = 0;
            H264Utils.clamp[i + 512 + 256] = 255;
        }
    }

    private static void initRedMap(int alpha) {
        alpha <<= 24;
        for (int luma = 0; luma <= 255; ++luma) {
            for (int cr = 0; cr <= 255; ++cr) {
                int c = luma - 16;
                int e = cr - 128;
                int red = 298 * c + 409 * e + 128 >> 8;
                red = clamp[red + 512];
                H264Utils.redMap[luma][cr] = alpha | red;
            }
        }
    }

    private static void initBlueMap() {
        for (int luma = 0; luma <= 255; ++luma) {
            for (int cb = 0; cb <= 255; ++cb) {
                int c = luma - 16;
                int d = cb - 128;
                int blue = 298 * c + 516 * d + 128 >> 8;
                blue = clamp[blue + 512];
                H264Utils.blueMap[luma][cb] = blue << 16;
            }
        }
    }

    private static void initYuvj() {
        for (int i = 0; i < 256; ++i) {
            H264Utils.lumaYuvjToYuvTable[i] = Math.round((float)i / 255.0f * 224.0f + 16.0f);
        }
    }

    public static void YUV2ARGB(int width, int height, int[] luma, int[] cb, int[] cr, int[] argb) {
        H264Utils.YUV2ABGR(width, height, luma, cb, cr, argb);
        for (int i = 0; i < argb.length; ++i) {
            int color = argb[i];
            argb[i] = color = color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16;
        }
    }

    public static void YUV2ABGR(int width, int height, int[] luma, int[] cb, int[] cr, int[] abgr) {
        int width2 = width >> 1;
        int offset = 0;
        for (int y = 0; y < height; ++y) {
            int offset2 = (y >> 1) * width2;
            int x = 0;
            while (x < width) {
                int c = luma[offset] & 0xFF;
                int d = cb[offset2 + (x >> 1)] & 0xFF;
                int e = cr[offset2 + (x >> 1)] & 0xFF;
                int red = redMap[c][e];
                int blue = blueMap[c][d];
                int green = 298 * (c -= 16) - 100 * (d -= 128) - 208 * (e -= 128) + 128 >> 8;
                green = clamp[green + 512];
                abgr[offset] = blue | green << 8 | red;
                ++x;
                ++offset;
            }
        }
    }

    public static void setAlpha(int alpha) {
        H264Utils.initRedMap(alpha & 0xFF);
    }

    public static void YUVJ2YUV(int[] lumaYuvj, int[] lumaYuv, int size) {
        for (int i = 0; i < size; ++i) {
            lumaYuv[i] = lumaYuvjToYuvTable[lumaYuvj[i]];
        }
    }

    public static int findExtradata(int[] input, int inputOffset, int inputLength) {
        int state = -1;
        boolean hasSps = false;
        for (int i = 0; i <= inputLength; ++i) {
            if ((state & 0xFFFFFF1F) == 263) {
                hasSps = true;
            }
            if ((state & 0xFFFFFF00) == 256 && (state & 0xFFFFFF1F) != 263 && (state & 0xFFFFFF1F) != 264 && (state & 0xFFFFFF1F) != 265 && hasSps) {
                while (i > 4 && input[inputOffset + i - 5] == 0) {
                    --i;
                }
                return i - 4;
            }
            if (i >= inputLength) continue;
            state = state << 8 | input[inputOffset + i];
        }
        return 0;
    }

    static {
        H264Utils.initClamp();
        H264Utils.initRedMap(255);
        H264Utils.initBlueMap();
        H264Utils.initYuvj();
    }
}

