/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.mp3;

import java.util.Arrays;
import jpcsp.Memory;
import jpcsp.media.codec.ICodec;
import jpcsp.media.codec.mp3.Context;
import jpcsp.media.codec.mp3.Granule;
import jpcsp.media.codec.mp3.Mp3Data;
import jpcsp.media.codec.mp3.Mp3Dsp;
import jpcsp.media.codec.mp3.Mp3Header;
import jpcsp.media.codec.util.BitBuffer;
import jpcsp.media.codec.util.BitReader;
import jpcsp.media.codec.util.CodecUtils;
import jpcsp.media.codec.util.FloatDSP;
import jpcsp.media.codec.util.VLC;
import org.apache.log4j.Logger;

public class Mp3Decoder
implements ICodec {
    public static Logger log = Logger.getLogger((String)"mp3");
    public static final int MP3_ERROR = -3;
    private static final int HEADER_SIZE = 4;
    public static final int BACKSTEP_SIZE = 512;
    public static final int EXTRABYTES = 24;
    public static final int LAST_BUF_SIZE = 1048;
    public static final int MP3_MAX_CHANNELS = 2;
    public static final int SBLIMIT = 32;
    public static final int MP3_STEREO = 0;
    public static final int MP3_JSTEREO = 1;
    public static final int MP3_DUAL = 2;
    public static final int MP3_MONO = 3;
    public static final int FRAC_BITS = 23;
    public static final int WFRAC_BITS = 16;
    public static final int FRAC_ONE = 0x800000;
    public static final float IMDCT_SCALAR = 1.759f;
    private Context ctx;
    private BitReader br;
    private BitBuffer bb = new BitBuffer(32768);
    private static boolean initializedTables = false;
    private static VLC[] huff_vlc = new VLC[16];
    private static VLC[] huff_quad_vlc = new VLC[2];
    private static final int[][] band_index_long = new int[9][23];
    private static final float[][] is_table = new float[2][16];
    private static final float[][][] is_table_lsf = new float[2][2][16];
    private static final float[][] csa_table = new float[8][4];
    private static final int[] division_tab3 = new int[64];
    private static final int[] division_tab5 = new int[256];
    private static final int[] division_tab9 = new int[2048];
    private static final int[][] division_tabs = new int[][]{division_tab3, division_tab5, null, division_tab9};
    private static final int[] scale_factor_modshift = new int[64];
    private static final int[][] scale_factor_mult = new int[15][3];
    private static final double ISQRT2 = 0.7071067811865476;
    private static final int[] idxtab = new int[]{3, 3, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final float C3 = 0.4330127f;
    private static final float C4 = 0.35355338f;
    private static final float C5 = 0.25881904f;
    private static final float C6 = 0.4829629f;

    private void initStatic() {
        int i;
        if (initializedTables) {
            return;
        }
        for (i = 0; i < 64; ++i) {
            int shift = i / 3;
            int mod = i % 3;
            Mp3Decoder.scale_factor_modshift[i] = mod | shift << 2;
        }
        for (i = 0; i < 15; ++i) {
            int n = i + 2;
            int norm = (int)((1L << n) * 0x800000L / (long)((1 << n) - 1));
            Mp3Decoder.scale_factor_mult[i][0] = (int)((float)norm * 1.0f * 2.0f);
            Mp3Decoder.scale_factor_mult[i][1] = (int)((float)norm * 0.7937005f * 2.0f);
            Mp3Decoder.scale_factor_mult[i][2] = (int)((float)norm * 0.62996054f * 2.0f);
        }
        Mp3Dsp.synthInit(Mp3Dsp.mpa_synth_window);
        for (i = 1; i < 16; ++i) {
            Mp3Data.HuffTable h = Mp3Data.mpa_huff_tables[i];
            int[] tmpBits = new int[512];
            int[] tmpCodes = new int[512];
            int xsize = h.xsize;
            int j = 0;
            for (int x = 0; x < xsize; ++x) {
                for (int y = 0; y < xsize; ++y) {
                    tmpBits[x << 5 | y | (x != 0 && y != 0 ? 16 : 0)] = h.bits[j];
                    tmpCodes[x << 5 | y | (x != 0 && y != 0 ? 16 : 0)] = h.codes[j++];
                }
            }
            Mp3Decoder.huff_vlc[i] = new VLC();
            huff_vlc[i].initVLCSparse(7, 512, tmpBits, tmpCodes, null);
        }
        for (i = 0; i < 2; ++i) {
            Mp3Decoder.huff_quad_vlc[i] = new VLC();
            huff_quad_vlc[i].initVLCSparse(i == 0 ? 7 : 4, 16, Mp3Data.mpa_quad_bits[i], Mp3Data.mpa_quad_codes[i], null);
        }
        for (i = 0; i < 9; ++i) {
            int k = 0;
            for (int j = 0; j < 22; ++j) {
                Mp3Decoder.band_index_long[i][j] = k;
                k += Mp3Data.band_size_long[i][j];
            }
            Mp3Decoder.band_index_long[i][22] = k;
        }
        Mp3Data.tableinit();
        Mp3Dsp.initMpadspTabs();
        for (i = 0; i < 4; ++i) {
            if (Mp3Data.mp3_quant_bits[i] >= 0) continue;
            for (int j = 0; j < 1 << -Mp3Data.mp3_quant_bits[i] + 1; ++j) {
                int val = j;
                int steps = Mp3Data.mp3_quant_steps[i];
                int val1 = val % steps;
                int val2 = (val /= steps) % steps;
                int val3 = val / steps;
                Mp3Decoder.division_tabs[i][j] = val1 + (val2 << 4) + (val3 << 8);
            }
        }
        for (i = 0; i < 7; ++i) {
            float v;
            if (i != 6) {
                float f = (float)Math.tan((double)i * Math.PI / 12.0);
                v = f / (1.0f + f);
            } else {
                v = 1.0f;
            }
            Mp3Decoder.is_table[0][i] = v;
            Mp3Decoder.is_table[1][6 - i] = v;
        }
        for (i = 7; i < 16; ++i) {
            Mp3Decoder.is_table[0][i] = 0.0f;
            Mp3Decoder.is_table[1][i] = 0.0f;
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 2; ++j) {
                int e = -(j + 1) * (i + 1 >> 1);
                double f = Math.pow(2.0, (double)e / 4.0);
                int k = i & 1;
                Mp3Decoder.is_table_lsf[j][k ^ 1][i] = (float)f;
                Mp3Decoder.is_table_lsf[j][k][i] = 1.0f;
            }
        }
        for (i = 0; i < 8; ++i) {
            float ci = Mp3Data.ci_table[i];
            float cs = (float)(1.0 / Math.sqrt(1.0 + (double)(ci * ci)));
            float ca = cs * ci;
            Mp3Decoder.csa_table[i][0] = cs;
            Mp3Decoder.csa_table[i][1] = ca;
            Mp3Decoder.csa_table[i][2] = ca + cs;
            Mp3Decoder.csa_table[i][3] = ca - cs;
        }
        initializedTables = true;
    }

    @Override
    public int init(int bytesPerFrame, int channels, int outputChannels, int codingMode) {
        this.initStatic();
        this.ctx = new Context();
        this.ctx.outputChannels = outputChannels;
        return 0;
    }

    private int mpaCheckHeader(int header) {
        if ((header & 0xFFE00000) != -2097152) {
            return -1;
        }
        if ((header & 0x60000) == 0) {
            return -1;
        }
        if ((header & 0xF000) == 61440) {
            return -1;
        }
        if ((header & 0xC00) == 3072) {
            return -1;
        }
        return 0;
    }

    public static int decodeHeader(Mp3Header s, int header) {
        int frameSize;
        int bitrateIndex;
        int sampleRateIndex;
        int mpeg25;
        if ((header & 0x100000) != 0) {
            s.lsf = (header & 0x80000) != 0 ? 0 : 1;
            mpeg25 = 0;
        } else {
            s.lsf = 1;
            mpeg25 = 1;
        }
        s.mpeg25 = mpeg25;
        s.version = header >> 19 & 3;
        s.layer = 4 - (header >> 17 & 3);
        s.rawSampleRateIndex = sampleRateIndex = header >> 10 & 3;
        if (sampleRateIndex >= Mp3Data.mp3_freq_tab.length) {
            sampleRateIndex = 0;
        }
        int sampleRate = Mp3Data.mp3_freq_tab[sampleRateIndex] >> s.lsf + mpeg25;
        s.sampleRateIndex = sampleRateIndex += 3 * (s.lsf + mpeg25);
        s.errorProtection = header >> 16 & 1 ^ 1;
        s.sampleRate = sampleRate;
        s.bitrateIndex = bitrateIndex = header >> 12 & 0xF;
        int padding = header >> 9 & 1;
        s.mode = header >> 6 & 3;
        s.modeExt = header >> 4 & 3;
        s.nbChannels = s.mode == 3 ? 1 : 2;
        switch (s.layer) {
            case 1: {
                s.maxSamples = 384;
                break;
            }
            case 2: {
                s.maxSamples = 1152;
                break;
            }
            default: {
                int n = s.maxSamples = s.lsf != 0 ? 576 : 1152;
            }
        }
        if (bitrateIndex != 0) {
            frameSize = Mp3Data.mp3_bitrate_tab[s.lsf][s.layer - 1][bitrateIndex];
            s.bitRate = frameSize * 1000;
            switch (s.layer) {
                case 1: {
                    frameSize = frameSize * 12000 / sampleRate;
                    frameSize = (frameSize + padding) * 4;
                    break;
                }
                case 2: {
                    frameSize = frameSize * 144000 / sampleRate;
                    frameSize += padding;
                    break;
                }
                default: {
                    frameSize = frameSize * 144000 / (sampleRate << s.lsf);
                    frameSize += padding;
                }
            }
        } else {
            return 1;
        }
        s.frameSize = frameSize;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Mp3Header: %s", s));
        }
        return 0;
    }

    private int decodeLayer1() {
        log.warn((Object)"Unimplemented MP3 Layer-1");
        return 0;
    }

    private int decodeLayer2() {
        log.warn((Object)"Unimplemented MP3 Layer-2");
        return 0;
    }

    private void initShortRegion(Granule g) {
        g.regionSize[0] = g.blockType == 2 ? (this.ctx.header.sampleRateIndex != 8 ? 18 : 36) : (this.ctx.header.sampleRateIndex <= 2 ? 18 : (this.ctx.header.sampleRateIndex != 8 ? 27 : 54));
        g.regionSize[1] = 288;
    }

    private void initLongRegion(Granule g, int ra1, int ra2) {
        g.regionSize[0] = band_index_long[this.ctx.header.sampleRateIndex][ra1 + 1] >> 1;
        int l = Math.min(ra1 + ra2 + 2, 22);
        g.regionSize[1] = band_index_long[this.ctx.header.sampleRateIndex][l] >> 1;
    }

    private void computeBandIndexes(Granule g) {
        if (g.blockType == 2) {
            if (g.switchPoint != 0) {
                if (this.ctx.header.sampleRateIndex == 8) {
                    log.warn((Object)String.format("Unimplemented switch point in 8kHz", new Object[0]));
                }
                g.longEnd = this.ctx.header.sampleRateIndex <= 2 ? 8 : 6;
                g.shortStart = 3;
            } else {
                g.longEnd = 0;
                g.shortStart = 0;
            }
        } else {
            g.shortStart = 13;
            g.longEnd = 22;
        }
    }

    private void regionOffset2size(Granule g) {
        g.regionSize[2] = 288;
        int j = 0;
        for (int i = 0; i < 3; ++i) {
            int k = Math.min(g.regionSize[i], g.bigValues);
            g.regionSize[i] = k - j;
            j = k;
        }
    }

    private void lsfSfExpand(int[] slen, int sf, int n1, int n2, int n3) {
        if (n3 != 0) {
            slen[3] = sf % n3;
            sf /= n3;
        } else {
            slen[3] = 0;
        }
        if (n2 != 0) {
            slen[2] = sf % n2;
            sf /= n2;
        } else {
            slen[2] = 0;
        }
        if (n1 != 0) {
            slen[1] = sf % n1;
            sf /= n1;
        } else {
            slen[1] = 0;
        }
        slen[0] = sf;
    }

    public void exponentsFromScaleFactors(Granule g, int[] exponents) {
        int len;
        int expPtr = 0;
        int gain = g.globalGain - 210;
        int shift = g.scalefacScale + 1;
        int[] gains = new int[3];
        int[] bstab = Mp3Data.band_size_long[this.ctx.header.sampleRateIndex];
        int[] pretab = Mp3Data.mpa_pretab[g.preflag];
        for (int i = 0; i < g.longEnd; ++i) {
            int v0 = gain - (g.scaleFactors[i] + pretab[i] << shift) + 400;
            for (int j = len = bstab[i]; j > 0; --j) {
                exponents[expPtr++] = v0;
            }
        }
        if (g.shortStart < 13) {
            bstab = Mp3Data.band_size_short[this.ctx.header.sampleRateIndex];
            gains[0] = gain - (g.subblockGain[0] << 3);
            gains[1] = gain - (g.subblockGain[1] << 3);
            gains[2] = gain - (g.subblockGain[2] << 3);
            int k = g.longEnd;
            for (int i = g.shortStart; i < 13; ++i) {
                len = bstab[i];
                for (int l = 0; l < 3; ++l) {
                    int v0 = gains[l] - (g.scaleFactors[k++] << shift) + 400;
                    for (int j = len; j > 0; --j) {
                        exponents[expPtr++] = v0;
                    }
                }
            }
        }
    }

    private int l3Unscale(int value, int exponent) {
        int e = Mp3Data.table_4_3_exp[4 * value + (exponent & 3)];
        int m = Mp3Data.table_4_3_value[4 * value + (exponent & 3)];
        if ((e -= exponent >> 2) > 31) {
            return 0;
        }
        m = m + (1 << e - 1) >> e;
        return m;
    }

    private void huffmanDecode(Granule g, int[] exponents) {
        int bitsLeft;
        int sIndex = 0;
        for (int i = 0; i < 3; ++i) {
            int j = g.regionSize[i];
            if (j == 0) continue;
            int k = g.tableSelect[i];
            int l = Mp3Data.mpa_huff_data[k][0];
            int linbits = Mp3Data.mpa_huff_data[k][1];
            VLC vlc = huff_vlc[l];
            if (l == 0) {
                Arrays.fill(g.sbHybrid, sIndex, sIndex + 2 * j, 0.0f);
                sIndex += 2 * j;
                continue;
            }
            while (j > 0) {
                int y = vlc.getVLC2(this.bb, 3);
                if (y == 0) {
                    g.sbHybrid[sIndex] = 0.0f;
                    g.sbHybrid[sIndex + 1] = 0.0f;
                    sIndex += 2;
                } else {
                    float v;
                    int x;
                    int exponent = exponents[sIndex];
                    if ((y & 0x10) != 0) {
                        x = y >> 5;
                        y &= 0xF;
                        if (x < 15) {
                            v = Mp3Data.expval_table[exponent][x];
                            if (this.bb.readBool()) {
                                v = -v;
                            }
                            g.sbHybrid[sIndex] = v;
                        } else {
                            v = this.l3Unscale(x += this.bb.read(linbits), exponent);
                            if (this.bb.readBool()) {
                                v = -v;
                            }
                            g.sbHybrid[sIndex] = v;
                        }
                        if (y < 15) {
                            v = Mp3Data.expval_table[exponent][y];
                            if (this.bb.readBool()) {
                                v = -v;
                            }
                            g.sbHybrid[sIndex + 1] = v;
                        } else {
                            v = this.l3Unscale(y += this.bb.read(linbits), exponent);
                            if (this.bb.readBool()) {
                                v = -v;
                            }
                            g.sbHybrid[sIndex + 1] = v;
                        }
                    } else {
                        x = y >> 5;
                        if ((x += (y &= 0xF)) < 15) {
                            v = Mp3Data.expval_table[exponent][x];
                            if (this.bb.readBool()) {
                                v = -v;
                            }
                            g.sbHybrid[sIndex + (y != 0 ? 1 : 0)] = v;
                        } else {
                            x += this.bb.read(linbits);
                            v = this.l3Unscale(y, exponent);
                            if (this.bb.readBool()) {
                                v = -v;
                            }
                            g.sbHybrid[sIndex + (y != 0 ? 1 : 0)] = v;
                        }
                        g.sbHybrid[sIndex + (y == 0 ? 1 : 0)] = 0.0f;
                    }
                    sIndex += 2;
                }
                --j;
            }
        }
        VLC vlc = huff_quad_vlc[g.count1tableSelect];
        int lastPos = 0;
        while (sIndex <= 572) {
            int pos = this.bb.getBitsRead();
            if (pos >= g.granuleStartPosition + g.part23Length) {
                int overread = pos - (g.granuleStartPosition + g.part23Length);
                if (overread <= 0 || lastPos <= 0) break;
                sIndex -= 4;
                this.bb.skip(lastPos - pos);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("Overread part23 by %d bits", overread));
                break;
            }
            lastPos = pos;
            int code = vlc.getVLC2(this.bb);
            g.sbHybrid[sIndex + 0] = 0.0f;
            g.sbHybrid[sIndex + 1] = 0.0f;
            g.sbHybrid[sIndex + 2] = 0.0f;
            g.sbHybrid[sIndex + 3] = 0.0f;
            while (code != 0) {
                pos = sIndex + idxtab[code];
                code ^= 8 >> idxtab[code];
                float v = Mp3Data.exp_table[exponents[pos]];
                if (this.bb.readBool()) {
                    v = -v;
                }
                g.sbHybrid[pos] = v;
            }
            sIndex += 4;
        }
        if ((bitsLeft = g.granuleStartPosition + g.part23Length - this.bb.getBitsRead()) > 0) {
            this.bb.skip(bitsLeft);
        }
        Arrays.fill(g.sbHybrid, sIndex, 576, 0.0f);
    }

    private void computeStereo(Granule g0, Granule g1) {
        boolean[] nonZeroFoundShort = new boolean[3];
        if ((this.ctx.header.modeExt & 1) != 0) {
            int sfMax;
            float[][] isTab;
            if (this.ctx.header.lsf == 0) {
                isTab = is_table;
                sfMax = 7;
            } else {
                isTab = is_table_lsf[g1.scalefacCompress & 1];
                sfMax = 16;
            }
            int tab0 = 576;
            int tab1 = 576;
            nonZeroFoundShort[0] = false;
            nonZeroFoundShort[1] = false;
            nonZeroFoundShort[2] = false;
            int k = (13 - g1.shortStart) * 3 + g1.longEnd - 3;
            for (int i = 12; i >= g1.shortStart; --i) {
                if (i != 11) {
                    k -= 3;
                }
                int len = Mp3Data.band_size_short[this.ctx.header.sampleRateIndex][i];
                int l = 2;
                while (l >= 0) {
                    int j;
                    tab0 -= len;
                    tab1 -= len;
                    boolean doNonZero = nonZeroFoundShort[l];
                    int sf = 0;
                    if (!doNonZero) {
                        for (j = 0; j < len; ++j) {
                            if (g1.sbHybrid[tab1 + j] == 0.0f) continue;
                            nonZeroFoundShort[l] = true;
                            doNonZero = true;
                            break;
                        }
                        if (!doNonZero && (sf = g1.scaleFactors[k + l]) >= sfMax) {
                            doNonZero = true;
                        }
                    }
                    if (!doNonZero) {
                        float v1 = isTab[0][sf];
                        float v2 = isTab[1][sf];
                        for (int j2 = 0; j2 < len; ++j2) {
                            float tmp0 = g0.sbHybrid[tab0 + j2];
                            g0.sbHybrid[tab0 + j2] = tmp0 * v1;
                            g1.sbHybrid[tab1 + j2] = tmp0 * v2;
                        }
                    } else if ((this.ctx.header.modeExt & 2) != 0) {
                        for (j = 0; j < len; ++j) {
                            float tmp0 = g0.sbHybrid[tab0 + j];
                            float tmp1 = g1.sbHybrid[tab1 + j];
                            g0.sbHybrid[tab0 + j] = (float)((double)(tmp0 + tmp1) * 0.7071067811865476);
                            g1.sbHybrid[tab1 + j] = (float)((double)(tmp0 - tmp1) * 0.7071067811865476);
                        }
                    }
                    --k;
                }
            }
            boolean nonZeroFound = nonZeroFoundShort[0] || nonZeroFoundShort[1] || nonZeroFoundShort[2];
            for (int i = g1.longEnd - 1; i >= 0; --i) {
                int len = Mp3Data.band_size_long[this.ctx.header.sampleRateIndex][i];
                tab0 -= len;
                tab1 -= len;
                if (!nonZeroFound) {
                    for (int j = 0; j < len; ++j) {
                        if (g1.sbHybrid[tab1 + j] == 0.0f) continue;
                        nonZeroFound = true;
                        break;
                    }
                }
                int sf = 0;
                if (!nonZeroFound && (sf = g1.scaleFactors[k = i == 21 ? 20 : i]) >= sfMax) {
                    nonZeroFound = true;
                }
                if (!nonZeroFound) {
                    float v1 = isTab[0][sf];
                    float v2 = isTab[1][sf];
                    for (int j = 0; j < len; ++j) {
                        float tmp0 = g0.sbHybrid[tab0 + j];
                        g0.sbHybrid[tab0 + j] = tmp0 * v1;
                        g1.sbHybrid[tab1 + j] = tmp0 * v2;
                    }
                    continue;
                }
                if ((this.ctx.header.modeExt & 2) == 0) continue;
                for (int j = 0; j < len; ++j) {
                    float tmp0 = g0.sbHybrid[tab0 + j];
                    float tmp1 = g1.sbHybrid[tab1 + j];
                    g0.sbHybrid[tab0 + j] = (float)((double)(tmp0 + tmp1) * 0.7071067811865476);
                    g1.sbHybrid[tab1 + j] = (float)((double)(tmp0 - tmp1) * 0.7071067811865476);
                }
            }
        } else if ((this.ctx.header.modeExt & 2) != 0) {
            FloatDSP.butterflies(g0.sbHybrid, 0, g1.sbHybrid, 0, 576);
        }
    }

    private void reorderBlock(Granule g) {
        if (g.blockType != 2) {
            return;
        }
        float[] tmp = new float[576];
        int ptr = g.switchPoint != 0 ? (this.ctx.header.sampleRateIndex != 8 ? 36 : 72) : 0;
        for (int i = g.shortStart; i < 13; ++i) {
            int len = Mp3Data.band_size_short[this.ctx.header.sampleRateIndex][i];
            int ptr1 = ptr;
            int dst = 0;
            for (int j = len; j > 0; --j) {
                tmp[dst++] = g.sbHybrid[ptr + 0 * len];
                tmp[dst++] = g.sbHybrid[ptr + 1 * len];
                tmp[dst++] = g.sbHybrid[ptr + 2 * len];
                ++ptr;
            }
            ptr += 2 * len;
            System.arraycopy(tmp, 0, g.sbHybrid, ptr1, 3 * len);
        }
    }

    private void AA(float[] ptr, int ptrOffset, int j) {
        float tmp0 = ptr[ptrOffset - 1 - j];
        float tmp1 = ptr[ptrOffset + j];
        ptr[ptrOffset - 1 - j] = tmp0 * csa_table[j][0] - tmp1 * csa_table[j][1];
        ptr[ptrOffset + j] = tmp0 * csa_table[j][1] + tmp1 * csa_table[j][0];
    }

    private void computeAntialias(Granule g) {
        int n;
        if (g.blockType == 2) {
            if (g.switchPoint == 0) {
                return;
            }
            n = 1;
        } else {
            n = 31;
        }
        int ptr = 18;
        for (int i = n; i > 0; --i) {
            this.AA(g.sbHybrid, ptr, 0);
            this.AA(g.sbHybrid, ptr, 1);
            this.AA(g.sbHybrid, ptr, 2);
            this.AA(g.sbHybrid, ptr, 3);
            this.AA(g.sbHybrid, ptr, 4);
            this.AA(g.sbHybrid, ptr, 5);
            this.AA(g.sbHybrid, ptr, 6);
            this.AA(g.sbHybrid, ptr, 7);
            ptr += 18;
        }
    }

    private void imdct12(float[] out, int outOffset, float[] in, int inOffset) {
        float in0 = in[inOffset + 0];
        float in1 = in[inOffset + 3] + in[inOffset + 0];
        float in2 = in[inOffset + 6] + in[inOffset + 3];
        float in3 = in[inOffset + 9] + in[inOffset + 6];
        float in4 = in[inOffset + 12] + in[inOffset + 9];
        float in5 = in[inOffset + 15] + in[inOffset + 12];
        in5 += in3;
        in3 += in1;
        in2 = in2 * 0.4330127f * 2.0f;
        in3 = in3 * 0.4330127f * 4.0f;
        float t1 = in0 - in4;
        float t2 = (in1 - in5) * 0.35355338f * 2.0f;
        out[outOffset + 7] = t1 + t2;
        out[outOffset + 10] = t1 + t2;
        out[outOffset + 1] = t1 - t2;
        out[outOffset + 4] = t1 - t2;
        in0 += in4 * 0.5f;
        in4 = in0 + in2;
        in5 += 2.0f * in1;
        in1 = (in5 + in3) * 0.25881904f;
        out[outOffset + 8] = in4 + in1;
        out[outOffset + 9] = in4 + in1;
        out[outOffset + 2] = in4 - in1;
        out[outOffset + 3] = in4 - in1;
        in5 = (in5 - in3) * 0.4829629f * 2.0f;
        out[outOffset + 0] = (in0 -= in2) - in5;
        out[outOffset + 5] = in0 - in5;
        out[outOffset + 6] = in0 + in5;
        out[outOffset + 11] = in0 + in5;
    }

    private void computeImdct(Granule g, float[] sbSamples, int sbSamplesOffset, float[] mdctbuf) {
        int j;
        float[] out2 = new float[12];
        int ptr = 576;
        int ptr1 = 36;
        float[] p = g.sbHybrid;
        while (ptr >= ptr1 && p[ptr -= 6] == 0.0f && p[ptr + 1] == 0.0f && p[ptr + 2] == 0.0f && p[ptr + 3] == 0.0f && p[ptr + 4] == 0.0f && p[ptr + 5] == 0.0f) {
        }
        int sblimit = ptr / 18 + 1;
        int mdctLongEnd = g.blockType == 2 ? (g.switchPoint != 0 ? 2 : 0) : sblimit;
        Mp3Dsp.imdct36Blocks(sbSamples, sbSamplesOffset, mdctbuf, 0, g.sbHybrid, 0, mdctLongEnd, g.switchPoint, g.blockType);
        int buf = 72 * (mdctLongEnd >> 2) + (mdctLongEnd & 3);
        ptr = 18 * mdctLongEnd;
        for (j = mdctLongEnd; j < sblimit; ++j) {
            int i;
            float[] win = Mp3Dsp.mdct_win[2 + (4 & -(j & 1))];
            int outPtr = j;
            for (i = 0; i < 6; ++i) {
                sbSamples[outPtr] = mdctbuf[buf + 4 * i];
                outPtr += 32;
            }
            this.imdct12(out2, 0, g.sbHybrid, ptr + 0);
            for (i = 0; i < 6; ++i) {
                sbSamples[outPtr] = out2[i] * win[i] + mdctbuf[buf + 4 * (i + 6)];
                mdctbuf[buf + 4 * (i + 12)] = out2[i + 6] * win[i + 6];
                outPtr += 32;
            }
            this.imdct12(out2, 0, g.sbHybrid, ptr + 1);
            for (i = 0; i < 6; ++i) {
                sbSamples[outPtr] = out2[i] * win[i] + mdctbuf[buf + 4 * (i + 12)];
                mdctbuf[buf + 4 * (i + 0)] = out2[i + 6] * win[i + 6];
                outPtr += 32;
            }
            this.imdct12(out2, 0, g.sbHybrid, ptr + 2);
            for (i = 0; i < 6; ++i) {
                mdctbuf[buf + 4 * (i + 0)] = out2[i] * win[i] + mdctbuf[buf + 4 * (i + 0)];
                mdctbuf[buf + 4 * (i + 6)] = out2[i + 6] * win[i + 6];
                mdctbuf[buf + 4 * (i + 12)] = 0.0f;
            }
            ptr += 18;
            buf += (j & 3) != 3 ? 1 : 69;
        }
        for (j = sblimit; j < 32; ++j) {
            int outPtr = j;
            for (int i = 0; i < 18; ++i) {
                sbSamples[outPtr] = mdctbuf[buf + 4 * i];
                mdctbuf[buf + 4 * i] = 0.0f;
                outPtr += 32;
            }
            buf += (j & 3) != 3 ? 1 : 69;
        }
    }

    private int decodeLayer3(int frameStart) {
        int ch;
        int gr;
        int nbGranules;
        int mainDataBegin;
        int[] exponents = new int[576];
        Mp3Header s = this.ctx.header;
        if (s.lsf != 0) {
            mainDataBegin = this.br.read(8);
            this.br.skip(s.nbChannels);
            nbGranules = 1;
        } else {
            mainDataBegin = this.br.read(9);
            if (s.nbChannels == 2) {
                this.br.skip(3);
            } else {
                this.br.skip(5);
            }
            nbGranules = 2;
            for (int ch2 = 0; ch2 < s.nbChannels; ++ch2) {
                this.ctx.granules[ch2][0].scfsi = 0;
                this.ctx.granules[ch2][1].scfsi = this.br.read(4);
            }
        }
        for (gr = 0; gr < nbGranules; ++gr) {
            for (ch = 0; ch < s.nbChannels; ++ch) {
                int i;
                Granule g = this.ctx.granules[ch][gr];
                g.part23Length = this.br.read(12);
                g.bigValues = this.br.read(9);
                if (g.bigValues > 288) {
                    log.error((Object)String.format("bigValues too big %d", g.bigValues));
                    return -3;
                }
                g.globalGain = this.br.read(8);
                if ((s.modeExt & 3) == 2) {
                    g.globalGain -= 2;
                }
                g.scalefacCompress = s.lsf != 0 ? this.br.read(9) : this.br.read(4);
                boolean blocksplitFlag = this.br.readBool();
                if (blocksplitFlag) {
                    g.blockType = this.br.read(2);
                    if (g.blockType == 0) {
                        log.error((Object)String.format("invalid block type", new Object[0]));
                        return -3;
                    }
                    g.switchPoint = this.br.read1();
                    for (i = 0; i < 2; ++i) {
                        g.tableSelect[i] = this.br.read(5);
                    }
                    for (i = 0; i < 3; ++i) {
                        g.subblockGain[i] = this.br.read(3);
                    }
                    this.initShortRegion(g);
                } else {
                    g.blockType = 0;
                    g.switchPoint = 0;
                    for (i = 0; i < 3; ++i) {
                        g.tableSelect[i] = this.br.read(5);
                    }
                    int regionAddress1 = this.br.read(4);
                    int regionAddress2 = this.br.read(3);
                    this.initLongRegion(g, regionAddress1, regionAddress2);
                }
                this.regionOffset2size(g);
                this.computeBandIndexes(g);
                g.preflag = 0;
                if (s.lsf == 0) {
                    g.preflag = this.br.read1();
                }
                g.scalefacScale = this.br.read1();
                g.count1tableSelect = this.br.read1();
            }
        }
        if (this.ctx.aduMode == 0) {
            int currentPosition = this.br.getBytesRead();
            int copyLength = this.ctx.header.frameSize - (currentPosition - frameStart);
            int bitsToSkip = this.bb.getBitsWritten() - this.bb.getBitsRead() - (mainDataBegin << 3);
            for (int i = 0; i < copyLength; ++i) {
                this.bb.writeByte(this.br.readByte());
            }
            this.bb.skip(bitsToSkip);
        }
        for (gr = 0; gr < nbGranules; ++gr) {
            for (ch = 0; ch < s.nbChannels; ++ch) {
                Granule g = this.ctx.granules[ch][gr];
                g.granuleStartPosition = this.bb.getBitsRead();
                if (s.lsf == 0) {
                    int j;
                    int slen1 = Mp3Data.slen_table[0][g.scalefacCompress];
                    int slen2 = Mp3Data.slen_table[1][g.scalefacCompress];
                    if (g.blockType == 2) {
                        int i;
                        int n = g.switchPoint != 0 ? 17 : 18;
                        j = 0;
                        if (slen1 != 0) {
                            for (i = 0; i < n; ++i) {
                                g.scaleFactors[j++] = this.bb.read(slen1);
                            }
                        } else {
                            for (i = 0; i < n; ++i) {
                                g.scaleFactors[j++] = 0;
                            }
                        }
                        if (slen2 != 0) {
                            for (i = 0; i < 18; ++i) {
                                g.scaleFactors[j++] = this.bb.read(slen2);
                            }
                            for (i = 0; i < 3; ++i) {
                                g.scaleFactors[j++] = 0;
                            }
                        } else {
                            for (i = 0; i < 21; ++i) {
                                g.scaleFactors[j++] = 0;
                            }
                        }
                    } else {
                        int[] sc = this.ctx.granules[ch][0].scaleFactors;
                        j = 0;
                        for (int k = 0; k < 4; ++k) {
                            int n;
                            int n2 = n = k == 0 ? 6 : 5;
                            if ((g.scfsi & 8 >> k) == 0) {
                                int i;
                                int slen;
                                int n3 = slen = k < 2 ? slen1 : slen2;
                                if (slen != 0) {
                                    for (i = 0; i < n; ++i) {
                                        g.scaleFactors[j++] = this.bb.read(slen);
                                    }
                                    continue;
                                }
                                for (i = 0; i < n; ++i) {
                                    g.scaleFactors[j++] = 0;
                                }
                                continue;
                            }
                            for (int i = 0; i < n; ++i) {
                                g.scaleFactors[j] = sc[j];
                                ++j;
                            }
                        }
                        g.scaleFactors[j++] = 0;
                    }
                } else {
                    int tindex2;
                    int[] slen = new int[4];
                    int tindex = g.blockType == 2 ? (g.switchPoint != 0 ? 2 : 1) : 0;
                    int sf = g.scalefacCompress;
                    if ((s.modeExt & 1) != 0 && ch == 1) {
                        if ((sf >>= 1) < 180) {
                            this.lsfSfExpand(slen, sf, 6, 6, 0);
                            tindex2 = 3;
                        } else if (sf < 244) {
                            this.lsfSfExpand(slen, sf - 180, 4, 4, 0);
                            tindex2 = 4;
                        } else {
                            this.lsfSfExpand(slen, sf - 244, 3, 0, 0);
                            tindex2 = 5;
                        }
                    } else if (sf < 400) {
                        this.lsfSfExpand(slen, sf, 5, 4, 4);
                        tindex2 = 0;
                    } else if (sf < 500) {
                        this.lsfSfExpand(slen, sf - 400, 5, 4, 0);
                        tindex2 = 1;
                    } else {
                        this.lsfSfExpand(slen, sf - 500, 3, 0, 0);
                        tindex2 = 2;
                        g.preflag = 1;
                    }
                    int j = 0;
                    for (int k = 0; k < 4; ++k) {
                        int i;
                        int n = Mp3Data.lsf_nsf_table[tindex2][tindex][k];
                        int sl = slen[k];
                        if (sl != 0) {
                            for (i = 0; i < n; ++i) {
                                g.scaleFactors[j++] = this.bb.read(sl);
                            }
                            continue;
                        }
                        for (i = 0; i < n; ++i) {
                            g.scaleFactors[j++] = 0;
                        }
                    }
                    while (j < 40) {
                        g.scaleFactors[j] = 0;
                        ++j;
                    }
                }
                this.exponentsFromScaleFactors(g, exponents);
                this.huffmanDecode(g, exponents);
            }
            if (s.mode == 1) {
                this.computeStereo(this.ctx.granules[0][gr], this.ctx.granules[1][gr]);
            }
            for (ch = 0; ch < s.nbChannels; ++ch) {
                Granule g = this.ctx.granules[ch][gr];
                this.reorderBlock(g);
                this.computeAntialias(g);
                this.computeImdct(g, this.ctx.sbSamples[ch], 18 * gr * 32, this.ctx.mdctBuf[ch]);
            }
        }
        return nbGranules * 18;
    }

    private int decodeFrame(int frameStart) {
        int nbFrames;
        if (this.ctx.header.errorProtection != 0) {
            this.br.skip(16);
        }
        switch (this.ctx.header.layer) {
            case 1: {
                nbFrames = this.decodeLayer1();
                break;
            }
            case 2: {
                nbFrames = this.decodeLayer2();
                break;
            }
            default: {
                nbFrames = this.decodeLayer3(frameStart);
            }
        }
        if (nbFrames < 0) {
            return nbFrames;
        }
        if (this.ctx.samples == null) {
            this.ctx.samples = new float[this.ctx.header.nbChannels][this.ctx.header.maxSamples];
        }
        for (int ch = 0; ch < this.ctx.header.nbChannels; ++ch) {
            int sampleStride = 1;
            int samplesPtr = 0;
            for (int i = 0; i < nbFrames; ++i) {
                Mp3Dsp.synthFilter(this.ctx, ch, this.ctx.samples[ch], samplesPtr, sampleStride, this.ctx.sbSamples[ch], i * 32);
                samplesPtr += 32 * sampleStride;
            }
        }
        return nbFrames * 32 * 4 * this.ctx.header.nbChannels;
    }

    @Override
    public int decode(Memory inputMemory, int inputAddr, int inputLength, Memory outputMemory, int outputAddr) {
        this.ctx.br = this.br = new BitReader(inputMemory, inputAddr, inputLength);
        int skippedBytes = 0;
        while (this.br.peek(8) == 0) {
            this.br.skip(8);
            ++skippedBytes;
        }
        if (this.br.getBitsLeft() < 32) {
            return -3;
        }
        int frameStart = this.br.getBytesRead();
        int header = this.br.read(32);
        if (this.mpaCheckHeader(header) < 0) {
            log.error((Object)String.format("Header missing", new Object[0]));
            return -3;
        }
        if (Mp3Decoder.decodeHeader(this.ctx.header, header) == 1) {
            this.ctx.header.frameSize = -1;
            return -3;
        }
        int ret = this.decodeFrame(frameStart);
        if (ret < 0) {
            return ret;
        }
        CodecUtils.writeOutput(this.ctx.samples, outputMemory, outputAddr, this.ctx.header.maxSamples, this.ctx.header.nbChannels, this.ctx.outputChannels);
        return this.ctx.header.frameSize + skippedBytes;
    }

    @Override
    public int getNumberOfSamples() {
        return this.ctx.header.maxSamples;
    }

    public Mp3Header getMp3Header() {
        return this.ctx.header;
    }
}

