/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.TPointer;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.IMemoryReader;

public class MemoryReader {
    private static int getMaxLength(int rawAddress) {
        int address = rawAddress & 0x1FFFFFFF;
        int length = address >= 0x8000000 && address <= MemoryMap.END_RAM ? MemoryMap.END_RAM - address + 1 : (address >= 0x4000000 && address <= 0x41FFFFF ? 0x41FFFFF - address + 1 : (address >= 65536 && address <= 81919 ? 81919 - address + 1 : (rawAddress >= -1140850688 && rawAddress <= -1073741825 ? -1073741825 - rawAddress + 1 : 0)));
        return length;
    }

    private static IMemoryReader getFastMemoryReader(int address, int step) {
        int[] memoryInt = RuntimeContext.getMemoryInt();
        switch (step) {
            case 1: {
                return new MemoryReaderIntArray8(memoryInt, address);
            }
            case 2: {
                return new MemoryReaderIntArray16(memoryInt, address);
            }
            case 4: {
                return new MemoryReaderIntArray32(memoryInt, address);
            }
        }
        return new MemoryReaderGeneric(address, MemoryReader.getMaxLength(address), step);
    }

    public static IMemoryReader getMemoryReader(int address, int length, int step) {
        if (RuntimeContext.hasMemoryInt(address)) {
            return MemoryReader.getFastMemoryReader(address, step);
        }
        if (!DebuggerMemory.isInstalled()) {
            Buffer buffer = Emulator.getMemory(address).getBuffer(address, length);
            if (buffer instanceof IntBuffer) {
                IntBuffer intBuffer = (IntBuffer)buffer;
                switch (step) {
                    case 1: {
                        return new MemoryReaderInt8(intBuffer, address);
                    }
                    case 2: {
                        return new MemoryReaderInt16(intBuffer, address);
                    }
                    case 4: {
                        return new MemoryReaderInt32(intBuffer, address);
                    }
                }
            } else if (buffer instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                switch (step) {
                    case 1: {
                        return new MemoryReaderByte8(byteBuffer, address);
                    }
                    case 2: {
                        return new MemoryReaderByte16(byteBuffer, address);
                    }
                    case 4: {
                        return new MemoryReaderByte32(byteBuffer, address);
                    }
                }
            }
        }
        return new MemoryReaderGeneric(address, length, step);
    }

    public static IMemoryReader getMemoryReader(Memory mem, int address, int length, int step) {
        if (mem == RuntimeContext.memory) {
            return MemoryReader.getMemoryReader(address, length, step);
        }
        return new MemoryReaderGeneric(mem, address, length, step);
    }

    public static IMemoryReader getMemoryReader(TPointer address, int length, int step) {
        return MemoryReader.getMemoryReader(address.getMemory(), address.getAddress(), length, step);
    }

    public static IMemoryReader getMemoryReader(int address, int step) {
        if (RuntimeContext.hasMemoryInt(address)) {
            return MemoryReader.getFastMemoryReader(address, step);
        }
        return MemoryReader.getMemoryReader(address, MemoryReader.getMaxLength(address), step);
    }

    public static IMemoryReader getMemoryReader(Memory mem, int address, int step) {
        return MemoryReader.getMemoryReader(mem, address, MemoryReader.getMaxLength(address), step);
    }

    public static IMemoryReader getMemoryReader(int address, byte[] bytes, int offset, int length, int step) {
        switch (step) {
            case 1: {
                return new MemoryReaderBytes8(address, bytes, offset, length);
            }
            case 2: {
                return new MemoryReaderBytes16(address, bytes, offset, length);
            }
            case 4: {
                return new MemoryReaderBytes32(address, bytes, offset, length);
            }
        }
        return null;
    }

    public static IMemoryReader getMemoryReader(int address, int[] ints, int offset, int length) {
        return new MemoryReaderInts32(address, ints, offset, length);
    }

    private static final class MemoryReaderInts32
    implements IMemoryReader {
        private int address;
        private final int[] ints;
        private int offset;
        private int maxOffset;

        public MemoryReaderInts32(int address, int[] ints, int offset, int length) {
            this.address = address;
            this.ints = ints;
            this.offset = offset;
            this.maxOffset = offset + (length >> 2);
        }

        @Override
        public int readNext() {
            if (this.offset >= this.maxOffset) {
                return 0;
            }
            this.address += 4;
            return this.ints[this.offset++];
        }

        @Override
        public void skip(int n) {
            this.offset += n;
            this.address += n * 4;
        }

        @Override
        public int getCurrentAddress() {
            return this.address;
        }
    }

    private static final class MemoryReaderBytes32
    implements IMemoryReader {
        private int address;
        private final byte[] bytes;
        private int offset;
        private int maxOffset;

        public MemoryReaderBytes32(int address, byte[] bytes, int offset, int length) {
            this.address = address;
            this.bytes = bytes;
            this.offset = offset;
            this.maxOffset = offset + length;
        }

        @Override
        public int readNext() {
            if (this.offset >= this.maxOffset) {
                return 0;
            }
            this.address += 4;
            return this.bytes[this.offset++] & 0xFF | (this.bytes[this.offset++] & 0xFF) << 8 | (this.bytes[this.offset++] & 0xFF) << 16 | (this.bytes[this.offset++] & 0xFF) << 24;
        }

        @Override
        public void skip(int n) {
            this.offset += n * 4;
            this.address += n * 4;
        }

        @Override
        public int getCurrentAddress() {
            return this.address;
        }
    }

    private static final class MemoryReaderBytes16
    implements IMemoryReader {
        private int address;
        private final byte[] bytes;
        private int offset;
        private int maxOffset;

        public MemoryReaderBytes16(int address, byte[] bytes, int offset, int length) {
            this.address = address;
            this.bytes = bytes;
            this.offset = offset;
            this.maxOffset = offset + length;
        }

        @Override
        public int readNext() {
            if (this.offset >= this.maxOffset) {
                return 0;
            }
            this.address += 2;
            return this.bytes[this.offset++] & 0xFF | (this.bytes[this.offset++] & 0xFF) << 8;
        }

        @Override
        public void skip(int n) {
            this.offset += n * 2;
            this.address += n * 2;
        }

        @Override
        public int getCurrentAddress() {
            return this.address;
        }
    }

    private static final class MemoryReaderBytes8
    implements IMemoryReader {
        private int address;
        private final byte[] bytes;
        private int offset;
        private int maxOffset;

        public MemoryReaderBytes8(int address, byte[] bytes, int offset, int length) {
            this.address = address;
            this.bytes = bytes;
            this.offset = offset;
            this.maxOffset = offset + length;
        }

        @Override
        public int readNext() {
            if (this.offset >= this.maxOffset) {
                return 0;
            }
            ++this.address;
            return this.bytes[this.offset++] & 0xFF;
        }

        @Override
        public void skip(int n) {
            this.offset += n;
            this.address += n;
        }

        @Override
        public int getCurrentAddress() {
            return this.address;
        }
    }

    private static final class MemoryReaderByte32
    implements IMemoryReader {
        private ByteBuffer buffer;
        private int address;

        public MemoryReaderByte32(ByteBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address;
        }

        @Override
        public final int readNext() {
            return this.buffer.getInt();
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.buffer.position(this.buffer.position() + (n << 2));
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + this.buffer.position();
        }
    }

    private static final class MemoryReaderByte16
    implements IMemoryReader {
        private ByteBuffer buffer;
        private int address;

        public MemoryReaderByte16(ByteBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address;
        }

        @Override
        public final int readNext() {
            return this.buffer.getShort() & 0xFFFF;
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.buffer.position(this.buffer.position() + (n << 1));
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + this.buffer.position();
        }
    }

    private static final class MemoryReaderByte8
    implements IMemoryReader {
        private ByteBuffer buffer;
        private int address;

        public MemoryReaderByte8(ByteBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address;
        }

        @Override
        public final int readNext() {
            return this.buffer.get() & 0xFF;
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.buffer.position(this.buffer.position() + n);
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + this.buffer.position();
        }
    }

    private static final class MemoryReaderInt32
    implements IMemoryReader {
        private IntBuffer buffer;
        private int address;

        public MemoryReaderInt32(IntBuffer buffer, int address) {
            this.buffer = buffer;
            this.address = address;
        }

        @Override
        public final int readNext() {
            return this.buffer.get();
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.buffer.position(this.buffer.position() + n);
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + (this.buffer.position() << 2);
        }
    }

    private static final class MemoryReaderInt16
    implements IMemoryReader {
        private int index;
        private int value;
        private IntBuffer buffer;
        private int address;

        public MemoryReaderInt16(IntBuffer buffer, int index) {
            this.buffer = buffer;
            this.address &= 0xFFFFFFFC;
            this.index = (this.address & 2) >> 1;
            if (index != 0 && buffer.capacity() > 0) {
                this.value = buffer.get();
            }
        }

        @Override
        public final int readNext() {
            int n;
            if (this.index == 0) {
                this.value = this.buffer.get();
                n = this.value & 0xFFFF;
                this.index = 1;
            } else {
                this.index = 0;
                n = this.value >>> 16;
            }
            return n;
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.index += n;
                this.buffer.position(this.buffer.position() + (this.index >> 1));
                this.index &= 1;
                if (this.index != 0) {
                    this.value = this.buffer.get();
                }
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + (this.buffer.position() << 2) + this.index;
        }
    }

    private static final class MemoryReaderInt8
    implements IMemoryReader {
        private int index;
        private int value;
        private IntBuffer buffer;
        private int address;

        public MemoryReaderInt8(IntBuffer buffer, int index) {
            this.buffer = buffer;
            this.address &= 0xFFFFFFFC;
            index = this.address & 3;
            if (buffer.capacity() > 0) {
                this.value = buffer.get() >> (index << 3);
            }
        }

        @Override
        public final int readNext() {
            if (this.index == 4) {
                this.index = 0;
                this.value = this.buffer.get();
            }
            int n = this.value & 0xFF;
            this.value >>= 8;
            ++this.index;
            return n;
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.index += n;
                this.buffer.position(this.buffer.position() + (this.index >> 2));
                this.index &= 3;
                this.value = this.buffer.get() >> 8 * this.index;
            }
        }

        @Override
        public int getCurrentAddress() {
            return this.address + (this.buffer.position() << 2) + this.index;
        }
    }

    private static final class MemoryReaderIntArray32
    implements IMemoryReader {
        private int offset;
        private int[] buffer;

        public MemoryReaderIntArray32(int[] buffer, int addr) {
            this.offset = (addr & 0x1FFFFFFF) >> 2;
            this.buffer = buffer;
        }

        @Override
        public final int readNext() {
            return this.buffer[this.offset++];
        }

        @Override
        public final void skip(int n) {
            this.offset += n;
        }

        @Override
        public int getCurrentAddress() {
            return this.offset << 2;
        }
    }

    private static final class MemoryReaderIntArray16
    implements IMemoryReader {
        private int index;
        private int offset;
        private int value;
        private int[] buffer;

        public MemoryReaderIntArray16(int[] buffer, int addr) {
            this.buffer = buffer;
            this.offset = (addr & 0x1FFFFFFF) >> 2;
            this.index = addr >> 1 & 1;
            if (this.index != 0) {
                this.value = buffer[this.offset];
            }
        }

        @Override
        public final int readNext() {
            int n;
            if (this.index == 0) {
                this.value = this.buffer[this.offset];
                n = this.value & 0xFFFF;
                this.index = 1;
            } else {
                this.index = 0;
                ++this.offset;
                n = this.value >>> 16;
            }
            return n;
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.index += n;
                this.offset += this.index >> 1;
                this.index &= 1;
                if (this.index != 0) {
                    this.value = this.buffer[this.offset];
                }
            }
        }

        @Override
        public int getCurrentAddress() {
            return (this.offset << 2) + (this.index << 1);
        }
    }

    private static final class MemoryReaderIntArray8
    implements IMemoryReader {
        private int index;
        private int offset;
        private int value;
        private int[] buffer;

        public MemoryReaderIntArray8(int[] buffer, int addr) {
            this.buffer = buffer;
            this.offset = (addr & 0x1FFFFFFF) >> 2;
            this.index = addr & 3;
            this.value = buffer[this.offset] >> (this.index << 3);
        }

        @Override
        public final int readNext() {
            if (this.index == 4) {
                this.index = 0;
                ++this.offset;
                this.value = this.buffer[this.offset];
            }
            int n = this.value & 0xFF;
            this.value >>= 8;
            ++this.index;
            return n;
        }

        @Override
        public final void skip(int n) {
            if (n > 0) {
                this.index += n;
                this.offset += this.index >> 2;
                this.index &= 3;
                this.value = this.buffer[this.offset] >> (this.index << 3);
            }
        }

        @Override
        public int getCurrentAddress() {
            return (this.offset << 2) + this.index;
        }
    }

    private static final class MemoryReaderGeneric
    implements IMemoryReader {
        private final Memory mem;
        private int address;
        private int length;
        private final int step;

        public MemoryReaderGeneric(Memory mem, int address, int length, int step) {
            this.mem = mem;
            this.address = address;
            this.length = length;
            this.step = step;
        }

        public MemoryReaderGeneric(int address, int length, int step) {
            this.address = address;
            this.length = length;
            this.step = step;
            this.mem = Emulator.getMemory(address);
        }

        @Override
        public final int readNext() {
            int n;
            if (this.length <= 0) {
                return 0;
            }
            switch (this.step) {
                case 1: {
                    n = this.mem.read8(this.address);
                    break;
                }
                case 2: {
                    n = this.mem.read16(this.address);
                    break;
                }
                case 4: {
                    n = this.mem.read32(this.address);
                    break;
                }
                default: {
                    n = 0;
                }
            }
            this.address += this.step;
            this.length -= this.step;
            return n;
        }

        @Override
        public final void skip(int n) {
            this.address += n * this.step;
            this.length -= n * this.step;
        }

        @Override
        public int getCurrentAddress() {
            return this.address;
        }
    }
}

