/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.HLE.modules.sceHibari;
import jpcsp.hardware.Model;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerLcdControllerSlim
extends MMIOHandlerBase {
    public static Logger log = sceHibari.log;
    private static final int STATE_VERSION = 0;
    private int unknown08;
    private int unknown0C;

    public MMIOHandlerLcdControllerSlim(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.unknown08 = stream.readInt();
        this.unknown0C = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.unknown08);
        stream.writeInt(this.unknown0C);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.unknown08 = 0;
        this.unknown0C = 0;
    }

    private void setUnknown04(int value) {
        if (value == 2) {
            this.unknown0C |= 2;
        }
    }

    private void setUnknown08(int value) {
        this.unknown08 = value;
        switch (value) {
            case 48: 
            case 7680: 
            case 8192: 
            case 12528: 
            case 12544: 
            case 49408: 
            case 49409: 
            case 49440: 
            case 49442: 
            case 49443: 
            case 49444: 
            case 49452: 
            case 49470: 
            case 49472: 
            case 49511: 
            case 49512: 
            case 49515: 
            case 49612: 
            case 49616: 
            case 52993: 
            case 61184: {
                this.unknown0C |= 4;
                break;
            }
            case 15872: {
                this.unknown0C |= 4;
                this.unknown08 |= 0xA0;
                break;
            }
            case 49664: {
                this.unknown0C |= 4;
                if (Model.getGeneration() == 7) {
                    this.unknown08 |= 7;
                    break;
                }
                this.unknown08 |= 0xD7;
            }
        }
    }

    private int readUnknown08() {
        this.unknown0C &= 0xFFFFFFFB;
        return this.unknown08;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 8: {
                value = this.readUnknown08();
                break;
            }
            case 12: {
                value = this.unknown0C;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                break;
            }
            case 4: {
                this.setUnknown04(value);
                break;
            }
            case 8: {
                this.setUnknown08(value);
                break;
            }
            case 16: {
                break;
            }
            case 20: {
                break;
            }
            case 36: {
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

