/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.modules.sceNand;
import jpcsp.hardware.Model;
import jpcsp.memory.IntArrayMemory;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerNandPage;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerNand
extends MMIOHandlerBase {
    public static Logger log = sceNand.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1123020800;
    public static final int PSP_NAND_CONTROL_AUTO_USER_ECC = 65536;
    public static final int PSP_NAND_STATUS_READY = 1;
    public static final int PSP_NAND_STATUS_WRITE_ENABLED = 128;
    public static final int PSP_NAND_INTR_WRITE_COMPLETED = 2;
    public static final int PSP_NAND_INTR_READ_COMPLETED = 1;
    public static final int PSP_NAND_COMMAND_READ_EXTRA = 80;
    public static final int PSP_NAND_COMMAND_ERASE_BLOCK = 96;
    public static final int PSP_NAND_COMMAND_GET_READ_STATUS = 112;
    public static final int PSP_NAND_COMMAND_READ_ID = 144;
    public static final int PSP_NAND_COMMAND_ERASE_BLOCK_CONFIRM = 208;
    public static final int PSP_NAND_COMMAND_RESET = 255;
    private static final int DMA_CONTROL_START = 1;
    private static final int DMA_CONTROL_WRITE = 2;
    private static MMIOHandlerNand instance;
    private final IntArrayMemory pageDataMemory;
    private final IntArrayMemory pageEccMemory;
    private final IntArrayMemory dataMemory;
    private final IntArrayMemory scrambleBufferMemory;
    private int control;
    private int status;
    private int command;
    private int pageAddress;
    private final int[] data = new int[4];
    private int dataIndex;
    private int dmaAddress;
    private int dmaControl;
    private int dmaStatus;
    private int dmaInterrupt;
    private int unknown200;
    private boolean needPageAddress;
    private final int[] scrambleBuffer = new int[128];

    public static MMIOHandlerNand getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerNand(-1123020800);
        }
        return instance;
    }

    private MMIOHandlerNand(int baseAddress) {
        super(baseAddress);
        this.pageDataMemory = new IntArrayMemory(MMIOHandlerNandPage.getInstance().getData());
        this.pageEccMemory = new IntArrayMemory(MMIOHandlerNandPage.getInstance().getEcc());
        this.dataMemory = new IntArrayMemory(this.data);
        this.scrambleBufferMemory = new IntArrayMemory(this.scrambleBuffer);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.control = stream.readInt();
        this.status = stream.readInt();
        this.command = stream.readInt();
        this.pageAddress = stream.readInt();
        stream.readInts(this.data);
        this.dataIndex = stream.readInt();
        this.dmaAddress = stream.readInt();
        this.dmaControl = stream.readInt();
        this.dmaStatus = stream.readInt();
        this.dmaInterrupt = stream.readInt();
        this.unknown200 = stream.readInt();
        this.needPageAddress = stream.readBoolean();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.control);
        stream.writeInt(this.status);
        stream.writeInt(this.command);
        stream.writeInt(this.pageAddress);
        stream.writeInts(this.data);
        stream.writeInt(this.dataIndex);
        stream.writeInt(this.dmaAddress);
        stream.writeInt(this.dmaControl);
        stream.writeInt(this.dmaStatus);
        stream.writeInt(this.dmaInterrupt);
        stream.writeInt(this.unknown200);
        stream.writeBoolean(this.needPageAddress);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        Modules.sceNandModule.reset();
        this.control = 0;
        this.status = 1;
        this.command = 0;
        this.pageAddress = 0;
        Arrays.fill(this.data, 0);
        this.dataIndex = 0;
        this.dmaAddress = 0;
        this.dmaControl = 0;
        this.dmaStatus = 0;
        this.dmaInterrupt = 0;
        this.unknown200 = 0;
        this.needPageAddress = false;
    }

    private void startCommand(int command) {
        this.command = command;
        this.dataIndex = 0;
        this.needPageAddress = false;
        switch (command) {
            case 255: {
                break;
            }
            case 112: {
                this.data[0] = this.status & 0x80;
                break;
            }
            case 144: {
                this.needPageAddress = true;
                break;
            }
            case 80: {
                this.needPageAddress = true;
                break;
            }
            case 96: {
                this.needPageAddress = true;
                break;
            }
            case 208: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("PSP_NAND_COMMAND_ERASE_BLOCK ppn=0x%X", this.pageAddress >> 10));
                break;
            }
            default: {
                log.error((Object)String.format("MMIOHandlerNand.startCommand unknown command 0x%X", command));
            }
        }
    }

    private void startCommandWithPageAddress() {
        this.needPageAddress = false;
        switch (this.command) {
            case 144: {
                if (this.pageAddress != 0) break;
                this.data[0] = 236;
                if (sceNand.isSmallNand()) {
                    this.data[1] = 117;
                    break;
                }
                this.data[1] = 54;
                break;
            }
            case 80: {
                TPointer spare = this.dataMemory.getPointer();
                Modules.sceNandModule.hleNandReadPages(this.pageAddress >> 10, TPointer.NULL, spare, 1, true, true, true);
                break;
            }
            case 96: {
                Modules.sceNandModule.hleNandEraseBlock(this.pageAddress >> 10, true);
            }
        }
    }

    private void endCommand(int value) {
        if (value == 1) {
            this.dataIndex = 0;
        }
    }

    private void writePageAddress(int pageAddress) {
        this.pageAddress = pageAddress;
        if (this.needPageAddress) {
            this.startCommandWithPageAddress();
        }
    }

    private int readData() {
        return this.data[this.dataIndex++];
    }

    public static int getScrambleBootSector(long fuseId, int partitionNumber) {
        int scramble = (int)fuseId ^ Integer.rotateLeft((int)(fuseId >> 32), partitionNumber * 2);
        if (scramble == 0) {
            scramble = Integer.rotateLeft(-1001165338, partitionNumber);
        }
        return scramble;
    }

    private static int getScrambleConstant() {
        int firmwareVersion = RuntimeContextLLE.getFirmwareVersion();
        if (firmwareVersion >= 660) {
            return 1433240062;
        }
        if (firmwareVersion >= 630) {
            return -479192453;
        }
        if (firmwareVersion >= 600) {
            return -860296821;
        }
        if (firmwareVersion >= 500) {
            return -1842165098;
        }
        if (firmwareVersion >= 390) {
            return -761820581;
        }
        if (firmwareVersion >= 370) {
            return -191835534;
        }
        if (firmwareVersion >= 350) {
            return -547211078;
        }
        if (firmwareVersion >= 330) {
            return -1684200095;
        }
        if (firmwareVersion >= 310) {
            return -28424131;
        }
        if (firmwareVersion >= 300) {
            return -67362376;
        }
        return 0;
    }

    public static int getScrambleDataSector(long fuseId, int partitionNumber) {
        if (partitionNumber == 3) {
            return 1008894250;
        }
        int scramble = (int)fuseId ^ Integer.rotateRight((int)(fuseId >> 32), partitionNumber * 3);
        int scrambleConstant = MMIOHandlerNand.getScrambleConstant();
        if ((scramble ^= scrambleConstant) == 0) {
            scramble = Integer.rotateRight(scrambleConstant, partitionNumber);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("getScrambleDataSector partitionNumber=%d, value=0x%08X, scramble=0x%08X", partitionNumber, scrambleConstant, scramble));
        }
        return scramble;
    }

    public int getScramble(int ppn) {
        if (RuntimeContextLLE.getFirmwareVersion() < 300) {
            return 0;
        }
        long fuseId = Modules.sceSysregModule.sceSysregGetFuseId();
        int lbn = Modules.sceNandModule.getLbnFromPpn(ppn);
        int sector = ppn % 32;
        int scramble = 0;
        if (ppn >= 128 && ppn <= 383) {
            scramble = 0;
        } else if (ppn >= 512 && ppn <= 991) {
            scramble = 0;
        } else if (ppn >= 1536 && ppn <= 2047) {
            if (Model.getTachyonVersion() < 0x500000) {
                scramble = 0;
            } else {
                byte[] bytes = new byte[16];
                Utilities.writeUnaligned64(bytes, 0, fuseId);
                Utilities.writeUnaligned32(bytes, 8, (int)fuseId << 1);
                Utilities.writeUnaligned32(bytes, 12, -736260903);
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-1");
                    byte[] hash = md.digest(bytes);
                    scramble = (Utilities.readUnaligned32(hash, 0) ^ Utilities.readUnaligned32(hash, 12)) + Utilities.readUnaligned32(hash, 8);
                }
                catch (Exception e) {
                    log.error((Object)"getScramble", (Throwable)e);
                }
            }
        } else if (lbn == 3 && sector == 0) {
            scramble = MMIOHandlerNand.getScrambleBootSector(fuseId, 0);
        } else if (lbn >= 4 && lbn < sceNand.flash1LbnStart - 1) {
            scramble = MMIOHandlerNand.getScrambleDataSector(fuseId, 0);
        } else if (lbn >= sceNand.flash1LbnStart && lbn < sceNand.flash2LbnStart - 1) {
            scramble = 0;
        } else if (lbn == sceNand.flash2LbnStart + 1 && sector == 0) {
            scramble = MMIOHandlerNand.getScrambleBootSector(fuseId, 2);
        } else if (lbn >= sceNand.flash2LbnStart + 2 && lbn < sceNand.flash3LbnStart) {
            scramble = MMIOHandlerNand.getScrambleDataSector(fuseId, 2);
        } else if (lbn == sceNand.flash3LbnStart && sector == 0) {
            scramble = Model.getTachyonVersion() < 0x500000 ? MMIOHandlerNand.getScrambleBootSector(fuseId, 3) : 0;
        } else if (lbn >= sceNand.flash3LbnStart + 1) {
            scramble = MMIOHandlerNand.getScrambleDataSector(fuseId, 3);
        } else if (lbn == sceNand.flash4LbnStart && sector == 0) {
            scramble = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("getScramble ppn=0x%X, lbn=0x%X, sector=0x%X, scramble=0x%X", ppn, lbn, sector, scramble));
        }
        return scramble;
    }

    private void startDma(int value) {
        this.dmaControl = value;
        if (Utilities.hasFlag(this.dmaControl, 1)) {
            int ppn = this.dmaAddress >> 10;
            int scramble = this.getScramble(ppn);
            if ((this.dmaControl & 2) != 0) {
                int lbn = Utilities.endianSwap16(this.pageEccMemory.read16(6) & 0xFFFF);
                TPointer spare = this.pageEccMemory.getPointer();
                Modules.sceNandModule.hleNandWriteSparePages(ppn, spare, 1, true, true, true);
                TPointer user = this.pageDataMemory.getPointer();
                scramble = this.getScramble(ppn);
                if (scramble != 0) {
                    sceNand.descramblePage(scramble, ppn, MMIOHandlerNandPage.getInstance().getData(), this.scrambleBuffer);
                    user = this.scrambleBufferMemory.getPointer();
                }
                Modules.sceNandModule.hleNandWriteUserPages(ppn, user, 1, true, true);
                if (log.isDebugEnabled()) {
                    byte[] userBytes = new byte[512];
                    user = scramble != 0 ? this.scrambleBufferMemory.getPointer() : this.pageDataMemory.getPointer();
                    for (int i = 0; i < userBytes.length; ++i) {
                        userBytes[i] = user.getValue8(i);
                    }
                    byte[] spareBytes = new byte[16];
                    spare = this.pageEccMemory.getPointer();
                    for (int i = 0; i < spareBytes.length; ++i) {
                        spareBytes[i] = spare.getValue8(i);
                    }
                    log.debug((Object)String.format("hleNandWritePages ppn=0x%X, lbn=0x%X, scramble=0x%X: %s%sSpare: %s", ppn, lbn, scramble, Utilities.getMemoryDump(userBytes), Utilities.lineSeparator, Utilities.getMemoryDump(spareBytes)));
                }
                this.dmaControl = Utilities.clearFlag(this.dmaControl, 1);
                this.triggerInterrupt(2);
            } else {
                TPointer user = scramble != 0 ? this.scrambleBufferMemory.getPointer() : this.pageDataMemory.getPointer();
                TPointer spare = this.pageEccMemory.getPointer();
                Modules.sceNandModule.sceNandSetScramble(scramble);
                Modules.sceNandModule.hleNandReadPages(ppn, user, spare, 1, true, true, true);
                if (log.isDebugEnabled()) {
                    byte[] bytes = new byte[512];
                    user = scramble != 0 ? this.scrambleBufferMemory.getPointer() : this.pageDataMemory.getPointer();
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = user.getValue8(i);
                    }
                    log.debug((Object)String.format("hleNandReadPages ppn=0x%X, scramble=0x%X: %s", ppn, scramble, Utilities.getMemoryDump(bytes)));
                }
                if (scramble != 0) {
                    sceNand.scramblePage(scramble, ppn, this.scrambleBuffer, MMIOHandlerNandPage.getInstance().getData());
                }
                this.dmaControl = Utilities.clearFlag(this.dmaControl, 1);
                this.triggerInterrupt(1);
            }
        }
    }

    private void writeDmaInterrupt(int dmaInterrupt) {
        this.dmaInterrupt &= 0xFFFFFFFC;
        this.checkInterrupt();
    }

    private void triggerInterrupt(int dmaInterrupt) {
        this.dmaInterrupt |= 0x300 | dmaInterrupt;
        this.checkInterrupt();
    }

    private void checkInterrupt() {
        if ((this.dmaInterrupt & 3) != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 20);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 20);
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.control;
                break;
            }
            case 4: {
                value = this.status;
                break;
            }
            case 8: {
                value = this.command;
                break;
            }
            case 12: {
                value = this.pageAddress;
                break;
            }
            case 32: {
                value = this.dmaAddress;
                break;
            }
            case 36: {
                value = this.dmaControl;
                break;
            }
            case 40: {
                value = this.dmaStatus;
                break;
            }
            case 56: {
                value = this.dmaInterrupt;
                break;
            }
            case 512: {
                value = this.unknown200;
                break;
            }
            case 768: {
                value = this.readData();
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.control = value;
                break;
            }
            case 4: {
                this.status = value;
                break;
            }
            case 8: {
                this.startCommand(value);
                break;
            }
            case 12: {
                this.writePageAddress(value);
                break;
            }
            case 20: {
                this.endCommand(value);
                break;
            }
            case 32: {
                this.dmaAddress = value;
                break;
            }
            case 36: {
                this.startDma(value);
                break;
            }
            case 40: {
                this.dmaStatus = value;
                break;
            }
            case 56: {
                this.writeDmaInterrupt(value);
                break;
            }
            case 512: {
                this.unknown200 = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

