/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceUsb;
import jpcsp.Memory;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerSystemControl;
import jpcsp.scheduler.Scheduler;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerUsb
extends MMIOHandlerBase {
    public static Logger log = sceUsb.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1115684864;
    private static MMIOHandlerUsb instance;
    private final Endpoint[] sendingEndpoints = new SendingEndpoint[5];
    private final Endpoint[] receivingEndpoints = new ReceivingEndpoint[5];
    private int unknown400;
    private int unknown404;
    private int unknown408;
    public static final int CONNECTION_INTERRUPT_CONNECT = 0;
    public static final int CONNECTION_INTERRUPT_STREAMING = 1;
    public static final int CONNECTION_INTERRUPT_DETACH_1 = 2;
    public static final int CONNECTION_INTERRUPT_DETACH_2 = 4;
    public static final int CONNECTION_INTERRUPT_UNKNOWN_6 = 6;
    private int connectionInterrupt;
    private int connectionInterruptEnabled;
    private int unknown414;
    private int endpointsInterfacesDisabled;
    private int unknown41C;
    private int unknown504;
    private final int[] unknown508 = new int[4];
    private int state = 0;

    public static MMIOHandlerUsb getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerUsb(-1115684864);
        }
        return instance;
    }

    private MMIOHandlerUsb(int baseAddress) {
        super(baseAddress);
        int i;
        for (i = 0; i < this.sendingEndpoints.length; ++i) {
            this.sendingEndpoints[i] = new SendingEndpoint(this.getMemory(), i);
        }
        for (i = 0; i < this.receivingEndpoints.length; ++i) {
            this.receivingEndpoints[i] = new ReceivingEndpoint(this.getMemory(), i);
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        int i;
        stream.readVersion(0);
        for (i = 0; i < this.sendingEndpoints.length; ++i) {
            this.sendingEndpoints[i].read(stream);
        }
        for (i = 0; i < this.receivingEndpoints.length; ++i) {
            this.receivingEndpoints[i].read(stream);
        }
        this.unknown400 = stream.readInt();
        this.unknown404 = stream.readInt();
        this.unknown408 = stream.readInt();
        this.connectionInterrupt = stream.readInt();
        this.connectionInterruptEnabled = stream.readInt();
        this.unknown414 = stream.readInt();
        this.endpointsInterfacesDisabled = stream.readInt();
        this.unknown41C = stream.readInt();
        this.unknown504 = stream.readInt();
        stream.readInts(this.unknown508);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        int i;
        stream.writeVersion(0);
        for (i = 0; i < this.sendingEndpoints.length; ++i) {
            this.sendingEndpoints[i].write(stream);
        }
        for (i = 0; i < this.receivingEndpoints.length; ++i) {
            this.receivingEndpoints[i].write(stream);
        }
        stream.writeInt(this.unknown400);
        stream.writeInt(this.unknown404);
        stream.writeInt(this.unknown408);
        stream.writeInt(this.connectionInterrupt);
        stream.writeInt(this.connectionInterruptEnabled);
        stream.writeInt(this.unknown414);
        stream.writeInt(this.endpointsInterfacesDisabled);
        stream.writeInt(this.unknown41C);
        stream.writeInt(this.unknown504);
        stream.writeInts(this.unknown508);
        super.write(stream);
    }

    @Override
    public void reset() {
        int i;
        super.reset();
        for (i = 0; i < this.sendingEndpoints.length; ++i) {
            this.sendingEndpoints[i].reset();
        }
        for (i = 0; i < this.receivingEndpoints.length; ++i) {
            this.receivingEndpoints[i].reset();
        }
        this.unknown400 = 0;
        this.unknown404 = 0;
        this.unknown408 = 0;
        this.connectionInterrupt = 0;
        this.connectionInterruptEnabled = 0;
        this.unknown414 = 0;
        this.endpointsInterfacesDisabled = 0;
        this.unknown41C = 0;
        this.unknown504 = 0;
        for (i = 0; i < this.unknown508.length; ++i) {
            this.unknown508[i] = 0;
        }
    }

    public void triggerReset() {
        Emulator.getScheduler().addAction(Scheduler.getNow() + 1000L, new UsbReset());
    }

    private void checkConnectionInterrupt() {
        if ((this.connectionInterrupt & this.connectionInterruptEnabled) != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 26);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 26);
        }
    }

    private void triggerConnectionInterrupt(int bit) {
        this.connectionInterrupt = Utilities.setBit(this.connectionInterrupt, bit);
        this.checkConnectionInterrupt();
    }

    private void clearConnectionInterrupt(int mask) {
        this.connectionInterrupt &= ~mask;
        this.checkConnectionInterrupt();
    }

    private void clearUnknown414(int mask) {
        this.unknown414 &= ~mask;
    }

    private void setConnectionInterruptEnabled(int value) {
        this.connectionInterruptEnabled = value;
        this.checkConnectionInterrupt();
    }

    private void moveToConnectionEstablished() {
        this.unknown408 = 15;
        this.triggerConnectionInterrupt(0);
    }

    private void setUnknown404(int value) {
        int oldValue = this.unknown404;
        this.unknown404 = value;
        if (value == 528 || value == 540 && oldValue == 528 || value == 1564 || value == 1552) {
            // empty if block
        }
    }

    protected boolean isEndpointEnabled(int endpointNumber) {
        return Utilities.notHasBit(this.endpointsInterfacesDisabled, endpointNumber);
    }

    protected boolean isInterfaceEnabled(int interfaceNumber) {
        return Utilities.notHasBit(this.endpointsInterfacesDisabled, interfaceNumber + 16);
    }

    private void setEndpointsInterfacesDisabled(int value) {
        int oldEndpointsInterfacesDisabled = this.endpointsInterfacesDisabled;
        this.endpointsInterfacesDisabled = value &= 0x1FF01FF;
        for (int i = 0; i < this.sendingEndpoints.length; ++i) {
            if (!Utilities.isFallingBit(oldEndpointsInterfacesDisabled, this.endpointsInterfacesDisabled, i)) continue;
            if (this.state == 1 || this.state == 6 || this.state == 10 || this.state == 17 || this.state == 22) {
                log.error((Object)String.format("setEndpointsInterfacesDisabled enabling interface %d, state=%d", i, this.state));
                this.unknown414 = Utilities.setBit(this.unknown414, i);
                this.sendingEndpoints[i].status |= 0x40;
                RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 26);
                ++this.state;
                continue;
            }
            log.error((Object)String.format("setEndpointsInterfacesDisabled unimplemented enabling interface %d, state=%d", i, this.state));
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 28: {
                value = this.sendingEndpoints[0].read32(address - this.baseAddress - 0);
                break;
            }
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: {
                value = this.sendingEndpoints[1].read32(address - this.baseAddress - 32);
                break;
            }
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 80: 
            case 84: 
            case 88: 
            case 92: {
                value = this.sendingEndpoints[2].read32(address - this.baseAddress - 64);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 124: {
                value = this.sendingEndpoints[3].read32(address - this.baseAddress - 96);
                break;
            }
            case 128: 
            case 132: 
            case 136: 
            case 140: 
            case 144: 
            case 148: 
            case 152: 
            case 156: {
                value = this.sendingEndpoints[4].read32(address - this.baseAddress - 128);
                break;
            }
            case 512: 
            case 516: 
            case 520: 
            case 524: 
            case 528: 
            case 532: 
            case 536: 
            case 540: {
                value = this.receivingEndpoints[0].read32(address - this.baseAddress - 512);
                break;
            }
            case 544: 
            case 548: 
            case 552: 
            case 556: 
            case 560: 
            case 564: 
            case 568: 
            case 572: {
                value = this.receivingEndpoints[1].read32(address - this.baseAddress - 544);
                break;
            }
            case 576: 
            case 580: 
            case 584: 
            case 588: 
            case 592: 
            case 596: 
            case 600: 
            case 604: {
                value = this.receivingEndpoints[2].read32(address - this.baseAddress - 576);
                break;
            }
            case 608: 
            case 612: 
            case 616: 
            case 620: 
            case 624: 
            case 628: 
            case 632: 
            case 636: {
                value = this.receivingEndpoints[3].read32(address - this.baseAddress - 608);
                break;
            }
            case 640: 
            case 644: 
            case 648: 
            case 652: 
            case 656: 
            case 660: 
            case 664: 
            case 668: {
                value = this.receivingEndpoints[4].read32(address - this.baseAddress - 640);
                break;
            }
            case 1024: {
                value = this.unknown400;
                break;
            }
            case 1028: {
                value = this.unknown404;
                break;
            }
            case 1032: {
                value = this.unknown408;
                break;
            }
            case 1036: {
                value = this.connectionInterrupt;
                break;
            }
            case 1040: {
                value = this.connectionInterruptEnabled;
                break;
            }
            case 1044: {
                value = this.unknown414;
                break;
            }
            case 1048: {
                value = this.endpointsInterfacesDisabled;
                break;
            }
            case 1052: {
                value = this.unknown41C;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 28: {
                this.sendingEndpoints[0].write32(address - this.baseAddress - 0, value);
                break;
            }
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: {
                this.sendingEndpoints[1].write32(address - this.baseAddress - 32, value);
                break;
            }
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 80: 
            case 84: 
            case 88: 
            case 92: {
                this.sendingEndpoints[2].write32(address - this.baseAddress - 64, value);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 124: {
                this.sendingEndpoints[3].write32(address - this.baseAddress - 96, value);
                break;
            }
            case 128: 
            case 132: 
            case 136: 
            case 140: 
            case 144: 
            case 148: 
            case 152: 
            case 156: {
                this.sendingEndpoints[4].write32(address - this.baseAddress - 128, value);
                break;
            }
            case 512: 
            case 516: 
            case 520: 
            case 524: 
            case 528: 
            case 532: 
            case 536: 
            case 540: {
                this.receivingEndpoints[0].write32(address - this.baseAddress - 512, value);
                break;
            }
            case 544: 
            case 548: 
            case 552: 
            case 556: 
            case 560: 
            case 564: 
            case 568: 
            case 572: {
                this.receivingEndpoints[1].write32(address - this.baseAddress - 544, value);
                break;
            }
            case 576: 
            case 580: 
            case 584: 
            case 588: 
            case 592: 
            case 596: 
            case 600: 
            case 604: {
                this.receivingEndpoints[2].write32(address - this.baseAddress - 576, value);
                break;
            }
            case 608: 
            case 612: 
            case 616: 
            case 620: 
            case 624: 
            case 628: 
            case 632: 
            case 636: {
                this.receivingEndpoints[3].write32(address - this.baseAddress - 608, value);
                break;
            }
            case 640: 
            case 644: 
            case 648: 
            case 652: 
            case 656: 
            case 660: 
            case 664: 
            case 668: {
                this.receivingEndpoints[4].write32(address - this.baseAddress - 640, value);
                break;
            }
            case 1024: {
                this.unknown400 = value;
                break;
            }
            case 1028: {
                this.setUnknown404(value);
                break;
            }
            case 1036: {
                this.clearConnectionInterrupt(value);
                break;
            }
            case 1040: {
                this.setConnectionInterruptEnabled(value);
                break;
            }
            case 1044: {
                this.clearUnknown414(value);
                break;
            }
            case 1048: {
                this.setEndpointsInterfacesDisabled(value);
                break;
            }
            case 1052: {
                this.unknown41C = value;
                break;
            }
            case 1284: {
                this.unknown504 = value;
                break;
            }
            case 1288: {
                this.unknown508[0] = value;
                break;
            }
            case 1292: {
                this.unknown508[1] = value;
                break;
            }
            case 1296: {
                this.unknown508[2] = value;
                break;
            }
            case 1300: {
                this.unknown508[3] = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    protected class SendingEndpoint
    extends Endpoint {
        public SendingEndpoint(Memory mem, int endpointNumber) {
            super(mem, endpointNumber);
        }

        private void completeRequest(boolean pendingData) {
            log.error((Object)String.format("setControl CONTROL_UNKNOWN_008 state=%d", MMIOHandlerUsb.this.state));
            if (pendingData) {
                this.control = Utilities.clearFlag(this.control, 8);
            }
            MMIOHandlerUsb.this.unknown414 = Utilities.setBit(MMIOHandlerUsb.this.unknown414, this.endpointNumber);
            this.status |= 0x400;
            ((MMIOHandlerUsb)MMIOHandlerUsb.this).receivingEndpoints[this.endpointNumber].control = Utilities.clearFlag(((MMIOHandlerUsb)MMIOHandlerUsb.this).receivingEndpoints[this.endpointNumber].control, 320);
            int flags = this.mem.read16(this.address14 + 2);
            flags = flags & 0x3FFF | 0x8000;
            this.mem.write16(this.address14 + 2, (short)flags);
            RuntimeContextLLE.triggerInterrupt(MMIOHandlerUsb.this.getProcessor(), 26);
            MMIOHandlerUsb.this.state++;
        }

        @Override
        protected void setControl(int value) {
            block31: {
                int oldControl;
                block28: {
                    block30: {
                        int address;
                        int length;
                        block29: {
                            oldControl = this.control;
                            super.setControl(value);
                            if (!Utilities.isRaisingFlag(oldControl, this.control, 8)) break block28;
                            length = this.mem.read16(this.address14 + 0);
                            int flags = this.mem.read16(this.address14 + 2);
                            address = this.mem.read32(this.address14 + 8);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("setControl CONTROL_UNKNOWN_008 length=0x%X, flags=0x%X, address=0x%08X: %s", length, flags, address, Utilities.getMemoryDump(this.mem, address, length)));
                            }
                            if (length != 4) break block29;
                            if (log.isDebugEnabled()) {
                                int parameter0 = this.mem.read16(address + 0);
                                int parameter2 = this.mem.read8(address + 2);
                                int length3 = this.mem.read8(address + 3);
                                log.debug((Object)String.format("setControl sending length=0x%X, flags=0x%04X, parameter0=0x%04X, parameter2=0x%02X, length3=0x%02X", length, flags, parameter0, parameter2, length3, Utilities.getMemoryDump(address + 4, length3)));
                            }
                            switch (this.mem.read8(address + 2)) {
                                case 164: {
                                    int saturationValue = this.mem.read8(address + 4);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)String.format("setSaturation %d", saturationValue));
                                        break;
                                    }
                                    break block30;
                                }
                                case 165: {
                                    int brightnessValue = this.mem.read8(address + 4);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)String.format("setBrightness %d", brightnessValue));
                                        break;
                                    }
                                    break block30;
                                }
                                case 166: {
                                    int contrastValue = this.mem.read8(address + 4);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)String.format("setContrast %d", contrastValue));
                                        break;
                                    }
                                    break block30;
                                }
                                case 43: {
                                    log.error((Object)"setControl 0x2B triggering interrupt");
                                    this.mem.writeUnsigned16(this.address14 + 2, flags & 0x3FFF | 0x8000);
                                    MMIOHandlerUsb.this.triggerConnectionInterrupt(5);
                                    break;
                                }
                                default: {
                                    log.error((Object)String.format("setControl length=%d, unknown parameter2 0x%02X", length, this.mem.read8(address + 2)));
                                    break;
                                }
                            }
                            break block30;
                        }
                        if (length == 1) {
                            int parameter0 = this.mem.read8(address + 0);
                            switch (parameter0) {
                                case 0: {
                                    log.error((Object)"setControl length=1, parameter0=0x00");
                                    break;
                                }
                                case 1: {
                                    log.error((Object)"setControl length=1, parameter0=0x01");
                                    break;
                                }
                                default: {
                                    log.error((Object)String.format("setControl length=%d, unknown parameter0 0x%02X", length, this.mem.read8(address + 2)));
                                    break;
                                }
                            }
                        } else if (length == 18) {
                            log.error((Object)"setControl length=18");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("GET_DESCRIPTOR for device: %s", Utilities.getMemoryDump(this.mem, address, length)));
                            }
                        } else if (length == 64 || length == 6) {
                            // empty if block
                        }
                    }
                    if (MMIOHandlerUsb.this.state == 2 || MMIOHandlerUsb.this.state == 7 || MMIOHandlerUsb.this.state == 14 || MMIOHandlerUsb.this.state == 19 || MMIOHandlerUsb.this.state == 24) {
                        this.completeRequest(false);
                    } else if (MMIOHandlerUsb.this.state == 12 || MMIOHandlerUsb.this.state == 13) {
                        this.completeRequest(true);
                    } else {
                        log.error((Object)String.format("setControl CONTROL_UNKNOWN_008 unimplemented state=%d", MMIOHandlerUsb.this.state));
                    }
                    break block31;
                }
                if (Utilities.isFallingFlag(oldControl, this.control, 8)) {
                    if (MMIOHandlerUsb.this.state == 4 || MMIOHandlerUsb.this.state == 9 || MMIOHandlerUsb.this.state == 16 || MMIOHandlerUsb.this.state == 21) {
                        log.error((Object)String.format("setControl clear CONTROL_UNKNOWN_008 state=%d", MMIOHandlerUsb.this.state));
                        ((MMIOHandlerUsb)MMIOHandlerUsb.this).receivingEndpoints[this.endpointNumber].control = Utilities.clearFlag(((MMIOHandlerUsb)MMIOHandlerUsb.this).receivingEndpoints[this.endpointNumber].control, 64);
                        MMIOHandlerUsb.this.state++;
                    } else {
                        log.error((Object)String.format("setControl clear CONTROL_UNKNOWN_008 unimplemented state=%d", MMIOHandlerUsb.this.state));
                    }
                }
            }
        }
    }

    protected class ReceivingEndpoint
    extends Endpoint {
        public ReceivingEndpoint(Memory mem, int endpointNumber) {
            super(mem, endpointNumber);
        }

        private void sendRequest(boolean deviceToHost, int type, int recipient, int bRequest, int wValue, int wIndex, int wLength) {
            MMIOHandlerUsb.this.unknown414 = Utilities.setBit(MMIOHandlerUsb.this.unknown414, 16 + this.endpointNumber);
            this.mem.write32(this.address10, Integer.MIN_VALUE);
            this.status |= 0x20;
            TPointer deviceRequest = new TPointer(this.mem, this.address10 + 8);
            int bmRequestType = 0;
            bmRequestType |= (deviceToHost ? 1 : 0) << 7;
            bmRequestType |= type << 5;
            deviceRequest.setUnsignedValue8(0, bmRequestType |= recipient << 0);
            deviceRequest.setUnsignedValue8(1, bRequest);
            deviceRequest.setUnsignedValue16(2, wValue);
            deviceRequest.setUnsignedValue16(4, wIndex);
            deviceRequest.setUnsignedValue16(6, wLength);
            this.control = Utilities.clearFlag(this.control, 256);
            this.control = Utilities.setFlag(this.control, 64);
            RuntimeContextLLE.triggerInterrupt(MMIOHandlerUsb.this.getProcessor(), 26);
        }

        @Override
        protected void setControl(int value) {
            int oldControl = this.control;
            super.setControl(value);
            if (Utilities.isRaisingFlag(oldControl, this.control, 256) && Utilities.notHasFlag(this.control, 64) && this.endpointNumber == 0) {
                if (MMIOHandlerUsb.this.state == 0) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    this.sendRequest(true, 2, 1, 1, 3, 0, 1);
                    MMIOHandlerUsb.this.state++;
                } else if (MMIOHandlerUsb.this.state == 3) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    this.sendRequest(false, 2, 1, 1, 0, 0, 8);
                    MMIOHandlerUsb.this.state++;
                } else if (MMIOHandlerUsb.this.state == 5) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    this.sendRequest(true, 0, 0, 6, 256, 0, 18);
                    MMIOHandlerUsb.this.state++;
                } else if (MMIOHandlerUsb.this.state == 8) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    this.sendRequest(true, 0, 0, 6, 512, 0, 148);
                    MMIOHandlerUsb.this.state++;
                } else if (MMIOHandlerUsb.this.state == 11) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    ((MMIOHandlerUsb)MMIOHandlerUsb.this).sendingEndpoints[this.endpointNumber].control = Utilities.clearFlag(((MMIOHandlerUsb)MMIOHandlerUsb.this).sendingEndpoints[this.endpointNumber].control, 10);
                    MMIOHandlerUsb.this.state++;
                } else if (MMIOHandlerUsb.this.state == 15) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    this.sendRequest(true, 2, 1, 3, 0, 3, 5);
                    MMIOHandlerUsb.this.state++;
                } else if (MMIOHandlerUsb.this.state == 18) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    ((MMIOHandlerUsb)MMIOHandlerUsb.this).sendingEndpoints[this.endpointNumber].control = Utilities.clearFlag(((MMIOHandlerUsb)MMIOHandlerUsb.this).sendingEndpoints[this.endpointNumber].control, 10);
                    MMIOHandlerUsb.this.state++;
                } else if (MMIOHandlerUsb.this.state == 20) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    this.sendRequest(true, 2, 1, 8, 0, 3, 8);
                    MMIOHandlerUsb.this.state++;
                } else if (MMIOHandlerUsb.this.state == 23) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    ((MMIOHandlerUsb)MMIOHandlerUsb.this).sendingEndpoints[this.endpointNumber].control = Utilities.clearFlag(((MMIOHandlerUsb)MMIOHandlerUsb.this).sendingEndpoints[this.endpointNumber].control, 10);
                    MMIOHandlerUsb.this.state++;
                } else if (MMIOHandlerUsb.this.state == 25) {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 state=%d", MMIOHandlerUsb.this.state));
                    ((MMIOHandlerUsb)MMIOHandlerUsb.this).sendingEndpoints[this.endpointNumber].control = Utilities.clearFlag(((MMIOHandlerUsb)MMIOHandlerUsb.this).sendingEndpoints[this.endpointNumber].control, 10);
                    MMIOHandlerUsb.this.unknown414 = Utilities.setBit(MMIOHandlerUsb.this.unknown414, 16 + this.endpointNumber);
                    this.mem.write32(this.address14, Integer.MIN_VALUE);
                    MMIOHandlerUsb.this.state++;
                } else {
                    log.error((Object)String.format("receivingEndpoints[0].control CONTROL_UNKNOWN_100 unimplemented state=%d", MMIOHandlerUsb.this.state));
                }
            }
        }
    }

    protected class Endpoint
    implements IState {
        private static final int STATE_VERSION = 0;
        protected static final int CONTROL_UNKNOWN_002 = 2;
        protected static final int CONTROL_UNKNOWN_008 = 8;
        protected static final int CONTROL_TRANSFER_TYPE_MASK = 48;
        protected static final int TRANSFER_TYPE_CONTROL = 0;
        protected static final int TRANSFER_TYPE_ISOCHRONOUS = 1;
        protected static final int TRANSFER_TYPE_BULK = 2;
        protected static final int TRANSFER_TYPE_INTERRUPT = 3;
        protected static final int CONTROL_UNKNOWN_040 = 64;
        protected static final int CONTROL_UNKNOWN_080 = 128;
        protected static final int CONTROL_UNKNOWN_100 = 256;
        protected static final int STATUS_UNKNOWN_010 = 16;
        protected static final int STATUS_UNKNOWN_020 = 32;
        protected static final int STATUS_UNKNOWN_040 = 64;
        protected static final int STATUS_UNKNOWN_080 = 128;
        protected static final int STATUS_UNKNOWN_200 = 512;
        protected static final int STATUS_UNKNOWN_400 = 1024;
        protected static final int STATUS_UNKNOWN_4000 = 16384;
        protected final Memory mem;
        protected final int endpointNumber;
        protected int control;
        protected int status;
        protected int maxPacketSizeInWords;
        protected int maxPacketSizeInBytes;
        protected int address10;
        protected int address14;

        public Endpoint(Memory mem, int endpointNumber) {
            this.mem = mem;
            this.endpointNumber = endpointNumber;
        }

        protected void clearStatus(int mask) {
            this.status = Utilities.clearFlag(this.status, mask);
        }

        protected int getTransferType() {
            return (this.control & 0x30) >> 4;
        }

        protected void setAddress10(int value) {
            this.address10 = value;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("setAddress10: %s", Utilities.getMemoryDump(this.address10, 16)));
            }
        }

        protected void setAddress14(int value) {
            this.address14 = value;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("setAddress14: %s", Utilities.getMemoryDump(this.address14, 12)));
            }
        }

        protected int readStatus() {
            return this.status;
        }

        protected void setControl(int value) {
            this.control = value;
        }

        public int read32(int offset) {
            int value = 0;
            switch (offset) {
                case 0: {
                    value = this.control;
                    break;
                }
                case 4: {
                    value = this.readStatus();
                    break;
                }
                case 8: {
                    value = this.maxPacketSizeInWords;
                    break;
                }
                case 12: {
                    value = this.maxPacketSizeInBytes;
                    break;
                }
                case 16: {
                    value = this.address10;
                    break;
                }
                case 20: {
                    value = this.address14;
                    break;
                }
                default: {
                    log.error((Object)String.format("Endpoint.read32 invalid offset 0x%X", offset));
                }
            }
            return value;
        }

        public void write32(int offset, int value) {
            switch (offset) {
                case 0: {
                    this.setControl(value);
                    break;
                }
                case 4: {
                    this.clearStatus(value);
                    break;
                }
                case 8: {
                    this.maxPacketSizeInWords = value;
                    break;
                }
                case 12: {
                    this.maxPacketSizeInBytes = value;
                    break;
                }
                case 16: {
                    this.setAddress10(value);
                    break;
                }
                case 20: {
                    this.setAddress14(value);
                    break;
                }
                default: {
                    log.error((Object)String.format("Endpoint.write32 invalid offset 0x%X", offset));
                }
            }
        }

        @Override
        public void read(StateInputStream stream) throws IOException {
            stream.readVersion(0);
            this.control = stream.readInt();
            this.status = stream.readInt();
            this.maxPacketSizeInWords = stream.readInt();
            this.maxPacketSizeInBytes = stream.readInt();
            this.address10 = stream.readInt();
            this.address14 = stream.readInt();
        }

        @Override
        public void write(StateOutputStream stream) throws IOException {
            stream.writeVersion(0);
            stream.writeInt(this.control);
            stream.writeInt(this.status);
            stream.writeInt(this.maxPacketSizeInWords);
            stream.writeInt(this.maxPacketSizeInBytes);
            stream.writeInt(this.address10);
            stream.writeInt(this.address14);
        }

        public void reset() {
            this.control = 0;
            this.status = 0;
            this.maxPacketSizeInWords = 0;
            this.maxPacketSizeInBytes = 0;
            this.address10 = 0;
            this.address14 = 0;
        }
    }

    private class UsbReset
    implements IAction {
        private UsbReset() {
        }

        @Override
        public void execute() {
            MMIOHandlerSystemControl.getInstance().triggerUsbMemoryStickInterrupt(3);
        }
    }
}

