/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.dmac;

import java.util.concurrent.Semaphore;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.Memory;
import jpcsp.memory.mmio.MMIO;
import jpcsp.memory.mmio.MMIOHandlerAudio;
import jpcsp.memory.mmio.MMIOHandlerDdr;
import jpcsp.memory.mmio.MMIOHandlerDmac;
import jpcsp.memory.mmio.dmac.DmacDdrFlushAction;
import jpcsp.memory.mmio.dmac.DmacProcessor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class DmacThread
extends Thread {
    private static Logger log = MMIOHandlerDmac.log;
    private static final int DMAC_MEMCPY_STEP2 = 0;
    private static final int DMAC_MEMCPY_STEP16 = 1;
    private static final int DMAC_MEMCPY_STEP8 = 2;
    private static final int DMAC_MEMCPY_STEP4 = 3;
    public static final int[] dmacMemcpyStepLength = new int[8];
    private final Semaphore job = new Semaphore(0);
    private final Semaphore trigger = new Semaphore(0);
    private final DmacProcessor dmacProcessor;
    private volatile Memory memSrc;
    private volatile Memory memDst;
    private volatile int src;
    private volatile int dst;
    private volatile int next;
    private volatile int attributes;
    private volatile int status;
    private volatile IAction interruptAction;
    private volatile IAction completedAction;
    private volatile boolean exit;
    private volatile boolean abortJob;
    private volatile boolean inProgress;

    public DmacThread(DmacProcessor dmacProcessor) {
        this.dmacProcessor = dmacProcessor;
        DmacThread.dmacMemcpyStepLength[0] = 2;
        DmacThread.dmacMemcpyStepLength[3] = 4;
        DmacThread.dmacMemcpyStepLength[2] = 8;
        DmacThread.dmacMemcpyStepLength[1] = 16;
    }

    @Override
    public void run() {
        RuntimeContext.setLog4jMDC();
        while (!this.exit) {
            try {
                this.job.acquire();
                if (this.exit || this.abortJob) continue;
                this.inProgress = true;
                this.dmacMemcpy();
                this.inProgress = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void exit() {
        this.exit = true;
        this.abortJob();
    }

    public void execute(Memory memDst, Memory memSrc, int dst, int src, int next, int attributes, int status, IAction interruptAction, IAction completedAction) {
        this.abortJob = false;
        this.memSrc = memSrc;
        this.memDst = memDst;
        this.dst = dst;
        this.src = src;
        this.next = next;
        this.attributes = attributes;
        this.status = status;
        this.interruptAction = interruptAction;
        this.completedAction = completedAction;
        this.job.release();
    }

    public void abortJob() {
        this.abortJob = true;
        this.trigger.release();
        while (this.inProgress) {
        }
    }

    private void dmacMemcpy(int dst, int src, int dstLength, int srcLength, int dstStepLength, int srcStepLength, boolean dstIncrement, boolean srcIncrement) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("dmacMemcpy dst=0x%08X, src=0x%08X, dstLength=0x%X, srcLength=0x%X, dstStepLength=%d, srcStepLength=%d, dstIncrement=%b, srcIncrement=%b", dst, src, dstLength, srcLength, dstStepLength, srcStepLength, dstIncrement, srcIncrement));
        }
        int srcStep4 = srcIncrement ? 4 : 0;
        int srcStep8 = srcIncrement ? 8 : 0;
        int srcStep12 = srcIncrement ? 12 : 0;
        int dstStep4 = dstIncrement ? 4 : 0;
        int dstStep8 = dstIncrement ? 8 : 0;
        int dstStep12 = dstIncrement ? 12 : 0;
        int stepLength = Math.min(srcStepLength, dstStepLength);
        while (dstLength > 0 && srcLength > 0 && !this.abortJob) {
            switch (stepLength) {
                case 1: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 1));
                    }
                    this.memDst.write8(dst, (byte)this.memSrc.read8(src));
                    break;
                }
                case 2: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 2));
                    }
                    this.memDst.write16(dst, (short)this.memSrc.read16(src));
                    break;
                }
                case 4: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 4));
                    }
                    this.memDst.write32(dst, this.memSrc.read32(src));
                    break;
                }
                case 8: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 8));
                    }
                    this.memDst.write32(dst, this.memSrc.read32(src));
                    this.memDst.write32(dst + dstStep4, this.memSrc.read32(src + srcStep4));
                    break;
                }
                case 16: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("memcpy dst=0x%08X, src=0x%08X, length=0x%X", dst, src, 16));
                    }
                    this.memDst.write32(dst, this.memSrc.read32(src));
                    this.memDst.write32(dst + dstStep4, this.memSrc.read32(src + srcStep4));
                    this.memDst.write32(dst + dstStep8, this.memSrc.read32(src + srcStep8));
                    this.memDst.write32(dst + dstStep12, this.memSrc.read32(src + srcStep12));
                }
            }
            dstLength -= stepLength;
            srcLength -= stepLength;
            if (dstIncrement) {
                dst += stepLength;
            }
            if (!srcIncrement) continue;
            src += stepLength;
        }
    }

    private void dmacMemcpyAudio(int dst, int src, int dstLength, int srcLength, int dstStepLength, int srcStepLength, boolean dstIncrement, boolean srcIncrement) {
        if (dstLength != srcLength || dstIncrement || !srcIncrement || srcStepLength != 16) {
            log.error((Object)String.format("dmacMemcpyAudio unimplemented dst=0x%08X, src=0x%08X, dstLength=0x%X, srcLength=0x%X, dstStepLength=%d, srcStepLength=%d, dstIncrement=%b, srcIncrement=%b", dst, src, dstLength, srcLength, dstStepLength, srcStepLength, dstIncrement, srcIncrement));
            return;
        }
        int length = srcLength;
        for (int i = 0; i < length && !this.abortJob; i += 4) {
            this.memDst.write32(dst, this.memSrc.read32(src + i));
            this.dmacProcessor.setSrc(src + i);
            this.dmacProcessor.setAttributes(this.attributes & 0xFFFFF000 | length - i - 4 >> 2);
        }
        MMIOHandlerAudio mmioHandlerAudio = MMIOHandlerAudio.getInstance();
        if (Utilities.hasFlag(this.attributes, Integer.MIN_VALUE)) {
            mmioHandlerAudio.dmacFlush(dst);
        }
        if (!this.abortJob) {
            int syncDelay = mmioHandlerAudio.getDmacSyncDelay(dst, length);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("dmacMemcpyAudio dst=0x%08X, src=0x%08X, length=0x%X, syncDelay=0x%X milliseconds", dst, src, length, syncDelay));
            }
            if (syncDelay > 0) {
                Utilities.sleep(syncDelay);
            }
        }
    }

    private boolean isAudio(int ddrValue) {
        return (this.status & 0xFFFFFFFE) == (0x100C900 | ddrValue << 4);
    }

    private boolean isAudio() {
        return this.isAudio(4) || this.isAudio(8);
    }

    private boolean dmacMemcpyStep() {
        int dstLength;
        int srcLength;
        if (this.abortJob) {
            return false;
        }
        int srcStep = this.attributes >> 12 & 7;
        int dstStep = this.attributes >> 15 & 7;
        int srcLengthShift = this.attributes >> 18 & 7;
        int dstLengthShift = this.attributes >> 21 & 7;
        boolean srcIncrement = Utilities.hasFlag(this.attributes, 0x4000000);
        boolean dstIncrement = Utilities.hasFlag(this.attributes, 0x8000000);
        int length = this.attributes & 0xFFF;
        int srcStepLength = dmacMemcpyStepLength[srcStep];
        if (srcStepLength == 0) {
            log.error((Object)String.format("dmacMemcpy with unknown srcStep=%d", srcStep));
            return false;
        }
        int dstStepLength = dmacMemcpyStepLength[dstStep];
        if (dstStepLength == 0) {
            log.error((Object)String.format("dmacMemcpy with unknown dstStep=%d", dstStep));
            return false;
        }
        if (Utilities.hasFlag(this.attributes, 0x2000000)) {
            srcIncrement = true;
            dstIncrement = true;
            srcStepLength = 1;
            dstStepLength = 1;
            srcLengthShift = 0;
            dstLengthShift = 0;
        }
        if (Utilities.hasFlag(this.attributes, 0x1000000)) {
            srcIncrement = true;
            dstIncrement = true;
        }
        if ((srcLength = length << srcLengthShift) != (dstLength = length << dstLengthShift)) {
            log.error((Object)String.format("dmacMemcpy with different lengths: srcLength=0x%X, dstLength=0x%X", srcLength, dstLength));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("dmacMemcpy dst=0x%08X, src=0x%08X, attr=0x%08X, dstLength=0x%X(shift=%d), srcLength=0x%X(shift=%d), dstStepLength=0x%X(step=%d), srcStepLength=0x%X(step=%d), dstIncrement=%b, srcIncrement=%b, next=0x%08X, status=0x%X", this.dst, this.src, this.attributes, dstLength, dstLengthShift, srcLength, srcLengthShift, dstStepLength, dstStep, srcStepLength, srcStep, dstIncrement, srcIncrement, this.next, this.status));
        }
        this.dmacProcessor.setSrc(this.src);
        this.dmacProcessor.setDst(this.dst);
        this.dmacProcessor.setAttributes(this.attributes);
        int normalizedSrc = MMIO.normalizeAddress(this.src);
        int normalizedDst = MMIO.normalizeAddress(this.dst);
        if (srcIncrement && dstIncrement && this.memSrc == this.memDst) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("dmacMemcpy dst=0x%08X, src=0x%08X, length=0x%X", normalizedDst, normalizedSrc, srcLength));
            }
            this.memSrc.memcpy(normalizedDst, normalizedSrc, srcLength);
        } else if (this.isAudio()) {
            this.dmacMemcpyAudio(normalizedDst, normalizedSrc, dstLength, srcLength, dstStepLength, srcStepLength, dstIncrement, srcIncrement);
        } else {
            this.dmacMemcpy(normalizedDst, normalizedSrc, dstLength, srcLength, dstStepLength, srcStepLength, dstIncrement, srcIncrement);
        }
        if (length > 0) {
            if (srcIncrement) {
                this.dmacProcessor.setSrc(this.src + (length - 1 << srcLengthShift));
            }
            if (dstIncrement) {
                this.dmacProcessor.setDst(this.dst + (length - 1 << dstLengthShift));
            }
            this.dmacProcessor.setAttributes(this.attributes & 0xFFFFF000);
        }
        if (this.next != 0) {
            this.dmacProcessor.setNext(this.memSrc.read32(this.next + 8));
        }
        if (Utilities.hasFlag(this.attributes, Integer.MIN_VALUE) && this.interruptAction != null) {
            this.interruptAction.execute();
        }
        return true;
    }

    private void checkTrigger(int ddrValue) {
        if (MMIOHandlerDdr.getInstance().checkAndClearFlushDone(ddrValue)) {
            this.trigger.release();
        }
    }

    private boolean waitForTrigger() {
        if (this.abortJob) {
            return false;
        }
        if (this.trigger.tryAcquire()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("waitForTrigger starting", new Object[0]));
        }
        boolean acquired = false;
        while (!acquired && !this.abortJob) {
            try {
                this.trigger.acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("waitForTrigger done acquired=%b", acquired));
        }
        return acquired;
    }

    private void dmacMemcpy() {
        boolean waitForTrigger = false;
        DmacDdrFlushAction dmacDdrFlushAction = null;
        int ddrValue = -1;
        if (Utilities.hasFlag(this.status, 256)) {
            ddrValue = (this.status & 0xF0) >> 4;
            if (this.isAudio(8)) {
                ddrValue = 4;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("dmacMemcpy requiring a call to sceDdrFlush(0x%X), dst=0x%08X, src=0x%08X, attr=0x%08X, next=0x%08X, status=0x%X", ddrValue, this.dst, this.src, this.attributes, this.next, this.status));
            }
            waitForTrigger = true;
            dmacDdrFlushAction = new DmacDdrFlushAction(this, ddrValue);
            MMIOHandlerDdr.getInstance().setFlushAction(ddrValue, dmacDdrFlushAction);
            this.checkTrigger(ddrValue);
            if (!this.waitForTrigger()) {
                return;
            }
        }
        if (this.dmacMemcpyStep()) {
            while (this.next != 0 && !this.abortJob) {
                this.src = this.memSrc.read32(this.next + 0);
                this.dst = this.memSrc.read32(this.next + 4);
                this.attributes = this.memSrc.read32(this.next + 12);
                if (!this.dmacMemcpyStep()) break;
                if (waitForTrigger) {
                    while (this.memSrc.read32(this.next + 8) == 0) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("dmacMemcpy next at 0x%08X is 0, waiting", this.next + 8));
                        }
                        if (this.waitForTrigger()) continue;
                    }
                }
                this.next = this.memSrc.read32(this.next + 8);
                this.dmacProcessor.setNext(this.next);
            }
        }
        if (this.isAudio()) {
            MMIOHandlerAudio.getInstance().dmacFlush(MMIO.normalizeAddress(this.dst));
        }
        if (dmacDdrFlushAction != null) {
            MMIOHandlerDdr.getInstance().clearFlushAction(ddrValue, dmacDdrFlushAction);
            this.trigger.drainPermits();
        }
        if (this.completedAction != null) {
            this.completedAction.execute();
        }
    }

    public void ddrFlushDone(int ddrValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("dmacMemcpy sceDdrFlush(0x%X) called", ddrValue));
        }
        this.checkTrigger(ddrValue);
    }
}

