/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.uart;

import java.io.IOException;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerUartBase
extends MMIOHandlerBase {
    public static Logger log = Logger.getLogger((String)"uart");
    private static final int STATE_VERSION = 0;
    public static final int SIZE_OF = 72;
    public static final int UART_STATUS_RXEMPTY = 16;
    public static final int UART_STATUS_TXFULL = 32;
    private int data;
    private int status = 16;
    private long baudrateDivisor;
    private int control;
    private int unknown04;
    private int unknown30;
    private int unknown34;
    private int unknown38;
    private int interrupt;

    public MMIOHandlerUartBase(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.data = stream.readInt();
        this.status = stream.readInt();
        this.baudrateDivisor = stream.readLong();
        this.control = stream.readInt();
        this.unknown04 = stream.readInt();
        this.unknown30 = stream.readInt();
        this.unknown34 = stream.readInt();
        this.unknown34 = stream.readInt();
        this.interrupt = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.data);
        stream.writeInt(this.status);
        stream.writeLong(this.baudrateDivisor);
        stream.writeInt(this.control);
        stream.writeInt(this.unknown04);
        stream.writeInt(this.unknown30);
        stream.writeInt(this.unknown34);
        stream.writeInt(this.unknown38);
        stream.writeInt(this.interrupt);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.data = 0;
        this.status = 0;
        this.baudrateDivisor = 0L;
        this.control = 0;
        this.unknown04 = 0;
        this.unknown30 = 0;
        this.unknown34 = 0;
        this.unknown38 = 0;
        this.interrupt = 0;
    }

    private void clearInterrupt(int mask) {
        this.interrupt &= ~mask;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.data;
                break;
            }
            case 4: {
                value = this.unknown04;
                break;
            }
            case 24: {
                value = this.status;
                break;
            }
            case 44: {
                value = this.control;
                break;
            }
            case 48: {
                value = this.unknown30;
                break;
            }
            case 52: {
                value = this.unknown34;
                break;
            }
            case 56: {
                value = this.unknown38;
                break;
            }
            case 68: {
                value = this.interrupt;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.data = value;
                break;
            }
            case 4: {
                this.unknown04 = value;
                break;
            }
            case 24: {
                this.status = value;
                break;
            }
            case 36: {
                this.baudrateDivisor = this.baudrateDivisor & 0x3FL | (long)value << 6;
                break;
            }
            case 40: {
                this.baudrateDivisor = this.baudrateDivisor & 0xFFFFFFFFFFFFFFC0L | (long)(value & 0x3F);
                break;
            }
            case 44: {
                this.control = value;
                break;
            }
            case 48: {
                this.unknown30 = value;
                break;
            }
            case 52: {
                this.unknown34 = value;
                break;
            }
            case 56: {
                this.unknown38 = value;
                break;
            }
            case 68: {
                this.clearInterrupt(value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

