/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.adhoc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import jpcsp.hardware.Wlan;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocSocket;

public class AdhocStreamSocket
extends AdhocSocket {
    private Socket socket;

    public AdhocStreamSocket() {
    }

    protected AdhocStreamSocket(Socket socket) {
        this.socket = socket;
        try {
            socket.setSoTimeout(1);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public int bind(int port) throws IOException {
        this.socket = new Socket();
        this.socket.bind(new InetSocketAddress(Wlan.getLocalInetAddress(), port));
        this.socket.setSoTimeout(1);
        return this.socket.getLocalPort();
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    @Override
    public void setTimeout(int millis) throws SocketException {
        this.socket.setSoTimeout(millis);
    }

    @Override
    public void send(SocketAddress socketAddress, AdhocMessage adhocMessage) throws IOException {
        this.socket.getOutputStream().write(adhocMessage.getMessage());
    }

    @Override
    public int receive(byte[] buffer, int size) throws IOException {
        return this.socket.getInputStream().read(buffer, 0, size);
    }

    @Override
    public void connect(SocketAddress socketAddress, int port) throws IOException {
        this.socket.connect(socketAddress);
    }

    @Override
    public AdhocSocket accept() throws IOException {
        return null;
    }
}

