/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.modules.sceNet;
import jpcsp.hardware.Wlan;
import jpcsp.util.LWJGLFixer;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class XLinkKaiTest {
    public static Logger log;
    private DatagramSocket socket;
    private String uniqueIdentifier;
    private InetAddress destAddr;
    private static final int destPort = 34523;
    private static final String applicationName = "Jpcsp";
    private ReadThread readThread;
    private volatile boolean connected;
    private volatile boolean disconnected;

    public static void main(String[] args) {
        LWJGLFixer.fixOnce();
        DOMConfigurator.configure((String)"LogSettings.xml");
        log = Logger.getLogger((String)"XLinkKai");
        RuntimeContext.setLog4jMDC();
        Wlan.initialize();
        XLinkKaiTest test = new XLinkKaiTest();
        try {
            test.testListen();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private void send(byte[] buffer, int offset, int length) throws IOException {
        log.debug((Object)String.format("Sending bytes %s", Utilities.getMemoryDump(buffer, offset, length)));
        DatagramPacket packet = new DatagramPacket(buffer, offset, length, this.destAddr, 34523);
        this.socket.send(packet);
    }

    private void send(String s) throws IOException {
        log.debug((Object)String.format("Sending '%s'", s));
        byte[] bytes = s.getBytes();
        this.send(bytes, 0, bytes.length);
    }

    private byte[] receiveBytes() throws IOException {
        byte[] buffer = new byte[10000];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            this.socket.receive(packet);
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        byte[] data = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), packet.getOffset(), data, 0, packet.getLength());
        log.debug((Object)String.format("Received bytes from %s: %s", packet.getAddress(), Utilities.getMemoryDump(data)));
        return data;
    }

    private void process(byte[] data) throws IOException {
        if (data.length < 4) {
            log.warn((Object)String.format("Received too short packet %s", Utilities.getMemoryDump(data)));
            return;
        }
        if (data[0] == 101 && data[1] == 59 && data[2] == 101 && data[3] == 59) {
            this.processData(data, 4, data.length - 4);
        } else {
            String controlMessage = new String(data);
            log.debug((Object)String.format("Processing control message '%s'", controlMessage));
            if (controlMessage.startsWith("connected;")) {
                this.connected = true;
            } else if (controlMessage.startsWith("disconnected;")) {
                this.disconnected = true;
            } else if (controlMessage.startsWith("keepalive;")) {
                log.debug((Object)String.format("Received keepalive", new Object[0]));
                this.send("keepalive;");
            } else if (controlMessage.startsWith("message;")) {
                String message = controlMessage.substring(8);
                log.info((Object)String.format("Received message '%s'", message));
            } else if (controlMessage.startsWith("chat;")) {
                String message = controlMessage.substring(5);
                log.info((Object)String.format("Received chat '%s'", message));
            } else if (controlMessage.startsWith("directmessage;")) {
                String message = controlMessage.substring(14);
                log.info((Object)String.format("Received direct message '%s'", message));
            } else {
                log.warn((Object)String.format("Received unknown control message '%s'", controlMessage));
            }
        }
    }

    private void processData(byte[] data, int offset, int length) throws IOException {
        log.debug((Object)String.format("Processing data message %s", Utilities.getMemoryDump(data, offset, length)));
    }

    private void connect() throws IOException {
        this.connected = false;
        this.send(String.format("connect;%s;%s;", this.uniqueIdentifier, applicationName));
        while (!this.connected) {
            Utilities.sleep(1, 0);
        }
    }

    private void disconnect() throws IOException {
        this.disconnected = false;
        this.send(String.format("disconnect;%s;%s;", this.uniqueIdentifier, applicationName));
        while (!this.disconnected) {
            Utilities.sleep(1, 0);
        }
    }

    private void enableChat() throws IOException {
        this.send("setting;chat;true;");
    }

    private void init() throws IOException {
        this.uniqueIdentifier = String.format("%s_%s", applicationName, sceNet.convertMacAddressToString(Wlan.getMacAddress()));
        this.destAddr = InetAddress.getByName("localhost");
        this.socket = new DatagramSocket();
        this.socket.setSoTimeout(1);
        this.connected = false;
        this.disconnected = false;
        this.readThread = new ReadThread();
        this.readThread.setName("XLink Kai Read Thread");
        this.readThread.setDaemon(true);
        this.readThread.start();
    }

    private void exit() throws IOException {
        this.readThread.exit();
        this.socket.close();
    }

    public void testConnectDisconnect() throws IOException {
        this.init();
        this.connect();
        this.disconnect();
        this.exit();
    }

    public void testListen() throws IOException {
        this.init();
        this.connect();
        this.enableChat();
        while (!this.disconnected) {
            Utilities.sleep(10, 0);
        }
        this.exit();
    }

    private class ReadThread
    extends Thread {
        private volatile boolean exit;

        private ReadThread() {
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            while (!this.exit) {
                try {
                    byte[] data = XLinkKaiTest.this.receiveBytes();
                    if (data == null) continue;
                    XLinkKaiTest.this.process(data);
                }
                catch (IOException e) {
                    if (this.exit) continue;
                    log.error((Object)e);
                }
            }
            XLinkKaiTest.this.readThread = null;
        }

        public void exit() {
            this.exit = true;
        }
    }
}

