/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.EOFException;

public class BytesPacket {
    private byte[] buffer;
    private int offset;
    private int length;
    private boolean littleEndian;
    private int bufferBits;
    private int bit;

    public BytesPacket(int length) {
        this.buffer = new byte[length];
        this.length = length;
    }

    public BytesPacket(byte[] buffer) {
        this.buffer = buffer;
        this.length = buffer.length;
    }

    public BytesPacket(byte[] buffer, int length) {
        this.buffer = buffer;
        this.length = length;
    }

    public BytesPacket(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public void setLittleEndian() {
        this.littleEndian = true;
    }

    public void setBigEndian() {
        this.littleEndian = false;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length <= 0 && this.bit <= 0;
    }

    public byte readByte() throws EOFException {
        if (this.length <= 0) {
            throw new EOFException();
        }
        --this.length;
        return this.buffer[this.offset++];
    }

    public int read8() throws EOFException {
        return this.readByte() & 0xFF;
    }

    public int read16() throws EOFException {
        if (this.littleEndian) {
            return this.read8() | this.read8() << 8;
        }
        return this.read8() << 8 | this.read8();
    }

    public int read32() throws EOFException {
        if (this.littleEndian) {
            return this.read8() | this.read8() << 8 | this.read8() << 16 | this.read8() << 24;
        }
        return this.read8() << 24 | this.read8() << 16 | this.read8() << 8 | this.read8();
    }

    public int read1() throws EOFException {
        if (this.bit <= 0) {
            this.bufferBits = this.read8();
            this.bit = 8;
        }
        --this.bit;
        return this.bufferBits >> this.bit & 1;
    }

    public int readBits(int n) throws EOFException {
        if (n <= this.bit) {
            this.bit -= n;
            return this.bufferBits >> this.bit & (1 << n) - 1;
        }
        int value = 0;
        for (int i = 0; i < n; ++i) {
            value = value << 1 | this.read1();
        }
        return value;
    }

    public boolean readBoolean() throws EOFException {
        return this.read1() != 0;
    }

    public byte[] readBytes(byte[] dataBuffer) throws EOFException {
        return this.readBytes(dataBuffer, 0, dataBuffer.length);
    }

    public byte[] readBytes(int dataLength) throws EOFException {
        return this.readBytes(new byte[dataLength], 0, dataLength);
    }

    public byte[] readBytes(byte[] dataBuffer, int dataOffset, int dataLength) throws EOFException {
        for (int i = 0; i < dataLength; ++i) {
            dataBuffer[dataOffset + i] = this.readByte();
        }
        return dataBuffer;
    }

    public char readAsciiChar() throws EOFException {
        return (char)this.read8();
    }

    public void skip8() throws EOFException {
        this.skip8(1);
    }

    public void skip8(int n) throws EOFException {
        if (n > 0) {
            if (this.length < n) {
                this.offset += this.length;
                this.length = 0;
                throw new EOFException();
            }
            this.offset += n;
            this.length -= n;
        }
    }

    public String readStringNZ(int n) throws EOFException {
        StringBuilder s = new StringBuilder();
        while (n > 0) {
            --n;
            int c = this.read8();
            if (c == 0) break;
            s.append((char)c);
        }
        this.skip8(n);
        return s.toString();
    }

    public void writeByte(byte b) throws EOFException {
        if (this.length <= 0) {
            throw new EOFException();
        }
        --this.length;
        this.buffer[this.offset++] = b;
    }

    public void writeBytesZero(int n) throws EOFException {
        while (n > 0) {
            this.writeByte((byte)0);
            --n;
        }
    }

    public void write8(int n) throws EOFException {
        this.writeByte((byte)(n & 0xFF));
    }

    public void write16(int n) throws EOFException {
        if (this.littleEndian) {
            this.write8(n);
            this.write8(n >> 8);
        } else {
            this.write8(n >> 8);
            this.write8(n);
        }
    }

    public void write32(int n) throws EOFException {
        if (this.littleEndian) {
            this.write8(n);
            this.write8(n >> 8);
            this.write8(n >> 16);
            this.write8(n >> 24);
        } else {
            this.write8(n >> 24);
            this.write8(n >> 16);
            this.write8(n >> 8);
            this.write8(n);
        }
    }

    public void writeBytes(byte[] dataBuffer) throws EOFException {
        if (dataBuffer != null) {
            this.writeBytes(dataBuffer, 0, dataBuffer.length);
        }
    }

    public void writeBytes(byte[] dataBuffer, int dataOffset, int dataLength) throws EOFException {
        if (dataBuffer != null) {
            int copyLength = Math.min(dataLength, dataBuffer.length - dataOffset);
            for (int i = 0; i < copyLength; ++i) {
                this.writeByte(dataBuffer[dataOffset + i]);
            }
            dataLength -= copyLength;
        }
        this.writeBytesZero(dataLength);
    }

    public void write1(int n) throws EOFException {
        if (this.bit == 0) {
            this.bufferBits = 0;
        }
        ++this.bit;
        this.bufferBits |= (n & 1) << 8 - this.bit;
        if (this.bit == 8) {
            this.write8(this.bufferBits);
            this.bit = 0;
            this.bufferBits = 0;
        }
    }

    public void writeBoolean(boolean b) throws EOFException {
        this.write1(b ? 1 : 0);
    }

    public void writeBits(int b, int n) throws EOFException {
        for (int i = n - 1; i >= 0; --i) {
            this.write1(b >> i);
        }
    }

    public void writeAsciiChar(char c) throws EOFException {
        this.writeByte((byte)c);
    }

    public void rewind(int newOffset) {
        if (newOffset < this.offset) {
            this.length += this.offset - newOffset;
            this.offset = newOffset;
        }
    }

    public void writeString(String s) throws EOFException {
        if (s != null) {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                this.writeAsciiChar(s.charAt(i));
            }
        }
    }

    public void writeStringNZ(String s, int n) throws EOFException {
        if (s != null) {
            int copyLength = Math.min(s.length(), n);
            for (int i = 0; i < copyLength; ++i) {
                this.writeAsciiChar(s.charAt(i));
            }
            n -= copyLength;
        }
        this.writeBytesZero(n);
    }
}

