/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import java.io.IOException;
import jpcsp.Allegrex.GprState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class MduState
extends GprState {
    private static final int STATE_VERSION = 0;
    public long hilo;

    public void setHi(int value) {
        this.hilo = this.hilo & 0xFFFFFFFFL | (long)value << 32;
    }

    public int getHi() {
        return (int)(this.hilo >>> 32);
    }

    public void setLo(int value) {
        this.hilo = this.hilo & 0xFFFFFFFF00000000L | (long)value & 0xFFFFFFFFL;
    }

    public int getLo() {
        return (int)(this.hilo & 0xFFFFFFFFL);
    }

    @Override
    public void reset() {
        this.hilo = 0L;
    }

    @Override
    public void resetAll() {
        super.resetAll();
        this.hilo = 0L;
    }

    public MduState() {
        this.hilo = 0L;
    }

    public void copy(MduState that) {
        super.copy(that);
        this.hilo = that.hilo;
    }

    public MduState(MduState that) {
        super(that);
        this.hilo = that.hilo;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.hilo = stream.readLong();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeLong(this.hilo);
        super.write(stream);
    }

    public static final long signedDivMod(int x, int y) {
        return (long)(x % y) << 32 | (long)(x / y) & 0xFFFFFFFFL;
    }

    public static final long unsignedDivMod(long x, long y) {
        return x % y << 32 | x / y & 0xFFFFFFFFL;
    }

    public final void doMFHI(int rd) {
        if (rd != 0) {
            this.setRegister(rd, this.getHi());
        }
    }

    public final void doMTHI(int rs) {
        int hi = this.getRegister(rs);
        this.hilo = (long)hi << 32 | this.hilo & 0xFFFFFFFFL;
    }

    public final void doMFLO(int rd) {
        if (rd != 0) {
            this.setRegister(rd, this.getLo());
        }
    }

    public final void doMTLO(int rs) {
        int lo = this.getRegister(rs);
        this.hilo = this.hilo & 0xFFFFFFFF00000000L | (long)lo & 0xFFFFFFFFL;
    }

    public final void doMULT(int rs, int rt) {
        this.hilo = (long)this.getRegister(rs) * (long)this.getRegister(rt);
    }

    public final void doMULTU(int rs, int rt) {
        this.hilo = ((long)this.getRegister(rs) & 0xFFFFFFFFL) * ((long)this.getRegister(rt) & 0xFFFFFFFFL);
    }

    public final void doDIV(int rs, int rt) {
        int rsValue = this.getRegister(rs);
        int rtValue = this.getRegister(rt);
        if (rtValue == 0) {
            long lo = rsValue > 65535 ? 0xFFFFFFFFL : 65535L;
            this.hilo = (long)rsValue << 32 | lo;
        } else {
            int lo = rsValue / rtValue;
            int hi = rsValue % rtValue;
            this.hilo = (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
        }
    }

    public final void doDIVU(int rs, int rt) {
        int rsValue = this.getRegister(rs);
        int rtValue = this.getRegister(rt);
        if (rtValue == 0) {
            long lo = rsValue > 65535 ? 0xFFFFFFFFL : 65535L;
            this.hilo = (long)rsValue << 32 | lo;
        } else {
            long x = (long)rsValue & 0xFFFFFFFFL;
            long y = (long)rtValue & 0xFFFFFFFFL;
            this.hilo = x % y << 32 | x / y & 0xFFFFFFFFL;
        }
    }

    public final void doMADD(int rs, int rt) {
        this.hilo += (long)this.getRegister(rs) * (long)this.getRegister(rt);
    }

    public final void doMADDU(int rs, int rt) {
        this.hilo += ((long)this.getRegister(rs) & 0xFFFFFFFFL) * ((long)this.getRegister(rt) & 0xFFFFFFFFL);
    }

    public final void doMSUB(int rs, int rt) {
        this.hilo -= (long)this.getRegister(rs) * (long)this.getRegister(rt);
    }

    public final void doMSUBU(int rs, int rt) {
        this.hilo -= ((long)this.getRegister(rs) & 0xFFFFFFFFL) * ((long)this.getRegister(rt) & 0xFFFFFFFFL);
    }
}

