/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.nativeCode.INativeCodeSequence;
import jpcsp.Emulator;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public abstract class AbstractNativeCodeSequence
implements INativeCodeSequence {
    protected static Logger log = Emulator.log;
    protected static int[] toUpperCase = AbstractNativeCodeSequence.buildToUpperCase();
    protected static int[] toLowerCase = AbstractNativeCodeSequence.buildToLowerCase();

    static int[] buildToUpperCase() {
        int[] toUpperCase = new int[256];
        for (int c = 0; c < toUpperCase.length; ++c) {
            toUpperCase[c] = c >= 97 && c <= 122 ? c - 32 : c;
        }
        return toUpperCase;
    }

    static int[] buildToLowerCase() {
        int[] toLowerCase = new int[256];
        for (int c = 0; c < toLowerCase.length; ++c) {
            toLowerCase[c] = c >= 65 && c <= 90 ? c + 32 : c;
        }
        return toLowerCase;
    }

    protected static Processor getProcessor() {
        return RuntimeContext.processor;
    }

    protected static CpuState getCpu() {
        return RuntimeContext.cpu;
    }

    protected static Memory getMemory(int address) {
        return Emulator.getMemory(address);
    }

    protected static int getPc() {
        return AbstractNativeCodeSequence.getCpu().pc;
    }

    protected static int getRegisterValue(int register) {
        return AbstractNativeCodeSequence.getCpu().getRegister(register);
    }

    protected static long getLong(int low, int high) {
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    protected static int getGprA0() {
        return AbstractNativeCodeSequence.getCpu()._a0;
    }

    protected static int getGprA1() {
        return AbstractNativeCodeSequence.getCpu()._a1;
    }

    protected static int getGprA2() {
        return AbstractNativeCodeSequence.getCpu()._a2;
    }

    protected static int getGprA3() {
        return AbstractNativeCodeSequence.getCpu()._a3;
    }

    protected static int getGprT0() {
        return AbstractNativeCodeSequence.getCpu()._t0;
    }

    protected static int getGprT1() {
        return AbstractNativeCodeSequence.getCpu()._t1;
    }

    protected static int getGprT2() {
        return AbstractNativeCodeSequence.getCpu()._t2;
    }

    protected static int getGprT3() {
        return AbstractNativeCodeSequence.getCpu()._t3;
    }

    protected static int getStackParam0() {
        return AbstractNativeCodeSequence.read32(AbstractNativeCodeSequence.getGprSp());
    }

    protected static int getStackParam1() {
        return AbstractNativeCodeSequence.read32(AbstractNativeCodeSequence.getGprSp() + 4);
    }

    protected static int getStackParam2() {
        return AbstractNativeCodeSequence.read32(AbstractNativeCodeSequence.getGprSp() + 8);
    }

    protected static int getGprSp() {
        return AbstractNativeCodeSequence.getCpu()._sp;
    }

    protected static void setGprV0(int v0) {
        AbstractNativeCodeSequence.getCpu()._v0 = v0;
    }

    protected static void setGprV0V1(long v0v1) {
        AbstractNativeCodeSequence.getCpu()._v0 = (int)v0v1;
        AbstractNativeCodeSequence.getCpu()._v1 = (int)(v0v1 >> 32);
    }

    protected static void setRegisterValue(int register, int value) {
        AbstractNativeCodeSequence.getCpu().setRegister(register, value);
    }

    static float[] getFpr() {
        return AbstractNativeCodeSequence.getCpu().fpr;
    }

    protected static float getFprF12() {
        return AbstractNativeCodeSequence.getFpr()[12];
    }

    protected static void setFprF0(float f0) {
        AbstractNativeCodeSequence.getFpr()[0] = f0;
    }

    protected static float getFRegisterValue(int register) {
        return AbstractNativeCodeSequence.getFpr()[register];
    }

    public static void strcpy(int dstAddr, int srcAddr) {
        int srcLength = AbstractNativeCodeSequence.getStrlen(srcAddr);
        AbstractNativeCodeSequence.memcpy(dstAddr, srcAddr, srcLength + 1);
    }

    public static int strcmp(int src1Addr, int src2Addr) {
        block4: {
            int c1;
            if (src1Addr == 0) {
                if (src2Addr == 0) {
                    return 0;
                }
                return -1;
            }
            if (src2Addr == 0) {
                return 1;
            }
            IMemoryReader memoryReader1 = MemoryReader.getMemoryReader(src1Addr, 1);
            IMemoryReader memoryReader2 = MemoryReader.getMemoryReader(src2Addr, 1);
            if (memoryReader1 == null || memoryReader2 == null) break block4;
            do {
                int c2;
                if ((c1 = memoryReader1.readNext()) == (c2 = memoryReader2.readNext())) continue;
                return c1 > c2 ? 1 : -1;
            } while (c1 != 0);
        }
        return 0;
    }

    public static int getStrlen(int srcAddr) {
        int value;
        if (srcAddr == 0) {
            return 0;
        }
        int srcAddr3 = srcAddr & 3;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(srcAddr - srcAddr3, 4);
        if (memoryReader == null) {
            Compiler.log.warn((Object)"getStrlen: null MemoryReader");
            return 0;
        }
        int offset = 0;
        switch (srcAddr3) {
            case 1: {
                value = memoryReader.readNext();
                if ((value & 0xFF00) == 0) {
                    return 0;
                }
                if ((value & 0xFF0000) == 0) {
                    return 1;
                }
                if ((value & 0xFF000000) == 0) {
                    return 2;
                }
                offset = 3;
                break;
            }
            case 2: {
                value = memoryReader.readNext();
                if ((value & 0xFF0000) == 0) {
                    return 0;
                }
                if ((value & 0xFF000000) == 0) {
                    return 1;
                }
                offset = 2;
                break;
            }
            case 3: {
                value = memoryReader.readNext();
                if ((value & 0xFF000000) == 0) {
                    return 0;
                }
                offset = 1;
            }
        }
        while (((value = memoryReader.readNext()) & 0xFF) != 0) {
            if ((value & 0xFF00) == 0) {
                return offset + 1;
            }
            if ((value & 0xFF0000) == 0) {
                return offset + 2;
            }
            if ((value & 0xFF000000) == 0) {
                return offset + 3;
            }
            offset += 4;
        }
        return offset;
    }

    protected static int getStrlen(int srcAddr, int maxLength) {
        int value;
        if (srcAddr == 0 || maxLength <= 0) {
            return 0;
        }
        int srcAddr3 = srcAddr & 3;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(srcAddr - srcAddr3, 4);
        if (memoryReader == null) {
            Compiler.log.warn((Object)"getStrlen: null MemoryReader");
            return 0;
        }
        int offset = 0;
        switch (srcAddr3) {
            case 1: {
                value = memoryReader.readNext();
                if ((value & 0xFF00) == 0) {
                    return 0;
                }
                if ((value & 0xFF0000) == 0) {
                    return 1;
                }
                if ((value & 0xFF000000) == 0) {
                    return Math.min(2, maxLength);
                }
                offset = 3;
                break;
            }
            case 2: {
                value = memoryReader.readNext();
                if ((value & 0xFF0000) == 0) {
                    return 0;
                }
                if ((value & 0xFF000000) == 0) {
                    return 1;
                }
                offset = 2;
                break;
            }
            case 3: {
                value = memoryReader.readNext();
                if ((value & 0xFF000000) == 0) {
                    return 0;
                }
                offset = 1;
            }
        }
        while (offset < maxLength) {
            value = memoryReader.readNext();
            if ((value & 0xFF) == 0) {
                return offset;
            }
            if ((value & 0xFF00) == 0) {
                return offset + 1;
            }
            if ((value & 0xFF0000) == 0) {
                return Math.min(offset + 2, maxLength);
            }
            if ((value & 0xFF000000) == 0) {
                return Math.min(offset + 3, maxLength);
            }
            offset += 4;
        }
        return maxLength;
    }

    protected static int getRelocatedAddress(int address1, int address2) {
        int address = (address1 << 16) + (short)address2;
        return address & 0x1FFFFFFF;
    }

    protected static void interpret(int opcode) {
        Common.Instruction insn = Decoder.instruction(opcode);
        insn.interpret(RuntimeContext.processor, opcode);
    }

    protected static void invalidateCache(int address, int length) {
        address = AbstractNativeCodeSequence.getMemory(address).normalize(address);
        int endAddress = address + length;
        int invalidateSize = 64;
        for (address = Utilities.alignDown(address, 63); address < endAddress; address += 64) {
            RuntimeContext.invalidateRange(address, 64);
        }
    }

    protected static TPointer getPointer(int address) {
        if (address == 0) {
            return TPointer.NULL;
        }
        return new TPointer(AbstractNativeCodeSequence.getMemory(address), address);
    }

    protected static TPointer32 getPointer32(int address) {
        if (address == 0) {
            return TPointer32.NULL;
        }
        return new TPointer32(AbstractNativeCodeSequence.getMemory(address), address);
    }

    protected static IMemoryReader getMemoryReader(int address, int length, int step) {
        return MemoryReader.getMemoryReader(AbstractNativeCodeSequence.getMemory(address), address, length, step);
    }

    protected static IMemoryReader getMemoryReader(int address, int step) {
        return MemoryReader.getMemoryReader(AbstractNativeCodeSequence.getMemory(address), address, step);
    }

    protected static IMemoryWriter getMemoryWriter(int address, int length, int step) {
        return MemoryWriter.getMemoryWriter(AbstractNativeCodeSequence.getMemory(address), address, length, step);
    }

    protected static int read32(int address) {
        return AbstractNativeCodeSequence.getMemory(address).read32(address);
    }

    protected static int read16(int address) {
        return AbstractNativeCodeSequence.getMemory(address).read16(address);
    }

    protected static int read8(int address) {
        return AbstractNativeCodeSequence.getMemory(address).read8(address);
    }

    protected static void write32(int address, int data) {
        AbstractNativeCodeSequence.getMemory(address).write32(address, data);
    }

    protected static void memcpy(int dstAddr, int srcAddr, int length) {
        AbstractNativeCodeSequence.getMemory(dstAddr).memcpy(dstAddr, srcAddr, length);
    }

    protected static void memcpyWithVideoCheck(int dstAddr, int srcAddr, int length) {
        AbstractNativeCodeSequence.getMemory(dstAddr).memcpyWithVideoCheck(dstAddr, srcAddr, length);
    }
}

