/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.io.IOException;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class Clock
implements IState {
    private static final int STATE_VERSION = 0;
    private long baseNanos;
    private long pauseNanos;
    private long baseTimeMillis;
    private boolean isPaused;

    public Clock() {
        this.reset();
    }

    public Clock(Clock clock) {
        if (clock != null) {
            this.baseNanos = clock.baseNanos;
            this.pauseNanos = clock.pauseNanos;
            this.baseTimeMillis = clock.baseTimeMillis;
            this.isPaused = clock.isPaused;
        } else {
            this.reset();
        }
    }

    public synchronized void pause() {
        if (!this.isPaused) {
            this.pauseNanos = this.getSystemNanoTime();
            this.isPaused = true;
        }
    }

    public synchronized void resume() {
        if (this.isPaused) {
            this.baseNanos += this.getSystemNanoTime() - this.pauseNanos;
            this.isPaused = false;
        }
    }

    public synchronized void reset() {
        this.baseNanos = this.getSystemNanoTime();
        this.baseTimeMillis = this.getSystemMilliTime();
        this.pauseNanos = this.baseNanos;
        this.isPaused = true;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public long nanoTime() {
        long now = this.isPaused ? this.pauseNanos : this.getSystemNanoTime();
        return now - this.baseNanos;
    }

    public long milliTime() {
        return this.nanoTime() / 1000000L;
    }

    public long microTime() {
        return this.nanoTime() / 1000L;
    }

    public long currentTimeMillis() {
        return this.baseTimeMillis + this.milliTime();
    }

    public TimeNanos currentTimeNanos() {
        long nanoTime = this.nanoTime();
        long currentTimeMillis = this.baseTimeMillis + nanoTime / 1000000L;
        TimeNanos timeNano = new TimeNanos();
        timeNano.nanos = (int)(nanoTime % 1000L);
        timeNano.micros = (int)(nanoTime / 1000L % 1000L);
        timeNano.millis = (int)(currentTimeMillis % 1000L);
        timeNano.seconds = (int)(currentTimeMillis / 1000L);
        return timeNano;
    }

    protected long getSystemNanoTime() {
        return System.nanoTime();
    }

    protected long getSystemMilliTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        long systemNanoTimeAtWrite = stream.readLong();
        long delta = this.getSystemNanoTime() - systemNanoTimeAtWrite;
        this.baseNanos += delta;
        this.pauseNanos += delta;
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeLong(this.getSystemNanoTime());
    }

    public static class TimeNanos {
        public int seconds;
        public int millis;
        public int micros;
        public int nanos;
    }
}

