/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger.DisassemblerModule;

import com.jidesoft.list.StyledListCellRenderer;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.Instructions;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Debugger.DisassemblerModule.DumpCodeDialog;
import jpcsp.Debugger.DisassemblerModule.RegisterTable;
import jpcsp.Debugger.DisassemblerModule.VfpuFrame;
import jpcsp.Debugger.DisassemblerModule.ViewTooltips;
import jpcsp.Debugger.DumpDebugState;
import jpcsp.Debugger.MemoryBreakpoints.MemoryBreakpointsDialog;
import jpcsp.Debugger.MemoryViewer;
import jpcsp.Debugger.StepLogger;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.WindowPropSaver;
import jpcsp.memory.DebuggerMemory;
import jpcsp.util.Constants;
import jpcsp.util.JpcspDialogManager;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class DisassemblerFrame
extends JFrame
implements ClipboardOwner {
    private static final long serialVersionUID = -8481807175706172292L;
    private int DebuggerPC;
    private int SelectedPC;
    private Emulator emu;
    private DefaultListModel listmodel = new DefaultListModel();
    private ArrayList<Integer> breakpoints = new ArrayList();
    private int temporaryBreakpoint1;
    private int temporaryBreakpoint2;
    private boolean stepOut;
    protected int gpi;
    protected int gpo;
    private int selectedRegCount;
    private final Color[] selectedRegColors = new Color[]{new Color(128, 255, 255), new Color(255, 255, 128), new Color(128, 255, 128)};
    private String[] selectedRegNames = new String[this.selectedRegColors.length];
    private final Color selectedAddressColor = new Color(255, 128, 255);
    private String selectedAddress;
    private MemoryBreakpointsDialog mbpDialog;
    private SearchTask searchTask;
    private JButton AddBreakpoint;
    private JMenuItem BranchOrJump;
    private JMenuItem CopyAddress;
    private JMenuItem CopyAll;
    private JMenuItem CopyValue;
    private JButton DeleteAllBreakpoints;
    private JButton DeleteBreakpoint;
    private JPopupMenu DisMenu;
    private JButton DumpCodeToText;
    private JButton ExportBreaks;
    private JButton ImportBreaks;
    private JButton JumpToAddress;
    private JButton ManageMemBreaks;
    private JToggleButton PauseDebugger;
    private JPopupMenu RegMenu;
    private JButton ResetToPCbutton;
    private JToggleButton RunDebugger;
    private JMenuItem SetPCToCursor;
    private JButton btnCancelSearch;
    private JToggleButton btnCapture;
    private JButton btnDumpDebugState;
    private JToggleButton btnReplay;
    private JButton btnStepInto;
    private JButton btnStepOut;
    private JButton btnStepOver;
    private JTable cop0Table;
    private JTable cop1Table;
    private JList disasmList;
    private JTabbedPane disasmTabs;
    private JToggleButton gpiButton1;
    private JToggleButton gpiButton2;
    private JToggleButton gpiButton3;
    private JToggleButton gpiButton4;
    private JToggleButton gpiButton5;
    private JToggleButton gpiButton6;
    private JToggleButton gpiButton7;
    private JToggleButton gpiButton8;
    private JLabel gpioLabel;
    private JLabel gpoLabel1;
    private JLabel gpoLabel2;
    private JLabel gpoLabel3;
    private JLabel gpoLabel4;
    private JLabel gpoLabel5;
    private JLabel gpoLabel6;
    private JLabel gpoLabel7;
    private JLabel gpoLabel8;
    private RegisterTable gprTable;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator9;
    private JLabel lblCaptureReplay;
    private JLabel lblDumpState;
    private JLabel lblSearch;
    private JMenu mBreakpoints;
    private JMenu mDebug;
    private JMenu mDisassembler;
    private JMenu mFile;
    private JMenuBar mbMain;
    private JMenuItem miClose;
    private JMenuItem miDeleteAllBreakpoints;
    private JMenuItem miDeleteBreakpoint;
    private JMenuItem miDumpCode;
    private JMenuItem miExportBreakpoints;
    private JMenuItem miImportBreakpoints;
    private JMenuItem miJumpTo;
    private JMenuItem miManageMemoryBreakpoints;
    private JMenuItem miNewBreakpoint;
    private JMenuItem miPause;
    private JMenuItem miResetToPC;
    private JMenuItem miRun;
    private JMenuItem miStepInto;
    private JMenuItem miStepOut;
    private JMenuItem miStepOver;
    private JPanel miscPanel;
    private JProgressBar prgBarSearch;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JToolBar tbBreakpoints;
    private JToolBar tbDisasm;
    private JTextField txtSearch;

    public DisassemblerFrame(Emulator emu) {
        this.emu = emu;
        this.listmodel = new DefaultListModel();
        this.initComponents();
        this.RefreshButtons();
        this.disasmList.setPrototypeCellValue("PROTOTYPE");
        this.gprTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("tableCellEditor".equals(evt.getPropertyName()) && !DisassemblerFrame.this.gprTable.isEditing()) {
                    int row = DisassemblerFrame.this.gprTable.getEditingRow();
                    int value = DisassemblerFrame.this.gprTable.getAddressAt(row);
                    boolean changedPC = false;
                    CpuState cpu = Emulator.getProcessor().cpu;
                    switch (row) {
                        case 0: {
                            if (value % 4 == 0) {
                                cpu.pc = value;
                                changedPC = true;
                                break;
                            }
                            DisassemblerFrame.this.gprTable.setValueAt(cpu.pc, row, 1);
                            break;
                        }
                        case 1: {
                            cpu.setHi(value);
                            break;
                        }
                        case 2: {
                            cpu.setLo(value);
                            break;
                        }
                        default: {
                            cpu.setRegister(row - 3, value);
                        }
                    }
                    if (changedPC) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DisassemblerFrame.this.RefreshDebuggerDisassembly(true);
                            }
                        });
                    }
                }
            }
        });
        ViewTooltips.register(this.disasmList);
        this.disasmList.setCellRenderer(new StyledListCellRenderer(){
            private static final long serialVersionUID = 3921020228217850610L;

            protected void customizeStyledLabel(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.customizeStyledLabel(list, value, index, isSelected, cellHasFocus);
                String text = this.getText();
                this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
                this.setIcon(null);
                if (index == DisassemblerFrame.this.disasmListGetSelectedIndex()) {
                    this.setBackground(Color.LIGHT_GRAY);
                }
                DisassemblerFrame.this.customizeStyledLabel((StyledLabel)this, text);
            }
        });
        this.disasmList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String text;
                if (!e.getValueIsAdjusting() && (text = (String)DisassemblerFrame.this.disasmList.getSelectedValue()) != null) {
                    DisassemblerFrame.this.SelectedPC = DisassemblerFrame.this.DebuggerPC + DisassemblerFrame.this.disasmList.getSelectedIndex() * 4;
                    DisassemblerFrame.this.updateSelectedRegisters(text);
                    DisassemblerFrame.this.disasmList.clearSelection();
                    DisassemblerFrame.this.disasmList.repaint();
                }
            }
        });
        this.RefreshDebugger(true);
        WindowPropSaver.loadWindowProperties(this);
    }

    private void customizeStyledLabel(StyledLabel label, String text) {
        int find;
        if (text.startsWith("<*>")) {
            label.addStyleRange(new StyleRange(0, 3, 1, Color.RED));
        }
        if (text.contains(String.format("%08X:", Emulator.getProcessor().cpu.pc))) {
            int length = 32;
            if (length > text.length() - 3) {
                length = text.length() - 3;
            }
            label.addStyleRange(new StyleRange(3, length, 1, Color.BLACK));
            if (!text.startsWith("<*>")) {
                label.addStyleRange(new StyleRange(0, 3, 1, Color.BLACK, Color.YELLOW, 0));
            }
        }
        if (text.contains(" [")) {
            find = text.indexOf(" [");
            label.addStyleRange(new StyleRange(find, -1, 0, Color.BLUE));
        }
        if (text.contains("<=>")) {
            find = text.indexOf("<=>");
            label.addStyleRange(new StyleRange(find, -1, 0, Color.GRAY));
        }
        if (this.selectedAddress != null && text.contains("0x" + this.selectedAddress) && !text.contains("syscall")) {
            find = text.indexOf("0x" + this.selectedAddress);
            label.addStyleRange(new StyleRange(find, 10, 0, Color.BLACK, this.selectedAddressColor, 0));
        } else if (this.selectedAddress != null && text.contains(this.selectedAddress) && !text.contains("syscall")) {
            find = text.indexOf(this.selectedAddress);
            label.addStyleRange(new StyleRange(find, 8, 0, Color.BLACK, this.selectedAddressColor, 0));
        }
        int lastfind = 0;
        while ((lastfind = text.indexOf("$", lastfind)) != -1) {
            String regName = text.substring(lastfind);
            for (int i = 0; i < Common.gprNames.length; ++i) {
                if (!regName.startsWith(Common.gprNames[i])) continue;
                for (int j = 0; j < this.selectedRegCount; ++j) {
                    if (!regName.startsWith(this.selectedRegNames[j])) continue;
                    label.addStyleRange(new StyleRange(lastfind, 3, 0, Color.BLACK, this.selectedRegColors[j], 0));
                }
                break;
            }
            lastfind += 3;
        }
    }

    public void resetDebugger() {
        this.DeleteAllBreakpoints();
        this.RefreshDebugger(true);
    }

    public void SafeRefreshDebugger(final boolean moveToPC) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DisassemblerFrame.this.RefreshDebugger(moveToPC);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RefreshDebuggerDisassembly(boolean moveToPC) {
        CpuState cpu = Emulator.getProcessor().cpu;
        if (moveToPC) {
            this.SelectedPC = this.DebuggerPC = cpu.pc;
        }
        ViewTooltips.unregister(this.disasmList);
        DefaultListModel defaultListModel = this.listmodel;
        synchronized (defaultListModel) {
            this.listmodel.clear();
            int numVisibleRows = this.disasmList.getHeight() / this.disasmList.getFixedCellHeight();
            Memory mem = MemoryViewer.getMemory();
            for (int pc = this.DebuggerPC; pc < this.DebuggerPC + numVisibleRows * 4; pc += 4) {
                if (MemoryViewer.isAddressGood(pc)) {
                    int opcode = mem.read32(pc);
                    Common.Instruction insn = Decoder.instruction(opcode);
                    String line = this.breakpoints.indexOf(pc) != -1 ? String.format("<*>0x%08X:[0x%08X]: %s", pc, opcode, insn.disasm(pc, opcode)) : (pc == cpu.pc ? String.format("-->0x%08X:[0x%08X]: %s", pc, opcode, insn.disasm(pc, opcode)) : String.format("   0x%08X:[0x%08X]: %s", pc, opcode, insn.disasm(pc, opcode)));
                    this.listmodel.addElement(line);
                    if (pc != this.SelectedPC) continue;
                    this.updateSelectedRegisters(line);
                    continue;
                }
                this.listmodel.addElement(String.format("   0x%08X: invalid address", pc));
            }
        }
        ViewTooltips.register(this.disasmList);
    }

    private void RefreshDebuggerRegisters() {
        int i;
        CpuState cpu = Emulator.getProcessor().cpu;
        this.gprTable.resetChanges();
        this.gprTable.setValueAt(cpu.pc, 0, 1);
        this.gprTable.setValueAt(cpu.getHi(), 1, 1);
        this.gprTable.setValueAt(cpu.getLo(), 2, 1);
        for (i = 0; i < 32; ++i) {
            this.gprTable.setValueAt(cpu.getRegister(i), 3 + i, 1);
        }
        for (i = 0; i < cpu.fpr.length; ++i) {
            this.cop1Table.setValueAt(Float.valueOf(cpu.fpr[i]), i, 1);
        }
        VfpuFrame.getInstance().updateRegisters(cpu);
    }

    public final void RefreshDebugger(boolean moveToPC) {
        this.RefreshDebuggerDisassembly(moveToPC);
        this.RefreshDebuggerRegisters();
        this.ManageMemBreaks.setEnabled(Memory.getInstance() instanceof DebuggerMemory);
        this.miManageMemoryBreakpoints.setEnabled(Memory.getInstance() instanceof DebuggerMemory);
    }

    private void updateSelectedRegisters(String text) {
        this.selectedAddress = null;
        int find = text.indexOf(" 0x");
        if (find != -1 && find + 11 <= text.length() && text.charAt(find + 7) != ' ') {
            this.selectedAddress = text.substring(find + 3, find + 3 + 8);
        }
        this.selectedRegCount = 0;
        this.gprTable.clearRegisterHighlights();
        int lastFind = 0;
        while ((lastFind = text.indexOf("$", lastFind)) != -1 && this.selectedRegCount < this.selectedRegColors.length) {
            String regName = text.substring(lastFind);
            for (int i = 0; i < Common.gprNames.length; ++i) {
                if (!regName.startsWith(Common.gprNames[i])) continue;
                boolean found = false;
                for (int j = 0; j < this.selectedRegCount && !found; ++j) {
                    found = regName.startsWith(this.selectedRegNames[j]);
                }
                if (found) break;
                this.selectedRegNames[this.selectedRegCount] = Common.gprNames[i];
                this.gprTable.highlightRegister(this.selectedRegNames[this.selectedRegCount], this.selectedRegColors[this.selectedRegCount]);
                ++this.selectedRegCount;
                break;
            }
            lastFind += 3;
        }
    }

    private void initComponents() {
        this.DisMenu = new JPopupMenu();
        this.CopyAddress = new JMenuItem();
        this.CopyAll = new JMenuItem();
        this.BranchOrJump = new JMenuItem();
        this.SetPCToCursor = new JMenuItem();
        this.RegMenu = new JPopupMenu();
        this.CopyValue = new JMenuItem();
        this.tbDisasm = new JToolBar();
        this.RunDebugger = new JToggleButton();
        this.PauseDebugger = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnStepInto = new JButton();
        this.btnStepOver = new JButton();
        this.btnStepOut = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.ResetToPCbutton = new JButton();
        this.JumpToAddress = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.DumpCodeToText = new JButton();
        this.tbBreakpoints = new JToolBar();
        this.AddBreakpoint = new JButton();
        this.DeleteBreakpoint = new JButton();
        this.DeleteAllBreakpoints = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.ManageMemBreaks = new JButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.ImportBreaks = new JButton();
        this.ExportBreaks = new JButton();
        this.disasmList = new JList(this.listmodel);
        this.disasmTabs = new JTabbedPane();
        this.gprTable = new RegisterTable();
        this.cop0Table = new JTable();
        this.cop1Table = new JTable();
        this.miscPanel = new JPanel();
        this.gpiButton1 = new JToggleButton();
        this.gpiButton2 = new JToggleButton();
        this.gpiButton3 = new JToggleButton();
        this.gpiButton4 = new JToggleButton();
        this.gpiButton5 = new JToggleButton();
        this.gpiButton6 = new JToggleButton();
        this.gpiButton7 = new JToggleButton();
        this.gpiButton8 = new JToggleButton();
        this.gpoLabel1 = new JLabel();
        this.gpoLabel2 = new JLabel();
        this.gpoLabel3 = new JLabel();
        this.gpoLabel4 = new JLabel();
        this.gpoLabel5 = new JLabel();
        this.gpoLabel6 = new JLabel();
        this.gpoLabel7 = new JLabel();
        this.gpoLabel8 = new JLabel();
        this.gpioLabel = new JLabel();
        this.lblCaptureReplay = new JLabel();
        this.btnCapture = new JToggleButton();
        this.btnReplay = new JToggleButton();
        this.lblDumpState = new JLabel();
        this.btnDumpDebugState = new JButton();
        this.txtSearch = new JTextField();
        this.lblSearch = new JLabel();
        this.prgBarSearch = new JProgressBar();
        this.btnCancelSearch = new JButton();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.mbMain = new JMenuBar();
        this.mFile = new JMenu();
        this.miClose = new JMenuItem();
        this.mDebug = new JMenu();
        this.miRun = new JMenuItem();
        this.miPause = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.miStepInto = new JMenuItem();
        this.miStepOver = new JMenuItem();
        this.miStepOut = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.miResetToPC = new JMenuItem();
        this.miJumpTo = new JMenuItem();
        this.mBreakpoints = new JMenu();
        this.miNewBreakpoint = new JMenuItem();
        this.miDeleteBreakpoint = new JMenuItem();
        this.miDeleteAllBreakpoints = new JMenuItem();
        this.miImportBreakpoints = new JMenuItem();
        this.miExportBreakpoints = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.miManageMemoryBreakpoints = new JMenuItem();
        this.mDisassembler = new JMenu();
        this.miDumpCode = new JMenuItem();
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.CopyAddress.setText(bundle.getString("DisassemblerFrame.CopyAddress.text"));
        this.CopyAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.CopyAddressActionPerformed(evt);
            }
        });
        this.DisMenu.add(this.CopyAddress);
        this.CopyAll.setText(bundle.getString("DisassemblerFrame.CopyAll.text"));
        this.CopyAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.CopyAllActionPerformed(evt);
            }
        });
        this.DisMenu.add(this.CopyAll);
        this.BranchOrJump.setText(bundle.getString("DisassemblerFrame.CopyBranchOrJump.text"));
        this.BranchOrJump.setEnabled(false);
        this.BranchOrJump.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.BranchOrJumpActionPerformed(evt);
            }
        });
        this.DisMenu.add(this.BranchOrJump);
        this.SetPCToCursor.setText(bundle.getString("DisassemblerFrame.SetPCToCursor.text"));
        this.SetPCToCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.SetPCToCursorActionPerformed(evt);
            }
        });
        this.DisMenu.add(this.SetPCToCursor);
        this.CopyValue.setText(bundle.getString("DisassemblerFrame.CopyValue.text"));
        this.CopyValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.CopyValueActionPerformed(evt);
            }
        });
        this.RegMenu.add(this.CopyValue);
        this.setTitle(bundle.getString("DisassemblerFrame.title"));
        this.setMinimumSize(new Dimension(800, 700));
        this.setName("frmDebugger");
        this.tbDisasm.setFloatable(false);
        this.tbDisasm.setRollover(true);
        this.tbDisasm.setOpaque(false);
        this.RunDebugger.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PlayIcon.png")));
        this.RunDebugger.setToolTipText(bundle.getString("DisassemblerFrame.miRun.text"));
        this.RunDebugger.setFocusable(false);
        this.RunDebugger.setHorizontalTextPosition(4);
        this.RunDebugger.setIconTextGap(2);
        this.RunDebugger.setVerticalTextPosition(3);
        this.RunDebugger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.RunDebuggerActionPerformed(evt);
            }
        });
        this.tbDisasm.add(this.RunDebugger);
        this.PauseDebugger.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PauseIcon.png")));
        this.PauseDebugger.setToolTipText(bundle.getString("DisassemblerFrame.miPause.text"));
        this.PauseDebugger.setFocusable(false);
        this.PauseDebugger.setHorizontalTextPosition(4);
        this.PauseDebugger.setIconTextGap(2);
        this.PauseDebugger.setInheritsPopupMenu(true);
        this.PauseDebugger.setVerticalTextPosition(3);
        this.PauseDebugger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.PauseDebuggerActionPerformed(evt);
            }
        });
        this.tbDisasm.add(this.PauseDebugger);
        this.tbDisasm.add(this.jSeparator1);
        this.btnStepInto.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StepIntoIcon.png")));
        this.btnStepInto.setToolTipText(bundle.getString("DisassemblerFrame.miStepInto.text"));
        this.btnStepInto.setFocusable(false);
        this.btnStepInto.setHorizontalTextPosition(4);
        this.btnStepInto.setIconTextGap(2);
        this.btnStepInto.setVerticalTextPosition(3);
        this.btnStepInto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.StepIntoActionPerformed(evt);
            }
        });
        this.tbDisasm.add(this.btnStepInto);
        this.btnStepOver.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StepOverIcon.png")));
        this.btnStepOver.setToolTipText(bundle.getString("DisassemblerFrame.miStepOver.text"));
        this.btnStepOver.setFocusable(false);
        this.btnStepOver.setHorizontalTextPosition(4);
        this.btnStepOver.setIconTextGap(2);
        this.btnStepOver.setVerticalTextPosition(3);
        this.btnStepOver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.StepOverActionPerformed(evt);
            }
        });
        this.tbDisasm.add(this.btnStepOver);
        this.btnStepOut.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StepOutIcon.png")));
        this.btnStepOut.setToolTipText(bundle.getString("DisassemblerFrame.miStepOut.text"));
        this.btnStepOut.setFocusable(false);
        this.btnStepOut.setHorizontalTextPosition(4);
        this.btnStepOut.setIconTextGap(2);
        this.btnStepOut.setVerticalTextPosition(3);
        this.btnStepOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.StepOutActionPerformed(evt);
            }
        });
        this.tbDisasm.add(this.btnStepOut);
        this.tbDisasm.add(this.jSeparator2);
        this.ResetToPCbutton.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/ResetToPc.png")));
        this.ResetToPCbutton.setToolTipText(bundle.getString("DisassemblerFrame.miResetToPC.text"));
        this.ResetToPCbutton.setFocusable(false);
        this.ResetToPCbutton.setHorizontalTextPosition(4);
        this.ResetToPCbutton.setIconTextGap(2);
        this.ResetToPCbutton.setVerticalTextPosition(3);
        this.ResetToPCbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ResetToPCActionPerformed(evt);
            }
        });
        this.tbDisasm.add(this.ResetToPCbutton);
        this.JumpToAddress.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/JumpTo.png")));
        this.JumpToAddress.setToolTipText(bundle.getString("DisassemblerFrame.miJumpTo.text"));
        this.JumpToAddress.setFocusable(false);
        this.JumpToAddress.setHorizontalTextPosition(4);
        this.JumpToAddress.setIconTextGap(2);
        this.JumpToAddress.setVerticalTextPosition(3);
        this.JumpToAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.JumpToAddressActionPerformed(evt);
            }
        });
        this.tbDisasm.add(this.JumpToAddress);
        this.tbDisasm.add(this.jSeparator4);
        this.DumpCodeToText.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/Dump.png")));
        this.DumpCodeToText.setToolTipText(bundle.getString("DisassemblerFrame.miDumpCode.text"));
        this.DumpCodeToText.setFocusable(false);
        this.DumpCodeToText.setHorizontalTextPosition(4);
        this.DumpCodeToText.setIconTextGap(2);
        this.DumpCodeToText.setVerticalTextPosition(3);
        this.DumpCodeToText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.DumpCodeToTextActionPerformed(evt);
            }
        });
        this.tbDisasm.add(this.DumpCodeToText);
        this.tbBreakpoints.setFloatable(false);
        this.tbBreakpoints.setRollover(true);
        this.tbBreakpoints.setOpaque(false);
        this.AddBreakpoint.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/NewBreakpointIcon.png")));
        this.AddBreakpoint.setToolTipText(bundle.getString("DisassemblerFrame.miNewBreakpoint.text"));
        this.AddBreakpoint.setFocusable(false);
        this.AddBreakpoint.setHorizontalTextPosition(4);
        this.AddBreakpoint.setIconTextGap(2);
        this.AddBreakpoint.setVerticalTextPosition(3);
        this.AddBreakpoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.AddBreakpointActionPerformed(evt);
            }
        });
        this.tbBreakpoints.add(this.AddBreakpoint);
        this.DeleteBreakpoint.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/DeleteBreakpointIcon.png")));
        this.DeleteBreakpoint.setToolTipText(bundle.getString("DisassemblerFrame.miDeleteBreakpoint.text"));
        this.DeleteBreakpoint.setFocusable(false);
        this.DeleteBreakpoint.setHorizontalTextPosition(4);
        this.DeleteBreakpoint.setIconTextGap(2);
        this.DeleteBreakpoint.setInheritsPopupMenu(true);
        this.DeleteBreakpoint.setVerticalTextPosition(3);
        this.DeleteBreakpoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.DeleteBreakpointActionPerformed(evt);
            }
        });
        this.tbBreakpoints.add(this.DeleteBreakpoint);
        this.DeleteAllBreakpoints.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/DeleteAllBreakpointsIcon.png")));
        this.DeleteAllBreakpoints.setToolTipText(bundle.getString("DisassemblerFrame.miDeleteAllBreakpoints.text"));
        this.DeleteAllBreakpoints.setFocusable(false);
        this.DeleteAllBreakpoints.setHorizontalTextPosition(4);
        this.DeleteAllBreakpoints.setIconTextGap(2);
        this.DeleteAllBreakpoints.setVerticalTextPosition(3);
        this.DeleteAllBreakpoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.DeleteAllBreakpointsActionPerformed(evt);
            }
        });
        this.tbBreakpoints.add(this.DeleteAllBreakpoints);
        this.tbBreakpoints.add(this.jSeparator3);
        this.ManageMemBreaks.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/MemoryBreakpointsIcon.png")));
        this.ManageMemBreaks.setToolTipText(bundle.getString("DisassemblerFrame.miManageMemoryBreakpoints.text"));
        this.ManageMemBreaks.setFocusable(false);
        this.ManageMemBreaks.setHorizontalTextPosition(0);
        this.ManageMemBreaks.setVerticalTextPosition(3);
        this.ManageMemBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ManageMemBreaksActionPerformed(evt);
            }
        });
        this.tbBreakpoints.add(this.ManageMemBreaks);
        this.tbBreakpoints.add(this.jSeparator7);
        this.ImportBreaks.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/LoadStateIcon.png")));
        this.ImportBreaks.setToolTipText(bundle.getString("DisassemblerFrame.miImportBreakpoints.text"));
        this.ImportBreaks.setFocusable(false);
        this.ImportBreaks.setHorizontalTextPosition(4);
        this.ImportBreaks.setVerticalTextPosition(3);
        this.ImportBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ImportBreaksActionPerformed(evt);
            }
        });
        this.tbBreakpoints.add(this.ImportBreaks);
        this.ExportBreaks.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/SaveStateIcon.png")));
        this.ExportBreaks.setToolTipText(bundle.getString("DisassemblerFrame.miExportBreakpoints.text"));
        this.ExportBreaks.setFocusable(false);
        this.ExportBreaks.setHorizontalTextPosition(4);
        this.ExportBreaks.setVerticalTextPosition(3);
        this.ExportBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ExportBreaksActionPerformed(evt);
            }
        });
        this.tbBreakpoints.add(this.ExportBreaks);
        this.disasmList.setFont(new Font("Courier New", 0, 12));
        this.disasmList.setSelectionMode(0);
        this.disasmList.setMinimumSize(new Dimension(500, 50));
        this.disasmList.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                DisassemblerFrame.this.disasmListMouseWheelMoved(evt);
            }
        });
        this.disasmList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DisassemblerFrame.this.disasmListMouseClicked(evt);
            }
        });
        this.disasmList.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DisassemblerFrame.this.disasmListComponentResized(evt);
            }
        });
        this.disasmList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DisassemblerFrame.this.disasmListKeyPressed(evt);
            }
        });
        this.disasmTabs.setMinimumSize(new Dimension(280, 587));
        this.disasmTabs.setPreferredSize(new Dimension(280, 587));
        this.gprTable.setModel(null);
        this.gprTable.setRegisters(new String[]{"PC", "HI", "LO", "zr", "at", "v0", "v1", "a0", "a1", "a2", "a3", "t0", "t1", "t2", "t3", "t4", "t5", "t6", "t7", "s0", "s1", "s2", "s3", "s4", "s5", "s6", "s7", "t8", "t9", "k0", "k1", "gp", "sp", "fp", "ra"});
        this.disasmTabs.addTab(bundle.getString("DisassemblerFrame.gprTable.TabConstraints.tabTitle"), this.gprTable);
        this.cop0Table.setModel(new DefaultTableModel(new Object[0][], new String[]{"REG", "HEX"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.disasmTabs.addTab(bundle.getString("DisassemblerFrame.cop0Table.TabConstraints.tabTitle"), this.cop0Table);
        this.cop1Table.setFont(new Font("Courier New", 0, 12));
        this.cop1Table.setModel(new DefaultTableModel(new Object[][]{{"FPR0", null}, {"FPR1", null}, {"FPR2", null}, {"FPR3", null}, {"FPR4", null}, {"FPR5", null}, {"FPR6", null}, {"FPR7", null}, {"FPR8", null}, {"FPR9", null}, {"FPR10", null}, {"FPR11", null}, {"FPR12", null}, {"FPR13", null}, {"FPR14", null}, {"FPR15", null}, {"FPR16", null}, {"FPR17", null}, {"FPR18", null}, {"FPR19", null}, {"FPR20", null}, {"FPR21", null}, {"FPR22", null}, {"FPR23", null}, {"FPR24", null}, {"FPR25", null}, {"FPR26", null}, {"FPR27", null}, {"FPR28", null}, {"FPR29", null}, {"FPR30", null}, {"FPR31", null}}, new String[]{"REG", "FLOAT"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Float.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.cop1Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DisassemblerFrame.this.cop1TableMouseClicked(evt);
            }
        });
        this.disasmTabs.addTab(bundle.getString("DisassemblerFrame.cop1Table.TabConstraints.tabTitle"), this.cop1Table);
        this.gpiButton1.setText("1");
        this.gpiButton1.setBorder(null);
        this.gpiButton1.setPreferredSize(new Dimension(16, 16));
        this.gpiButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton1ActionPerformed(evt);
            }
        });
        this.gpiButton2.setText("2");
        this.gpiButton2.setBorder(null);
        this.gpiButton2.setPreferredSize(new Dimension(16, 16));
        this.gpiButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton2ActionPerformed(evt);
            }
        });
        this.gpiButton3.setText("3");
        this.gpiButton3.setBorder(null);
        this.gpiButton3.setPreferredSize(new Dimension(16, 16));
        this.gpiButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton3ActionPerformed(evt);
            }
        });
        this.gpiButton4.setText("4");
        this.gpiButton4.setBorder(null);
        this.gpiButton4.setPreferredSize(new Dimension(16, 16));
        this.gpiButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton4ActionPerformed(evt);
            }
        });
        this.gpiButton5.setText("5");
        this.gpiButton5.setBorder(null);
        this.gpiButton5.setPreferredSize(new Dimension(16, 16));
        this.gpiButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton5ActionPerformed(evt);
            }
        });
        this.gpiButton6.setText("6");
        this.gpiButton6.setBorder(null);
        this.gpiButton6.setPreferredSize(new Dimension(16, 16));
        this.gpiButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton6ActionPerformed(evt);
            }
        });
        this.gpiButton7.setText("7");
        this.gpiButton7.setBorder(null);
        this.gpiButton7.setPreferredSize(new Dimension(16, 16));
        this.gpiButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton7ActionPerformed(evt);
            }
        });
        this.gpiButton8.setText("8");
        this.gpiButton8.setBorder(null);
        this.gpiButton8.setPreferredSize(new Dimension(16, 16));
        this.gpiButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.gpiButton8ActionPerformed(evt);
            }
        });
        this.gpoLabel1.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel1.setEnabled(false);
        this.gpoLabel2.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel2.setEnabled(false);
        this.gpoLabel3.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel3.setEnabled(false);
        this.gpoLabel4.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel4.setEnabled(false);
        this.gpoLabel5.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel5.setEnabled(false);
        this.gpoLabel6.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel6.setEnabled(false);
        this.gpoLabel7.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel7.setEnabled(false);
        this.gpoLabel8.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/tick.gif")));
        this.gpoLabel8.setEnabled(false);
        this.gpioLabel.setText(bundle.getString("DisassemblerFrame.gpioLabel.text"));
        this.lblCaptureReplay.setText(bundle.getString("DisassemblerFrame.lblCaptureReplay.text"));
        this.btnCapture.setText(bundle.getString("DisassemblerFrame.btnCapture.text"));
        this.btnCapture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.btnCaptureActionPerformed(evt);
            }
        });
        this.btnReplay.setText(bundle.getString("DisassemblerFrame.btnReplay.text"));
        this.btnReplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.btnReplayActionPerformed(evt);
            }
        });
        this.lblDumpState.setText(bundle.getString("DisassemblerFrame.lblDebugState.text"));
        this.btnDumpDebugState.setText(bundle.getString("DisassemblerFrame.btnDumpDebugState.text"));
        this.btnDumpDebugState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.btnDumpDebugStateActionPerformed(evt);
            }
        });
        this.txtSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.txtSearchActionPerformed(evt);
            }
        });
        this.txtSearch.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DisassemblerFrame.this.txtSearchFocusGained(evt);
            }
        });
        this.lblSearch.setText(bundle.getString("DisassemblerFrame.lblSearch.text"));
        this.btnCancelSearch.setText(bundle.getString("DisassemblerFrame.btnCancelSearch.text"));
        this.btnCancelSearch.setEnabled(false);
        this.btnCancelSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.btnCancelSearchActionPerformed(evt);
            }
        });
        GroupLayout miscPanelLayout = new GroupLayout(this.miscPanel);
        this.miscPanel.setLayout(miscPanelLayout);
        miscPanelLayout.setHorizontalGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscPanelLayout.createSequentialGroup().addContainerGap().addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(miscPanelLayout.createSequentialGroup().addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpoLabel1).addComponent(this.gpiButton1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton2, -2, -1, -2).addComponent(this.gpoLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton3, -2, -1, -2).addComponent(this.gpoLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton4, -2, -1, -2).addComponent(this.gpoLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton5, -2, -1, -2).addComponent(this.gpoLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton6, -2, -1, -2).addComponent(this.gpoLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpiButton7, -2, -1, -2).addComponent(this.gpoLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpoLabel8).addComponent(this.gpiButton8, -2, -1, -2))).addComponent(this.txtSearch).addComponent(this.lblSearch).addComponent(this.gpioLabel).addComponent(this.lblCaptureReplay).addComponent(this.lblDumpState).addComponent(this.btnDumpDebugState, -1, -1, Short.MAX_VALUE).addComponent(this.btnCapture, -1, -1, Short.MAX_VALUE).addComponent(this.btnReplay, -1, -1, Short.MAX_VALUE).addComponent(this.prgBarSearch, -1, -1, Short.MAX_VALUE).addComponent(this.btnCancelSearch, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        miscPanelLayout.setVerticalGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.gpioLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscPanelLayout.createSequentialGroup().addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gpoLabel1).addComponent(this.gpoLabel2).addComponent(this.gpoLabel3).addComponent(this.gpoLabel4).addComponent(this.gpoLabel5).addComponent(this.gpoLabel6).addComponent(this.gpoLabel7)).addGap(11, 11, 11).addGroup(miscPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gpiButton1, -2, -1, -2).addComponent(this.gpiButton2, -2, -1, -2).addComponent(this.gpiButton3, -2, -1, -2).addComponent(this.gpiButton4, -2, -1, -2).addComponent(this.gpiButton5, -2, -1, -2).addComponent(this.gpiButton6, -2, -1, -2).addComponent(this.gpiButton7, -2, -1, -2).addComponent(this.gpiButton8, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblCaptureReplay)).addComponent(this.gpoLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCapture).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReplay).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblDumpState).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDumpDebugState).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSearch, -2, 11, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSearch, -2, -1, -2).addGap(0, 0, 0).addComponent(this.prgBarSearch, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancelSearch).addContainerGap(243, Short.MAX_VALUE)));
        this.disasmTabs.addTab(bundle.getString("DisassemblerFrame.miscPanel.TabConstraints.tabTitle"), this.miscPanel);
        this.statusPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 2));
        this.statusLabel.setFont(new Font("Dialog", 0, 12));
        this.statusLabel.setText("ready");
        this.statusPanel.add(this.statusLabel);
        this.mFile.setText(bundle.getString("DisassemblerFrame.mFile.text"));
        this.miClose.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/CloseIcon.png")));
        this.miClose.setText(bundle.getString("CloseButton.text"));
        this.miClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.CloseActionPerformed(evt);
            }
        });
        this.mFile.add(this.miClose);
        this.mbMain.add(this.mFile);
        this.mDebug.setText(bundle.getString("DisassemblerFrame.mDebug.text"));
        this.mDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.RunDebuggerActionPerformed(evt);
            }
        });
        this.miRun.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.miRun.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PlayIcon.png")));
        this.miRun.setText(bundle.getString("DisassemblerFrame.miRun.text"));
        this.miRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.RunDebuggerActionPerformed(evt);
            }
        });
        this.mDebug.add(this.miRun);
        this.miPause.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        this.miPause.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PauseIcon.png")));
        this.miPause.setText(bundle.getString("DisassemblerFrame.miPause.text"));
        this.miPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.PauseDebuggerActionPerformed(evt);
            }
        });
        this.mDebug.add(this.miPause);
        this.mDebug.add(this.jSeparator9);
        this.miStepInto.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.miStepInto.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StepIntoIcon.png")));
        this.miStepInto.setText(bundle.getString("DisassemblerFrame.miStepInto.text"));
        this.miStepInto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.StepIntoActionPerformed(evt);
            }
        });
        this.mDebug.add(this.miStepInto);
        this.miStepOver.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.miStepOver.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StepOverIcon.png")));
        this.miStepOver.setText(bundle.getString("DisassemblerFrame.miStepOver.text"));
        this.miStepOver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.StepOverActionPerformed(evt);
            }
        });
        this.mDebug.add(this.miStepOver);
        this.miStepOut.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.miStepOut.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StepOutIcon.png")));
        this.miStepOut.setText(bundle.getString("DisassemblerFrame.miStepOut.text"));
        this.mDebug.add(this.miStepOut);
        this.mDebug.add(this.jSeparator10);
        this.miResetToPC.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.miResetToPC.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/ResetToPc.png")));
        this.miResetToPC.setText(bundle.getString("DisassemblerFrame.miResetToPC.text"));
        this.miResetToPC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ResetToPCActionPerformed(evt);
            }
        });
        this.mDebug.add(this.miResetToPC);
        this.miJumpTo.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.miJumpTo.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/JumpTo.png")));
        this.miJumpTo.setText(bundle.getString("DisassemblerFrame.miJumpTo.text"));
        this.miJumpTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.JumpToAddressActionPerformed(evt);
            }
        });
        this.mDebug.add(this.miJumpTo);
        this.mbMain.add(this.mDebug);
        this.mBreakpoints.setText(bundle.getString("DisassemblerFrame.mBreakpoints.text"));
        this.miNewBreakpoint.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.miNewBreakpoint.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/NewBreakpointIcon.png")));
        this.miNewBreakpoint.setText(bundle.getString("DisassemblerFrame.miNewBreakpoint.text"));
        this.miNewBreakpoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.AddBreakpointActionPerformed(evt);
            }
        });
        this.mBreakpoints.add(this.miNewBreakpoint);
        this.miDeleteBreakpoint.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/DeleteBreakpointIcon.png")));
        this.miDeleteBreakpoint.setText(bundle.getString("DisassemblerFrame.miDeleteBreakpoint.text"));
        this.miDeleteBreakpoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.DeleteBreakpointActionPerformed(evt);
            }
        });
        this.mBreakpoints.add(this.miDeleteBreakpoint);
        this.miDeleteAllBreakpoints.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/DeleteAllBreakpointsIcon.png")));
        this.miDeleteAllBreakpoints.setText(bundle.getString("DisassemblerFrame.miDeleteAllBreakpoints.text"));
        this.miDeleteAllBreakpoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.DeleteAllBreakpointsActionPerformed(evt);
            }
        });
        this.mBreakpoints.add(this.miDeleteAllBreakpoints);
        this.miImportBreakpoints.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/LoadStateIcon.png")));
        this.miImportBreakpoints.setText(bundle.getString("DisassemblerFrame.miImportBreakpoints.text"));
        this.miImportBreakpoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ImportBreaksActionPerformed(evt);
            }
        });
        this.mBreakpoints.add(this.miImportBreakpoints);
        this.miExportBreakpoints.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/SaveStateIcon.png")));
        this.miExportBreakpoints.setText(bundle.getString("DisassemblerFrame.miExportBreakpoints.text"));
        this.miExportBreakpoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ExportBreaksActionPerformed(evt);
            }
        });
        this.mBreakpoints.add(this.miExportBreakpoints);
        this.mBreakpoints.add(this.jSeparator11);
        this.miManageMemoryBreakpoints.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.miManageMemoryBreakpoints.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/SettingsIcon.png")));
        this.miManageMemoryBreakpoints.setText(bundle.getString("DisassemblerFrame.miManageMemoryBreakpoints.text"));
        this.miManageMemoryBreakpoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.ManageMemBreaksActionPerformed(evt);
            }
        });
        this.mBreakpoints.add(this.miManageMemoryBreakpoints);
        this.mbMain.add(this.mBreakpoints);
        this.mDisassembler.setText(bundle.getString("DisassemblerFrame.mDisassembler.text"));
        this.miDumpCode.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.miDumpCode.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/Dump.png")));
        this.miDumpCode.setText(bundle.getString("DisassemblerFrame.miDumpCode.text"));
        this.miDumpCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisassemblerFrame.this.DumpCodeToTextActionPerformed(evt);
            }
        });
        this.mDisassembler.add(this.miDumpCode);
        this.mbMain.add(this.mDisassembler);
        this.setJMenuBar(this.mbMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tbDisasm, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbBreakpoints, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.disasmList, -1, 500, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disasmTabs, -2, 265, -2))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbDisasm, -2, -1, -2).addComponent(this.tbBreakpoints, -2, 32, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.disasmTabs, -2, -1, -2).addComponent(this.disasmList, -1, 647, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void disasmListKeyPressed(KeyEvent evt) {
        int keyCode2 = evt.getKeyCode();
        int numVisibleRows = this.disasmList.getHeight() / this.disasmList.getFixedCellHeight();
        switch (keyCode2) {
            case 40: {
                this.DebuggerPC += 4;
                this.RefreshDebuggerDisassembly(false);
                this.updateSelectedIndex();
                evt.consume();
                break;
            }
            case 38: {
                this.DebuggerPC -= 4;
                this.RefreshDebuggerDisassembly(false);
                this.updateSelectedIndex();
                evt.consume();
                break;
            }
            case 33: {
                this.DebuggerPC -= numVisibleRows * 4;
                this.RefreshDebuggerDisassembly(false);
                this.updateSelectedIndex();
                evt.consume();
                break;
            }
            case 34: {
                this.DebuggerPC += numVisibleRows * 4;
                this.RefreshDebuggerDisassembly(false);
                this.updateSelectedIndex();
                evt.consume();
            }
        }
    }

    private void disasmListMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            this.DebuggerPC -= 4;
            this.RefreshDebuggerDisassembly(false);
            this.updateSelectedIndex();
            evt.consume();
        } else {
            this.DebuggerPC += 4;
            this.RefreshDebuggerDisassembly(false);
            this.updateSelectedIndex();
            evt.consume();
        }
    }

    private void updateSelectedIndex() {
        int numVisibleRows = this.disasmList.getHeight() / this.disasmList.getFixedCellHeight();
        if (this.SelectedPC >= this.DebuggerPC && this.SelectedPC < this.DebuggerPC + numVisibleRows * 4) {
            this.disasmList.setSelectedIndex((this.SelectedPC - this.DebuggerPC) / 4);
        }
    }

    private int disasmListGetSelectedIndex() {
        return (this.SelectedPC - this.DebuggerPC) / 4;
    }

    private Object disasmListGetSelectedValue() {
        if (this.disasmListGetSelectedIndex() < 0) {
            return null;
        }
        return this.disasmList.getModel().getElementAt(this.disasmListGetSelectedIndex());
    }

    private void ResetToPCActionPerformed(ActionEvent evt) {
        this.RefreshDebuggerDisassembly(true);
    }

    private void JumpToAddressActionPerformed(ActionEvent evt) {
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        String input = (String)JOptionPane.showInputDialog(this, bundle.getString("DisassemblerFrame.strEnterToJump.text"), "Jpcsp", 3, null, null, String.format("%08x", Emulator.getProcessor().cpu.pc));
        if (input == null) {
            return;
        }
        try {
            int value;
            this.DebuggerPC = value = Utilities.parseAddress(input);
            this.SelectedPC = value;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, bundle.getString("MemoryViewer.strInvalidAddress.text"));
            return;
        }
        this.RefreshDebuggerDisassembly(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void DumpCodeToTextActionPerformed(ActionEvent evt) {
        DumpCodeDialog dlgDC = new DumpCodeDialog((Frame)this, this.DebuggerPC);
        dlgDC.setVisible(true);
        if (dlgDC.getReturnValue() != 1) {
            return;
        }
        Logger.getRootLogger().debug((Object)("Start address: " + dlgDC.getStartAddress()));
        Logger.getRootLogger().debug((Object)("End address: " + dlgDC.getEndAddress()));
        Logger.getRootLogger().debug((Object)("File name: " + dlgDC.getFilename()));
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(dlgDC.getFilename()));
            bufferedWriter.write("------- JPCSP DISASM -------");
            bufferedWriter.newLine();
            for (int i = dlgDC.getStartAddress(); i <= dlgDC.getEndAddress(); i += 4) {
                if (Memory.isAddressGood(i)) {
                    String disasm;
                    int opcode = Memory.getInstance().read32(i);
                    Common.Instruction insn = Decoder.instruction(opcode);
                    try {
                        disasm = insn.disasm(i, opcode);
                    }
                    catch (Exception e) {
                        disasm = "???";
                    }
                    bufferedWriter.write(String.format("0x%08X:[0x%08X]: %s", i, opcode, disasm));
                } else {
                    bufferedWriter.write(String.format("%08X: invalid address", i));
                }
                bufferedWriter.newLine();
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Utilities.close(bufferedWriter);
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
            {
                catch (Throwable throwable) {
                    Utilities.close(bufferedWriter);
                    throw throwable;
                }
            }
            Utilities.close(bufferedWriter);
        }
        Utilities.close(bufferedWriter);
    }

    private void CopyAddressActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        String address = value.substring(3, 11);
        StringSelection stringSelection = new StringSelection(address);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private void CopyAllActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        StringSelection stringSelection = new StringSelection(value);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private void BranchOrJumpActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        int address = value.indexOf("0x");
        if (address == -1) {
            JpcspDialogManager.showError(this, "Can't find the jump or branch address");
            return;
        }
        String add = value.substring(address + 2, value.length());
        int addressend = add.indexOf(" ");
        if (addressend != -1) {
            add = add.substring(0, addressend);
        }
        StringSelection stringSelection = new StringSelection(add);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    @Override
    public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
    }

    private void disasmListMouseClicked(MouseEvent evt) {
        this.BranchOrJump.setEnabled(false);
        this.SetPCToCursor.setEnabled(false);
        if (SwingUtilities.isRightMouseButton(evt) && this.disasmList.locationToIndex(evt.getPoint()) == this.disasmListGetSelectedIndex()) {
            int addr;
            int finddot;
            String line = (String)this.disasmListGetSelectedValue();
            String opcode = line.substring((finddot = line.indexOf("]:")) + 3, line.length());
            if (opcode.startsWith("b") || opcode.startsWith("j")) {
                this.BranchOrJump.setEnabled(true);
            }
            if (Memory.isAddressGood(addr = this.DebuggerPC + this.disasmListGetSelectedIndex() * 4)) {
                this.SetPCToCursor.setEnabled(true);
            }
            this.DisMenu.show(this.disasmList, evt.getX(), evt.getY());
        }
    }

    private void AddBreakpointActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        if (value != null) {
            try {
                String address = value.substring(3, 13);
                int addr = Utilities.parseAddress(address);
                if (!this.breakpoints.contains(addr)) {
                    this.breakpoints.add(addr);
                }
                this.RefreshDebuggerDisassembly(false);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            JpcspDialogManager.showInformation(this, "Breakpoint Help : Select the line to add a breakpoint to.");
        }
    }

    private void DeleteAllBreakpointsActionPerformed(ActionEvent evt) {
        this.DeleteAllBreakpoints();
    }

    public void DeleteAllBreakpoints() {
        if (!this.breakpoints.isEmpty()) {
            this.breakpoints.clear();
            this.RefreshDebuggerDisassembly(false);
        }
    }

    private void DeleteBreakpointActionPerformed(ActionEvent evt) {
        String value = (String)this.disasmListGetSelectedValue();
        if (value != null) {
            boolean breakpointexists = value.startsWith("<*>");
            if (breakpointexists) {
                String address = value.substring(3, 13);
                int addr = Utilities.parseAddress(address);
                int b = this.breakpoints.indexOf(addr);
                this.breakpoints.remove(b);
                this.RefreshDebuggerDisassembly(false);
            }
        } else {
            JpcspDialogManager.showInformation(this, "Breakpoint Help : Select the line to remove a breakpoint from.");
        }
    }

    private void removeTemporaryBreakpoints() {
        if (this.temporaryBreakpoint1 != 0) {
            this.breakpoints.remove(new Integer(this.temporaryBreakpoint1));
            this.temporaryBreakpoint1 = 0;
        }
        if (this.temporaryBreakpoint2 != 0) {
            this.breakpoints.remove(new Integer(this.temporaryBreakpoint2));
            this.temporaryBreakpoint2 = 0;
        }
    }

    private void addTemporaryBreakpoints() {
        if (this.temporaryBreakpoint1 != 0) {
            this.breakpoints.add(new Integer(this.temporaryBreakpoint1));
        }
        if (this.temporaryBreakpoint2 != 0) {
            this.breakpoints.add(new Integer(this.temporaryBreakpoint2));
        }
    }

    private void setTemporaryBreakpoints(boolean stepOver) {
        this.removeTemporaryBreakpoints();
        int pc = Emulator.getProcessor().cpu.pc;
        int opcode = Emulator.getMemory().read32(pc);
        Common.Instruction insn = Decoder.instruction(opcode);
        if (insn != null) {
            int branchingTo = 0;
            boolean isBranching = false;
            int npc = pc + 4;
            if (!stepOver || !insn.hasFlags(64)) {
                if (insn.hasFlags(16)) {
                    branchingTo = Compiler.jumpTarget(npc, opcode);
                    isBranching = true;
                } else if (insn.hasFlags(8)) {
                    branchingTo = Compiler.branchTarget(npc, opcode);
                    isBranching = true;
                } else if (insn == Instructions.JR) {
                    int rs = opcode >> 21 & 0x1F;
                    branchingTo = Emulator.getProcessor().cpu.getRegister(rs);
                    isBranching = true;
                    if (this.stepOut && rs == 31) {
                        this.stepOut = false;
                    }
                } else if (insn == Instructions.JALR && !stepOver) {
                    int rs = opcode >> 21 & 0x1F;
                    branchingTo = Emulator.getProcessor().cpu.getRegister(rs);
                    isBranching = true;
                }
            }
            if (!isBranching) {
                this.temporaryBreakpoint1 = npc;
            } else if (branchingTo != 0) {
                this.temporaryBreakpoint1 = branchingTo;
                if (insn.hasFlags(32)) {
                    this.temporaryBreakpoint2 = npc;
                    if (insn.hasFlags(4)) {
                        this.temporaryBreakpoint2 += 4;
                    }
                }
            }
        }
        this.addTemporaryBreakpoints();
        this.emu.RunEmu();
    }

    private void StepIntoActionPerformed(ActionEvent evt) {
        this.setTemporaryBreakpoints(false);
    }

    private void StepOverActionPerformed(ActionEvent evt) {
        this.stepOut = false;
        this.setTemporaryBreakpoints(true);
    }

    private void StepOutActionPerformed(ActionEvent evt) {
        this.stepOut = true;
        this.setTemporaryBreakpoints(true);
    }

    private void RunDebuggerActionPerformed(ActionEvent evt) {
        this.stepOut = false;
        this.removeTemporaryBreakpoints();
        this.emu.RunEmu();
    }

    public void step() {
        if (this.breakpoints.isEmpty()) {
            return;
        }
        if (this.breakpoints.contains(Emulator.getProcessor().cpu.pc)) {
            if (this.stepOut) {
                this.setTemporaryBreakpoints(true);
            } else {
                this.removeTemporaryBreakpoints();
                Emulator.PauseEmuWithStatus(16);
            }
        }
    }

    private void PauseDebuggerActionPerformed(ActionEvent evt) {
        Emulator.PauseEmuWithStatus(64);
    }

    public final void RefreshButtons() {
        this.RunDebugger.setSelected(Emulator.run && !Emulator.pause);
        this.PauseDebugger.setSelected(Emulator.run && Emulator.pause);
        this.btnCapture.setSelected(State.captureGeNextFrame);
        this.btnReplay.setSelected(State.replayGeNextFrame);
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        if (Emulator.run && !Emulator.pause) {
            this.statusLabel.setText(bundle.getString("DisassemblerFrame.strEmuRunning.text"));
        } else if (Emulator.run && Emulator.pause) {
            this.statusLabel.setText(bundle.getString("DisassemblerFrame.strEmuHalted.text") + " (" + StepLogger.getStatusString() + ").");
        } else {
            this.statusLabel.setText(bundle.getString("DisassemblerFrame.strEmuNotRunning.text"));
        }
    }

    private boolean isCellChecked(JTable table) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (!table.isCellSelected(i, 1)) continue;
            return true;
        }
        return false;
    }

    private void CopyValueActionPerformed(ActionEvent evt) {
        if (this.cop1Table.isShowing()) {
            float value = ((Float)this.cop1Table.getValueAt(this.cop1Table.getSelectedRow(), 1)).floatValue();
            StringSelection stringSelection = new StringSelection(Float.toString(value));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, this);
        }
    }

    public int GetGPI() {
        return this.gpi;
    }

    public void SetGPO(int gpo) {
        this.gpo = gpo;
        for (int i = 0; i < 8; ++i) {
            this.SetGPO(i, (gpo & 1 << i) != 0);
        }
    }

    private void ToggleGPI(int index) {
        this.gpi ^= 1 << index;
        for (int i = 0; i < 8; ++i) {
            this.SetGPI(i, (this.gpi & 1 << i) != 0);
        }
    }

    private void SetGPO(int index, boolean on) {
        switch (index) {
            case 0: {
                this.gpoLabel1.setEnabled(on);
                break;
            }
            case 1: {
                this.gpoLabel2.setEnabled(on);
                break;
            }
            case 2: {
                this.gpoLabel3.setEnabled(on);
                break;
            }
            case 3: {
                this.gpoLabel4.setEnabled(on);
                break;
            }
            case 4: {
                this.gpoLabel5.setEnabled(on);
                break;
            }
            case 5: {
                this.gpoLabel6.setEnabled(on);
                break;
            }
            case 6: {
                this.gpoLabel7.setEnabled(on);
                break;
            }
            case 7: {
                this.gpoLabel8.setEnabled(on);
            }
        }
    }

    private void SetGPI(int index, boolean on) {
        switch (index) {
            case 0: {
                this.gpiButton1.setSelected(on);
                break;
            }
            case 1: {
                this.gpiButton2.setSelected(on);
                break;
            }
            case 2: {
                this.gpiButton3.setSelected(on);
                break;
            }
            case 3: {
                this.gpiButton4.setSelected(on);
                break;
            }
            case 4: {
                this.gpiButton5.setSelected(on);
                break;
            }
            case 5: {
                this.gpiButton6.setSelected(on);
                break;
            }
            case 6: {
                this.gpiButton7.setSelected(on);
                break;
            }
            case 7: {
                this.gpiButton8.setSelected(on);
            }
        }
    }

    private void SetPCToCursorActionPerformed(ActionEvent evt) {
        int index = this.disasmListGetSelectedIndex();
        if (index != -1) {
            Emulator.getProcessor().cpu.pc = this.DebuggerPC + index * 4;
            this.RefreshDebuggerDisassembly(true);
        } else {
            System.out.println("dpc: " + Integer.toHexString(this.DebuggerPC));
            System.out.println("idx: " + Integer.toHexString(index));
            System.out.println("npc: " + Integer.toHexString(this.DebuggerPC + index * 4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ExportBreaksActionPerformed(ActionEvent evt) {
        BufferedWriter out;
        File f;
        block7: {
            int res;
            ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
            JFileChooser fc = new JFileChooser();
            fc.setSelectedFile(new File(State.discId + ".brk"));
            fc.setDialogTitle(bundle.getString("DisassemblerFrame.miExportBreakpoints.text"));
            fc.setCurrentDirectory(new File("."));
            fc.addChoosableFileFilter(Constants.fltBreakpointFiles);
            fc.setFileFilter(Constants.fltBreakpointFiles);
            int returnVal = fc.showSaveDialog(this);
            if (returnVal != 0) {
                return;
            }
            f = fc.getSelectedFile();
            out = null;
            if (!f.exists() || (res = JOptionPane.showConfirmDialog(this, bundle.getString("ConsoleWindow.strFileExists.text"), bundle.getString("DisassemblerFrame.miExportBreakpoints.text"), 0, 2)) == 0) break block7;
            Utilities.close(out);
            return;
        }
        try {
            out = new BufferedWriter(new FileWriter(f));
            for (int i = 0; i < this.breakpoints.size(); ++i) {
                out.write(Integer.toHexString(this.breakpoints.get(i)) + System.getProperty("line.separator"));
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                Utilities.close(out);
                throw throwable;
            }
            Utilities.close(out);
        }
        Utilities.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ImportBreaksActionPerformed(ActionEvent evt) {
        BufferedReader in;
        File f;
        block7: {
            ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle(bundle.getString("DisassemblerFrame.miImportBreakpoints.text"));
            fc.setSelectedFile(new File(State.discId + ".brk"));
            fc.setCurrentDirectory(new File("."));
            fc.addChoosableFileFilter(Constants.fltBreakpointFiles);
            fc.setFileFilter(Constants.fltBreakpointFiles);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal != 0) {
                return;
            }
            f = fc.getSelectedFile();
            in = null;
            if (f.getName().contains(".brk")) break block7;
            JOptionPane.showMessageDialog(this, bundle.getString("DisassemblerFrame.strInvalidBRKFile.text"), bundle.getString("DisassemblerFrame.miImportBreakpoints.text"), 0);
            Utilities.close(in);
            return;
        }
        try {
            in = new BufferedReader(new FileReader(f));
            String nextBrk = in.readLine();
            while (nextBrk != null) {
                this.breakpoints.add(Integer.parseInt(nextBrk, 16));
                nextBrk = in.readLine();
            }
            this.RefreshDebuggerDisassembly(false);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                Utilities.close(in);
                throw throwable;
            }
            Utilities.close(in);
        }
        Utilities.close(in);
    }

    private void ManageMemBreaksActionPerformed(ActionEvent evt) {
        if (this.mbpDialog == null) {
            this.mbpDialog = new MemoryBreakpointsDialog(this);
        }
        this.mbpDialog.setVisible(true);
    }

    private void CloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void txtSearchActionPerformed(ActionEvent evt) {
        if (this.txtSearch.getText().isEmpty()) {
            return;
        }
        this.prgBarSearch.setIndeterminate(true);
        this.txtSearch.setEnabled(false);
        this.btnCancelSearch.setEnabled(true);
        this.searchTask = new SearchTask(this.txtSearch.getText(), this.SelectedPC + 4);
        this.searchTask.execute();
    }

    private void btnDumpDebugStateActionPerformed(ActionEvent evt) {
        DumpDebugState.dumpDebugState();
    }

    private void gpiButton8ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(7);
    }

    private void gpiButton7ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(6);
    }

    private void gpiButton6ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(5);
    }

    private void gpiButton5ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(4);
    }

    private void gpiButton4ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(3);
    }

    private void gpiButton3ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(2);
    }

    private void gpiButton2ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(1);
    }

    private void gpiButton1ActionPerformed(ActionEvent evt) {
        this.ToggleGPI(0);
    }

    private void cop1TableMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt) && this.cop1Table.isColumnSelected(1) && this.isCellChecked(this.cop1Table)) {
            this.RegMenu.show(this.cop1Table, evt.getX(), evt.getY());
        }
    }

    private void disasmListComponentResized(ComponentEvent evt) {
        this.RefreshDebuggerDisassembly(false);
    }

    private void btnCaptureActionPerformed(ActionEvent evt) {
        State.captureGeNextFrame = this.btnCapture.isSelected();
    }

    private void btnReplayActionPerformed(ActionEvent evt) {
        State.replayGeNextFrame = this.btnReplay.isSelected();
    }

    private void btnCancelSearchActionPerformed(ActionEvent evt) {
        this.searchTask.cancel(false);
    }

    private void txtSearchFocusGained(FocusEvent evt) {
        this.txtSearch.selectAll();
    }

    @Override
    public void dispose() {
        if (this.mbpDialog != null) {
            this.mbpDialog.dispose();
        }
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    private static class ClickAction
    extends AbstractAction {
        private static final long serialVersionUID = -6595335927462915819L;
        private JButton button;

        public ClickAction(JButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.button.doClick();
        }
    }

    private class SearchTask
    extends SwingWorker {
        private String search = "";
        private int position;

        public SearchTask(String search, int startAt) {
            this.search = search;
            this.position = startAt;
        }

        @Override
        protected void done() {
            try {
                final Integer address = (Integer)this.get();
                if (address != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DisassemblerFrame.this.DebuggerPC = address;
                            DisassemblerFrame.this.SelectedPC = address;
                            DisassemblerFrame.this.RefreshDebuggerDisassembly(false);
                        }
                    });
                }
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            DisassemblerFrame.this.prgBarSearch.setIndeterminate(false);
            DisassemblerFrame.this.txtSearch.setEnabled(true);
            DisassemblerFrame.this.btnCancelSearch.setEnabled(false);
            if (DisassemblerFrame.this.txtSearch.isVisible()) {
                DisassemblerFrame.this.txtSearch.requestFocus();
            }
        }

        protected Object doInBackground() throws Exception {
            if (this.search.isEmpty()) {
                return null;
            }
            while (Memory.isAddressGood(this.position)) {
                int opcode = Memory.getInstance().read32(this.position);
                Common.Instruction insn = Decoder.instruction(opcode);
                if (insn.disasm(this.position, opcode).contains(this.search)) {
                    return new Integer(this.position);
                }
                this.position += 4;
                if (!this.isCancelled()) continue;
                break;
            }
            return null;
        }
    }
}

