/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import jpcsp.HLE.ITPointerBase;
import jpcsp.HLE.TPointer;
import jpcsp.Memory;

public abstract class TPointerBase
implements ITPointerBase {
    protected TPointer pointer;
    private boolean canBeNull;

    protected TPointerBase() {
        this.pointer = TPointer.NULL;
        this.canBeNull = true;
    }

    protected TPointerBase(Memory memory, int address, boolean canBeNull) {
        this.pointer = new TPointer(memory, address);
        this.canBeNull = canBeNull;
    }

    @Override
    public boolean isAddressGood() {
        return Memory.isAddressGood(this.pointer.getAddress());
    }

    @Override
    public boolean isAlignedTo(int offset) {
        return this.pointer.isAlignedTo(offset);
    }

    @Override
    public int getAddress() {
        return this.pointer.getAddress();
    }

    @Override
    public boolean isNull() {
        return this.pointer.isNull();
    }

    @Override
    public boolean isNotNull() {
        return this.pointer.isNotNull();
    }

    @Override
    public Memory getMemory() {
        return this.pointer.getMemory();
    }

    @Override
    public Memory getNewPointerMemory() {
        return this.getMemory();
    }

    protected boolean canSetValue() {
        return !this.canBeNull || this.isNotNull();
    }

    public String toString() {
        return String.format("0x%08X", this.getAddress());
    }
}

