/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.fat;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualCache;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.fat.FatBuilder;
import jpcsp.HLE.VFS.fat.FatFileInfo;
import jpcsp.HLE.VFS.fat.FatUtils;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public abstract class FatVirtualFile
implements IVirtualFile,
IVirtualCache,
IState {
    public static Logger log = Logger.getLogger((String)"fat");
    private static final int STATE_VERSION = 0;
    public static final int sectorSize = 512;
    protected static final int firstClusterNumber = 2;
    protected final byte[] currentSector = new byte[512];
    private static final byte[] emptySector = new byte[512];
    private String deviceName;
    private IVirtualFileSystem vfs;
    private long position;
    protected int totalSectors;
    protected int fatSectors;
    protected int[] fatClusterMap;
    private FatFileInfo[] fatFileInfoMap;
    private byte[] pendingCreateDirectoryEntryLFN;
    private final Map<Integer, byte[]> pendingWriteSectors = new HashMap<Integer, byte[]>();
    private final Map<Integer, FatFileInfo> pendingDeleteFiles = new HashMap<Integer, FatFileInfo>();
    private FatBuilder builder;
    private int fatSectorNumber = 32;
    private int fsInfoSectorNumber = 1;
    protected FatFileInfo rootDirectory;
    protected int rootDirectoryStartSectorNumber = -1;
    protected int rootDirectoryEndSectorNumber = -1;
    private final byte[] secondFat;

    protected FatVirtualFile(String deviceName, IVirtualFileSystem vfs, int totalSectors) {
        this.deviceName = deviceName;
        this.vfs = vfs;
        this.totalSectors = totalSectors;
        this.fatSectors = this.getFatSectors(totalSectors, this.getSectorsPerCluster());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("totalSectors=0x%X, fatSectors=0x%X", totalSectors, this.fatSectors));
        }
        int usedSectors = 32 + this.fatSectors * 2;
        int maxNumberClusters = (totalSectors - (usedSectors += this.getFirstDataClusterOffset())) / this.getSectorsPerCluster();
        this.fatClusterMap = new int[maxNumberClusters];
        this.fatClusterMap[0] = 0xFFFFFFF8 & this.getClusterMask();
        this.fatClusterMap[1] = 0xFFFFFFFF & this.getClusterMask();
        this.fatFileInfoMap = new FatFileInfo[maxNumberClusters];
        this.secondFat = new byte[this.fatSectors * 512];
        this.builder = new FatBuilder(this, vfs, maxNumberClusters);
    }

    protected abstract int getClusterMask();

    protected abstract int getSectorsPerCluster();

    protected abstract int getFatEOC();

    protected abstract int getFatSectors(int var1, int var2);

    protected abstract void readBIOSParameterBlock();

    protected abstract int getFirstDataClusterOffset();

    protected abstract void setRootDirectory(FatFileInfo var1);

    protected int getFirstFreeCluster() {
        return 2 + this.getFirstDataClusterOffset() / this.getSectorsPerCluster();
    }

    protected int getClusterSize() {
        return 512 * this.getSectorsPerCluster();
    }

    public int getFsInfoSectorNumber() {
        return this.fsInfoSectorNumber;
    }

    public void setFsInfoSectorNumber(int fsInfoSectorNumber) {
        this.fsInfoSectorNumber = fsInfoSectorNumber;
    }

    public int getFatSectorNumber() {
        return this.fatSectorNumber;
    }

    public void setFatSectorNumber(int fatSectorNumber) {
        this.fatSectorNumber = fatSectorNumber;
    }

    public void scan() {
        this.builder.scan(this.deviceName);
    }

    private void extendClusterMap(int clusterNumber) {
        int extend = clusterNumber + 1 - this.fatClusterMap.length;
        if (extend > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("extendClusterMap clusterNumber=0x%X, extend=0x%X", clusterNumber, extend));
            }
            this.fatClusterMap = Utilities.extendArray(this.fatClusterMap, extend);
            this.fatFileInfoMap = FatUtils.extendArray(this.fatFileInfoMap, extend);
        }
    }

    public void setFatFileInfoMap(int clusterNumber, FatFileInfo fileInfo) {
        if (clusterNumber >= this.fatFileInfoMap.length) {
            this.extendClusterMap(clusterNumber);
        }
        this.fatFileInfoMap[clusterNumber] = fileInfo;
    }

    public void setFatClusterMap(int clusterNumber, int value) {
        if (clusterNumber >= this.fatClusterMap.length) {
            this.extendClusterMap(clusterNumber);
        }
        this.fatClusterMap[clusterNumber] = value;
    }

    private int getClusterNumber(int sectorNumber) {
        sectorNumber -= this.fatSectorNumber;
        sectorNumber -= 2 * this.fatSectors;
        return 2 + (sectorNumber -= this.getFirstDataClusterOffset()) / this.getSectorsPerCluster();
    }

    private int getSectorNumberFromCluster(int clusterNumber) {
        int sectorNumber = (clusterNumber - 2) * this.getSectorsPerCluster();
        sectorNumber += this.fatSectorNumber;
        sectorNumber += 2 * this.fatSectors;
        return sectorNumber += this.getFirstDataClusterOffset();
    }

    private int getSectorOffsetInCluster(int sectorNumber) {
        sectorNumber -= this.fatSectorNumber;
        sectorNumber -= 2 * this.fatSectors;
        return (sectorNumber -= this.getFirstDataClusterOffset()) % this.getSectorsPerCluster();
    }

    private boolean isFreeClusterNumber(int clusterNumber) {
        return (clusterNumber &= this.getClusterMask()) == 0;
    }

    private boolean isDataClusterNumber(int clusterNumber) {
        return (clusterNumber &= this.getClusterMask()) >= 2 && clusterNumber <= 0xFFFFFEF;
    }

    protected String getOEMName() {
        return "";
    }

    private void readBootSector() {
        this.readEmptySector();
        FatUtils.storeSectorInt8(this.currentSector, 0, 235);
        FatUtils.storeSectorInt8(this.currentSector, 1, 88);
        FatUtils.storeSectorInt8(this.currentSector, 2, 144);
        FatUtils.storeSectorString(this.currentSector, 3, this.getOEMName(), 8);
        this.readBIOSParameterBlock();
        FatUtils.storeSectorInt8(this.currentSector, 510, 85);
        FatUtils.storeSectorInt8(this.currentSector, 511, 170);
    }

    private void readFsInfoSector() {
        this.readEmptySector();
        FatUtils.storeSectorInt8(this.currentSector, 0, 82);
        FatUtils.storeSectorInt8(this.currentSector, 1, 82);
        FatUtils.storeSectorInt8(this.currentSector, 2, 97);
        FatUtils.storeSectorInt8(this.currentSector, 3, 65);
        FatUtils.storeSectorInt8(this.currentSector, 484, 114);
        FatUtils.storeSectorInt8(this.currentSector, 485, 114);
        FatUtils.storeSectorInt8(this.currentSector, 486, 65);
        FatUtils.storeSectorInt8(this.currentSector, 487, 97);
        FatUtils.storeSectorInt32(this.currentSector, 488, -1);
        FatUtils.storeSectorInt32(this.currentSector, 492, -1);
        FatUtils.storeSectorInt8(this.currentSector, 510, 85);
        FatUtils.storeSectorInt8(this.currentSector, 511, 170);
    }

    protected abstract void readFatSector(int var1);

    private void readDataSector(int sectorNumber, int clusterNumber, int sectorOffsetInCluster, FatFileInfo fileInfo) {
        this.readEmptySector();
        if (fileInfo == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("readDataSector unknown sectorNumber=0x%X, clusterNumber=0x%X", sectorNumber, clusterNumber));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readDataSector clusterNumber=0x%X(sector=0x%X), fileInfo=%s", clusterNumber, sectorOffsetInCluster, fileInfo));
        }
        if (fileInfo.isDirectory()) {
            int byteOffset;
            byte[] directoryData = fileInfo.getFileData();
            if (directoryData == null) {
                directoryData = this.builder.buildDirectoryData(fileInfo);
                fileInfo.setFileData(directoryData);
            }
            if ((byteOffset = sectorOffsetInCluster * 512) < directoryData.length) {
                int length = Math.min(directoryData.length - byteOffset, 512);
                System.arraycopy(directoryData, byteOffset, this.currentSector, 0, length);
            }
        } else {
            IVirtualFile vFile = fileInfo.getVirtualFile(this.vfs);
            if (vFile == null) {
                log.warn((Object)String.format("readDataSector cannot read file '%s'", fileInfo));
                return;
            }
            long byteOffset = (long)sectorOffsetInCluster * 512L;
            int[] clusters = fileInfo.getClusters();
            if (clusters != null) {
                for (int i = 0; i < clusters.length && clusters[i] != clusterNumber; ++i) {
                    byteOffset += (long)(this.getSectorsPerCluster() * 512);
                }
            }
            if (byteOffset < fileInfo.getFileSize()) {
                if (vFile.ioLseek(byteOffset) != byteOffset) {
                    log.warn((Object)String.format("readDataSector cannot seek file '%s' to 0x%X", fileInfo, byteOffset));
                    return;
                }
                int length = (int)Math.min(fileInfo.getFileSize() - byteOffset, 512L);
                int readLength = vFile.ioRead(this.currentSector, 0, length);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("readDataSector readLength=0x%X", readLength));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("readDataSector trying to read at offset 0x%X past end of file", byteOffset, fileInfo));
            }
        }
    }

    private void readRootDirectory(int sectorNumber) {
        this.readDataSector(this.rootDirectoryStartSectorNumber, 0, sectorNumber, this.rootDirectory);
    }

    private void readDataSector(int sectorNumber) {
        this.readEmptySector();
        int clusterNumber = this.getClusterNumber(sectorNumber);
        if (clusterNumber >= this.fatFileInfoMap.length) {
            return;
        }
        FatFileInfo fileInfo = this.fatFileInfoMap[clusterNumber];
        int sectorOffsetInCluster = this.getSectorOffsetInCluster(sectorNumber);
        this.readDataSector(sectorNumber, clusterNumber, sectorOffsetInCluster, fileInfo);
    }

    private void readSecondFatSector(int fatIndex) {
        System.arraycopy(this.secondFat, fatIndex * 512, this.currentSector, 0, 512);
    }

    protected void readEmptySector() {
        System.arraycopy(emptySector, 0, this.currentSector, 0, 512);
    }

    private void readSector(int sectorNumber) {
        byte[] pendingWriteSector = this.pendingWriteSectors.get(sectorNumber);
        if (pendingWriteSector != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("readSector sectorNumber=0x%X reading from pending write sector", sectorNumber));
            }
            System.arraycopy(pendingWriteSector, 0, this.currentSector, 0, 512);
            return;
        }
        if (sectorNumber == 0) {
            this.readBootSector();
        } else if (sectorNumber == this.fsInfoSectorNumber) {
            this.readFsInfoSector();
        } else if (sectorNumber < this.fatSectorNumber) {
            this.readEmptySector();
        } else if (sectorNumber >= this.fatSectorNumber && sectorNumber < this.fatSectorNumber + this.fatSectors) {
            this.readFatSector(sectorNumber - this.fatSectorNumber);
        } else if (sectorNumber >= this.fatSectorNumber + this.fatSectors && sectorNumber < this.fatSectorNumber + 2 * this.fatSectors) {
            this.readSecondFatSector(sectorNumber - this.fatSectorNumber - this.fatSectors);
        } else if (sectorNumber >= this.rootDirectoryStartSectorNumber && sectorNumber <= this.rootDirectoryEndSectorNumber) {
            this.readRootDirectory(sectorNumber - this.rootDirectoryStartSectorNumber);
        } else {
            this.readDataSector(sectorNumber);
        }
    }

    private void writeBootSector() {
        log.warn((Object)String.format("Writing to the MemoryStick boot sector!", new Object[0]));
        this.writeEmptySector();
    }

    private void writeFsInfoSector() {
        log.warn((Object)String.format("Writing to the MemoryStick FsInfo sector!", new Object[0]));
        this.writeEmptySector();
    }

    protected void writeFatSectorEntry(int clusterNumber, int value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeFatSectorEntry[0x%X]=0x%08X", clusterNumber, value));
        }
        this.fatClusterMap[clusterNumber] = value;
        FatFileInfo fileInfo = this.fatFileInfoMap[clusterNumber];
        if (fileInfo != null) {
            if (this.isFreeClusterNumber(value)) {
                if (this.pendingDeleteFiles.get(clusterNumber) == fileInfo) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Deleting the file '%s'", fileInfo.getFullFileName()));
                    }
                    this.closeTree(fileInfo);
                    int result = this.vfs.ioRemove(fileInfo.getFullFileName());
                    if (result < 0) {
                        log.warn((Object)String.format("Cannot delete the file '%s'", fileInfo.getFullFileName()));
                    }
                    this.pendingDeleteFiles.remove(clusterNumber);
                }
            } else {
                int newClusterNumber;
                if (this.isDataClusterNumber(value) && !fileInfo.hasCluster(newClusterNumber = value & this.getClusterMask())) {
                    fileInfo.addCluster(newClusterNumber);
                    this.fatFileInfoMap[newClusterNumber] = fileInfo;
                }
                this.checkPendingWriteSectors(fileInfo);
            }
        }
    }

    protected abstract void writeFatSector(int var1);

    private void deleteDirectoryEntry(FatFileInfo fileInfo, byte[] directoryData, int offset) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("deleteDirectoryEntry on %s: %s", fileInfo, Utilities.getMemoryDump(directoryData, offset, 32)));
        }
        if (!FatVirtualFile.isLongFileNameDirectoryEntry(directoryData, offset)) {
            String fileName83 = Utilities.readStringNZ(directoryData, offset + 0, 11);
            FatFileInfo childFileInfo = fileInfo.getChildByFileName83(fileName83);
            if (childFileInfo == null) {
                log.warn((Object)String.format("deleteDirectoryEntry cannot find child entry '%s' in %s", fileName83, fileInfo));
            } else {
                this.pendingDeleteFiles.put(childFileInfo.getFirstCluster(), childFileInfo);
            }
        }
    }

    private void deleteDirectoryEntries(FatFileInfo fileInfo, byte[] directoryData, int offset, int length) {
        if (directoryData == null || length <= 0 || offset >= directoryData.length) {
            return;
        }
        for (int i = 0; i < length; i += 32) {
            this.deleteDirectoryEntry(fileInfo, directoryData, offset + i);
        }
    }

    private static String getFileNameLFN(byte[] lfn) {
        boolean last = false;
        byte[] fileNameBytes = null;
        int sequenceNumber = 1;
        while (!last) {
            for (int i = 0; i < lfn.length; i += 32) {
                if ((lfn[i + 0] & 0x1F) != sequenceNumber) continue;
                if ((lfn[i + 0] & 0x40) != 0) {
                    last = true;
                }
                fileNameBytes = Utilities.extendArray(fileNameBytes, lfn, i + 1, 10);
                fileNameBytes = Utilities.extendArray(fileNameBytes, lfn, i + 14, 12);
                fileNameBytes = Utilities.extendArray(fileNameBytes, lfn, i + 28, 4);
                break;
            }
            ++sequenceNumber;
        }
        if (fileNameBytes == null) {
            return "";
        }
        for (int i = 0; i < fileNameBytes.length; i += 2) {
            if (fileNameBytes[i] != false || fileNameBytes[i + 1] != false) continue;
            return new String(fileNameBytes, 0, i, pspAbstractMemoryMappedStructure.charset16);
        }
        return new String(fileNameBytes, pspAbstractMemoryMappedStructure.charset16);
    }

    public static String getFileName(byte[] sector, int offset, byte[] lfn) {
        String fileName;
        if (lfn != null) {
            fileName = FatVirtualFile.getFileNameLFN(lfn);
        } else {
            String name = FatUtils.readSectorString(sector, offset + 0, 8);
            String ext = FatUtils.readSectorString(sector, offset + 8, 3);
            fileName = ext.length() == 0 ? name : name + '.' + ext;
        }
        return fileName;
    }

    private void closeTree(FatFileInfo fileInfo) {
        if (fileInfo != null) {
            fileInfo.closeVirtualFile();
            List<FatFileInfo> children = fileInfo.getChildren();
            if (children != null) {
                for (FatFileInfo child : children) {
                    this.closeTree(child);
                }
            }
        }
    }

    private int getMode(boolean directory, boolean readOnly) {
        int mode = 292;
        if (directory) {
            mode |= 0x49;
        }
        if (!readOnly) {
            mode |= 0x92;
        }
        return mode;
    }

    private void createDirectoryEntry(FatFileInfo fileInfo, byte[] sector, int offset) {
        if (offset >= sector.length) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("createDirectoryEntry on %s: %s", fileInfo, Utilities.getMemoryDump(sector, offset, 32)));
        }
        if (FatVirtualFile.isLongFileNameDirectoryEntry(sector, offset)) {
            this.pendingCreateDirectoryEntryLFN = Utilities.extendArray(this.pendingCreateDirectoryEntryLFN, sector, offset, 32);
        } else {
            FatFileInfo pendingDeleteFile;
            String fileName = FatVirtualFile.getFileName(sector, offset, this.pendingCreateDirectoryEntryLFN);
            boolean readOnly = (sector[offset + 11] & 1) != 0;
            boolean directory = (sector[offset + 11] & 0x10) != 0;
            int clusterNumber = FatUtils.readSectorInt16(sector, offset + 20) << 16;
            clusterNumber |= FatUtils.readSectorInt16(sector, offset + 26);
            long fileSize = (long)FatUtils.readSectorInt32(sector, offset + 28) & 0xFFFFFFFFL;
            int time = FatUtils.readSectorInt16(sector, offset + 22);
            ScePspDateTime lastModified = ScePspDateTime.fromMSDOSTime(time |= FatUtils.readSectorInt16(sector, offset + 24) << 16);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("createDirectoryEntry fileName='%s', readOnly=%b, directory=%b, clusterNumber=0x%X, fileSize=0x%X", fileName, readOnly, directory, clusterNumber, fileSize));
            }
            if ((pendingDeleteFile = this.pendingDeleteFiles.remove(clusterNumber)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Renaming directory entry %s into '%s'", pendingDeleteFile, fileName));
                }
                if (readOnly != pendingDeleteFile.isReadOnly()) {
                    log.warn((Object)String.format("Cannot change read-only attribute of %s", pendingDeleteFile));
                }
                if (directory != pendingDeleteFile.isDirectory()) {
                    log.warn((Object)String.format("Cannot change directory attribute of %s", pendingDeleteFile));
                }
                if (fileSize != pendingDeleteFile.getFileSize()) {
                    log.warn((Object)String.format("Cannot change file size of %s", pendingDeleteFile));
                }
                String oldFullFileName = pendingDeleteFile.getFullFileName();
                pendingDeleteFile.setFileName(fileName);
                String newFullFileName = pendingDeleteFile.getFullFileName();
                this.closeTree(pendingDeleteFile);
                int result = this.vfs.ioRename(oldFullFileName, newFullFileName);
                if (result < 0) {
                    log.warn((Object)String.format("Cannot rename file '%s' into '%s'", oldFullFileName, newFullFileName));
                }
                pendingDeleteFile.setDirectory(directory);
                pendingDeleteFile.setReadOnly(readOnly);
                pendingDeleteFile.setFileSize(fileSize);
                pendingDeleteFile.setLastModified(lastModified);
            } else {
                FatFileInfo newFileInfo = new FatFileInfo(this.deviceName, fileInfo.getFullFileName(), fileName, directory, readOnly, lastModified, fileSize);
                newFileInfo.setFileName83(Utilities.readStringNZ(sector, offset + 0, 11));
                if (clusterNumber != 0) {
                    int[] clusters = this.getClusters(clusterNumber);
                    this.builder.setClusters(newFileInfo, clusters);
                }
                fileInfo.addChild(newFileInfo);
                if (directory) {
                    this.vfs.ioMkdir(newFileInfo.getFullFileName(), this.getMode(directory, readOnly));
                }
            }
            this.pendingCreateDirectoryEntryLFN = null;
        }
    }

    private void checkPendingWriteSectors(FatFileInfo fileInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("checkPendingWriteSectors for %s", fileInfo));
        }
        if (this.pendingWriteSectors.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("checkPendingWriteSectors - no pending sectors", new Object[0]));
            }
            return;
        }
        int[] clusters = fileInfo.getClusters();
        if (clusters == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            for (int sectorNumber : this.pendingWriteSectors.keySet()) {
                log.debug((Object)String.format("checkPendingWriteSectors pending sectorNumber=0x%X", sectorNumber));
            }
        }
        for (int i = 0; i < clusters.length; ++i) {
            int clusterNumber = clusters[i];
            int sectorNumber = this.getSectorNumberFromCluster(clusterNumber);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("checkPendingWriteSectors checking for clusterNumber=0x%X, sectorNumber=0x%X-0x%X", clusterNumber, sectorNumber, sectorNumber + this.getSectorsPerCluster() - 1));
            }
            int j = 0;
            while (j < this.getSectorsPerCluster()) {
                byte[] pendingWriteSector = this.pendingWriteSectors.remove(sectorNumber);
                if (pendingWriteSector != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("checkPendingWriteSectors writing pending sectorNumber=0x%X for %s", sectorNumber, fileInfo));
                    }
                    if (!this.writeFileSector(fileInfo, this.getByteOffset(fileInfo, sectorNumber), pendingWriteSector)) {
                        this.pendingWriteSectors.put(sectorNumber, pendingWriteSector);
                    }
                }
                ++j;
                ++sectorNumber;
            }
        }
    }

    private int[] getClusters(int clusterNumber) {
        int nextCluster;
        int[] clusters = new int[]{clusterNumber};
        while (clusterNumber < this.fatClusterMap.length && this.isDataClusterNumber(nextCluster = this.fatClusterMap[clusterNumber])) {
            clusters = Utilities.extendArray(clusters, 1);
            clusters[clusters.length - 1] = clusterNumber = nextCluster & this.getClusterMask();
        }
        return clusters;
    }

    private void updateDirectoryEntry(FatFileInfo fileInfo, byte[] directoryData, int directoryDataOffset, byte[] sector, int sectorOffset) {
        boolean newLFN;
        boolean oldLFN;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("updateDirectoryEntry on %s: from %s, to %s", fileInfo, Utilities.getMemoryDump(directoryData, directoryDataOffset, 32), Utilities.getMemoryDump(sector, sectorOffset, 32)));
        }
        if ((oldLFN = FatVirtualFile.isLongFileNameDirectoryEntry(directoryData, directoryDataOffset)) != (newLFN = FatVirtualFile.isLongFileNameDirectoryEntry(sector, sectorOffset))) {
            log.error((Object)String.format("updateDirectoryEntry changing LongFileName entries not implemented: %s from %s, to %s", fileInfo, Utilities.getMemoryDump(directoryData, directoryDataOffset, 32), Utilities.getMemoryDump(sector, sectorOffset, 32)));
        } else if (newLFN) {
            log.error((Object)String.format("updateDirectoryEntry updating LongFileName entries not implemented: %s from %s, to %s", fileInfo, Utilities.getMemoryDump(directoryData, directoryDataOffset, 32), Utilities.getMemoryDump(sector, sectorOffset, 32)));
        } else {
            FatFileInfo childFileInfo;
            String newFileName83;
            String oldFileName83;
            int oldClusterNumber = FatUtils.readSectorInt16(directoryData, directoryDataOffset + 20) << 16;
            oldClusterNumber |= FatUtils.readSectorInt16(directoryData, directoryDataOffset + 26);
            int newClusterNumber = FatUtils.readSectorInt16(sector, sectorOffset + 20) << 16;
            newClusterNumber |= FatUtils.readSectorInt16(sector, sectorOffset + 26);
            long newFileSize = (long)FatUtils.readSectorInt32(sector, sectorOffset + 28) & 0xFFFFFFFFL;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("updateDirectoryEntry oldClusterNumber=0x%X, newClusterNumber=0x%X, newFileSize=0x%X", oldClusterNumber, newClusterNumber, newFileSize));
            }
            if (!(oldFileName83 = Utilities.readStringNZ(directoryData, directoryDataOffset + 0, 11)).equals(newFileName83 = Utilities.readStringNZ(sector, sectorOffset + 0, 11))) {
                log.warn((Object)String.format("updateDirectoryEntry unimplemented change of 8.3. file name: from '%s' to '%s'", oldFileName83, newFileName83));
            }
            if ((childFileInfo = fileInfo.getChildByFileName83(oldFileName83)) == null) {
                log.warn((Object)String.format("updateDirectoryEntry child '%s' not found", oldFileName83));
            } else {
                childFileInfo.setFileSize(newFileSize);
                if (oldClusterNumber != newClusterNumber) {
                    int[] clusters = this.getClusters(newClusterNumber);
                    this.builder.setClusters(childFileInfo, clusters);
                    this.checkPendingWriteSectors(childFileInfo);
                }
            }
        }
    }

    public static boolean isLongFileNameDirectoryEntry(byte[] directoryData, int offset) {
        return directoryData[offset + 11] == 15;
    }

    private long getByteOffset(FatFileInfo fileInfo, int sectorNumber) {
        int clusterNumber = this.getClusterNumber(sectorNumber);
        int sectorOffsetInCluster = this.getSectorOffsetInCluster(sectorNumber);
        long byteOffset = (long)sectorOffsetInCluster * 512L;
        int[] clusters = fileInfo.getClusters();
        if (clusters != null) {
            for (int i = 0; i < clusters.length && clusters[i] != clusterNumber; ++i) {
                byteOffset += (long)this.getClusterSize();
            }
        }
        return byteOffset;
    }

    private static boolean isEmpty(byte[] sector, int offset) {
        for (int i = offset; i < 512; ++i) {
            if (sector[i] == 0) continue;
            return false;
        }
        return true;
    }

    private boolean writeFileSector(FatFileInfo fileInfo, long byteOffset, byte[] sector) {
        int length;
        IVirtualFile vFile = fileInfo.getVirtualFile(this.vfs);
        if (vFile == null) {
            log.warn((Object)String.format("writeFileSector cannot write file '%s'", fileInfo));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeFileSector byteOffset=0x%X for %s", byteOffset, fileInfo));
        }
        if ((length = (int)Math.min(fileInfo.getFileSize() - byteOffset, 512L)) < 0 || !FatVirtualFile.isEmpty(sector, length)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("writeFileSector writing past end of file '%s'", fileInfo));
            }
            return false;
        }
        if (vFile.ioLseek(byteOffset) != byteOffset) {
            log.warn((Object)String.format("writeFileSector cannot seek file '%s' to 0x%X", fileInfo, byteOffset));
            return false;
        }
        int writeLength = vFile.ioWrite(sector, 0, length);
        if (writeLength != length) {
            log.warn((Object)String.format("writeFileSector cannot write file 0x%X bytes to file '%s': result 0x%X", length, fileInfo, writeLength));
            return false;
        }
        return true;
    }

    private boolean isCurrentSectorEmpty() {
        for (int i = 0; i < 512; ++i) {
            if (this.currentSector[i] == -1) continue;
            return false;
        }
        return true;
    }

    private void addPendingWriteSectors(int sectorNumber) {
        this.pendingWriteSectors.put(sectorNumber, (byte[])this.currentSector.clone());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("addPendingWriteSectors sectorNumber=0x%X", sectorNumber));
        }
    }

    private void writeDataSector(int sectorNumber, int clusterNumber, int sectorOffsetInCluster, FatFileInfo fileInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeDataSector clusterNumber=0x%X(sector=0x%X), fileInfo=%s", clusterNumber, sectorOffsetInCluster, fileInfo));
        }
        if (fileInfo.isDirectory()) {
            if (this.isCurrentSectorEmpty()) {
                this.addPendingWriteSectors(sectorNumber);
                return;
            }
            byte[] directoryData = fileInfo.getFileData();
            if (directoryData == null) {
                directoryData = this.builder.buildDirectoryData(fileInfo);
                fileInfo.setFileData(directoryData);
            }
            int byteOffset = sectorOffsetInCluster * 512;
            int sectorLength = 512;
            for (int i = 0; i < 512; i += 32) {
                if (this.currentSector[i + 0] == 0) {
                    this.deleteDirectoryEntries(fileInfo, directoryData, byteOffset + i, directoryData.length - (byteOffset + i));
                    sectorLength = i;
                    break;
                }
                if (this.currentSector[i + 0] == -27) {
                    if (byteOffset + i >= directoryData.length || directoryData[byteOffset + i + 0] == -27) continue;
                    this.deleteDirectoryEntry(fileInfo, directoryData, byteOffset + i);
                    continue;
                }
                if (byteOffset + i >= directoryData.length) {
                    this.createDirectoryEntry(fileInfo, this.currentSector, i);
                    continue;
                }
                if (Utilities.equals(directoryData, byteOffset + i, this.currentSector, i, 32)) continue;
                this.updateDirectoryEntry(fileInfo, directoryData, byteOffset + i, this.currentSector, i);
            }
            directoryData = Utilities.copyToArrayAndExtend(directoryData, byteOffset, this.currentSector, 0, sectorLength);
            fileInfo.setFileData(directoryData);
        } else if (!this.writeFileSector(fileInfo, this.getByteOffset(fileInfo, sectorNumber), this.currentSector)) {
            this.addPendingWriteSectors(sectorNumber);
        }
    }

    private void writeRootDirectory(int sectorNumber) {
        this.writeDataSector(this.rootDirectoryStartSectorNumber, 0, sectorNumber, this.rootDirectory);
    }

    private void writeDataSector(int sectorNumber) {
        int clusterNumber = this.getClusterNumber(sectorNumber);
        int sectorOffsetInCluster = this.getSectorOffsetInCluster(sectorNumber);
        FatFileInfo fileInfo = this.fatFileInfoMap[clusterNumber];
        if (fileInfo == null) {
            this.addPendingWriteSectors(sectorNumber);
            return;
        }
        this.writeDataSector(sectorNumber, clusterNumber, sectorOffsetInCluster, fileInfo);
    }

    private void writeSecondFatSector(int fatIndex) {
        System.arraycopy(this.currentSector, 0, this.secondFat, fatIndex * 512, 512);
    }

    private void writeEmptySector() {
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    private void writeSector(int sectorNumber) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeSector 0x%X", sectorNumber));
        }
        this.pendingWriteSectors.remove(sectorNumber);
        if (sectorNumber == 0) {
            this.writeBootSector();
        } else if (sectorNumber == this.fsInfoSectorNumber) {
            this.writeFsInfoSector();
        } else if (sectorNumber < this.fatSectorNumber) {
            this.writeEmptySector();
        } else if (sectorNumber >= this.fatSectorNumber && sectorNumber < this.fatSectorNumber + this.fatSectors) {
            if (this.isCurrentSectorEmpty()) {
                this.addPendingWriteSectors(sectorNumber);
            } else {
                this.writeFatSector(sectorNumber - this.fatSectorNumber);
            }
        } else if (sectorNumber >= this.fatSectorNumber + this.fatSectors && sectorNumber < this.fatSectorNumber + 2 * this.fatSectors) {
            if (this.isCurrentSectorEmpty()) {
                this.addPendingWriteSectors(sectorNumber);
            } else {
                this.writeSecondFatSector(sectorNumber - this.fatSectorNumber - this.fatSectors);
            }
        } else if (sectorNumber >= this.rootDirectoryStartSectorNumber && sectorNumber <= this.rootDirectoryEndSectorNumber) {
            if (this.isCurrentSectorEmpty()) {
                this.addPendingWriteSectors(sectorNumber);
            } else {
                this.writeRootDirectory(sectorNumber - this.rootDirectoryStartSectorNumber);
            }
        } else {
            this.writeDataSector(sectorNumber);
        }
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        int readLength = 0;
        int outputOffset = 0;
        while (outputLength > 0) {
            int sectorNumber = FatUtils.getSectorNumber(this.position);
            this.readSector(sectorNumber);
            int sectorOffset = FatUtils.getSectorOffset(this.position);
            int sectorLength = 512 - sectorOffset;
            int length = Math.min(sectorLength, outputLength);
            outputPointer.setArray(outputOffset, this.currentSector, sectorOffset, length);
            outputLength -= length;
            outputOffset += length;
            this.position += (long)length;
            readLength += length;
        }
        return readLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        int readLength = 0;
        while (outputLength > 0) {
            int sectorNumber = FatUtils.getSectorNumber(this.position);
            this.readSector(sectorNumber);
            int sectorOffset = FatUtils.getSectorOffset(this.position);
            int sectorLength = 512 - sectorOffset;
            int length = Math.min(sectorLength, outputLength);
            System.arraycopy(this.currentSector, sectorOffset, outputBuffer, outputOffset, length);
            outputLength -= length;
            outputOffset += length;
            this.position += (long)length;
            readLength += length;
        }
        return readLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        int writeLength = 0;
        int inputOffset = 0;
        while (inputLength > 0) {
            int sectorNumber;
            int sectorOffset = FatUtils.getSectorOffset(this.position);
            int sectorLength = 512 - sectorOffset;
            int length = Math.min(sectorLength, inputLength);
            if (length != 512) {
                sectorNumber = FatUtils.getSectorNumber(this.position);
                this.readSector(sectorNumber);
            }
            System.arraycopy(inputPointer.getArray8(inputOffset, length), 0, this.currentSector, sectorOffset, length);
            sectorNumber = FatUtils.getSectorNumber(this.position);
            this.writeSector(sectorNumber);
            inputLength -= length;
            inputOffset += length;
            this.position += (long)length;
            writeLength += length;
        }
        return writeLength;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        return -1;
    }

    @Override
    public long ioLseek(long offset) {
        this.position = offset;
        return this.position;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return -1;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public boolean isSectorBlockMode() {
        return false;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public IVirtualFile duplicate() {
        return null;
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return IoFileMgrForUser.noDelayTimings;
    }

    @Override
    public int ioClose() {
        this.closeCachedFiles();
        this.vfs.ioExit();
        this.vfs = null;
        return 0;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        int clusterNumber;
        int sectorNumber;
        int i;
        stream.readVersion(0);
        this.deviceName = stream.readString();
        this.position = stream.readLong();
        this.totalSectors = stream.readInt();
        this.fatSectors = stream.readInt();
        this.fatClusterMap = stream.readIntsWithLength();
        this.fatFileInfoMap = new FatFileInfo[this.fatClusterMap.length];
        LinkedList<FatFileInfo> fatFileInfoList = new LinkedList<FatFileInfo>();
        while ((i = stream.readInt()) >= 0) {
            int alreadyReadIndex = stream.readInt();
            if (alreadyReadIndex < 0) {
                FatFileInfo fatFileInfo;
                this.fatFileInfoMap[i] = fatFileInfo = new FatFileInfo();
                fatFileInfo.read(stream);
                fatFileInfoList.add(fatFileInfo);
                continue;
            }
            this.fatFileInfoMap[i] = this.fatFileInfoMap[alreadyReadIndex];
        }
        for (FatFileInfo fatFileInfo : fatFileInfoList) {
            fatFileInfo.read(stream, this);
        }
        this.pendingWriteSectors.clear();
        while ((sectorNumber = stream.readInt()) >= 0) {
            byte[] bytes = stream.readBytesWithLength();
            this.pendingWriteSectors.put(sectorNumber, bytes);
        }
        this.pendingDeleteFiles.clear();
        while ((clusterNumber = stream.readInt()) >= 0) {
            FatFileInfo info = this.readFatFileInfo(stream);
            this.pendingDeleteFiles.put(clusterNumber, info);
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeString(this.deviceName);
        stream.writeLong(this.position);
        stream.writeInt(this.totalSectors);
        stream.writeInt(this.fatSectors);
        stream.writeIntsWithLength(this.fatClusterMap);
        HashMap<FatFileInfo, Integer> alreadyWritten = new HashMap<FatFileInfo, Integer>();
        LinkedList<FatFileInfo> fatFileInfoList = new LinkedList<FatFileInfo>();
        for (int i = 0; i < this.fatFileInfoMap.length; ++i) {
            FatFileInfo fatFileInfo = this.fatFileInfoMap[i];
            if (fatFileInfo == null) continue;
            stream.writeInt(i);
            Integer alreadyWrittenIndex = (Integer)alreadyWritten.get(fatFileInfo);
            if (alreadyWrittenIndex != null) {
                stream.writeInt(alreadyWrittenIndex);
                continue;
            }
            stream.writeInt(-1);
            fatFileInfo.write(stream);
            alreadyWritten.put(fatFileInfo, i);
            fatFileInfoList.add(fatFileInfo);
        }
        stream.writeInt(-1);
        for (FatFileInfo fatFileInfo : fatFileInfoList) {
            fatFileInfo.write(stream, this);
        }
        Iterator<Object> iterator = this.pendingWriteSectors.keySet().iterator();
        while (iterator.hasNext()) {
            int sectorNumber = (Integer)iterator.next();
            stream.writeInt(sectorNumber);
            stream.writeBytesWithLength(this.pendingWriteSectors.get(sectorNumber));
        }
        stream.writeInt(-1);
        iterator = this.pendingDeleteFiles.keySet().iterator();
        while (iterator.hasNext()) {
            int clusterNumber = (Integer)iterator.next();
            stream.writeInt(clusterNumber);
            this.writeFatFileInfo(stream, this.pendingDeleteFiles.get(clusterNumber));
        }
        stream.writeInt(-1);
    }

    private int getFatFileInfoMapIndex(FatFileInfo info) {
        if (info != null) {
            for (int i = 0; i < this.fatFileInfoMap.length; ++i) {
                if (info != this.fatFileInfoMap[i]) continue;
                return i;
            }
        }
        return -1;
    }

    private FatFileInfo getFatFileInfoFromMapIndex(int index) {
        if (index < 0 || index >= this.fatFileInfoMap.length) {
            return null;
        }
        return this.fatFileInfoMap[index];
    }

    public FatFileInfo readFatFileInfo(StateInputStream stream) throws IOException {
        int mapIndex = stream.readInt();
        return this.getFatFileInfoFromMapIndex(mapIndex);
    }

    public void writeFatFileInfo(StateOutputStream stream, FatFileInfo info) throws IOException {
        int mapIndex = this.getFatFileInfoMapIndex(info);
        stream.writeInt(mapIndex);
    }

    @Override
    public void invalidateCachedData() {
    }

    @Override
    public void closeCachedFiles() {
        for (FatFileInfo fatFileInfo : this.fatFileInfoMap) {
            if (fatFileInfo == null) continue;
            fatFileInfo.closeVirtualFile();
        }
    }

    public String toString() {
        return String.format("%s%s", this.deviceName == null ? "" : this.deviceName, this.vfs);
    }
}

