/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.Collection;
import java.util.HashMap;
import jpcsp.HLE.kernel.types.SceModule;

public class ModuleManager {
    private int moduleCount;
    private HashMap<Integer, SceModule> moduleNumToModule;
    private HashMap<Integer, SceModule> moduleUidToModule;
    private HashMap<String, SceModule> moduleNameToModule;
    public static final ModuleManager singleton = new ModuleManager();

    public void reset() {
        this.moduleCount = 0;
        this.moduleNumToModule = new HashMap();
        this.moduleUidToModule = new HashMap();
        this.moduleNameToModule = new HashMap();
    }

    public void addModule(SceModule module) {
        ++this.moduleCount;
        this.moduleNumToModule.put(this.moduleCount, module);
        this.moduleUidToModule.put(module.modid, module);
        this.moduleNameToModule.put(module.modname, module);
    }

    public void removeModule(int uid) {
        SceModule sceModule;
        if (this.moduleCount > 0) {
            --this.moduleCount;
        }
        if ((sceModule = this.moduleUidToModule.remove(uid)) != null) {
            this.moduleNameToModule.remove(sceModule.modname);
        }
    }

    public Collection<SceModule> values() {
        return this.moduleUidToModule.values();
    }

    public SceModule getModuleByUID(int uid) {
        return this.moduleUidToModule.get(uid);
    }

    public SceModule getModuleByName(String name) {
        return this.moduleNameToModule.get(name);
    }

    public SceModule getModuleByAddress(int address) {
        for (SceModule module : this.moduleUidToModule.values()) {
            if (address < module.loadAddressLow || address >= module.loadAddressHigh) continue;
            return module;
        }
        return null;
    }

    public int getModuleGpByAddress(int address) {
        SceModule module = this.getModuleByAddress(address);
        if (module == null) {
            return 0;
        }
        return module.gp_value;
    }

    private ModuleManager() {
    }

    static {
        singleton.reset();
    }
}

