/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.managers.ThreadWaitingList;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;

public class SceKernelSemaInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public final int initCount;
    public int currentCount;
    public final int maxCount;
    public final ThreadWaitingList threadWaitingList;
    public final int uid;

    public SceKernelSemaInfo(String name, int attr, int initCount, int maxCount) {
        this.name = name;
        this.attr = attr;
        this.initCount = initCount;
        this.currentCount = initCount;
        this.maxCount = maxCount;
        this.uid = SceUidManager.getNewUid("ThreadMan-sema");
        this.threadWaitingList = ThreadWaitingList.createThreadWaitingList(3, this.uid, attr, 256);
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.initCount);
        this.write32(this.currentCount);
        this.write32(this.maxCount);
        this.write32(this.getNumWaitThreads());
    }

    public int getNumWaitThreads() {
        return this.threadWaitingList.getNumWaitingThreads();
    }

    @Override
    public String toString() {
        return String.format("SceKernelSemaInfo(uid=0x%X, name='%s', attr=0x%X, currentCount=%d, maxCount=%d, numWaitThreads=%d)", this.uid, this.name, this.attr, this.currentCount, this.maxCount, this.getNumWaitThreads());
    }
}

