/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.IOException;
import java.io.RandomAccessFile;
import jpcsp.Emulator;
import jpcsp.filesystems.umdiso.ISectorDevice;
import org.apache.log4j.Logger;

public abstract class AbstractFileSectorDevice
implements ISectorDevice {
    protected static Logger log = Emulator.log;
    protected RandomAccessFile fileAccess;

    public AbstractFileSectorDevice(RandomAccessFile fileAccess) {
        this.fileAccess = fileAccess;
    }

    protected int getNumSectors(long lengthInBytes, int sectorLength) {
        return (int)((lengthInBytes + (long)sectorLength - 1L) / (long)sectorLength);
    }

    @Override
    public int getNumSectors() throws IOException {
        return this.getNumSectors(this.fileAccess.length(), 2048);
    }

    @Override
    public void close() throws IOException {
        this.fileAccess.close();
        this.fileAccess = null;
    }

    @Override
    public int readSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        for (int i = 0; i < numberSectors; ++i) {
            this.readSector(sectorNumber + i, buffer, offset + i * 2048);
        }
        return numberSectors;
    }

    @Override
    public void writeSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        throw new IOException("Device is read-only");
    }

    @Override
    public void writeSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        throw new IOException("Device is read-only");
    }
}

