/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso.iso9660;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Iso9660File {
    private int fileLBA;
    private long fileSize;
    private int fileProperties;
    private String fileName;
    private Date timestamp;
    private static final Charset jolietCharset = Charset.forName("UTF-16BE");
    private static final Charset normalCharset = Charset.forName("US-ASCII");

    private static int Ubyte(byte b) {
        return b & 0xFF;
    }

    public Iso9660File(byte[] data, int length, boolean jolietExtension) throws IOException {
        this.fileLBA = Iso9660File.Ubyte(data[1]) | Iso9660File.Ubyte(data[2]) << 8 | Iso9660File.Ubyte(data[3]) << 16 | data[4] << 24;
        this.fileSize = (long)(Iso9660File.Ubyte(data[9]) | Iso9660File.Ubyte(data[10]) << 8 | Iso9660File.Ubyte(data[11]) << 16) | (long)Iso9660File.Ubyte(data[12]) << 24;
        int year = Iso9660File.Ubyte(data[17]);
        int month = Iso9660File.Ubyte(data[18]);
        int day = Iso9660File.Ubyte(data[19]);
        int hour = Iso9660File.Ubyte(data[20]);
        int minute = Iso9660File.Ubyte(data[21]);
        int second = Iso9660File.Ubyte(data[22]);
        byte gmtOffset = data[23];
        int gmtOffsetHours = gmtOffset / 4;
        int gmtOffsetMinutes = gmtOffset % 4 * 15;
        String timeZoneName = "GMT";
        if (gmtOffset >= 0) {
            timeZoneName = timeZoneName + "+";
        }
        timeZoneName = timeZoneName + gmtOffsetHours;
        if (gmtOffsetMinutes > 0) {
            if (gmtOffsetMinutes < 10) {
                timeZoneName = timeZoneName + "0";
            }
            timeZoneName = timeZoneName + gmtOffsetMinutes;
        }
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneName);
        Calendar timestampCalendar = Calendar.getInstance(timeZone);
        timestampCalendar.set(1900 + year, month - 1, day, hour, minute, second);
        this.timestamp = timestampCalendar.getTime();
        this.fileProperties = data[24];
        if (this.fileLBA < 0 || this.fileSize < 0L) {
            throw new IOException("Invalid ISO, size or lba < 0");
        }
        int fileNameLength = data[31];
        if (jolietExtension) {
            if (fileNameLength == 1) {
                char c = (char)data[32];
                if (c == '\u0000') {
                    c = '.';
                }
                this.fileName = Character.toString(c);
            } else {
                this.fileName = new String(data, 32, fileNameLength, jolietCharset);
                int end = this.fileName.indexOf(59);
                if (end >= 0) {
                    this.fileName = this.fileName.substring(0, end);
                }
            }
        } else {
            for (int i = 0; i < fileNameLength; ++i) {
                if (data[32 + i] != 0) continue;
                data[32 + i] = 46;
            }
            this.fileName = new String(data, 32, fileNameLength, normalCharset);
        }
    }

    public int getLBA() {
        return this.fileLBA;
    }

    public long getSize() {
        return this.fileSize;
    }

    public int getProperties() {
        return this.fileProperties;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.fileName;
    }
}

