/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.util.Utilities;

public class Elf32Header {
    public static final int ELF_MAGIC = 1179403647;
    public static final int E_MACHINE_SPARC = 2;
    public static final int E_MACHINE_x86 = 3;
    public static final int E_MACHINE_MIPS = 8;
    public static final int E_MACHINE_PowerPC = 20;
    public static final int E_MACHINE_ARM = 40;
    public static final int E_MACHINE_SuperH = 42;
    public static final int E_MACHINE_IA_64 = 50;
    public static final int E_MACHINE_x86_64 = 62;
    public static final int E_MACHINE_AArch64 = 183;
    public static final int ET_SCE_PRX = 65440;
    private int e_magic;
    private int e_class;
    private int e_data;
    private int e_idver;
    private byte[] e_pad = new byte[9];
    private int e_type;
    private int e_machine;
    private int e_version;
    private int e_entry;
    private int e_phoff;
    private int e_shoff;
    private int e_flags;
    private int e_ehsize;
    private int e_phentsize;
    private int e_phnum;
    private int e_shentsize;
    private int e_shnum;
    private int e_shstrndx;

    private void read(ByteBuffer f) throws IOException {
        if (f.capacity() == 0) {
            return;
        }
        this.e_magic = Utilities.readUWord(f);
        this.e_class = Utilities.readUByte(f);
        this.e_data = Utilities.readUByte(f);
        this.e_idver = Utilities.readUByte(f);
        f.get(this.getE_pad());
        this.e_type = Utilities.readUHalf(f);
        this.e_machine = Utilities.readUHalf(f);
        this.e_version = Utilities.readUWord(f);
        this.e_entry = Utilities.readUWord(f);
        this.e_phoff = Utilities.readUWord(f);
        this.e_shoff = Utilities.readUWord(f);
        this.e_flags = Utilities.readUWord(f);
        this.e_ehsize = Utilities.readUHalf(f);
        this.e_phentsize = Utilities.readUHalf(f);
        this.e_phnum = Utilities.readUHalf(f);
        this.e_shentsize = Utilities.readUHalf(f);
        this.e_shnum = Utilities.readUHalf(f);
        this.e_shstrndx = Utilities.readUHalf(f);
    }

    public Elf32Header(ByteBuffer f) throws IOException {
        this.read(f);
    }

    public static int sizeof() {
        return 52;
    }

    public boolean isValid() {
        return this.getE_magic() == 1179403647;
    }

    public boolean isMIPSExecutable() {
        return this.getE_machine() == 8;
    }

    public boolean isPRXDetected() {
        return this.getE_type() == 65440;
    }

    public boolean requiresRelocation() {
        return this.isPRXDetected() || this.getE_entry() < 0x8000000;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("-----ELF HEADER---------\n");
        str.append("e_magic \t " + Utilities.formatString("long", Long.toHexString((long)this.getE_magic() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("e_class \t " + Utilities.integerToHex(this.getE_class() & 0xFF) + "\n");
        str.append("e_data \t\t " + Utilities.formatString("byte", Integer.toHexString(this.getE_data() & 0xFF).toUpperCase()) + "\n");
        str.append("e_idver \t " + Utilities.formatString("byte", Integer.toHexString(this.getE_idver() & 0xFF).toUpperCase()) + "\n");
        str.append("e_type \t\t " + Utilities.formatString("short", Integer.toHexString(this.getE_type() & 0xFFFF).toUpperCase()) + "\n");
        str.append("e_machine \t " + Utilities.formatString("short", Integer.toHexString(this.getE_machine() & 0xFFFF).toUpperCase()) + "\n");
        str.append("e_version \t " + Utilities.formatString("long", Long.toHexString((long)this.getE_version() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("e_entry \t " + Utilities.formatString("long", Long.toHexString((long)this.getE_entry() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("e_phoff \t " + Utilities.formatString("long", Long.toHexString((long)this.getE_phoff() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("e_shoff \t " + Utilities.formatString("long", Long.toHexString((long)this.getE_shoff() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("e_flags \t " + Utilities.formatString("long", Long.toHexString((long)this.getE_flags() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("e_ehsize \t " + Utilities.formatString("short", Integer.toHexString(this.getE_ehsize() & 0xFFFF).toUpperCase()) + "\n");
        str.append("e_phentsize \t " + Utilities.formatString("short", Integer.toHexString(this.getE_phentsize() & 0xFFFF).toUpperCase()) + "\n");
        str.append("e_phnum \t " + Utilities.formatString("short", Integer.toHexString(this.getE_phnum() & 0xFFFF).toUpperCase()) + "\n");
        str.append("e_shentsize \t " + Utilities.formatString("short", Integer.toHexString(this.getE_shentsize() & 0xFFFF).toUpperCase()) + "\n");
        str.append("e_shnum \t " + Utilities.formatString("short", Integer.toHexString(this.getE_shnum() & 0xFFFF).toUpperCase()) + "\n");
        str.append("e_shstrndx \t " + Utilities.formatString("short", Integer.toHexString(this.getE_shstrndx() & 0xFFFF).toUpperCase()) + "\n");
        return str.toString();
    }

    public int getE_magic() {
        return this.e_magic;
    }

    public int getE_class() {
        return this.e_class;
    }

    public int getE_data() {
        return this.e_data;
    }

    public int getE_idver() {
        return this.e_idver;
    }

    public byte[] getE_pad() {
        return this.e_pad;
    }

    public int getE_type() {
        return this.e_type;
    }

    public int getE_machine() {
        return this.e_machine;
    }

    public int getE_version() {
        return this.e_version;
    }

    public int getE_entry() {
        return this.e_entry;
    }

    public int getE_phoff() {
        return this.e_phoff;
    }

    public int getE_shoff() {
        return this.e_shoff;
    }

    public int getE_flags() {
        return this.e_flags;
    }

    public int getE_ehsize() {
        return this.e_ehsize;
    }

    public int getE_phentsize() {
        return this.e_phentsize;
    }

    public int getE_phnum() {
        return this.e_phnum;
    }

    public int getE_shentsize() {
        return this.e_shentsize;
    }

    public int getE_shnum() {
        return this.e_shnum;
    }

    public int getE_shstrndx() {
        return this.e_shstrndx;
    }
}

