/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.util.Utilities;

public final class PixelState {
    public int materialAmbient;
    public int materialDiffuse;
    public int materialSpecular;
    public boolean hasNormal;
    private boolean computedV;
    private boolean computedN;
    private boolean computedNormalizedN;
    private boolean computedVe;
    private boolean computedNe;
    private boolean computedNormalizedNe;
    private final float[] V = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] Ve = new float[3];
    private final float[] N = new float[]{0.0f, 0.0f, 1.0f};
    private final float[] normalizedN = new float[]{0.0f, 0.0f, 1.0f};
    private final float[] Ne = new float[]{0.0f, 0.0f, 1.0f};
    private final float[] normalizedNe = new float[]{0.0f, 0.0f, 1.0f};
    public float v1x;
    public float v1y;
    public float v1z;
    public float v2x;
    public float v2y;
    public float v2z;
    public float v3x;
    public float v3y;
    public float v3z;
    public float n1x;
    public float n1y;
    public float n1z;
    public float n2x;
    public float n2y;
    public float n2z;
    public float n3x;
    public float n3y;
    public float n3z;
    public int c1a;
    public int c1b;
    public int c1g;
    public int c1r;
    public int c2a;
    public int c2b;
    public int c2g;
    public int c2r;
    public int c3a;
    public int c3b;
    public int c3g;
    public int c3r;
    public int c3;
    public final float[] textureMatrix = new float[16];
    public final float[] modelViewMatrix = new float[16];
    public final float[] modelViewProjectionMatrix = new float[16];
    public final float[] normalMatrix = new float[16];
    private int numberPixels;
    public float triangleWeight1;
    public float triangleWeight2;
    public float triangleWeight3;

    protected void copy(PixelState from) {
        this.materialAmbient = from.materialAmbient;
        this.materialDiffuse = from.materialDiffuse;
        this.materialSpecular = from.materialSpecular;
        this.hasNormal = from.hasNormal;
        this.v1x = from.v1x;
        this.v1y = from.v1y;
        this.v1z = from.v1z;
        this.v2x = from.v2x;
        this.v2y = from.v2y;
        this.v2z = from.v2z;
        this.v3x = from.v3x;
        this.v3y = from.v3y;
        this.v3z = from.v3z;
        this.n1x = from.n1x;
        this.n1y = from.n1y;
        this.n1z = from.n1z;
        this.n2x = from.n2x;
        this.n2y = from.n2y;
        this.n2z = from.n2z;
        this.n3x = from.n3x;
        this.n3y = from.n3y;
        this.n3z = from.n3z;
        this.c1a = from.c1a;
        this.c1b = from.c1b;
        this.c1g = from.c1g;
        this.c1r = from.c1r;
        this.c2a = from.c2a;
        this.c2b = from.c2b;
        this.c2g = from.c2g;
        this.c2r = from.c2r;
        this.c3a = from.c3a;
        this.c3b = from.c3b;
        this.c3g = from.c3g;
        this.c3r = from.c3r;
        this.c3 = from.c3;
        System.arraycopy(from.textureMatrix, 0, this.textureMatrix, 0, this.textureMatrix.length);
        System.arraycopy(from.modelViewMatrix, 0, this.modelViewMatrix, 0, this.modelViewMatrix.length);
        System.arraycopy(from.modelViewProjectionMatrix, 0, this.modelViewProjectionMatrix, 0, this.modelViewProjectionMatrix.length);
        if (this.hasNormal) {
            System.arraycopy(from.normalMatrix, 0, this.normalMatrix, 0, this.normalMatrix.length);
        }
    }

    public float getTriangleWeightedValue(float value1, float value2, float value3) {
        return this.triangleWeight1 * value1 + this.triangleWeight2 * value2 + this.triangleWeight3 * value3;
    }

    public int getTriangleWeightedValue(int value1, int value2, int value3) {
        return Utilities.round(this.triangleWeight1 * (float)value1 + this.triangleWeight2 * (float)value2 + this.triangleWeight3 * (float)value3);
    }

    public int getTriangleColorWeightedValue() {
        int a = this.getTriangleWeightedValue(this.c1a, this.c2a, this.c3a);
        int b = this.getTriangleWeightedValue(this.c1b, this.c2b, this.c3b);
        int g = this.getTriangleWeightedValue(this.c1g, this.c2g, this.c3g);
        int r = this.getTriangleWeightedValue(this.c1r, this.c2r, this.c3r);
        return PixelColor.getColor(a, b, g, r);
    }

    public boolean isInsideTriangle() {
        float limit = -1.0E-5f;
        return this.triangleWeight1 >= -1.0E-5f && this.triangleWeight2 >= -1.0E-5f && this.triangleWeight3 >= -1.0E-5f;
    }

    public void newPixel2D() {
        ++this.numberPixels;
    }

    public void newPixel3D() {
        this.newPixel2D();
        this.computedV = false;
        this.computedN = false;
        this.computedNormalizedN = false;
        this.computedVe = false;
        this.computedNe = false;
        this.computedNormalizedNe = false;
    }

    public void reset() {
        this.numberPixels = 0;
    }

    public int getNumberPixels() {
        return this.numberPixels;
    }

    private void computeV() {
        if (!this.computedV) {
            this.V[0] = this.getTriangleWeightedValue(this.v1x, this.v2x, this.v3x);
            this.V[1] = this.getTriangleWeightedValue(this.v1y, this.v2y, this.v3y);
            this.V[2] = this.getTriangleWeightedValue(this.v1z, this.v2z, this.v3z);
            this.computedV = true;
        }
    }

    public float[] getV() {
        this.computeV();
        return this.V;
    }

    public void getV(float[] V) {
        this.computeV();
        V[0] = this.V[0];
        V[1] = this.V[1];
        V[2] = this.V[2];
    }

    private void computeN() {
        if (!this.computedN && this.hasNormal) {
            this.N[0] = this.getTriangleWeightedValue(this.n1x, this.n2x, this.n3x);
            this.N[1] = this.getTriangleWeightedValue(this.n1y, this.n2y, this.n3y);
            this.N[2] = this.getTriangleWeightedValue(this.n1z, this.n2z, this.n3z);
            this.computedN = true;
        }
    }

    public float[] getN() {
        this.computeN();
        return this.N;
    }

    public void getN(float[] N) {
        this.computeN();
        N[0] = this.N[0];
        N[1] = this.N[1];
        N[2] = this.N[2];
    }

    private void computeNormalizedN() {
        if (!this.computedNormalizedN && this.hasNormal) {
            this.computeN();
            Utilities.normalize3(this.normalizedN, this.N);
            this.computedNormalizedN = true;
        }
    }

    public float[] getNormalizedN() {
        this.computeNormalizedN();
        return this.normalizedN;
    }

    public void getNormalizedN(float[] normalizedN) {
        this.computeNormalizedN();
        normalizedN[0] = this.normalizedN[0];
        normalizedN[1] = this.normalizedN[1];
        normalizedN[2] = this.normalizedN[2];
    }

    private void computeVe() {
        if (!this.computedVe) {
            this.computeV();
            Utilities.vectorMult34(this.Ve, this.modelViewMatrix, this.V);
            this.computedVe = true;
        }
    }

    public void getVe(float[] Ve) {
        this.computeVe();
        Ve[0] = this.Ve[0];
        Ve[1] = this.Ve[1];
        Ve[2] = this.Ve[2];
    }

    private void computeNe() {
        if (!this.computedNe && this.hasNormal) {
            this.computeN();
            Utilities.vectorMult33(this.Ne, this.normalMatrix, this.N);
            this.computedNe = true;
        }
    }

    public void getNe(float[] Ne) {
        this.computeNe();
        Ne[0] = this.Ne[0];
        Ne[1] = this.Ne[1];
        Ne[2] = this.Ne[2];
    }

    private void computeNormalizedNe() {
        if (!this.computedNormalizedNe && this.hasNormal) {
            this.computeNe();
            Utilities.normalize3(this.normalizedNe, this.Ne);
            this.computedNormalizedNe = true;
        }
    }

    public void getNormalizedNe(float[] normalizedNe) {
        this.computeNormalizedNe();
        normalizedNe[0] = this.normalizedNe[0];
        normalizedNe[1] = this.normalizedNe[1];
        normalizedNe[2] = this.normalizedNe[2];
    }
}

