/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.aac;

import jpcsp.media.codec.util.IBitReader;

public class AACADTSHeaderInfo {
    int sampleRate;
    int samples;
    int bitRate;
    boolean crcAbsent;
    int objectType;
    int samplingIndex;
    int chanConfig;
    int numAacFrames;
    private static final int AAC_ADTS_HEADER_SIZE = 7;
    private static final int[] mpeg4audioSampleRates = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, 0, 0, 0};

    public int parse(IBitReader br) {
        if (br.read(12) != 4095) {
            return -4;
        }
        br.skip(1);
        br.skip(2);
        boolean crcAbs = br.readBool();
        int aot = br.read(2);
        int sr = br.read(4);
        if (mpeg4audioSampleRates[sr] == 0) {
            return -4;
        }
        br.skip(1);
        int ch = br.read(3);
        br.skip(1);
        br.skip(1);
        br.skip(1);
        br.skip(1);
        int size = br.read(13);
        if (size < 7) {
            return -4;
        }
        br.skip(11);
        int rdb = br.read(2);
        this.objectType = aot + 1;
        this.chanConfig = ch;
        this.crcAbsent = crcAbs;
        this.numAacFrames = rdb + 1;
        this.samplingIndex = sr;
        this.sampleRate = mpeg4audioSampleRates[sr];
        this.samples = (rdb + 1) * 1024;
        this.bitRate = size * 8 * this.sampleRate / this.samples;
        return size;
    }
}

