/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.util;

public class FloatDSP {
    public static void vectorFmul(float[] dst, int dstOffset, float[] src0, int src0Offset, float[] src1, int src1Offset, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOffset + i] = src0[src0Offset + i] * src1[src1Offset + i];
        }
    }

    public static void vectorFmacScalar(float[] dst, int dstOffset, float[] src, int srcOffset, float mul, int len) {
        for (int i = 0; i < len; ++i) {
            int n = dstOffset + i;
            dst[n] = dst[n] + src[srcOffset + i] * mul;
        }
    }

    public static void vectorFmulScalar(float[] dst, int dstOffset, float[] src, int srcOffset, float mul, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOffset + i] = src[srcOffset + i] * mul;
        }
    }

    public static void vectorDmulScalar(double[] dst, int dstOffset, double[] src, int srcOffset, double mul, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOffset + i] = src[srcOffset + i] * mul;
        }
    }

    public static void vectorFmulWindow(float[] dst, int dstOffset, float[] src0, int src0Offset, float[] src1, int src1Offset, float[] win, int winOffset, int len) {
        dstOffset += len;
        winOffset += len;
        src0Offset += len;
        int i = -len;
        int j = len - 1;
        while (i < 0) {
            float s0 = src0[src0Offset + i];
            float s1 = src1[src1Offset + j];
            float wi = win[winOffset + i];
            float wj = win[winOffset + j];
            dst[dstOffset + i] = s0 * wj - s1 * wi;
            dst[dstOffset + j] = s0 * wi + s1 * wj;
            ++i;
            --j;
        }
    }

    public static void vectorFmulAdd(float[] dst, int dstOffset, float[] src0, int src0Offset, float[] src1, int src1Offset, float[] src2, int src2Offset, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOffset + i] = src0[src0Offset + i] * src1[src1Offset + i] + src2[src2Offset + i];
        }
    }

    public static void vectorFmulReverse(float[] dst, int dstOffset, float[] src0, int src0Offset, float[] src1, int src1Offset, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOffset + i] = src0[src0Offset + i] * src1[src1Offset + len - 1 - i];
        }
    }

    public static void butterflies(float[] v1, int v1Offset, float[] v2, int v2Offset, int len) {
        for (int i = 0; i < len; ++i) {
            float t = v1[v1Offset + i] - v2[v2Offset + i];
            int n = v1Offset + i;
            v1[n] = v1[n] + v2[v2Offset + i];
            v2[v2Offset + i] = t;
        }
    }

    public static float scalarproduct(float[] v1, int v1Offset, float[] v2, int v2Offset, int len) {
        float p = 0.0f;
        for (int i = 0; i < len; ++i) {
            p += v1[v1Offset + i] * v2[v2Offset + i];
        }
        return p;
    }
}

