/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.scheduler.Scheduler;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerDisplayController
extends MMIOHandlerBase {
    public static Logger log = sceDisplay.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1099694080;
    private static MMIOHandlerDisplayController instance;
    private long baseTimeMicros;
    private static final int displaySyncMicros = 16667;
    private static final int numberDisplayRows = 286;
    private static final int rowSyncMicros = 58;
    private TriggerVblankInterruptAction triggerVblankInterruptAction;
    private long triggerVblankInterruptSchedule;
    private static int maxVblankInterrupts;

    public static MMIOHandlerDisplayController getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerDisplayController(-1099694080);
        }
        return instance;
    }

    private MMIOHandlerDisplayController(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        maxVblankInterrupts = stream.readInt();
        this.baseTimeMicros = Scheduler.getNow() - stream.readLong();
        super.read(stream);
        this.triggerVblankInterruptSchedule = 0L;
        this.triggerVblankInterruptAction = null;
        this.startVblankInterrupts();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(maxVblankInterrupts);
        stream.writeLong(this.getTimeMicros());
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        maxVblankInterrupts = 0;
        this.baseTimeMicros = Scheduler.getNow();
    }

    private long getTimeMicros() {
        return Scheduler.getNow() - this.baseTimeMicros;
    }

    private int getDisplayRowSync(long time) {
        return this.getDisplaySync(time) + ((int)(time / 58L) + 1) % 286;
    }

    private int getDisplaySync(long time) {
        return (int)(time / 16667L) * 286;
    }

    private long getPreviousVblankSchedule() {
        return this.getTimeMicros() / 16667L * 16667L + this.baseTimeMicros;
    }

    private long getNextVblankSchedule() {
        return this.getPreviousVblankSchedule() + 16667L;
    }

    public static void setMaxVblankInterrupts(int maxVblankInterrupts) {
        MMIOHandlerDisplayController.maxVblankInterrupts = maxVblankInterrupts;
    }

    private void scheduleNextVblankInterrupt() {
        long schedule;
        if (maxVblankInterrupts == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Skipping Vblank interrupt %s", this));
            }
            return;
        }
        if (maxVblankInterrupts > 0) {
            --maxVblankInterrupts;
        }
        if ((schedule = this.getNextVblankSchedule()) != this.triggerVblankInterruptSchedule) {
            Scheduler scheduler = Emulator.getScheduler();
            if (this.triggerVblankInterruptSchedule != 0L) {
                scheduler.removeAction(this.triggerVblankInterruptSchedule, this.triggerVblankInterruptAction);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Scheduling next Vblank at 0x%X, %s", schedule, this));
            }
            this.triggerVblankInterruptSchedule = schedule;
            scheduler.addAction(this.triggerVblankInterruptSchedule, this.triggerVblankInterruptAction);
        }
    }

    public void triggerVblankInterrupt() {
        this.scheduleNextVblankInterrupt();
        RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 30);
    }

    private void startVblankInterrupts() {
        if (this.triggerVblankInterruptAction == null) {
            this.triggerVblankInterruptAction = new TriggerVblankInterruptAction();
            this.triggerVblankInterruptSchedule = 0L;
            this.scheduleNextVblankInterrupt();
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 4: {
                value = this.getDisplayRowSync(this.getTimeMicros());
                break;
            }
            case 8: {
                value = this.getDisplaySync(this.getTimeMicros());
                break;
            }
            case 32: {
                value = 0;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                break;
            }
            case 4: {
                this.baseTimeMicros = Scheduler.getNow();
                this.startVblankInterrupts();
                break;
            }
            case 12: {
                break;
            }
            case 16: {
                break;
            }
            case 20: {
                break;
            }
            case 36: {
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("MMIOHandlerDisplayController rowSync=0x%X, displaySync=0x%X, baseTime=0x%X, now=0x%X", this.getDisplayRowSync(this.getTimeMicros()), this.getDisplaySync(this.getTimeMicros()), this.baseTimeMicros, Scheduler.getNow());
    }

    static {
        maxVblankInterrupts = 0;
    }

    private class TriggerVblankInterruptAction
    implements IAction {
        private TriggerVblankInterruptAction() {
        }

        @Override
        public void execute() {
            MMIOHandlerDisplayController.this.triggerVblankInterruptSchedule = 0L;
            MMIOHandlerDisplayController.this.triggerVblankInterrupt();
        }
    }
}

