/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.memory.FastMemory;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class MMIOHandlerReadWrite
extends MMIOHandlerBase {
    private static final int STATE_VERSION = 0;
    private final int[] memory;

    public MMIOHandlerReadWrite(int baseAddress, int length) {
        super(baseAddress);
        this.memory = new int[length >> 2];
    }

    public MMIOHandlerReadWrite(int baseAddress, int length, int[] memory) {
        super(baseAddress);
        this.memory = memory;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.memory);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.memory);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.memory, 0);
    }

    public int[] getInternalMemory() {
        return this.memory;
    }

    @Override
    public int read32(int address) {
        int data = this.internalRead32(address);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read32(0x%08X)=0x%08X", this.getPc(), address, data));
        }
        return data;
    }

    @Override
    public int read16(int address) {
        int data = this.internalRead16(address);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read16(0x%08X)=0x%04X", this.getPc(), address, data));
        }
        return data;
    }

    @Override
    public int read8(int address) {
        int data = this.internalRead8(address);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read8(0x%08X)=0x%02X", this.getPc(), address, data));
        }
        return data;
    }

    @Override
    public int internalRead8(int address) {
        return this.memory[address - this.baseAddress >> 2] >> FastMemory.memory8Shift[address & 3] & 0xFF;
    }

    @Override
    public int internalRead16(int address) {
        return this.memory[address - this.baseAddress >> 2] >> FastMemory.memory16Shift[address & 2] & 0xFFFF;
    }

    @Override
    public int internalRead32(int address) {
        return this.memory[address - this.baseAddress >> 2];
    }

    @Override
    public void write32(int address, int value) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X)", this.getPc(), address, value));
        }
        this.memory[address - this.baseAddress >> 2] = value;
    }

    @Override
    public void write16(int address, short value) {
        int memData;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write16(0x%08X, 0x%04X)", this.getPc(), address, value & 0xFFFF));
        }
        int index = address & 2;
        this.memory[address - this.baseAddress >> 2] = memData = this.memory[address - this.baseAddress >> 2] & FastMemory.memory16Mask[index] | (value & 0xFFFF) << FastMemory.memory16Shift[index];
    }

    @Override
    public void write8(int address, byte value) {
        int memData;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write8(0x%08X, 0x%02X)", this.getPc(), address, value & 0xFF));
        }
        int index = address & 3;
        this.memory[address - this.baseAddress >> 2] = memData = this.memory[address - this.baseAddress >> 2] & FastMemory.memory8Mask[index] | (value & 0xFF) << FastMemory.memory8Shift[index];
    }
}

