/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import jpcsp.memory.mmio.MMIOHandlerAudio;
import jpcsp.sound.SoundBufferManager;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

public class AudioLine
implements IState {
    public static Logger log = MMIOHandlerAudio.log;
    private static final int STATE_VERSION = 0;
    private final SoundBufferManager soundBufferManager;
    private final int alSource;
    private int frequency = 44100;
    private int waitingBufferSamples;
    private final Map<Integer, Integer> waitingBufferSizes = new HashMap<Integer, Integer>();

    public AudioLine() {
        AudioLine.initOpenAL();
        this.soundBufferManager = SoundBufferManager.getInstance();
        this.alSource = AL10.alGenSources();
        AL10.alSourcei((int)this.alSource, (int)4103, (int)0);
    }

    private static void initOpenAL() {
        if (!AL.isCreated()) {
            try {
                AL.create();
            }
            catch (LWJGLException e) {
                log.error((Object)e);
            }
        }
    }

    private void alSourcePlay() {
        int state = AL10.alGetSourcei((int)this.alSource, (int)4112);
        if (state != 4114) {
            AL10.alSourcePlay((int)this.alSource);
        }
    }

    private void checkFreeBuffers() {
        int alBuffer;
        while ((alBuffer = this.soundBufferManager.checkFreeBuffer(this.alSource)) >= 0) {
            Integer bufferSizeInSamples = this.waitingBufferSizes.get(alBuffer);
            if (bufferSizeInSamples == null) continue;
            this.waitingBufferSamples -= bufferSizeInSamples.intValue();
            if (this.waitingBufferSamples >= 0) continue;
            this.waitingBufferSamples = 0;
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("AudioLine frequency=0x%X", frequency));
        }
    }

    public void setVolume(int volume) {
        float gain = (float)volume / 32768.0f;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("AudioLine volume=0x%X, gain=%f", volume, Float.valueOf(gain)));
        }
        AL10.alSourcef((int)this.alSource, (int)4106, (float)gain);
    }

    public void writeAudioData(int[] data, int offset, int length) {
        int audioBytesLength = length * 4;
        ByteBuffer directBuffer = this.soundBufferManager.getDirectBuffer(audioBytesLength);
        directBuffer.order(ByteOrder.LITTLE_ENDIAN);
        directBuffer.clear();
        directBuffer.limit(audioBytesLength);
        directBuffer.asIntBuffer().put(data, offset, length);
        directBuffer.rewind();
        int alBuffer = this.soundBufferManager.getBuffer();
        this.waitingBufferSizes.put(alBuffer, length);
        this.waitingBufferSamples += length;
        AL10.alBufferData((int)alBuffer, (int)4355, (ByteBuffer)directBuffer, (int)this.frequency);
        AL10.alSourceQueueBuffers((int)this.alSource, (int)alBuffer);
        this.soundBufferManager.releaseDirectBuffer(directBuffer);
        this.alSourcePlay();
        this.poll();
    }

    public void poll() {
        this.checkFreeBuffers();
    }

    public int getWaitingBuffers() {
        this.checkFreeBuffers();
        return AL10.alGetSourcei((int)this.alSource, (int)4117) - AL10.alGetSourcei((int)this.alSource, (int)4118);
    }

    public int getWaitingBufferSamples() {
        this.checkFreeBuffers();
        return this.waitingBufferSamples;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.frequency = stream.readInt();
        this.waitingBufferSamples = 0;
        this.waitingBufferSizes.clear();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.frequency);
    }
}

