/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.cy27040;

import java.io.IOException;
import jpcsp.memory.mmio.MMIOHandlerAudio;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class CY27040
implements IState {
    public static Logger log = Logger.getLogger((String)"CY27040");
    private static final int STATE_VERSION = 0;
    private static CY27040 instance;
    public static final int PSP_CLOCK_AUDIO_FREQ = 1;
    public static final int PSP_CLOCK_LEPTON = 8;
    public static final int PSP_CLOCK_AUDIO = 16;
    private int revision;
    private int clock;
    private int spreadSpectrum;

    public static CY27040 getInstance() {
        if (instance == null) {
            instance = new CY27040();
        }
        return instance;
    }

    private CY27040() {
        this.resetInternally();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.revision = stream.readInt();
        this.clock = stream.readInt();
        this.spreadSpectrum = stream.readInt();
        this.updateAudioFrequency();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.revision);
        stream.writeInt(this.clock);
        stream.writeInt(this.spreadSpectrum);
    }

    private void updateAudioFrequency() {
        MMIOHandlerAudio.getInstance().updateAudioFrequency();
    }

    public void reset() {
        this.resetInternally();
        this.updateAudioFrequency();
    }

    private void resetInternally() {
        this.revision = 4;
        this.clock = 0;
        this.spreadSpectrum = 0;
    }

    public void executeTransmitReceiveCommand(int[] transmitData, int[] receiveData) {
        int command = transmitData[0] & 0xFF;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("executeTransmitReceiveCommand command=0x%02X on %s", command, this));
        }
        switch (command) {
            case 0: {
                receiveData[0] = 3;
                receiveData[1] = this.revision;
                receiveData[2] = this.clock;
                receiveData[3] = this.spreadSpectrum;
                break;
            }
            case 128: {
                receiveData[0] = this.revision;
                break;
            }
            case 129: {
                receiveData[0] = this.clock;
                break;
            }
            case 130: {
                receiveData[0] = this.spreadSpectrum;
                break;
            }
            default: {
                log.error((Object)String.format("executeTransmitReceiveCommand unknown command 0x%X", command));
            }
        }
    }

    public void executeTransmitCommand(int[] transmitData) {
        int command = transmitData[0] & 0xFF;
        switch (command) {
            case 128: {
                this.revision = transmitData[1] & 0xFF;
                break;
            }
            case 129: {
                this.clock = transmitData[1] & 0xFF;
                this.updateAudioFrequency();
                break;
            }
            case 130: {
                this.spreadSpectrum = transmitData[1] & 0xFF;
                break;
            }
            default: {
                log.error((Object)String.format("executeTransmitCommand unknown command 0x%X", command));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("executeTransmitCommand command=0x%02X on %s", command, this));
        }
    }

    public int getAudioFreq() {
        return (this.clock & 1) == 0 ? 44100 : 48000;
    }

    private boolean isAudioEnabled() {
        return (this.clock & 0x10) != 0;
    }

    private boolean isLeptonEnabled() {
        return (this.clock & 8) != 0;
    }

    private String toString(boolean enabled) {
        return enabled ? "enabled" : "disabled";
    }

    private String toStringClock() {
        return String.format("%d, audio %s, lepton %s", this.getAudioFreq(), this.toString(this.isAudioEnabled()), this.toString(this.isLeptonEnabled()));
    }

    public String toString() {
        return String.format("CY27040 revision=0x%02X, clock=0x%02X(%s), spreadSpectrum=0x%02X", this.revision, this.clock, this.toStringClock(), this.spreadSpectrum);
    }
}

