/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.jpcsp;

import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNet;
import jpcsp.Memory;
import jpcsp.network.BaseNetworkAdapter;
import jpcsp.network.adhoc.AdhocMatchingEventMessage;
import jpcsp.network.adhoc.MatchingObject;

public class JpcspAdhocMatchingBirthEventMessage
extends AdhocMatchingEventMessage {
    protected byte[] birthMacAddress;

    public JpcspAdhocMatchingBirthEventMessage(MatchingObject matchingObject, byte[] toMacAddress, byte[] birthMacAddress) {
        super(matchingObject, 101, 0, 0, toMacAddress);
        this.birthMacAddress = new byte[6];
        this.setBirthMacAddress(birthMacAddress);
    }

    public JpcspAdhocMatchingBirthEventMessage(MatchingObject matchingObject, byte[] message, int length) {
        super(matchingObject, message, length);
    }

    public byte[] getBirthMacAddress() {
        return this.birthMacAddress;
    }

    public void setBirthMacAddress(byte[] birthMacAddress) {
        System.arraycopy(birthMacAddress, 0, this.birthMacAddress, 0, this.birthMacAddress.length);
    }

    @Override
    public byte[] getMessage() {
        byte[] message = new byte[this.getMessageLength()];
        this.offset = 0;
        this.addInt32ToBytes(message, this.getId());
        this.addToBytes(message, this.fromMacAddress);
        this.addToBytes(message, this.toMacAddress);
        this.addToBytes(message, (byte)this.getEvent());
        this.addToBytes(message, this.birthMacAddress);
        return message;
    }

    @Override
    public void setMessage(byte[] message, int length) {
        if (length >= this.getMessageLength()) {
            this.offset = 0;
            this.setId(this.copyInt32FromBytes(message));
            this.copyFromBytes(message, this.fromMacAddress);
            this.copyFromBytes(message, this.toMacAddress);
            this.setEvent(this.copyByteFromBytes(message));
            this.birthMacAddress = new byte[6];
            this.copyFromBytes(message, this.birthMacAddress);
        }
    }

    @Override
    public int getMessageLength() {
        return 23;
    }

    @Override
    public void processOnReceive(int macAddr, int optData, int optLen) {
        pspNetMacAddress fromMacAddress = new pspNetMacAddress();
        fromMacAddress.read(Memory.getInstance(), macAddr);
        if (BaseNetworkAdapter.log.isDebugEnabled()) {
            BaseNetworkAdapter.log.debug((Object)String.format("MatchingPacketBirth.processOnReceive fromMacAddress=%s, optData=0x%08X, optLen=0x%X, macAddress=%s", fromMacAddress, optData, optLen, new pspNetMacAddress(this.birthMacAddress)));
        }
        this.getMatchingObject().addMember(this.birthMacAddress);
        super.processOnReceive(macAddr, optData, optLen);
    }

    @Override
    public String toString() {
        return String.format("%s[id=0x%X, fromMacAddress=%s, toMacAddress=%s, birthMacAddress=%s]", this.getClass().getSimpleName(), this.getId(), sceNet.convertMacAddressToString(this.fromMacAddress), sceNet.convertMacAddressToString(this.toMacAddress), sceNet.convertMacAddressToString(this.birthMacAddress));
    }
}

