/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Emulator;
import jpcsp.GUI.ChatGUI;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNet;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.hardware.Wlan;
import jpcsp.network.BaseNetworkAdapter;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.AdhocMatchingEventMessage;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocSocket;
import jpcsp.network.adhoc.MatchingObject;
import jpcsp.network.adhoc.PdpObject;
import jpcsp.network.adhoc.PtpObject;
import jpcsp.network.proonline.MacIp;
import jpcsp.network.proonline.MatchingPacketFactory;
import jpcsp.network.proonline.PacketFactory;
import jpcsp.network.proonline.PortManager;
import jpcsp.network.proonline.ProOnlineAdhocDatagramSocket;
import jpcsp.network.proonline.ProOnlineAdhocGameModeMessage;
import jpcsp.network.proonline.ProOnlineAdhocMessage;
import jpcsp.network.proonline.ProOnlineMatchingObject;
import jpcsp.network.proonline.ProOnlinePdpObject;
import jpcsp.network.proonline.ProOnlinePtpObject;
import jpcsp.network.upnp.UPnP;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.AbstractIntSettingsListener;
import jpcsp.settings.AbstractStringSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ProOnlineNetworkAdapter
extends BaseNetworkAdapter {
    protected static Logger log = Logger.getLogger((String)"ProOnline");
    private static boolean enabled = false;
    private UPnP upnp;
    private Socket metaSocket;
    private static int metaPort = 27312;
    private static String metaServer = "coldbird.net";
    private static final int pingTimeoutMillis = 2000;
    private volatile boolean exit;
    private volatile boolean friendFinderActive;
    private List<MacIp> macIps = new LinkedList<MacIp>();
    private PacketFactory packetFactory = new PacketFactory();
    private PortManager portManager;
    private InetAddress broadcastInetAddress;
    private InetAddress loopbackInetAddress;
    private InetAddress localHostInetAddress;
    private ChatGUI chatGUI;
    private boolean connectComplete;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        ProOnlineNetworkAdapter.enabled = enabled;
        if (enabled) {
            log.info((Object)"Enabling ProOnline network");
        }
    }

    public static String getMetaServer() {
        return metaServer;
    }

    @Override
    public void start() {
        super.start();
        log.info((Object)String.format("ProOnline start, server %s:%d", metaServer, metaPort));
        try {
            this.broadcastInetAddress = InetAddress.getByAddress(new byte[]{1, 1, 1, 1});
        }
        catch (UnknownHostException e) {
            log.error((Object)"Unable to set the broadcast address", (Throwable)e);
        }
        try {
            this.loopbackInetAddress = InetAddress.getByName("localhost");
        }
        catch (UnknownHostException e) {
            log.error((Object)"Unable to set the loopback address", (Throwable)e);
        }
        try {
            this.localHostInetAddress = InetAddress.getByName(sceNetApctl.getLocalHostIP());
        }
        catch (UnknownHostException e) {
            log.error((Object)"Unable to set the local address", (Throwable)e);
        }
        this.upnp = new UPnP();
        this.upnp.discoverInBackground();
    }

    @Override
    public void stop() {
        this.upnp.stop();
        super.stop();
    }

    protected void sendToMetaServer(PacketFactory.SceNetAdhocctlPacketBaseC2S packet) throws IOException {
        if (this.metaSocket != null) {
            this.metaSocket.getOutputStream().write(packet.getBytes());
            this.metaSocket.getOutputStream().flush();
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Sent packet to meta server: %s", packet));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Message not sent to meta server because not connected: %s", packet));
        }
    }

    protected void safeSendToMetaServer(PacketFactory.SceNetAdhocctlPacketBaseC2S packet) {
        try {
            this.sendToMetaServer(packet);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void openChat() {
        if (this.chatGUI == null || !this.chatGUI.isVisible()) {
            this.chatGUI = new ChatGUI();
            Emulator.getMainGUI().startBackgroundWindowDialog(this.chatGUI);
            this.chatGUI.updateMembers(Modules.sceNetAdhocctlModule.getPeersNickName());
        }
    }

    private void closeChat() {
        if (this.chatGUI != null) {
            this.chatGUI.dispose();
            this.chatGUI = null;
        }
    }

    private void waitForFriendFinderToExit() {
        while (this.friendFinderActive && this.exit) {
            Utilities.sleep(1, 0);
        }
    }

    @Override
    public void sceNetAdhocctlInit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceNetAdhocctlInit");
        }
        this.waitForFriendFinderToExit();
        this.terminatePortManager();
        this.closeConnectionToMetaServer();
        this.connectToMetaServer();
        this.exit = false;
        this.portManager = new PortManager(this.upnp);
        if (this.metaSocket != null) {
            FriendFinder friendFinderThread = new FriendFinder();
            friendFinderThread.setName("ProOnline Friend Finder");
            friendFinderThread.setDaemon(true);
            friendFinderThread.start();
        }
    }

    @Override
    public void sceNetAdhocctlConnect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceNetAdhocctlConnect redirecting to sceNetAdhocctlCreate");
        }
        this.sceNetAdhocctlCreate();
    }

    @Override
    public void sceNetAdhocctlCreate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceNetAdhocctlCreate");
        }
        try {
            this.sendToMetaServer(new PacketFactory.SceNetAdhocctlConnectPacketC2S(this));
            this.openChat();
        }
        catch (IOException e) {
            log.error((Object)"sceNetAdhocctlCreate", (Throwable)e);
        }
    }

    @Override
    public void sceNetAdhocctlJoin() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceNetAdhocctlJoin redirecting to sceNetAdhocctlCreate");
        }
        this.sceNetAdhocctlCreate();
    }

    @Override
    public void sceNetAdhocctlDisconnect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceNetAdhocctlDisconnect");
        }
        try {
            this.sendToMetaServer(new PacketFactory.SceNetAdhocctlDisconnectPacketC2S(this));
            this.setConnectComplete(false);
            this.deleteAllFriends();
            this.closeChat();
        }
        catch (IOException e) {
            log.error((Object)"sceNetAdhocctlDisconnect", (Throwable)e);
        }
    }

    @Override
    public void sceNetAdhocctlTerm() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceNetAdhocctlTerm");
        }
        this.exit = true;
        this.terminatePortManager();
    }

    @Override
    public void sceNetAdhocctlScan() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceNetAdhocctlScan");
        }
        try {
            this.sendToMetaServer(new PacketFactory.SceNetAdhocctlScanPacketC2S(this));
        }
        catch (IOException e) {
            log.error((Object)"sceNetAdhocctlScan", (Throwable)e);
        }
    }

    public void sceNetPortOpen(String protocol, int port) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetPortOpen %s, port=%d", protocol, port));
        }
        this.portManager.addPort(port, protocol);
    }

    public void sceNetPortClose(String protocol, int port) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetPortClose %s, port=%d", protocol, port));
        }
        this.portManager.removePort(port, protocol);
    }

    private void connectToMetaServer() {
        this.metaSocket = null;
        try {
            this.metaSocket = new Socket(metaServer, metaPort, Wlan.getLocalInetAddress(), 0);
        }
        catch (UnknownHostException e) {
            log.error((Object)String.format("Could not connect to meta server %s:%d", metaServer, metaPort), (Throwable)e);
        }
        catch (IOException e) {
            try {
                this.metaSocket = new Socket(metaServer, metaPort);
            }
            catch (IOException ee) {
                log.error((Object)String.format("Could not connect to meta server %s:%d", metaServer, metaPort), (Throwable)e);
            }
        }
        if (this.metaSocket != null) {
            try {
                this.metaSocket.setReuseAddress(true);
                this.metaSocket.setSoTimeout(500);
                PacketFactory.SceNetAdhocctlLoginPacketC2S loginPacket = new PacketFactory.SceNetAdhocctlLoginPacketC2S(this);
                this.sendToMetaServer(loginPacket);
            }
            catch (IOException e) {
                log.error((Object)String.format("Could not connect to meta server %s:%d", metaServer, metaPort), (Throwable)e);
            }
        }
    }

    private void terminatePortManager() {
        if (this.portManager != null) {
            this.portManager.clear();
            this.portManager = null;
        }
    }

    private void closeConnectionToMetaServer() {
        if (this.metaSocket != null) {
            try {
                this.metaSocket.close();
            }
            catch (IOException e) {
                log.error((Object)"friendFinder", (Throwable)e);
            }
            this.metaSocket = null;
        }
    }

    protected void friendFinder() {
        long lastPing = Emulator.getClock().currentTimeMillis();
        byte[] buffer = new byte[1024];
        int offset = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting friendFinder");
        }
        this.friendFinderActive = true;
        while (!this.exit) {
            long now = Emulator.getClock().currentTimeMillis();
            if (now - lastPing >= 2000L) {
                lastPing = now;
                this.safeSendToMetaServer(new PacketFactory.SceNetAdhocctlPingPacketC2S(this));
            }
            try {
                int length = this.metaSocket.getInputStream().read(buffer, offset, buffer.length - offset);
                if (length > 0) {
                    offset += length;
                } else if (length < 0) {
                    this.closeConnectionToMetaServer();
                    this.connectToMetaServer();
                }
            }
            catch (SocketTimeoutException length) {
            }
            catch (IOException e) {
                log.error((Object)"friendFinder", (Throwable)e);
            }
            if (offset <= 0) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Received from meta server: OPCODE %d", buffer[0]));
            }
            int consumed = 0;
            PacketFactory.SceNetAdhocctlPacketBaseS2C packet = this.packetFactory.createPacketS2C(this, buffer, offset);
            if (packet == null) {
                consumed = 1;
            } else if (offset >= packet.getLength()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Incoming server packet %s", packet));
                }
                packet.process();
                consumed = packet.getLength();
            }
            if (consumed <= 0) continue;
            System.arraycopy(buffer, consumed, buffer, 0, offset - consumed);
            offset -= consumed;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exiting friendFinder");
        }
        try {
            this.sendToMetaServer(new PacketFactory.SceNetAdhocctlDisconnectPacketC2S(this));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeConnectionToMetaServer();
        this.exit = false;
        this.friendFinderActive = false;
    }

    public static String convertIpToString(int ip) {
        return String.format("%d.%d.%d.%d", ip & 0xFF, ip >> 8 & 0xFF, ip >> 16 & 0xFF, ip >> 24 & 0xFF);
    }

    protected synchronized void addFriend(String nickName, pspNetMacAddress mac, int ip) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Adding friend nickName='%s', mac=%s, ip=%s", nickName, mac, ProOnlineNetworkAdapter.convertIpToString(ip)));
        }
        Modules.sceNetAdhocctlModule.hleNetAdhocctlAddPeer(nickName, mac);
        if (this.chatGUI != null) {
            this.chatGUI.updateMembers(Modules.sceNetAdhocctlModule.getPeersNickName());
        }
        boolean found = false;
        for (MacIp macIp : this.macIps) {
            if (!mac.equals(macIp.mac)) continue;
            macIp.setIp(ip);
            found = true;
            break;
        }
        if (!found) {
            MacIp macIp = new MacIp(mac.macAddress, ip);
            this.macIps.add(macIp);
            this.portManager.addHost(ProOnlineNetworkAdapter.convertIpToString(ip));
        }
    }

    protected synchronized void deleteFriend(int ip) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting friend ip=%s", ProOnlineNetworkAdapter.convertIpToString(ip)));
        }
        for (MacIp macIp : this.macIps) {
            if (macIp.ip != ip) continue;
            this.macIps.remove(macIp);
            Modules.sceNetAdhocctlModule.hleNetAdhocctlDeletePeer(macIp.mac);
            this.portManager.removeHost(ProOnlineNetworkAdapter.convertIpToString(ip));
            if (this.chatGUI == null) break;
            this.chatGUI.updateMembers(Modules.sceNetAdhocctlModule.getPeersNickName());
            break;
        }
    }

    protected synchronized void deleteAllFriends() {
        while (!this.macIps.isEmpty()) {
            MacIp macIp = this.macIps.get(0);
            this.deleteFriend(macIp.ip);
        }
    }

    public boolean isBroadcast(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getAddress().equals(this.broadcastInetAddress);
        }
        return false;
    }

    public int getBroadcastPort(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress;
        if (socketAddress instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)socketAddress).getAddress().equals(this.broadcastInetAddress)) {
            return inetSocketAddress.getPort();
        }
        return -1;
    }

    @Override
    public SocketAddress getSocketAddress(byte[] macAddress, int realPort) throws UnknownHostException {
        InetAddress inetAddress = this.getInetAddress(macAddress);
        if (inetAddress == null && sceNetAdhoc.isMyMacAddress(macAddress)) {
            inetAddress = this.localHostInetAddress;
        }
        if (inetAddress == null) {
            throw new UnknownHostException(String.format("ProOnline: unknown MAC address %s", sceNet.convertMacAddressToString(macAddress)));
        }
        return new InetSocketAddress(inetAddress, realPort);
    }

    @Override
    public SocketAddress[] getMultiSocketAddress(byte[] macAddress, int realPort) throws UnknownHostException {
        if (sceNetAdhoc.isAnyMacAddress(macAddress)) {
            SocketAddress[] multiSocketAddress = new SocketAddress[this.macIps.size()];
            for (int i = 0; i < multiSocketAddress.length; ++i) {
                multiSocketAddress[i] = this.getSocketAddress(this.macIps.get((int)i).mac, realPort);
            }
            return multiSocketAddress;
        }
        return super.getMultiSocketAddress(macAddress, realPort);
    }

    public synchronized int getNumberMacIps() {
        return this.macIps.size();
    }

    public synchronized MacIp getMacIp(int index) {
        if (index < 0 || index >= this.macIps.size()) {
            return null;
        }
        return this.macIps.get(index);
    }

    public InetAddress getInetAddress(byte[] macAddress) {
        if (sceNetAdhoc.isAnyMacAddress(macAddress)) {
            return this.broadcastInetAddress;
        }
        MacIp macIp = this.getMacIp(macAddress);
        if (macIp == null) {
            return null;
        }
        return macIp.inetAddress;
    }

    public int getIp(byte[] macAddress) {
        MacIp macIp = this.getMacIp(macAddress);
        if (macIp == null) {
            return 0;
        }
        return macIp.ip;
    }

    public synchronized MacIp getMacIp(byte[] macAddress) {
        for (MacIp macIp : this.macIps) {
            if (!sceNetAdhoc.isSameMacAddress(macAddress, macIp.mac)) continue;
            return macIp;
        }
        return null;
    }

    private boolean isLocalInetAddress(InetAddress inetAddress) {
        return inetAddress.equals(this.loopbackInetAddress) || inetAddress.equals(this.localHostInetAddress);
    }

    public synchronized MacIp getMacIp(InetAddress inetAddress) {
        for (MacIp macIp : this.macIps) {
            if (inetAddress.equals(macIp.inetAddress)) {
                return macIp;
            }
            if (!this.isLocalInetAddress(inetAddress) || !this.isLocalInetAddress(macIp.inetAddress)) continue;
            return macIp;
        }
        return null;
    }

    public byte[] getMacAddress(InetAddress inetAddress) {
        MacIp macIp = this.getMacIp(inetAddress);
        if (macIp == null) {
            return null;
        }
        return macIp.mac;
    }

    @Override
    public PdpObject createPdpObject() {
        return new ProOnlinePdpObject(this);
    }

    @Override
    public PtpObject createPtpObject() {
        return new ProOnlinePtpObject(this);
    }

    @Override
    public AdhocMessage createAdhocPdpMessage(int address, int length, byte[] destMacAddress) {
        return new ProOnlineAdhocMessage(this, address, length, destMacAddress);
    }

    @Override
    public AdhocMessage createAdhocPdpMessage(byte[] message, int length) {
        return new ProOnlineAdhocMessage(this, message, length);
    }

    @Override
    public AdhocMessage createAdhocPtpMessage(int address, int length) {
        return new ProOnlineAdhocMessage(this, address, length);
    }

    @Override
    public AdhocMessage createAdhocPtpMessage(byte[] message, int length) {
        return new ProOnlineAdhocMessage(this, message, length);
    }

    @Override
    public AdhocMessage createAdhocGameModeMessage(byte[] message, int length) {
        return new ProOnlineAdhocGameModeMessage(this, message, length);
    }

    @Override
    public MatchingObject createMatchingObject() {
        return new ProOnlineMatchingObject(this);
    }

    @Override
    public AdhocMatchingEventMessage createAdhocMatchingEventMessage(MatchingObject matchingObject, int event) {
        return MatchingPacketFactory.createPacket(this, matchingObject, event);
    }

    @Override
    public AdhocMatchingEventMessage createAdhocMatchingEventMessage(MatchingObject matchingObject, int event, int data, int dataLength, byte[] macAddress) {
        return MatchingPacketFactory.createPacket(this, matchingObject, event, data, dataLength, macAddress);
    }

    @Override
    public AdhocMatchingEventMessage createAdhocMatchingEventMessage(MatchingObject matchingObject, byte[] message, int length) {
        return MatchingPacketFactory.createPacket(this, matchingObject, message, length);
    }

    public boolean isForMe(AdhocMessage adhocMessage, int port, InetAddress address) {
        byte[] fromMacAddress = this.getMacAddress(address);
        if (fromMacAddress == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("not for me: port=%d, address=%s, message=%s", port, address, adhocMessage));
            }
            return false;
        }
        adhocMessage.setFromMacAddress(fromMacAddress);
        return true;
    }

    @Override
    public void sendChatMessage(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sending chat message '%s'", message));
        }
        try {
            this.sendToMetaServer(new PacketFactory.SceNetAdhocctlChatPacketC2S(this, message));
        }
        catch (IOException e) {
            log.warn((Object)"Error while sending chat message", (Throwable)e);
        }
    }

    public void displayChatMessage(String nickName, String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Displaying chat message from '%s': '%s'", nickName, message));
        }
        this.chatGUI.addChatMessage(nickName, message);
    }

    public static void init() {
        Settings.getInstance().registerSettingsListener("ProOnline", "emu.enableProOnline", new EnabledSettingsListener());
        Settings.getInstance().registerSettingsListener("ProOnline", "network.ProOnline.metaServer", new MetaServerSettingsListener());
        Settings.getInstance().registerSettingsListener("ProOnline", "network.ProOnline.metaPort", new MetaServerPortSettingsListener());
    }

    public static void exit() {
        Settings.getInstance().removeSettingsListener("ProOnline");
        if (!ProOnlineNetworkAdapter.isEnabled()) {
            return;
        }
        INetworkAdapter networkAdapter = Modules.sceNetModule.getNetworkAdapter();
        if (networkAdapter == null || !(networkAdapter instanceof ProOnlineNetworkAdapter)) {
            return;
        }
        ProOnlineNetworkAdapter proOnline = (ProOnlineNetworkAdapter)networkAdapter;
        proOnline.exit = true;
        proOnline.terminatePortManager();
        proOnline.waitForFriendFinderToExit();
    }

    @Override
    public boolean isConnectComplete() {
        return this.connectComplete;
    }

    public void setConnectComplete(boolean connectComplete) {
        this.connectComplete = connectComplete;
    }

    @Override
    public void updatePeers() {
    }

    @Override
    public AdhocMatchingEventMessage createAdhocMatchingBirthMessage(MatchingObject matchingObject, byte[] toMacAddress, byte[] birthMacAddress) {
        return MatchingPacketFactory.createBirthPacket(this, matchingObject, toMacAddress, birthMacAddress);
    }

    @Override
    public AdhocSocket createAdhocGameModeSocket() {
        return new ProOnlineAdhocDatagramSocket(this);
    }

    protected class FriendFinder
    extends Thread {
        protected FriendFinder() {
        }

        @Override
        public void run() {
            ProOnlineNetworkAdapter.this.friendFinder();
        }
    }

    private static class EnabledSettingsListener
    extends AbstractBoolSettingsListener {
        private EnabledSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            ProOnlineNetworkAdapter.setEnabled(value);
        }
    }

    private static class MetaServerPortSettingsListener
    extends AbstractIntSettingsListener {
        private MetaServerPortSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(int value) {
            metaPort = value;
        }
    }

    private static class MetaServerSettingsListener
    extends AbstractStringSettingsListener {
        private MetaServerSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(String value) {
            metaServer = value;
        }
    }
}

