/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.IOException;
import java.io.InputStream;
import jpcsp.HLE.TPointer;
import jpcsp.Memory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class MemoryInputStream
extends InputStream {
    private IMemoryReader memoryReader;

    public MemoryInputStream(int address) {
        this.memoryReader = MemoryReader.getMemoryReader(address, 1);
    }

    public MemoryInputStream(TPointer address) {
        this.memoryReader = MemoryReader.getMemoryReader(address.getMemory(), address.getAddress(), 1);
    }

    @Override
    public int read() throws IOException {
        if (!Memory.isAddressGood(this.memoryReader.getCurrentAddress())) {
            return -1;
        }
        return this.memoryReader.readNext();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            if (!Memory.isAddressGood(this.memoryReader.getCurrentAddress())) {
                return i;
            }
            buffer[offset + i] = (byte)this.memoryReader.readNext();
        }
        return length;
    }
}

