/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class TextComponentSearchable
extends Searchable
implements DocumentListener,
PropertyChangeListener {
    private Highlighter.HighlightPainter _highlightPainter;
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private Color _highlightColor = null;
    private int _selectedIndex = -1;
    private HighlighCache _highlighCache = new HighlighCache();
    private String _text = null;

    public TextComponentSearchable(JTextComponent jTextComponent) {
        super(jTextComponent);
        this.installHighlightsRemover();
        this.setHighlightColor(DEFAULT_HIGHLIGHT_COLOR);
    }

    public void uninstallHighlightsRemover() {
        this._component.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    public void installHighlightsRemover() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextComponentSearchable.this.removeAllHighlights();
            }
        };
        this._component.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(27, 0), 0);
    }

    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().addDocumentListener(this);
            this._component.addPropertyChangeListener("document", this);
        }
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().removeDocumentListener(this);
            this._component.removePropertyChangeListener("document", this);
        }
    }

    protected void setSelectedIndex(int n, boolean bl) {
        if (this._component instanceof JTextComponent) {
            if (n == -1) {
                this.removeAllHighlights();
                this._selectedIndex = -1;
                return;
            }
            if (!bl) {
                this.removeAllHighlights();
            }
            String string = this.getSearchingText();
            try {
                this.addHighlight(n, string, bl);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    protected void addHighlight(final int n, final String string, boolean bl) throws BadLocationException {
        if (this._component instanceof JTextComponent) {
            final JTextComponent jTextComponent = (JTextComponent)this._component;
            Object object = jTextComponent.getHighlighter().addHighlight(n, n + string.length(), this._highlightPainter);
            this._highlighCache.addHighlight(object);
            this._selectedIndex = n;
            if (!bl) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        TextComponentSearchable.this.scrollTextVisible(jTextComponent, n, string.length());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private void scrollTextVisible(JTextComponent jTextComponent, int n, int n2) {
        if (n != -1) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                if (rectangle == null) {
                    return;
                }
                Rectangle rectangle2 = jTextComponent.modelToView(n + n2);
                if (rectangle2 == null) {
                    return;
                }
                Rectangle rectangle3 = this._component.getVisibleRect();
                if (rectangle.x <= rectangle3.width) {
                    rectangle.width = rectangle2.x;
                    rectangle.x = 0;
                } else {
                    rectangle.width = rectangle2.x - rectangle.x;
                }
                jTextComponent.scrollRectToVisible(rectangle);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected void removeAllHighlights() {
        if (this._component instanceof JTextComponent) {
            Iterator iterator = this._highlighCache.getAllHighlights();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                ((JTextComponent)this._component).getHighlighter().removeHighlight(e);
            }
            this._highlighCache.removeAllHighlights();
        }
    }

    protected int getSelectedIndex() {
        if (this._component instanceof JTextComponent) {
            return this._selectedIndex;
        }
        return 0;
    }

    protected Object getElementAt(int n) {
        String string = this.getSearchingText();
        if (string != null && this._component instanceof JTextComponent) {
            int n2;
            int n3 = n + string.length();
            if (n3 > (n2 = this.getElementCount())) {
                n3 = this.getElementCount();
            }
            try {
                return ((JTextComponent)this._component).getDocument().getText(n, n3 - n + 1);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return "";
    }

    protected int getElementCount() {
        if (this._component instanceof JTextComponent) {
            return ((JTextComponent)this._component).getDocument().getLength();
        }
        return 0;
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            if (propertyChangeEvent.getOldValue() instanceof Document) {
                ((Document)propertyChangeEvent.getNewValue()).removeDocumentListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof Document) {
                ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    protected boolean isActivateKey(KeyEvent keyEvent) {
        if (this._component instanceof JTextComponent && ((JTextComponent)this._component).isEditable()) {
            return keyEvent.getID() == 401 && keyEvent.getKeyCode() == 70 && (2 & keyEvent.getModifiers()) != 0;
        }
        return super.isActivateKey(keyEvent);
    }

    public Color getHighlightColor() {
        if (this._highlightColor != null) {
            return this._highlightColor;
        }
        return DEFAULT_HIGHLIGHT_COLOR;
    }

    public void setHighlightColor(Color color) {
        this._highlightColor = color;
        this._highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this._highlightColor);
    }

    public int findLast(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return string2.lastIndexOf(string);
            }
            return string2.toLowerCase().lastIndexOf(string.toLowerCase());
        }
        return super.findLast(string);
    }

    private String getDocumentText() {
        if (this._text == null) {
            Document document = ((JTextComponent)this._component).getDocument();
            try {
                String string;
                this._text = string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }
        return this._text;
    }

    public int findFirst(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return string2.indexOf(string);
            }
            return string2.toLowerCase().indexOf(string.toLowerCase());
        }
        return super.findFirst(string);
    }

    public int findFromCursor(String string) {
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n;
            int n2;
            String string2 = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                string2 = string2.toLowerCase();
            }
            String string3 = this.isCaseSensitive() ? string : string.toLowerCase();
            int n3 = n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n4 = string2.indexOf(string3, n2);
            if (n4 == -1 && (n4 = string2.indexOf(string3, 0)) >= n2) {
                n4 = -1;
            }
            return n4;
        }
        return super.findFromCursor(string);
    }

    public int reverseFindFromCursor(String string) {
        if (!this.isReverseOrder()) {
            return this.findFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n;
            int n2;
            String string2 = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                string2 = string2.toLowerCase();
            }
            String string3 = this.isCaseSensitive() ? string : string.toLowerCase();
            int n3 = n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n4 = string2.lastIndexOf(string3, n2);
            if (n4 == -1 && (n4 = string2.lastIndexOf(string3, string2.length() - 1)) <= n2) {
                n4 = -1;
            }
            return n4;
        }
        return super.findFromCursor(string);
    }

    public int findNext(String string) {
        if (this._component instanceof JTextComponent) {
            int n;
            int n2;
            String string2 = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                string2 = string2.toLowerCase();
            }
            String string3 = this.isCaseSensitive() ? string : string.toLowerCase();
            int n3 = n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n4 = string2.indexOf(string3, n2 + 1);
            if (n4 == -1 && this.isRepeats() && (n4 = string2.indexOf(string3, 0)) >= n2) {
                n4 = -1;
            }
            return n4;
        }
        return super.findNext(string);
    }

    public int findPrevious(String string) {
        if (this._component instanceof JTextComponent) {
            int n;
            int n2;
            String string2 = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                string2 = string2.toLowerCase();
            }
            String string3 = this.isCaseSensitive() ? string : string.toLowerCase();
            int n3 = n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n4 = string2.lastIndexOf(string3, n2 - 1);
            if (n4 == -1 && this.isRepeats() && (n4 = string2.lastIndexOf(string3, n - 1)) <= n2) {
                n4 = -1;
            }
            return n4;
        }
        return super.findPrevious(string);
    }

    public void hidePopup() {
        super.hidePopup();
        this._selectedIndex = -1;
    }

    private class HighlighCache
    extends HashMap {
        private HighlighCache() {
        }

        public void addHighlight(Object object) {
            this.put(object, null);
        }

        public void removeHighlight(Object object) {
            this.remove(object);
        }

        public Iterator getAllHighlights() {
            return this.keySet().iterator();
        }

        public void removeAllHighlights() {
            this.clear();
        }
    }
}

