/*
 * Decompiled with CFR 0.152.
 */
package org.bolet.jgz;

import java.io.IOException;
import java.io.InputStream;
import org.bolet.jgz.CRC;

final class CRCInputStream
extends InputStream {
    private InputStream sub;
    private int crc;

    CRCInputStream(InputStream inputStream) {
        this.sub = inputStream;
        this.resetCRC();
    }

    void resetCRC() {
        this.crc = -1;
    }

    void updateCRC(int n) {
        this.crc = CRC.updateCRC(this.crc, n);
    }

    int getCRC() {
        return ~this.crc;
    }

    public int read() throws IOException {
        int n = this.sub.read();
        if (n >= 0) {
            this.updateCRC(n);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.sub.read(byArray, n, n2);
        if (n3 > 0) {
            this.crc = CRC.updateCRC(this.crc, byArray, n, n3);
        }
        return n3;
    }
}

