/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IConfigurable;
import com.xuggle.xuggler.IMetaData;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IProperty;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.XugglerJNI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public class IStreamCoder
extends RefCounted
implements IConfigurable {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IStreamCoder(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIStreamCoderUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IStreamCoder(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.SWIGIStreamCoderUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IStreamCoder obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IStreamCoder copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IStreamCoder(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IStreamCoder) {
            equal = ((IStreamCoder)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public char[] getCodecTagArray() {
        char[] retval = new char[4];
        int fourcc = this.getCodecTag();
        retval[0] = (char)(fourcc & 0xFF);
        retval[1] = (char)(fourcc >> 8 & 0xFF);
        retval[2] = (char)(fourcc >> 16 & 0xFF);
        retval[3] = (char)(fourcc >> 24 & 0xFF);
        return retval;
    }

    public void setCodecTag(char[] fourcc) {
        if (fourcc == null || fourcc.length != 4) {
            throw new IllegalArgumentException();
        }
        int tag = 0;
        tag = (fourcc[3] << 24) + (fourcc[2] << 16) + (fourcc[1] << 8) + fourcc[0];
        this.setCodecTag(tag);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ICodec.Type type = this.getCodecType();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("codec=" + this.getCodec() + ";");
        result.append("time base=" + this.getTimeBase() + ";");
        result.append("frame rate=" + this.getFrameRate() + ";");
        switch (type) {
            case CODEC_TYPE_VIDEO: {
                result.append("pixel type=" + (Object)((Object)this.getPixelType()) + ";");
                result.append("width=" + this.getWidth() + ";");
                result.append("height=" + this.getHeight() + ";");
                break;
            }
            case CODEC_TYPE_AUDIO: {
                result.append("sample rate=" + this.getSampleRate() + ";");
                result.append("channels=" + this.getChannels() + ";");
                break;
            }
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public Collection<String> getPropertyNames() {
        LinkedList<String> retval = new LinkedList<String>();
        int numProperties = this.getNumProperties();
        for (int i = 0; i < numProperties; ++i) {
            IProperty property = this.getPropertyMetaData(i);
            String name = property.getName();
            retval.add(name);
        }
        return retval;
    }

    public IBuffer getExtraData() {
        int size = this.getExtraDataSize();
        if (size <= 0) {
            return null;
        }
        IBuffer retval = IBuffer.make(this, size);
        if (retval == null) {
            return null;
        }
        if (this.getExtraData(retval, 0, size) != size) {
            retval.delete();
            retval = null;
        }
        return retval;
    }

    public Direction getDirection() {
        return Direction.swigToEnum(XugglerJNI.IStreamCoder_getDirection(this.swigCPtr, this));
    }

    public IStream getStream() {
        long cPtr = XugglerJNI.IStreamCoder_getStream(this.swigCPtr, this);
        return cPtr == 0L ? null : new IStream(cPtr, false);
    }

    public ICodec getCodec() {
        long cPtr = XugglerJNI.IStreamCoder_getCodec(this.swigCPtr, this);
        return cPtr == 0L ? null : new ICodec(cPtr, false);
    }

    public ICodec.Type getCodecType() {
        return ICodec.Type.swigToEnum(XugglerJNI.IStreamCoder_getCodecType(this.swigCPtr, this));
    }

    public ICodec.ID getCodecID() {
        return ICodec.ID.swigToEnum(XugglerJNI.IStreamCoder_getCodecID(this.swigCPtr, this));
    }

    public void setCodec(ICodec codec) {
        XugglerJNI.IStreamCoder_setCodec__SWIG_0(this.swigCPtr, this, ICodec.getCPtr(codec), codec);
    }

    public void setCodec(ICodec.ID id) {
        XugglerJNI.IStreamCoder_setCodec__SWIG_1(this.swigCPtr, this, id.swigValue());
    }

    public int getBitRate() {
        return XugglerJNI.IStreamCoder_getBitRate(this.swigCPtr, this);
    }

    public void setBitRate(int rate) {
        XugglerJNI.IStreamCoder_setBitRate(this.swigCPtr, this, rate);
    }

    public int getBitRateTolerance() {
        return XugglerJNI.IStreamCoder_getBitRateTolerance(this.swigCPtr, this);
    }

    public void setBitRateTolerance(int tolerance) {
        XugglerJNI.IStreamCoder_setBitRateTolerance(this.swigCPtr, this, tolerance);
    }

    public int getHeight() {
        return XugglerJNI.IStreamCoder_getHeight(this.swigCPtr, this);
    }

    public void setHeight(int height) {
        XugglerJNI.IStreamCoder_setHeight(this.swigCPtr, this, height);
    }

    public int getWidth() {
        return XugglerJNI.IStreamCoder_getWidth(this.swigCPtr, this);
    }

    public void setWidth(int width) {
        XugglerJNI.IStreamCoder_setWidth(this.swigCPtr, this, width);
    }

    public IRational getTimeBase() {
        long cPtr = XugglerJNI.IStreamCoder_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public void setTimeBase(IRational newTimeBase) {
        XugglerJNI.IStreamCoder_setTimeBase(this.swigCPtr, this, IRational.getCPtr(newTimeBase), newTimeBase);
    }

    public IRational getFrameRate() {
        long cPtr = XugglerJNI.IStreamCoder_getFrameRate(this.swigCPtr, this);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    public void setFrameRate(IRational newFrameRate) {
        XugglerJNI.IStreamCoder_setFrameRate(this.swigCPtr, this, IRational.getCPtr(newFrameRate), newFrameRate);
    }

    public int getNumPicturesInGroupOfPictures() {
        return XugglerJNI.IStreamCoder_getNumPicturesInGroupOfPictures(this.swigCPtr, this);
    }

    public void setNumPicturesInGroupOfPictures(int gops) {
        XugglerJNI.IStreamCoder_setNumPicturesInGroupOfPictures(this.swigCPtr, this, gops);
    }

    public IPixelFormat.Type getPixelType() {
        return IPixelFormat.Type.swigToEnum(XugglerJNI.IStreamCoder_getPixelType(this.swigCPtr, this));
    }

    public void setPixelType(IPixelFormat.Type pixelFmt) {
        XugglerJNI.IStreamCoder_setPixelType(this.swigCPtr, this, pixelFmt.swigValue());
    }

    public int getSampleRate() {
        return XugglerJNI.IStreamCoder_getSampleRate(this.swigCPtr, this);
    }

    public void setSampleRate(int sampleRate) {
        XugglerJNI.IStreamCoder_setSampleRate(this.swigCPtr, this, sampleRate);
    }

    public IAudioSamples.Format getSampleFormat() {
        return IAudioSamples.Format.swigToEnum(XugglerJNI.IStreamCoder_getSampleFormat(this.swigCPtr, this));
    }

    public void setSampleFormat(IAudioSamples.Format aFormat) {
        XugglerJNI.IStreamCoder_setSampleFormat(this.swigCPtr, this, aFormat.swigValue());
    }

    public int getChannels() {
        return XugglerJNI.IStreamCoder_getChannels(this.swigCPtr, this);
    }

    public void setChannels(int channels) {
        XugglerJNI.IStreamCoder_setChannels(this.swigCPtr, this, channels);
    }

    public int getAudioFrameSize() {
        return XugglerJNI.IStreamCoder_getAudioFrameSize(this.swigCPtr, this);
    }

    public int getGlobalQuality() {
        return XugglerJNI.IStreamCoder_getGlobalQuality(this.swigCPtr, this);
    }

    public void setGlobalQuality(int newQuality) {
        XugglerJNI.IStreamCoder_setGlobalQuality(this.swigCPtr, this, newQuality);
    }

    public int getFlags() {
        return XugglerJNI.IStreamCoder_getFlags(this.swigCPtr, this);
    }

    public void setFlags(int newFlags) {
        XugglerJNI.IStreamCoder_setFlags(this.swigCPtr, this, newFlags);
    }

    public boolean getFlag(Flags flag) {
        return XugglerJNI.IStreamCoder_getFlag(this.swigCPtr, this, flag.swigValue());
    }

    public void setFlag(Flags flag, boolean value) {
        XugglerJNI.IStreamCoder_setFlag(this.swigCPtr, this, flag.swigValue(), value);
    }

    public long getNextPredictedPts() {
        return XugglerJNI.IStreamCoder_getNextPredictedPts(this.swigCPtr, this);
    }

    @Deprecated
    public int open() {
        return XugglerJNI.IStreamCoder_open__SWIG_0(this.swigCPtr, this);
    }

    public int close() {
        return XugglerJNI.IStreamCoder_close(this.swigCPtr, this);
    }

    public int decodeAudio(IAudioSamples pOutSamples, IPacket packet, int byteOffset) {
        return XugglerJNI.IStreamCoder_decodeAudio(this.swigCPtr, this, IAudioSamples.getCPtr(pOutSamples), pOutSamples, IPacket.getCPtr(packet), packet, byteOffset);
    }

    public int decodeVideo(IVideoPicture pOutFrame, IPacket packet, int byteOffset) {
        return XugglerJNI.IStreamCoder_decodeVideo(this.swigCPtr, this, IVideoPicture.getCPtr(pOutFrame), pOutFrame, IPacket.getCPtr(packet), packet, byteOffset);
    }

    public int encodeVideo(IPacket pOutPacket, IVideoPicture pFrame, int suggestedBufferSize) {
        return XugglerJNI.IStreamCoder_encodeVideo(this.swigCPtr, this, IPacket.getCPtr(pOutPacket), pOutPacket, IVideoPicture.getCPtr(pFrame), pFrame, suggestedBufferSize);
    }

    public int encodeAudio(IPacket pOutPacket, IAudioSamples pSamples, long sampleToStartFrom) {
        return XugglerJNI.IStreamCoder_encodeAudio(this.swigCPtr, this, IPacket.getCPtr(pOutPacket), pOutPacket, IAudioSamples.getCPtr(pSamples), pSamples, sampleToStartFrom);
    }

    @Deprecated
    public static IStreamCoder make(Direction direction) {
        long cPtr = XugglerJNI.IStreamCoder_make__SWIG_0(direction.swigValue());
        return cPtr == 0L ? null : new IStreamCoder(cPtr, false);
    }

    public int getCodecTag() {
        return XugglerJNI.IStreamCoder_getCodecTag(this.swigCPtr, this);
    }

    public void setCodecTag(int fourcc) {
        XugglerJNI.IStreamCoder_setCodecTag(this.swigCPtr, this, fourcc);
    }

    @Override
    public int getNumProperties() {
        return XugglerJNI.IStreamCoder_getNumProperties(this.swigCPtr, this);
    }

    @Override
    public IProperty getPropertyMetaData(int propertyNo) {
        long cPtr = XugglerJNI.IStreamCoder_getPropertyMetaData__SWIG_0(this.swigCPtr, this, propertyNo);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    @Override
    public IProperty getPropertyMetaData(String name) {
        long cPtr = XugglerJNI.IStreamCoder_getPropertyMetaData__SWIG_1(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IProperty(cPtr, false);
    }

    @Override
    public int setProperty(String name, String value) {
        return XugglerJNI.IStreamCoder_setProperty__SWIG_0(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, double value) {
        return XugglerJNI.IStreamCoder_setProperty__SWIG_1(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, long value) {
        return XugglerJNI.IStreamCoder_setProperty__SWIG_2(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, boolean value) {
        return XugglerJNI.IStreamCoder_setProperty__SWIG_3(this.swigCPtr, this, name, value);
    }

    @Override
    public int setProperty(String name, IRational value) {
        return XugglerJNI.IStreamCoder_setProperty__SWIG_4(this.swigCPtr, this, name, IRational.getCPtr(value), value);
    }

    @Override
    public String getPropertyAsString(String name) {
        return XugglerJNI.IStreamCoder_getPropertyAsString(this.swigCPtr, this, name);
    }

    @Override
    public double getPropertyAsDouble(String name) {
        return XugglerJNI.IStreamCoder_getPropertyAsDouble(this.swigCPtr, this, name);
    }

    @Override
    public long getPropertyAsLong(String name) {
        return XugglerJNI.IStreamCoder_getPropertyAsLong(this.swigCPtr, this, name);
    }

    @Override
    public IRational getPropertyAsRational(String name) {
        long cPtr = XugglerJNI.IStreamCoder_getPropertyAsRational(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IRational(cPtr, false);
    }

    @Override
    public boolean getPropertyAsBoolean(String name) {
        return XugglerJNI.IStreamCoder_getPropertyAsBoolean(this.swigCPtr, this, name);
    }

    public boolean isOpen() {
        return XugglerJNI.IStreamCoder_isOpen(this.swigCPtr, this);
    }

    public int getDefaultAudioFrameSize() {
        return XugglerJNI.IStreamCoder_getDefaultAudioFrameSize(this.swigCPtr, this);
    }

    public void setDefaultAudioFrameSize(int aNewSize) {
        XugglerJNI.IStreamCoder_setDefaultAudioFrameSize(this.swigCPtr, this, aNewSize);
    }

    public static IStreamCoder make(Direction direction, IStreamCoder copyCoder) {
        long cPtr = XugglerJNI.IStreamCoder_make__SWIG_1(direction.swigValue(), IStreamCoder.getCPtr(copyCoder), copyCoder);
        return cPtr == 0L ? null : new IStreamCoder(cPtr, false);
    }

    public long getNumDroppedFrames() {
        return XugglerJNI.IStreamCoder_getNumDroppedFrames(this.swigCPtr, this);
    }

    public void setAutomaticallyStampPacketsForStream(boolean value) {
        XugglerJNI.IStreamCoder_setAutomaticallyStampPacketsForStream(this.swigCPtr, this, value);
    }

    public boolean getAutomaticallyStampPacketsForStream() {
        return XugglerJNI.IStreamCoder_getAutomaticallyStampPacketsForStream(this.swigCPtr, this);
    }

    public void setCodecID(ICodec.ID id) {
        XugglerJNI.IStreamCoder_setCodecID(this.swigCPtr, this, id.swigValue());
    }

    public int setExtraData(IBuffer src, int offset, int length, boolean allocNew) {
        return XugglerJNI.IStreamCoder_setExtraData(this.swigCPtr, this, IBuffer.getCPtr(src), src, offset, length, allocNew);
    }

    public int getExtraData(IBuffer dest, int offset, int maxBytesToCopy) {
        return XugglerJNI.IStreamCoder_getExtraData(this.swigCPtr, this, IBuffer.getCPtr(dest), dest, offset, maxBytesToCopy);
    }

    public int getExtraDataSize() {
        return XugglerJNI.IStreamCoder_getExtraDataSize(this.swigCPtr, this);
    }

    public CodecStandardsCompliance getStandardsCompliance() {
        return CodecStandardsCompliance.swigToEnum(XugglerJNI.IStreamCoder_getStandardsCompliance(this.swigCPtr, this));
    }

    public int setStandardsCompliance(CodecStandardsCompliance compliance) {
        return XugglerJNI.IStreamCoder_setStandardsCompliance(this.swigCPtr, this, compliance.swigValue());
    }

    public int open(IMetaData options, IMetaData unsetOptions) {
        return XugglerJNI.IStreamCoder_open__SWIG_1(this.swigCPtr, this, IMetaData.getCPtr(options), options, IMetaData.getCPtr(unsetOptions), unsetOptions);
    }

    public static IStreamCoder make(Direction direction, ICodec codec) {
        long cPtr = XugglerJNI.IStreamCoder_make__SWIG_2(direction.swigValue(), ICodec.getCPtr(codec), codec);
        return cPtr == 0L ? null : new IStreamCoder(cPtr, false);
    }

    public static IStreamCoder make(Direction direction, ICodec.ID id) {
        long cPtr = XugglerJNI.IStreamCoder_make__SWIG_3(direction.swigValue(), id.swigValue());
        return cPtr == 0L ? null : new IStreamCoder(cPtr, false);
    }

    @Override
    public int setProperty(IMetaData valuesToSet, IMetaData valuesNotFound) {
        return XugglerJNI.IStreamCoder_setProperty__SWIG_5(this.swigCPtr, this, IMetaData.getCPtr(valuesToSet), valuesToSet, IMetaData.getCPtr(valuesNotFound), valuesNotFound);
    }

    public static enum CodecStandardsCompliance {
        COMPLIANCE_VERY_STRICT(XugglerJNI.IStreamCoder_COMPLIANCE_VERY_STRICT_get()),
        COMPLIANCE_STRICT(XugglerJNI.IStreamCoder_COMPLIANCE_STRICT_get()),
        COMPLIANCE_NORMAL(XugglerJNI.IStreamCoder_COMPLIANCE_NORMAL_get()),
        COMPLIANCE_UNOFFICIAL(XugglerJNI.IStreamCoder_COMPLIANCE_UNOFFICIAL_get()),
        COMPLIANCE_EXPERIMENTAL(XugglerJNI.IStreamCoder_COMPLIANCE_EXPERIMENTAL_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static CodecStandardsCompliance swigToEnum(int swigValue) {
            CodecStandardsCompliance[] swigValues = (CodecStandardsCompliance[])CodecStandardsCompliance.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (CodecStandardsCompliance swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + CodecStandardsCompliance.class + " with value " + swigValue);
        }

        private CodecStandardsCompliance() {
            this.swigValue = SwigNext.next++;
        }

        private CodecStandardsCompliance(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private CodecStandardsCompliance(CodecStandardsCompliance swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Flags {
        FLAG_QSCALE(XugglerJNI.IStreamCoder_FLAG_QSCALE_get()),
        FLAG_4MV(XugglerJNI.IStreamCoder_FLAG_4MV_get()),
        FLAG_QPEL(XugglerJNI.IStreamCoder_FLAG_QPEL_get()),
        FLAG_GMC(XugglerJNI.IStreamCoder_FLAG_GMC_get()),
        FLAG_MV0(XugglerJNI.IStreamCoder_FLAG_MV0_get()),
        FLAG_INPUT_PRESERVED(XugglerJNI.IStreamCoder_FLAG_INPUT_PRESERVED_get()),
        FLAG_PASS1(XugglerJNI.IStreamCoder_FLAG_PASS1_get()),
        FLAG_PASS2(XugglerJNI.IStreamCoder_FLAG_PASS2_get()),
        FLAG_GRAY(XugglerJNI.IStreamCoder_FLAG_GRAY_get()),
        FLAG_EMU_EDGE(XugglerJNI.IStreamCoder_FLAG_EMU_EDGE_get()),
        FLAG_PSNR(XugglerJNI.IStreamCoder_FLAG_PSNR_get()),
        FLAG_TRUNCATED(XugglerJNI.IStreamCoder_FLAG_TRUNCATED_get()),
        FLAG_NORMALIZE_AQP(XugglerJNI.IStreamCoder_FLAG_NORMALIZE_AQP_get()),
        FLAG_INTERLACED_DCT(XugglerJNI.IStreamCoder_FLAG_INTERLACED_DCT_get()),
        FLAG_LOW_DELAY(XugglerJNI.IStreamCoder_FLAG_LOW_DELAY_get()),
        FLAG_GLOBAL_HEADER(XugglerJNI.IStreamCoder_FLAG_GLOBAL_HEADER_get()),
        FLAG_BITEXACT(XugglerJNI.IStreamCoder_FLAG_BITEXACT_get()),
        FLAG_AC_PRED(XugglerJNI.IStreamCoder_FLAG_AC_PRED_get()),
        FLAG_CBP_RD(XugglerJNI.IStreamCoder_FLAG_CBP_RD_get()),
        FLAG_QP_RD(XugglerJNI.IStreamCoder_FLAG_QP_RD_get()),
        FLAG_LOOP_FILTER(XugglerJNI.IStreamCoder_FLAG_LOOP_FILTER_get()),
        FLAG_INTERLACED_ME(XugglerJNI.IStreamCoder_FLAG_INTERLACED_ME_get()),
        FLAG_CLOSED_GOP(XugglerJNI.IStreamCoder_FLAG_CLOSED_GOP_get()),
        FLAG2_FAST(XugglerJNI.IStreamCoder_FLAG2_FAST_get()),
        FLAG2_STRICT_GOP(XugglerJNI.IStreamCoder_FLAG2_STRICT_GOP_get()),
        FLAG2_NO_OUTPUT(XugglerJNI.IStreamCoder_FLAG2_NO_OUTPUT_get()),
        FLAG2_LOCAL_HEADER(XugglerJNI.IStreamCoder_FLAG2_LOCAL_HEADER_get()),
        FLAG2_SKIP_RD(XugglerJNI.IStreamCoder_FLAG2_SKIP_RD_get()),
        FLAG2_CHUNKS(XugglerJNI.IStreamCoder_FLAG2_CHUNKS_get()),
        FLAG2_SHOW_ALL(XugglerJNI.IStreamCoder_FLAG2_SHOW_ALL_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flags swigToEnum(int swigValue) {
            Flags[] swigValues = (Flags[])Flags.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flags swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flags.class + " with value " + swigValue);
        }

        private Flags() {
            this.swigValue = SwigNext.next++;
        }

        private Flags(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flags(Flags swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Direction {
        ENCODING,
        DECODING;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Direction swigToEnum(int swigValue) {
            Direction[] swigValues = (Direction[])Direction.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Direction swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Direction.class + " with value " + swigValue);
        }

        private Direction() {
            this.swigValue = SwigNext.next++;
        }

        private Direction(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Direction(Direction swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

