#include <stdio.h>
#include <windows.h>
#include "dev9.h"
#include "hdd.h"

#define VERSION(rev, major, minor)		((rev << 8) | (major) | (minor << 24) | (PS2E_DEV9_VERSION << 16))

DEV9callback DEV9irq;
FILE *logf;

void Log(char *txt, ...)
{
	va_list list;

	if(!config.log || !logf) return;

	va_start(list, txt);
	vfprintf(logf, txt, list);
	va_end(list);
}

u32 CALLBACK PS2EgetLibType()
{
	return PS2E_LT_DEV9;
}

u32 CALLBACK PS2EgetLibVersion2(u32 type)
{
	return VERSION(1, 0, 1);						// Increase it with each version !!!
}

char * CALLBACK PS2EgetLibName()
{
	return "MegaDev9 plugin";
}



s32 CALLBACK DEV9init()
{
	LoadConf();

	if(config.log)
	{
		logf = fopen("logs/dev9Log.txt", "w");
		if(logf) setvbuf(logf, 0, _IONBF, 0);

		Log("DEV9init\n");
	}

/*	if(!HDDinit())
		return -1;*/

	Log("DEV9init OK\n");

	return 0;
}

s32 CALLBACK DEV9open(void *pDsp)
{
	Log("DEV9open\n");

	LoadConf();

	memset(&dev9, 0, sizeof(dev9));

	dev9.ata_regs.nsector = 1;
	dev9.ata_regs.sector = 1;
	dev9.ata_regs.status = 0x40;

	if(!HDDinit())
		return -1;

	return 0;
}

void CALLBACK DEV9close()
{
	Log("DEV9close\n");

	HDDshutdown();
}

void CALLBACK DEV9shutdown()
{
	Log("DEV9shutdown\n");

	if(config.log)
	{
		if(logf) fclose(logf);
	}
}

// I/O read/write, not very much populated yet (except for 16-bit)
u8 CALLBACK DEV9read8(u32 addr)
{
	u8 value = 0;

	switch(addr)
	{
	case 0x1F80146E:
		value = 0x32;
		break;

	default:
	//	printf("DEV9 : read8 at unknown port %08X\n", addr);
		break;
	}

	Log("DEV9read8 at address %08X, value %02X\n", addr, value);

	return value;
}

u16 CALLBACK DEV9read16(u32 addr)
{
	u16 value = 0;

	switch(addr)
	{
	case 0x1F80146E:		// DEV9 hardware type (DEV9 bay)
		value = 0x0032;
		break;

	case 0x10000002:
		value = 0x0011;
		break;

	case 0x10000004:
		value = 0x0002;
		break;

	case 0x1000000E:
		value = 0x0002;
		break;

	case 0x10000038:			// ??? Seems to be the max DMA size per transfer
		value = dev9.reg_38;
	//	value = 0x1F;
		printf("DEV9 : reading the unknown reg at 10000038, %08X\n", value);
		break;

	case 0x10000028:			// INTR STAT
		value = dev9.intr_stat;
		break;

	case 0x1000002A:			// INTR MASK
		value = dev9.intr_mask;
		break;

	case 0x10000040:			// PIO DATA
		if(dev9.pio_count < dev9.pio_size)
			value = dev9.pio_buf[dev9.pio_count++];

		break;

	case 0x10000044:			// NSECTOR
		if(dev9.ata_regs.select & 0x10)
			value = 0x0000;
		else
			value = dev9.ata_regs.nsector;
		break;

	case 0x10000046:			// SECTOR
		if(dev9.ata_regs.select & 0x10)
			value = 0x0000;
		else
			value = dev9.ata_regs.sector;
		break;

	case 0x10000048:			// LCYL
		if(dev9.ata_regs.select & 0x10)
			value = 0x0000;
		else
			value = dev9.ata_regs.lcyl;
		break;

	case 0x1000004A:			// HCYL
		if(dev9.ata_regs.select & 0x10)
			value = 0x0000;
		else
			value = dev9.ata_regs.hcyl;
		break;

	case 0x1000004C:			// SELECT
		value = dev9.ata_regs.select;
		break;

	case 0x1000004E:			// STATUS
		if(dev9.ata_regs.select & 0x10)
		//	value = 0x0001;
			value = 0x0000;
		else
			value = dev9.ata_regs.status;
		break;

	case 0x1000005C:			// ALTERNATE STATUS
		//value = dev9.ata_hwport.r_control;
		if(dev9.ata_regs.select & 0x10)
		//	value = 0x0001;
			value = 0x0000;
		else
			//value = 0x0040;
			value = dev9.ata_regs.status;
		break;

	case 0x10000064:
		value = dev9.if_ctrl;
		break;

	default:
	//	printf("DEV9 : read16 at unknown port %08X\n", addr);
		break;
	}

	Log("DEV9read16 at address %08X, value %04X\n", addr, value);

	return value;
}

u32 CALLBACK DEV9read32(u32 addr)
{
	u32 value = 0;

	switch(addr)
	{
	default:
	//	printf("DEV9 : read32 at unknown port %08X\n", addr);
		break;
	}

	Log("DEV9read32 at address %08X, value %08X\n", addr, value);

	return value;
}

void CALLBACK DEV9write8(u32 addr,  u8 value)
{
	switch(addr)
	{
	default:
	//	printf("DEV9 : write8 at unknown port %08X, %08X\n", addr, value);
		break;
	}

	Log("DEV9write8 at address %08X, value %02X\n", addr, value);
}

void CALLBACK DEV9write16(u32 addr, u16 value)
{
	switch(addr)
	{
	case 0x10000038:			// ??? Seems to be the max DMA size per transfer
		dev9.reg_38 = value;
		printf("DEV9 : writing the unknown reg at 10000038, %08X\n", value);
		break;

	case 0x10000042:			// FEATURE
		dev9.ata_regs.feature = value;
		break;

	case 0x10000044:			// NSECTOR
		dev9.ata_regs.nsector = value;
		break;

	case 0x10000046:			// SECTOR
		dev9.ata_regs.sector = value;
		break;

	case 0x10000048:			// LCYL
		dev9.ata_regs.lcyl = value;
		break;

	case 0x1000004A:			// HCYL
		dev9.ata_regs.hcyl = value;
		break;

	case 0x1000004C:			// SELECT
		dev9.ata_regs.select = value;
		break;

	case 0x1000004E:			// COMMAND
		dev9.ata_regs.command = value;
		HDDcmds[value]();

		Log("HDD command %02X (%s)\n", value, HDDcmdNames[value]);

		break;

	case 0x1000005C:			// CONTROL
		dev9.ata_regs.control = value;

		printf("DEV9 : IRQ %s (%04X)\n", ((value & 2) ? "DISABLED" : "ENABLED"), value);

		if(value & 4)
			printf("DEV9 : HDD RESET (%04X)\n", value);

		break;

	case 0x10000064:
		dev9.if_ctrl = value;
		break;

	case 0x10000028:			// INTR STAT
		printf("DEV9 : IRQ ACKNOWLEDGE ??? (%08X)\n", value);
		dev9.intr_stat &= (~value);
		break;

	case 0x1000002A:			// INTR MASK
		dev9.intr_mask = value;
		if(dev9.intr_mask & dev9.irq_cause)
			DEV9irq(1);

		break;

	default:
	//	printf("DEV9 : write16 at unknown port %08X, %08X\n", addr, value);
		break;
	}

	Log("DEV9write16 at address %08X, value %04X\n", addr, value);
}

void CALLBACK DEV9write32(u32 addr, u32 value)
{
	switch(addr)
	{
	default:
	//	printf("DEV9 : write32 at unknown port %08X, %08X\n", addr, value);
		break;
	}

	Log("DEV9write32 at address %08X, value %08X\n", addr, value);
}

// DMA transfer funcs
// Don't know why, but DMA transfer size must always be divided by 2
void CALLBACK DEV9readDMA8Mem(u32 *pMem, int size)
{
	if(((dev9.xfer_mode & 0xF0) == 0x40) && (dev9.if_ctrl & 0x04))
		HDDreadDMA8Mem(pMem, size / 2);

	//triggerIRQ(3, 1);

	Log("DEV9readDMA8Mem size %i\n", size);
}

void CALLBACK DEV9writeDMA8Mem(u32 *pMem, int size)
{
	if(((dev9.xfer_mode & 0xF0) == 0x40) && (dev9.if_ctrl & 0x04))
		HDDwriteDMA8Mem(pMem, size / 2);

	//triggerIRQ(3, 1);

	Log("DEV9writeDMA8Mem size %i\n", size);
}

// All IRQ related stuff
void CALLBACK DEV9irqCallback(DEV9callback callback)
{
	DEV9irq = callback;
}

int _DEV9irqHandler(void)
{
//	Log("_DEV9irqHandler\n");

//	dev9.intr_stat |= dev9.irq_cause;
	dev9.intr_stat = dev9.irq_cause;
//	dev9.intr_stat = 0;

	if(/*dev9.intr_stat*/dev9.irq_cause & 0x0001)				// ATA command completion
	{
		dev9.ata_regs.status &= ~(ATA_STAT_DRQ | ATA_STAT_BUSY);
		dev9.ata_regs.status |= ATA_STAT_READY;
	}

	if(/*dev9.intr_stat*/dev9.irq_cause & 0x0002)				// DMA transfer completion (no DRQ)
	{
		dev9.ata_regs.status &= ~ATA_STAT_BUSY;
		dev9.ata_regs.status |= ATA_STAT_READY;
	}

	if((/*dev9.intr_stat*/dev9.irq_cause & dev9.intr_mask) && (!(dev9.ata_regs.control & 2)))
	{
	//	dev9.intr_stat &= ~(dev9.irq_cause);
	//	dev9.intr_stat = dev9.irq_cause;
	//	dev9.intr_stat = 0;
		Log("_DEV9irqHandler = 1\n");

		return 1;
	}

	Log("_DEV9irqHandler = 0\n");

	return 0;
}

DEV9handler CALLBACK DEV9irqHandler(void)
{
	return (DEV9handler)_DEV9irqHandler;
}

void triggerIRQ(u16 cause, int cycles)
{
	Log("triggerIRQ cause=%04X, cycles=%x\n", cause, cycles);

	dev9.irq_cause = cause;
//	dev9.intr_stat = cause;
	DEV9irq(cycles);
}

// Useful for savestates
s32 CALLBACK DEV9freeze(int mode, freezeData *data)
{
	//
	return 0;
}

// Extended funcs
void CALLBACK DEV9configure()
{
	ConfDlg();
}

void CALLBACK DEV9about()
{
	AboutDlg();
}

s32 CALLBACK DEV9test()
{
	return 0;
}
