#define DEV9defs
#include "PS2Edefs.h"

DEV9callback DEV9irq;
void triggerIRQ(u16, int);

struct
{
	int log;				// Logging (for debugging only)

	int hddSize;			// HDD file size in gigabytes
	char hddFile[256];		// HDD file name & path

} config;

struct
{
	u16 irq_cause;

	u16 intr_stat;			// 0x10000028
	u16 intr_mask;			// 0x1000002A

	u16 reg_38;				// 0x10000038 (???)

	/*
	Interrupts : 
	Bit 0 : command completion
	Bit 1 : DMA transfer completion
	*/

	// Inspired from ata_hwport struct (from PS2SDK, atahw.h)
	struct
	{
		u16	data;			// 0x10000040
		u16	error;			// 0x10000042 (read)
		u16 feature;		// 0x10000042 (write)
		u16	nsector;		// 0x10000044
		u16	sector;			// 0x10000046
		u16	lcyl;			// 0x10000048
		u16	hcyl;			// 0x1000004A
		u16	select;			// 0x1000004C
		u16	status;			// 0x1000004E (read)
		u16 command;		// 0x1000004E (write)
		u16	control;		// 0x1000005C (read : alternate status)

	} ata_regs;

	// HDD settings
	u16 xfer_mode;
	int smart_on;
	u16 if_ctrl;

	// For PIO transfers
	u16 pio_buf[256];
	int pio_size;
	int pio_count;

} dev9;

// Some defines from PS2SDK (atahw.h)

#define ATA_ERR_MARK		0x01
#define ATA_ERR_TRACK0		0x02
#define ATA_ERR_ABORT		0x04
#define ATA_ERR_MCR			0x08
#define ATA_ERR_ID			0x10
#define ATA_ERR_MC			0x20
#define ATA_ERR_ECC			0x40
#define ATA_ERR_ICRC		0x80

#define ATA_STAT_ERR		0x01
#define ATA_STAT_INDEX		0x02
#define ATA_STAT_ECC		0x04
#define	ATA_STAT_DRQ		0x08
#define ATA_STAT_SEEK		0x10
#define ATA_STAT_WRERR		0x20
#define ATA_STAT_READY		0x40
#define ATA_STAT_BUSY		0x80

// Reg names

// DEV9 Regs
/*
#define REG_DEV9_REV

// ATA Regs

#define REG_ATA_DATA			0x10000040
#define REG_ATA_ERROR			0x10000042
#define REG_ATA_NSECTOR			0x10000044
#define REG_ATA_SECTOR			0x10000046
#define REG_ATA_LCYL			0x10000048
#define REG_ATA_HCYL			0x1000004A
#define REG_ATA_SELECT			0x1000004C
#define REG_ATA_STATUS			0x1000004E
#define REG_ATA_CTRL			0x1000005C
*/
//

void SysMessage(char *, ...);

void ConfDlg();
void AboutDlg();

void LoadConf();
void SaveConf();