#include <stdio.h>
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include "dev9.h"
#include "resource.h"

HINSTANCE hInst;

void SysMessage(char *txt, ...)
{
	va_list list;
	char tmp[512];

	va_start(list, txt);
	vsprintf(tmp, txt, list);
	va_end(list);

	MessageBox(0, tmp, "MegaDev9 Msg", 0);
}

void WritePrivateProfileInt(char *section, char* key, int val, char *filename)
{
	char buf[64];

	itoa(val, buf, 10);
	WritePrivateProfileString(section, key, buf, filename);
}

void SaveConf()
{
	WritePrivateProfileInt("Version", "Version", 10, "inis/MegaDev9.ini");					// Increase it with each version !!!

	WritePrivateProfileInt("General settings", "Logging", config.log, "inis/MegaDev9.ini");

	WritePrivateProfileInt("HDD settings", "HDD file size", config.hddSize, "inis/MegaDev9.ini");
	WritePrivateProfileString("HDD settings", "HDD file name", config.hddFile, "inis/MegaDev9.ini");
}

void LoadConf()
{
	int version = GetPrivateProfileInt("Version", "Version", 0, "inis/MegaDev9.ini");
	if(version != 10)																		// Increase it with each version !!!
	{
		config.log = 0;

		config.hddSize = 8;
		strcpy(config.hddFile, "dev9hdd.raw");

		SaveConf();
		return;
	}

	config.log = GetPrivateProfileInt("General settings", "Logging", 0, "inis/MegaDev9.ini");

	config.hddSize = GetPrivateProfileInt("HDD settings", "HDD file size", 0, "inis/MegaDev9.ini");
	GetPrivateProfileString("HDD settings", "HDD file name", "dev9hdd.raw", config.hddFile, sizeof(config.hddFile), "inis/MegaDev9.ini");
}

BOOL APIENTRY ConfDlgProc(HWND hw, UINT msg, WPARAM wp, LPARAM lp)
{
	char buf[256];
	OPENFILENAME ofn;

	switch(msg)
	{
	case WM_INITDIALOG:
		LoadConf();

		CheckDlgButton(hw, IDC_LOG, config.log);

		SendDlgItemMessage(hw, IDC_HDDSIZEUD, UDM_SETRANGE, 0, MAKELONG(127, 1));
		SendDlgItemMessage(hw, IDC_HDDSIZEUD, UDM_SETBUDDY, (WPARAM)(HWND)GetDlgItem(hw, IDC_HDDSIZE), 0);
		SendDlgItemMessage(hw, IDC_HDDSIZEUD, UDM_SETPOS, 0, MAKELONG(config.hddSize, 0));
		SetWindowText(GetDlgItem(hw, IDC_HDDFILE), config.hddFile);

		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wp))
		{
		case IDOK:
			config.log = IsDlgButtonChecked(hw, IDC_LOG);

			GetWindowText(GetDlgItem(hw, IDC_HDDSIZE), buf, 256);
			config.hddSize = max(atoi(buf), 8);
			GetWindowText(GetDlgItem(hw, IDC_HDDFILE), buf, 256);
			strcpy(config.hddFile, buf);

			SaveConf();

		case IDCANCEL:
			EndDialog(hw, TRUE);
			return TRUE;

		case IDC_HDDFILEBROWSE:
			memset(&ofn, 0, sizeof(ofn));

			ofn.lStructSize = sizeof(ofn);
			ofn.Flags = OFN_NOCHANGEDIR;
			ofn.hInstance = hInst;
			ofn.hwndOwner = hw;
			ofn.lpstrDefExt = "raw";
			ofn.lpstrFile = "dev9hdd.raw";
			ofn.lpstrFilter = "Raw image (*.raw)\0*.raw\0";
			ofn.nMaxFile = MAX_PATH;
			ofn.lpstrTitle = "Select HDD image path...";

			if(GetSaveFileName(&ofn))
			{
				strcpy(buf, ofn.lpstrFile);

				SetWindowText(GetDlgItem(hw, IDC_HDDFILE), buf);
				strcpy(config.hddFile, buf);
			}

			return TRUE;

		case IDC_HDDSIZE:
			switch(HIWORD(wp))
			{
			case EN_UPDATE:
				GetWindowText(GetDlgItem(hw, IDC_HDDSIZE), buf, sizeof(buf));
				SendDlgItemMessage(hw, IDC_HDDSIZEUD, UDM_SETPOS, 0, MAKELONG(atoi(buf), 0));

				return TRUE;
			}

			return TRUE;
		}

		return TRUE;
	}

	return FALSE;
}

void ConfDlg()
{
	DialogBox(hInst, MAKEINTRESOURCE(IDD_CONFIG), 0, ConfDlgProc);
}

void AboutDlg()
{
	SysMessage("MegaDev9 Plugin by NHerv\nDEV9 plugin for HDD");
}

BOOL APIENTRY DllMain(HINSTANCE instance, DWORD reason, LPVOID reserved)
{
	hInst = instance;

	return TRUE;
}