#include <allegro.h>
#include "mem.h"
#include "video.h"
#include "gba.h"
#include "2xsai.h"

typedef struct RGB2
{
        int r,g,b;
} RGB2;

int bllookup[32][256];
int disbg=0;
BITMAP *b,*vb,*bx,*bx2[3],*bx2x;
PALETTE vpal,spal;
unsigned short tlook[256],slook[256],look15[65536];
unsigned long vbuf[5][1024];

unsigned short xlookup2[4][128],ylookup2[4][128];

int mosaicx=0,mosaicy=0,lastmy=0;

int bgsize[4]={128<<8,256<<8,512<<8,1024<<8};

void initvideo()
{
        int r,g,b,c;
        allegro_init();
        set_color_depth(desktop_color_depth());
        set_gfx_mode(GFX_AUTODETECT_WINDOWED,960,640,0,0);
        vb=create_video_bitmap(480,320);
        set_color_depth(16);
        Init_2xSaI(16);
        bx=create_bitmap(512+64+8+64,256+64+8+64);
        bx2x=create_bitmap(480,320);
        bx2[0]=create_bitmap(512+64+8+64,256+64+8+64);
        bx2[1]=create_bitmap(512+64+8+64,256+64+8+64);
        bx2[2]=create_bitmap(512+64+8+64,256+64+8+64);
        set_color_depth(8);
        b=create_bitmap(512+64,256+64);
        set_color_depth(16);
        for (c=0;c<65536;c++)
        {
                r=c&31;
                g=(c>>5)&31;
                b=(c>>10)&31;
                look15[c]=makecol(r*8,g*8,b*8);
        }
        for (c=0;c<128;c++)
        {
                xlookup2[0][c]=c&15;
                xlookup2[1][c]=c&31;
                xlookup2[2][c]=c&63;
                xlookup2[3][c]=c&127;
                ylookup2[0][c]=(c&15)*16;
                ylookup2[1][c]=(c&31)*32;
                ylookup2[2][c]=(c&63)*64;
                ylookup2[3][c]=(c&127)*128;
//                printf("%02X : %04X %04X\n",c,xlookup2[2][c],ylookup2[2][c]);
        }
        printf("Xlookup %i %i %i\n",xlookup2[1][0],xlookup2[1][8],xlookup2[1][15]);
        for (c=0;c<32;c++)
        {
                for (r=0;r<256;r++)
                {
                        if (c>15) bllookup[c][r]=r<<2;
                        else      bllookup[c][r]=((r<<2)*c)/16;
                }
        }
}

int oamsize[4][4][2]=
{
        {
                {8,8},{16,16},{32,32},{64,64}
        },
        {
                {16,8},{32,8},{32,16},{64,32}
        },
        {
                {8,16},{8,32},{16,32},{32,64}
        },
        {
                {8,8},{16,16},{32,32},{64,64}
        }
};

/*Lookup tables for address calculations*/
unsigned short ylookup[4][64]=
{
        {0x000,0x020,0x040,0x060,0x080,0x0A0,0x0C0,0x0E0,
         0x100,0x120,0x140,0x160,0x180,0x1A0,0x1C0,0x1E0,
         0x200,0x220,0x240,0x260,0x280,0x2A0,0x2C0,0x2E0,
         0x300,0x320,0x340,0x360,0x380,0x3A0,0x3C0,0x3E0,
         0x000,0x020,0x040,0x060,0x080,0x0A0,0x0C0,0x0E0,
         0x100,0x120,0x140,0x160,0x180,0x1A0,0x1C0,0x1E0,
         0x200,0x220,0x240,0x260,0x280,0x2A0,0x2C0,0x2E0,
         0x300,0x320,0x340,0x360,0x380,0x3A0,0x3C0,0x3E0},
        {0x000,0x020,0x040,0x060,0x080,0x0A0,0x0C0,0x0E0,
         0x100,0x120,0x140,0x160,0x180,0x1A0,0x1C0,0x1E0,
         0x200,0x220,0x240,0x260,0x280,0x2A0,0x2C0,0x2E0,
         0x300,0x320,0x340,0x360,0x380,0x3A0,0x3C0,0x3E0,
         0x000,0x020,0x040,0x060,0x080,0x0A0,0x0C0,0x0E0,
         0x100,0x120,0x140,0x160,0x180,0x1A0,0x1C0,0x1E0,
         0x200,0x220,0x240,0x260,0x280,0x2A0,0x2C0,0x2E0,
         0x300,0x320,0x340,0x360,0x380,0x3A0,0x3C0,0x3E0},
        {0x000,0x020,0x040,0x060,0x080,0x0A0,0x0C0,0x0E0,
         0x100,0x120,0x140,0x160,0x180,0x1A0,0x1C0,0x1E0,
         0x200,0x220,0x240,0x260,0x280,0x2A0,0x2C0,0x2E0,
         0x300,0x320,0x340,0x360,0x380,0x3A0,0x3C0,0x3E0,
         0x400,0x420,0x440,0x460,0x480,0x4A0,0x4C0,0x4E0,
         0x500,0x520,0x540,0x560,0x580,0x5A0,0x5C0,0x5E0,
         0x600,0x620,0x640,0x660,0x680,0x6A0,0x6C0,0x6E0,
         0x700,0x720,0x740,0x760,0x780,0x7A0,0x7C0,0x7E0},
        {0x000,0x020,0x040,0x060,0x080,0x0A0,0x0C0,0x0E0,
         0x100,0x120,0x140,0x160,0x180,0x1A0,0x1C0,0x1E0,
         0x200,0x220,0x240,0x260,0x280,0x2A0,0x2C0,0x2E0,
         0x300,0x320,0x340,0x360,0x380,0x3A0,0x3C0,0x3E0,
         0x800,0x820,0x840,0x860,0x880,0x8A0,0x8C0,0x8E0,
         0x900,0x920,0x940,0x960,0x980,0x9A0,0x9C0,0x9E0,
         0xA00,0xA20,0xA40,0xA60,0xA80,0xAA0,0xAC0,0xAE0,
         0xB00,0xB20,0xB40,0xB60,0xB80,0xBA0,0xBC0,0xBE0}
};

unsigned short xlookup[2][64]=
{
        {0x000,0x001,0x002,0x003,0x004,0x005,0x006,0x007,
         0x008,0x009,0x00A,0x00B,0x00C,0x00D,0x00E,0x00F,
         0x010,0x011,0x012,0x013,0x014,0x015,0x016,0x017,
         0x018,0x019,0x01A,0x01B,0x01C,0x01D,0x01E,0x01F,
         0x000,0x001,0x002,0x003,0x004,0x005,0x006,0x007,
         0x008,0x009,0x00A,0x00B,0x00C,0x00D,0x00E,0x00F,
         0x010,0x011,0x012,0x013,0x014,0x015,0x016,0x017,
         0x018,0x019,0x01A,0x01B,0x01C,0x01D,0x01E,0x01F},
        {0x000,0x001,0x002,0x003,0x004,0x005,0x006,0x007,
         0x008,0x009,0x00A,0x00B,0x00C,0x00D,0x00E,0x00F,
         0x010,0x011,0x012,0x013,0x014,0x015,0x016,0x017,
         0x018,0x019,0x01A,0x01B,0x01C,0x01D,0x01E,0x01F,
         0x400,0x401,0x402,0x403,0x404,0x405,0x406,0x407,
         0x408,0x409,0x40A,0x40B,0x40C,0x40D,0x40E,0x40F,
         0x410,0x411,0x412,0x413,0x414,0x415,0x416,0x417,
         0x418,0x419,0x41A,0x41B,0x41C,0x41D,0x41E,0x41F},
};

int skf=0;

void drawsprites(int pri)
{
        int c,x,y;
        int type,tile;
        int xf,yf;
        int col,addr;
        int size;
        int tx,ty;
        int xx,yy,x3,y3;
        int ox,oy;
        signed short dx,dy,dmx,dmy;
        unsigned char temp;
        int yoff;
        int xs,ys;
        if (disbg&0x10) return;
        for (c=508;c>=0;c-=4)
        {
//                if (((oam[c+2]>>10)&3)!=pri) continue;
                y=(oam[c]&255)+64;
                x=((oam[c+1]+64)&511);
                y&=255;
//                if (y>(160+64)) y-=256;
                if ((!(oam[c]&0x200) || oam[c]&0x100) && ((oam[c+2]>>10)&3)==pri)
                {
                        size=oam[c+1]>>14;
                        type=oam[c]>>14;
                        tile=oam[c+2]&0x3FF;
/*                        if (oam[c]&0x100)
                        {
                                x+=oamsize[type][size][0]/2;
                                y+=oamsize[type][size][1]/2;
                        }*/
                        if (oam[c]&0x100)
                        {
//                                oam[c]|=0x200;
                                        tx=(tile&31)>>1;
                                        ty=(tile>>5)&31;
                                        addr=(ty*16*64)+(tx*64)+0x10000;
//                                        printf("Normal addr %05X ",addr);
xs=oamsize[type][size][0];
ys=oamsize[type][size][1];
if (oam[c]&0x200) { xs*=2; ys*=2; }
                                addr=(oam[c+1]>>9)&31;
                                addr=(addr*32)+6;
                                dx=oam[addr>>1];
                                dmx=oam[(addr+8)>>1];
                                dy=oam[(addr+16)>>1];
                                dmy=oam[(addr+24)>>1];
                                
                                        x3=(xs/2);
                                        y3=(ys/2);
//                                if (oam[c]&0x200) { x3=xs/4; y3=ys/4; }
                                yoff=oamsize[type][size][0]*4;
                                if (oam[c]&0x2000) yoff*=2;
                                tx=((oamsize[type][size][0]/2)*256)-((dx*x3)+(dmx*y3));
                                ty=((oamsize[type][size][1]/2)*256)-((dy*x3)+(dmy*y3));
//                                tx*=256; ty*=256;
                                ox=x; oy=y;
                                                xf=((tx>>11)+tile)&31;
                                                yf=((ty>>11)+(tile>>5))&31;
                                                col=(oam[c+2]>>8)&0xF0;
                                addr=(yf*32*32)+(xf*32)+0x10000;
//                                printf("Start addr - %05X  %i %i  %04X  %i %i\n",addr,tx,ty,oam[c]&0x2000,tx/256,ty/256);
//                                printf("%i %i %i  ",x3,(dx*x3)/256,(dmx*y3)/256);
//                                printf("%i %i %i %08X %03X\n",y3,(dy*x3)/256,(dmy*y3)/256,dy,oam[c]&0x200);
                                for (y=0;y<ys;y++)
                                {
                                        xx=tx; yy=ty;
                                        if (oam[c]&0x2000)
                                        {
                                                for (x=0;x<xs;x++)
                                                {
//                                                      printf("Sprite %i X %i Y %i %i %i\n",c,x,y,oamsize[type][size][0],oamsize[type][size][1]);
                                                        xf=((xx>>11)+(tile>>1))&15;
                                                        if (lcd.ctrl&0x40) yf=(tile>>5)&31;
                                                        else               yf=((yy>>11)+(tile>>5))&31;
        //                                                printf("XX %i YY %i XF %i YF %i %02X %i %i  ",xx/256,yy/256,xf,yf,lcd.ctrl&0x40,tile&31,(tile>>5)&31);
        //                                                if (lcd.ctrl&0x40) addr=(yf*32*32)+(xf*32)+0x10000;
                                                        /*else               */
                                                        if (lcd.ctrl&0x40) addr=(yf*32*32)+(xf*64)+(((yy>>11)&31)*yoff)+0x10000;
                                                        else               addr=(yf*32*32)+(xf*64)+0x10000;
        //                                                printf("%04X\n",addr);
                                                        temp=vramb[addr+((xx>>8)&7)+(((yy>>8)&7)*8)];
                                                        if (xx<0 || yy<0 || ((xx/256)>=oamsize[type][size][0]) || ((yy/256)>=oamsize[type][size][1])) temp=0;
                                                        if (temp) ((unsigned short *)bx->line[oy+y])[ox+x]=slook[temp];
                                                        xx+=dx;
                                                        yy+=dy;
                                                        if (x==(xs/2) && y==(ys/2)) ((unsigned short *)bx->line[oy+y])[ox+x]=0x7FFF;
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<xs;x++)
                                                {
                                                        xf=((xx>>11)+tile)&31;
                                                        if (lcd.ctrl&0x40) yf=(tile>>5)&31;
                                                        else               yf=((yy>>11)+(tile>>5))&31;
                                                        if (lcd.ctrl&0x40) addr=(yf*32*32)+(xf*32)+((yy>>11)*yoff)+0x10000;
                                                        else               addr=(yf*32*32)+(xf*32)+0x10000;
                                                        temp=vramb[addr+((xx>>9)&3)+(((yy>>8)&7)*4)];
                                                        if (xx&0x100) temp>>=4;
                                                        temp&=15;
                                                        if (xx<0 || yy<0 || ((xx/256)>=oamsize[type][size][0]) || ((yy/256)>=oamsize[type][size][1])) temp=0;
                                                        if (temp) ((unsigned short *)bx->line[oy+y])[ox+x]=slook[temp|col];
                                                        xx+=dx;
                                                        yy+=dy;
                                                }
                                        }
                                        tx+=dmx;
                                        ty+=dmy;
                                        
                                }
                        }
                        else
                        {
                                xf=(oam[c+1]&0x1000)?(oamsize[type][size][0]-1):0;
                                yf=(oam[c+1]&0x2000)?(oamsize[type][size][1]-1):0;

                                if (oam[c]&0x2000)
                                {
                                        tx=(tile&31)>>1;
                                        ty=(tile>>5)&31;
                                        if (lcd.ctrl&0x40) addr=(ty*16*64)+(tx*64)+0x10000;
                                        for (yy=0;yy<oamsize[type][size][1];yy+=8)
                                        {
                                                if (!(lcd.ctrl&0x40)) addr=((ty+(yy>>3))*16*64)+(tx*64)+0x10000;
                                                for (xx=0;xx<oamsize[type][size][0];xx+=8)
                                                {
                                                        for (y3=0;y3<8;y3++)
                                                        {
                                                                for (x3=0;x3<8;x3++)
                                                                {
                                                                        if (vramb[addr]) ((unsigned short *)bx->line[y+((yy+y3)^yf)])[x+((xx+x3)^xf)]=slook[vramb[addr]];
                                                                        addr++;
                                                                }
                                                        }
                                                }
                                        }
                                }
                                else
                                {
                                        tx=(tile&31);
                                        ty=(tile>>5)&31;
                                        col=(oam[c+2]>>8)&0xF0;
                                        if (lcd.ctrl&0x40) addr=(ty*32*32)+(tx*32)+0x10000;
                                        for (yy=0;yy<oamsize[type][size][1];yy+=8)
                                        {
                                                if (!(lcd.ctrl&0x40)) addr=((ty+(yy>>3))*32*32)+(tx*32)+0x10000;
                                                for (xx=0;xx<oamsize[type][size][0];xx+=8)
                                                {
                                                        for (y3=0;y3<8;y3++)
                                                        {
                                                                for (x3=0;x3<8;x3+=2)
                                                                {
                                                                        if (vramb[addr]&0xF) ((unsigned short *)bx->line[y+((yy+y3)^yf)])[x+((xx+x3)^xf)]=slook[(vramb[addr]&0xF)|col];
                                                                        if (vramb[addr]>>4)  ((unsigned short *)bx->line[y+((yy+y3)^yf)])[x+((xx+x3+1)^xf)]=slook[(vramb[addr]>>4)|col];
                                                                        addr++;
                                                                }
                                                        }
                                                }
                                        }
                                }
                        }
//                        rectfill(b,x,y,x+oamsize[type][size][0],y+oamsize[type][size][1],makecol(255,255,255));
                }
        }
}

void drawvideo()
{
        int x,y,addr=getbase(),xx,yy;
        int c;
        int type,size,tile;
        int tx,ty;
        int x3,y3;
        int xf,yf;
        int tempx,tempy;
        int col;
        unsigned short chraddr,bgaddr;
        int first=1;
        int xoff,yoff;
        int pri;
        if (palchange)
        {
                palchange=0;
                for (x=0;x<256;x++)
                {
                        vpal[x].r=(pal[x]&31)<<1;
                        vpal[x].g=((pal[x]>>5)&31)<<1;
                        vpal[x].b=((pal[x]>>10)&31)<<1;
                        tlook[x]=makecol(vpal[x].r<<2,vpal[x].g<<2,vpal[x].b<<2);
                }
                for (x=0;x<256;x++)
                {
                        spal[x].r=(pal[x+256]&31)<<1;
                        spal[x].g=((pal[x+256]>>5)&31)<<1;
                        spal[x].b=((pal[x+256]>>10)&31)<<1;
                        slook[x]=makecol(spal[x].r<<2,spal[x].g<<2,spal[x].b<<2);
                }
 //               set_palette(vpal);
        }
//        set_palette(vpal);
        switch (lcd.ctrl&7)
        {
                case 0: 
                clear_to_color(bx,tlook[0]); first=0;
                for (pri=3;pri>=0;pri--)
                {
                        for (c=3;c>=0;c--)
                        {
                                if (!(lcd.ctrl&(0x100<<c))) continue;
                                if ((lcd.bgctrl[c]&3)!=pri) continue;
                                if (disbg & (1<<c)) continue;
                                bgaddr=((lcd.bgctrl[c]>>8)&31)*2048;
                                chraddr=((lcd.bgctrl[c]>>2)&3)*16384;
                                xoff=64-(lcd.xscroll[c]&7);
                                yoff=64-(lcd.yscroll[c]&7);
//                                printf("BG%i %04X %04X %04X\n",c,bgaddr,chraddr,lcd.bgctrl[c]);
                                for (y=0;y<168;y+=8)
                                {
                                        if (lcd.bgctrl[c]&0x80)
                                        {
                                                for (x=0;x<248;x+=8)
                                                {
                                                        addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((y+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                        tile=vramb[addr]|(vramb[addr+1]<<8);
                                                        addr+=2;
                                                        xf=(tile&0x400)?7:0;
                                                        yf=(tile&0x800)?7:0;
                                                        tile&=0x3FF;
                                                        tile=((tile*64)+chraddr)&0xFFFF;
                                                        for (yy=0;yy<8;yy++)
                                                        {
                                                                for (xx=0;xx<8;xx++)
                                                                {
                                                                        if (vramb[tile] || first) ((unsigned short *)bx->line[y+(yy^yf)+yoff])[x+(xx^xf)+xoff]=tlook[vramb[tile]];
                                                                        tile++;
                                                                }
                                                        }
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<248;x+=8)
                                                {
                                                        addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((y+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                        tile=vramb[addr]|(vramb[addr+1]<<8);
                                                        addr+=2;
                                                        xf=(tile&0x400)?7:0;
                                                        yf=(tile&0x800)?7:0;
                                                        col=(tile>>8)&0xF0;
                                                        tile&=0x3FF;
                                                        tile=((tile*32)+chraddr)&0xFFFF;
                                                        for (yy=0;yy<8;yy++)
                                                        {
                                                                for (xx=0;xx<8;xx+=2)
                                                                {
                                                                        if (vramb[tile]&0xF || first) ((unsigned short *)bx->line[y+(yy^yf)+yoff])[x+(xx^xf)+xoff]=tlook[(vramb[tile]&0xF)|col];
                                                                        if (vramb[tile]>>4  || first) ((unsigned short *)bx->line[y+(yy^yf)+yoff])[x+((xx+1)^xf)+xoff]=tlook[(vramb[tile]>>4)|col];
                                                                        tile++;
                                                                }
                                                        }
                                                }
                                        }
                                }
                                first=0;
                        }
//                        printf("Drawsprites %i\n",pri);
                        drawsprites(pri);
                }
                break;
                case 1:
                clear_to_color(bx,tlook[0]); first=0;
                for (pri=3;pri>=0;pri--)
                {
                        for (c=2;c>=0;c--)
                        {
                                if (!(lcd.ctrl&(0x100<<c))) continue;
                                if ((lcd.bgctrl[c]&3)!=pri) continue;
                                if (disbg & (1<<c)) continue;
                                if (c<2)
                                {
                                        bgaddr=((lcd.bgctrl[c]>>8)&31)*2048;
                                        chraddr=((lcd.bgctrl[c]>>2)&3)*16384;
                                        xoff=64-(lcd.xscroll[c]&7);
                                        yoff=64-(lcd.yscroll[c]&7);
                                        for (y=0;y<168;y+=8)
                                        {
                                                if (lcd.bgctrl[c]&0x80)
                                                {
                                                        for (x=0;x<248;x+=8)
                                                        {
                                                                addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((y+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                                tile=vramb[addr]|(vramb[addr+1]<<8);
                                                                addr+=2;
                                                                xf=(tile&0x400)?7:0;
                                                                yf=(tile&0x800)?7:0;
                                                                tile&=0x3FF;
                                                                tile=((tile*64)+chraddr)&0xFFFF;
                                                                for (yy=0;yy<8;yy++)
                                                                {
                                                                        for (xx=0;xx<8;xx++)
                                                                        {
                                                                                if (vramb[tile] || first) ((unsigned short *)bx->line[y+(yy^yf)+yoff])[x+(xx^xf)+xoff]=tlook[vramb[tile]];
                                                                                tile++;
                                                                        }
                                                                }
                                                        }
                                                }
                                                else
                                                {
                                                        for (x=0;x<248;x+=8)
                                                        {
                                                                addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((y+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                                tile=vramb[addr]|(vramb[addr+1]<<8);
                                                                addr+=2;
                                                                xf=(tile&0x400)?7:0;
                                                                yf=(tile&0x800)?7:0;
                                                                col=(tile>>8)&0xF0;
                                                                tile&=0x3FF;
                                                                tile=((tile*32)+chraddr)&0xFFFF;
                                                                for (yy=0;yy<8;yy++)
                                                                {
                                                                        for (xx=0;xx<8;xx+=2)
                                                                        {
                                                                                if (vramb[tile]&0xF || first) ((unsigned short *)bx->line[y+(yy^yf)+yoff])[x+(xx^xf)+xoff]=tlook[(vramb[tile]&0xF)|col];
                                                                                if (vramb[tile]>>4  || first) ((unsigned short *)bx->line[y+(yy^yf)+yoff])[x+((xx+1)^xf)+xoff]=tlook[(vramb[tile]>>4)|col];
                                                                                tile++;
                                                                        }
                                                                }
                                                        }
                                                }
                                        }
                                }
                                else
                                {
                                        bgaddr=((lcd.bgctrl[c]>>8)&31)*2048;
                                        chraddr=((lcd.bgctrl[c]>>2)&3)*16384;
                                        tempx=lcd.bg2x; tempy=lcd.bg2y;
                                        for (y=0;y<160;y++)
                                        {
                                                xx=tempx; yy=tempy;
                                                for (x=0;x<240;x++)
                                                {
                                                        addr=bgaddr+((ylookup2[lcd.bgctrl[c]>>14][(yy>>11)&127]+xlookup2[lcd.bgctrl[c]>>14][(xx>>11)&127]));
                                                        tile=((vramb[addr]*64)+chraddr+((xx>>8)&7)+(((yy>>8)&7)*8))&0xFFFF;
                                                        if (vramb[tile]) ((unsigned short *)bx->line[y+64])[x+64]=tlook[vramb[tile]];
                                                        xx+=lcd.dx[0];
                                                        yy+=lcd.dy[0];
                                                }
                                                tempx+=lcd.dmx[0];
                                                tempy+=lcd.dmy[0];
                                        }
/*                                        for (y=0;y<160;y+=8)
                                        {
                                                for (x=0;x<240;x+=8)
                                                {
                                                        addr=bgaddr+((ylookup2[lcd.bgctrl[c]>>14][(y>>3)&127]+xlookup2[(lcd.bgctrl[c]>>14)&1][(x>>3)&127]));
                                                        tile=((vramb[addr]*64)+chraddr)&0xFFFF;
//                                                        rpclog("%03i %03i %04X %04X %02X\n",x,y,addr,tile,vramb[addr]);
                                                        for (yy=0;yy<8;yy++)
                                                                {
                                                                        for (xx=0;xx<8;xx++)
                                                                        {
                                                                                if (vramb[tile] || first) ((unsigned short *)bx->line[y+yy+64])[x+xx+64]=tlook[vramb[tile]];
                                                                                tile++;
                                                                        }
                                                                }
                                                }
                                        }*/
                                }
                                first=0;
                        }
//                        printf("Drawsprites %i\n",pri);
                        drawsprites(pri);
                }
                break;
                case 3:
                addr=0;
                for (y=0;y<160;y++)
                {
                        for (x=0;x<240;x++)
                        {
                                ((unsigned short *)bx->line[y+64])[x+64]=look15[vramw[addr++]];
                        }
                }
                drawsprites(3);
                drawsprites(2);
                drawsprites(1);
                drawsprites(0);
                break;
                case 4:
//                if (lcd.ctrl&0x10) addr+=(240*160);
                for (y=0;y<160;y++)
                {
                        for (x=0;x<240;x++)
                        {
                                ((unsigned short *)bx->line[y+64])[x+64]=tlook[vramb[addr++]];
                        }
                }
                drawsprites(3);
                drawsprites(2);
                drawsprites(1);
                drawsprites(0);
                break;
                case 5:
                clear_to_color(bx,tlook[0]);
                addr>>=1;
                for (y=16;y<144;y++)
                {
                        for (x=40;x<200;x++)
                        {
                                ((unsigned short *)bx->line[y+64])[x+64]=look15[vramw[addr++]];
                        }
                }
                drawsprites(3);
                drawsprites(2);
                drawsprites(1);
                drawsprites(0);
                break;
                default: clear_to_color(bx,tlook[0]);
                drawsprites(3);
                drawsprites(2);
                drawsprites(1);
                drawsprites(0);
        }
//        blit(bx,vb,0,0,0,0,240,160);
//        clear(bx);
//        set_palette(spal);
startblit();
        blit(bx,vb,64,64,0,0,240,160);
/*        for (y=0;y<32;y++)
        {
                for (x=0;x<16;x++)
                {
                        addr=(y*16)+x;
                        addr=0x10000+(addr*64);
                        for (yy=0;yy<8;yy++)
                        {
                                for (xx=0;xx<8;xx++)
                                {
                                        b->line[(y<<3)+yy][(x<<3)+xx]=vramb[addr];//>>4;
//                                        b->line[(y<<3)+yy][(x<<3)+xx+1]=vramb[addr]&0xF;
                                        addr++;
                                }
                        }
                        
                }
        }
        blit(b,vb,0,0,256,0,256,256);*/
        stretch_blit(vb,screen,0,0,240,160,0,0,480,320);
endblit();
}

void drawspritesline(int pri, int l, unsigned short *buf)
{
        int c,x,y;
        int type,tile;
        int xf,yf;
        int col,addr;
        int size;
        int tx,ty;
        int xx,yy,x3,y3;
        int ox,oy;
        signed short dx,dy,dmx,dmy;
        unsigned char temp;
        int yoff;
        int xs,ys;
        if (disbg&0x10) return;
        l+=64;
        for (c=508;c>=0;c-=4)
        {
//                if (((oam[c+2]>>10)&3)!=pri) continue;
                y=(oam[c]&255)+64;
                x=((oam[c+1]+64)&511);
                y&=255;
//                if (y>(160+64)) y-=256;
                if ((!(oam[c]&0x200) || oam[c]&0x100) && ((oam[c+2]>>10)&3)==pri)
                {
                        size=oam[c+1]>>14;
                        type=oam[c]>>14;
                        tile=oam[c+2]&0x3FF;
                        if (oam[c]&0x100)
                        {
//                                oam[c]|=0x200;
                                        tx=(tile&31)>>1;
                                        ty=(tile>>5)&31;
                                        addr=(ty*16*64)+(tx*64)+0x10000;
//                                        printf("Normal addr %05X ",addr);
xs=oamsize[type][size][0];
ys=oamsize[type][size][1];
if (oam[c]&0x200) { xs*=2; ys*=2; }
                                if ((l-y) < 0 || (l-y)>=ys) continue;
                                addr=(oam[c+1]>>9)&31;
                                addr=(addr*32)+6;
                                dx=oam[addr>>1];
                                dmx=oam[(addr+8)>>1];
                                dy=oam[(addr+16)>>1];
                                dmy=oam[(addr+24)>>1];

                                        x3=(xs/2);
                                        y3=(ys/2);
                                yoff=oamsize[type][size][0]*4;
                                if (oam[c]&0x2000) yoff*=2;
                                tx=((oamsize[type][size][0]/2)*256)-((dx*x3)+(dmx*y3));
                                ty=((oamsize[type][size][1]/2)*256)-((dy*x3)+(dmy*y3));
                                ox=x; oy=y;
                                                xf=((tx>>11)+tile)&31;
                                                yf=((ty>>11)+(tile>>5))&31;
                                                col=(oam[c+2]>>8)&0xF0;
                                addr=(yf*32*32)+(xf*32)+0x10000;
                                tx+=(dmx*(l-y));
                                ty+=(dmy*(l-y));
                                y=l-y;
/*                                for (y=0;y<ys;y++)
                                {
                                        tx+=dmx;
                                        ty+=dmy;
                                        if ((oy+y)==l) break;
                                }*/
                                        xx=tx; yy=ty;
//                                        if ((oy+y)==l)
//                                        {
                                        if (oam[c]&0x2000)
                                        {
                                                for (x=0;x<xs;x++)
                                                {
                                                        xf=((xx>>11)+(tile>>1))&15;
                                                        if (lcd.ctrl&0x40) yf=(tile>>5)&31;
                                                        else               yf=((yy>>11)+(tile>>5))&31;
                                                        if (lcd.ctrl&0x40) addr=(yf*32*32)+(xf*64)+(((yy>>11)&31)*yoff)+0x10000;
                                                        else               addr=(yf*32*32)+(xf*64)+0x10000;
                                                        temp=vramb[addr+((xx>>8)&7)+(((yy>>8)&7)*8)];
                                                        if (xx<0 || yy<0 || ((xx/256)>=oamsize[type][size][0]) || ((yy/256)>=oamsize[type][size][1])) temp=0;
                                                        if (temp) buf[ox+x]=slook[temp];
                                                        xx+=dx;
                                                        yy+=dy;
//                                                        if (x==(xs/2) && y==(ys/2)) buf[ox+x]=0x7FFF;
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<xs;x++)
                                                {
                                                        xf=((xx>>11)+tile)&31;
                                                        if (lcd.ctrl&0x40) yf=(tile>>5)&31;
                                                        else               yf=((yy>>11)+(tile>>5))&31;
                                                        if (lcd.ctrl&0x40) addr=(yf*32*32)+(xf*32)+((yy>>11)*yoff)+0x10000;
                                                        else               addr=(yf*32*32)+(xf*32)+0x10000;
                                                        temp=vramb[addr+((xx>>9)&3)+(((yy>>8)&7)*4)];
                                                        if (xx&0x100) temp>>=4;
                                                        temp&=15;
                                                        if (xx<0 || yy<0 || ((xx/256)>=oamsize[type][size][0]) || ((yy/256)>=oamsize[type][size][1])) temp=0;
                                                        if (temp) buf[ox+x]=slook[temp|col];
                                                        xx+=dx;
                                                        yy+=dy;
                                                }
                                        }
//                                        }
//                                        tx+=dmx;
//                                        ty+=dmy;
//                                }
                        }
                        else if (!(oam[c]&0x200))
                        {
//                                if (l==64 && c==76) printf("%i : %i %i %i %i %i  %02X %03X\n",c,x,y,type,size,oamsize[type][size][0],lcd.ctrl&0x40,tile);
                                if ((l-y) < 0 || (l-y) >= oamsize[type][size][1]) continue;
                                xf=(oam[c+1]&0x1000)?(oamsize[type][size][0]-1):0;
                                yf=(oam[c+1]&0x2000)?(oamsize[type][size][1]-1):0;

                                if (oam[c]&0x2000)
                                {
                                        tx=(tile&31)>>1;
                                        ty=(tile>>5)&31;
                                        yy=(l-y)^yf;
                                        y3=yy&7;
                                        if (lcd.ctrl&0x40)
                                        {
                                                addr=(ty*16*64)+(tx*64)+0x10000+(y3*8)+((yy>>3)*oamsize[type][size][0]*8);
//                                                if (c==76) printf("Addr %04X %i %i\n",addr,yy,y3);
                                        }
                                        else               addr=((ty+(yy>>3))*16*64)+(tx*64)+0x10000+(y3*8);
                                        for (xx=0;xx<oamsize[type][size][0];xx+=8)
                                        {
                                                for (x3=0;x3<8;x3++)
                                                {
                                                        if (vramb[addr]) buf[x+((xx+x3)^xf)]=slook[vramb[addr]];
                                                        addr++;
                                                }
                                                addr+=56;
                                        }
                                }
                                else
                                {
                                        tx=tile&31;
                                        ty=(tile>>5)&31;
                                        col=(oam[c+2]>>8)&0xF0;
                                        yy=(l-y)^yf;
                                        y3=yy&7;
                                        if (lcd.ctrl&0x40) addr=(ty*16*64)+(tx*32)+0x10000+(y3*4)+((yy>>3)*oamsize[type][size][0]*4);
                                        else               addr=((ty+(yy>>3))*16*64)+(tx*32)+0x10000+(y3*4);
                                        for (xx=0;xx<oamsize[type][size][0];xx+=8)
                                        {
                                                for (x3=0;x3<8;x3+=2)
                                                {
                                                        if (vramb[addr]&0xF) buf[x+((xx+x3)^xf)]=slook[(vramb[addr]&0xF)|col];
                                                        if (vramb[addr]>>4 ) buf[x+((xx+x3+1)^xf)]=slook[(vramb[addr]>>4)|col];
                                                        addr++;
                                                }
                                                addr+=28;
                                        }
                                }
                        }
                }
        }
}

int objwind[1024];
int biggestframe;
void drawspritesline2(int l, unsigned long *buf)
{
        int c,x,y;
        int type,tile;
        int xf,yf;
        int col,addr;
        int size;
        int tx,ty;
        int xx,yy,x3,y3;
        int ox,oy;
        int pri;
        signed short dx,dy,dmx,dmy;
        unsigned char temp;
        int yoff;
        int xs,ys;
        int z=0;
        if (disbg&0x10) return;
        if (!(lcd.ctrl&0x1000)) return;
        l+=64;
        for (c=0;c<512;c++) objwind[c]=0;
        for (c=508;c>=0;c-=4)
        {
//                if (((oam[c+2]>>10)&3)!=pri) continue;
                y=(oam[c]&255)+64;
                x=((oam[c+1]+64)&511);
                y&=255;
//                if (l==64 && c==0x74) printf("%02X : %i,%i\n",c,x,y);
//                if (l==64 && c==0x94) printf("%02X : %i,%i\n",c,x,y);
//                if (y>(160+64)) y-=256;
                if ((!(oam[c]&0x200) || oam[c]&0x100) && !(!(oam[c+2]&0x200) && (lcd.ctrl&7)>=3))
                {
                        pri=(((oam[c+2]>>10)&3)<<11);
                        if (((oam[c]>>10)&3)==1) pri|=0x100;
                        if (((oam[c]>>10)&3)==2) pri|=0x200;
                        size=oam[c+1]>>14;
                        type=oam[c]>>14;
                        tile=oam[c+2]&0x3FF;
//                        if (tile==509) rpclog("Sprite 509 %04X %i\n",oam[c],c);
                        if (oam[c]&0x100)
                        {
//                                oam[c]|=0x200;
                                        tx=(tile&31)>>1;
                                        ty=(tile>>5)&31;
                                        addr=(ty*16*64)+(tx*64)+0x10000;
xs=oamsize[type][size][0];
ys=oamsize[type][size][1];
if (oam[c]&0x200) { xs*=2; ys*=2; }
//                        if (tile==509) rpclog("xSprite 509 %04X %i %i %i %i\n",oam[c],c,l,y,ys);
                                if ((l-y) < 0 || (l-y)>=ys) continue;
//                        if (tile==509) rpclog("zSprite 509 %04X %i\n",oam[c],c);
                                addr=(oam[c+1]>>9)&31;
                                addr=(addr*32)+6;
                                dx=oam[addr>>1];
                                dmx=oam[(addr+8)>>1];
                                dy=oam[(addr+16)>>1];
                                dmy=oam[(addr+24)>>1];

                                        x3=(xs/2);
                                        y3=(ys/2);
                                yoff=oamsize[type][size][0]*4;
                                if (oam[c]&0x2000) yoff*=2;
                                tx=((oamsize[type][size][0]/2)*256)-((dx*x3)+(dmx*y3));
                                ty=((oamsize[type][size][1]/2)*256)-((dy*x3)+(dmy*y3));
                                ox=x; oy=y;
                                                xf=((tx>>11)+tile)&31;
                                                yf=((ty>>11)+(tile>>5))&31;
                                                col=(oam[c+2]>>8)&0xF0;
                                addr=(yf*32*32)+(xf*32)+0x10000;
                                tx+=(dmx*(l-y));
                                ty+=(dmy*(l-y));
                                y=l-y;
/*                                for (y=0;y<ys;y++)
                                {
                                        tx+=dmx;
                                        ty+=dmy;
                                        if ((oy+y)==l) break;
                                }*/
                                        xx=tx; yy=ty;
//                                        if ((oy+y)==l)
//                                        {
                                        if (oam[c]&0x2000)
                                        {
                                                for (x=0;x<xs;x++)
                                                {
                                                        xf=((xx>>11)+(tile>>1))&15;
                                                        if (lcd.ctrl&0x40) yf=(tile>>5)&31;
                                                        else               yf=((yy>>11)+(tile>>5))&31;
                                                        if (lcd.ctrl&0x40) addr=(yf*32*32)+((xx>>11)*64)+((tile&0x1E)*32)+(((yy>>11)&31)*yoff)+0x10000;
                                                        else               addr=(yf*32*32)+(xf*64)+0x10000;
                                                        temp=vramb[addr+((xx>>8)&7)+(((yy>>8)&7)*8)];
                                                        if (xx<0 || yy<0 || ((xx/256)>=oamsize[type][size][0]) || ((yy/256)>=oamsize[type][size][1])) temp=0;
                                                        if (temp)
                                                        {
                                                                if (pri&0x200) objwind[ox+x]=1;
                                                                else           buf[ox+x]=temp|col|pri;
                                                        }
                                                        xx+=dx;
                                                        yy+=dy;
//                                                        if (x==(xs/2) && y==(ys/2)) buf[ox+x]=0x7FFF;
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<xs;x++)
                                                {
//                        if (tile==509) rpclog("ySprite 509 %04X %i\n",oam[c],c);
//                                                        if (tile==509) rpclog("%i %i xx %08X %08X %i %08X\n",x,c,xx,xx>>11,tile,((xx>>11)+tile));
                                                        xf=((xx>>11)+tile)&31;
                                                        if (lcd.ctrl&0x40) yf=(tile>>5)&31;
                                                        else               yf=((yy>>11)+(tile>>5))&31;
                                                        if (lcd.ctrl&0x40) addr=(yf*32*32)+((xx>>11)*32)+((tile&31)*32)+((yy>>11)*yoff)+0x10000;
                                                        else               addr=(yf*32*32)+(xf*32)+0x10000;
//                                                        if (tile==509) rpclog("xf %i yf %i addr %08X\n",xf,yf,addr);
                                                        temp=vramb[addr+((xx>>9)&3)+(((yy>>8)&7)*4)];
                                                        if (xx&0x100) temp>>=4;
                                                        temp&=15;
                                                        if (xx<0 || yy<0 || ((xx/256)>=oamsize[type][size][0]) || ((yy/256)>=oamsize[type][size][1])) temp=0;
                                                        if (temp)
                                                        {
                                                                if (pri&0x200) objwind[ox+x]=1;
                                                                else           buf[ox+x]=temp|col|pri;
                                                        }
                                                        xx+=dx;
                                                        yy+=dy;
                                                }
                                        }
//                                        }
//                                        tx+=dmx;
//                                        ty+=dmy;
//                                }
                        }
                        else if (!(oam[c]&0x200))
                        {
//                                if (l==64 && c==76) printf("%i : %i %i %i %i %i  %02X %03X\n",c,x,y,type,size,oamsize[type][size][0],lcd.ctrl&0x40,tile);
                                if ((l-y) < 0 || (l-y) >= oamsize[type][size][1]) continue;
                                xf=(oam[c+1]&0x1000)?(oamsize[type][size][0]-1):0;
                                yf=(oam[c+1]&0x2000)?(oamsize[type][size][1]-1):0;
                                if (oam[c]&0x2000)
                                {
                                        tx=(tile&31)>>1;
                                        ty=(tile>>5)&31;
                                        yy=(l-y)^yf;
                                        y3=yy&7;
                                        if (lcd.ctrl&0x40)
                                        {
                                                addr=/*(ty*0x200)+(tx*0x20)*/((tile&0x3FF)*32)+0x10000+(y3*8)+((yy>>3)*oamsize[type][size][0]*8);
//                                                if (c==76) printf("Addr %04X %i %i\n",addr,yy,y3);
                                        }
                                        else               addr=((ty+(yy>>3))*16*64)+(tx*64)+0x10000+(y3*8);
//                                        if ((addr&0xFF)!=0x40) return;
//                                        if (y3==0 && yy==0) printf("Addrx %04X %02X tile %03X\n",addr,lcd.ctrl&0x40,tile&0x3FF);
                                        for (xx=0;xx<oamsize[type][size][0];xx+=8)
                                        {
                                                for (x3=0;x3<8;x3++)
                                                {
                                                        if (vramb[addr])
                                                        {
                                                                if (pri&0x200) objwind[x+((xx+x3)^xf)]=1;
                                                                else           buf[x+((xx+x3)^xf)]=vramb[addr]|pri;
                                                        }
                                                        addr++;
                                                }
                                                if (lcd.ctrl&0x40) addr+=56;
                                                else
                                                {
                                                        tx++;
                                                        tx&=31;
                                                        addr=((ty+(yy>>3))*16*64)+(tx*64)+0x10000+(y3*8);
                                                }
                                        }
                                }
                                else
                                {
                                        tx=tile&31;
                                        ty=(tile>>5)&31;
                                        col=(oam[c+2]>>8)&0xF0;
                                        yy=(l-y)^yf;
                                        y3=yy&7;
                                        if (lcd.ctrl&0x40) addr=(ty*16*64)+(tx*32)+0x10000+(y3*4)+((yy>>3)*oamsize[type][size][0]*4);
                                        else               addr=((ty+(yy>>3))*16*64)+(tx*32)+0x10000+(y3*4);
//                                        printf("Addr %04X %02X\n",addr,lcd.ctrl&0x40);
                                        for (xx=0;xx<oamsize[type][size][0];xx+=8)
                                        {
                                                for (x3=0;x3<8;x3+=2)
                                                {
                                                        if (vramb[addr]&0xF)
                                                        {
                                                                if (pri&0x200) objwind[x+((xx+x3)^xf)]=1;
                                                                else           buf[x+((xx+x3)^xf)]=(vramb[addr]&0xF)|col|pri;
                                                        }
                                                        if (vramb[addr]>>4)
                                                        {
                                                                if (pri&0x200) objwind[x+((xx+x3+1)^xf)]=1;
                                                                else           buf[x+((xx+x3+1)^xf)]=(vramb[addr]>>4)|col|pri;
                                                        }
                                                        addr++;
                                                }
                                                if (lcd.ctrl&0x40) addr+=28;
                                                else
                                                {
                                                        tx++;
                                                        tx&=31;
                                                        addr=((ty+(yy>>3))*16*64)+(tx*32)+0x10000+(y3*4);
                                                }
                                        }
                                }
                        }
                }
        }
}

int window[304];
void drawline(int l)
{
        int c,pri;
        int col,col2;
        int xoff,yoff;
        int bgaddr,chraddr;
        int x;
        unsigned long xx,yy;
        int addr,tile;
        int xf,yf;
        int size;
        unsigned long *buf;
        int top,top2;
        RGB2 r,r2;
        unsigned long vcol[5];
        int lastmx=0;
        if (!l) mosaicy=lastmy=0;
        if (l==159)
        {
                skf++;
                if (skf==6) skf=0;
        }
        if (l>159) return;
        if (key[KEY_TILDE] && skf) return;
        if (palchange)
        {
                palchange=0;
                for (x=0;x<256;x++)
                {
                        vpal[x].r=(pal[x]&31)<<1;
                        vpal[x].g=((pal[x]>>5)&31)<<1;
                        vpal[x].b=((pal[x]>>10)&31)<<1;
                        tlook[x]=makecol(vpal[x].r<<2,vpal[x].g<<2,vpal[x].b<<2);
                }
                for (x=0;x<256;x++)
                {
                        spal[x].r=(pal[x+256]&31)<<1;
                        spal[x].g=((pal[x+256]>>5)&31)<<1;
                        spal[x].b=((pal[x+256]>>10)&31)<<1;
                        slook[x]=makecol(spal[x].r<<2,spal[x].g<<2,spal[x].b<<2);
                }
        }
        /*Do windows*/
        switch (lcd.ctrl&7)
        {
                case 0:
                hline(bx,64,l+64,304,tlook[0]);
//                for (pri=3;pri>=0;pri--)
//                {
                        for (c=3;c>=0;c--)
                        {
                                if (lcd.bgctrl[c]&0x40 && mosaicy) continue;
                                buf=vbuf[c];
                                if (!(lcd.ctrl&(0x100<<c)))
                                {
                                        for (x=0;x<248;x++) buf[x+64]=0x80000;
                                        continue;
                                }
//                                if ((lcd.bgctrl[c]&3)!=pri) continue;
                                if (disbg & (1<<c))
                                {
                                        for (x=0;x<248;x++) buf[x+64]=0x80000;
                                        continue;
                                }
                                pri=((lcd.bgctrl[c]&3)<<11)|0x400;
                                bgaddr=((lcd.bgctrl[c]>>8)&31)*2048;
                                chraddr=((lcd.bgctrl[c]>>2)&3)*16384;
                                xoff=64-(lcd.xscroll[c]&7);
                                yoff=lcd.yscroll[c]&7;
                                if (lcd.bgctrl[c]&0x80)
                                {
                                        for (x=0;x<248;x+=8)
                                        {
                                                /*if (lcd.bgctrl[c]&0x40) addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((lastmy+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                else                    */addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((l+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                tile=vramb[addr]|(vramb[addr+1]<<8);
                                                addr+=2;
                                                xf=(tile&0x400)?7:0;
                                                yf=(tile&0x800)?7:0;
                                                tile&=0x3FF;
                                                tile=((tile*64)+chraddr)&0xFFFF;
                                                /*if (lcd.bgctrl[c]&0x40) tile+=((((yoff+lastmy)&7)^yf)*8);
                                                else                    */tile+=((((yoff+l)&7)^yf)*8);
                                                for (xx=0;xx<8;xx++)
                                                {
                                                        if (vramb[tile]) buf[x+(xx^xf)+xoff]=vramb[tile]|pri;
                                                        else             buf[x+(xx^xf)+xoff]=0x80000;
                                                        tile++;
                                                }
                                        }
                                }
                                else
                                {
                                        for (x=0;x<248;x+=8)
                                        {
/*                                                if (lcd.bgctrl[c]&0x40) addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((lastmy+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                else                    */addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((l+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                tile=vramb[addr]|(vramb[addr+1]<<8);
                                                addr+=2;
                                                xf=(tile&0x400)?7:0;
                                                yf=(tile&0x800)?7:0;
                                                col=(tile>>8)&0xF0;
                                                tile&=0x3FF;
                                                tile=((tile*32)+chraddr)&0xFFFF;
/*                                                if (lcd.bgctrl[c]&0x40) tile+=((((yoff+lastmy)&7)^yf)*4);
                                                else                    */tile+=((((yoff+l)&7)^yf)*4);
                                                for (xx=0;xx<8;xx+=2)
                                                {
                                                        if (vramb[tile]&0xF) buf[x+(xx^xf)+xoff]=(vramb[tile]&0xF)|col|pri;
                                                        else                 buf[x+(xx^xf)+xoff]=0x80000;
                                                        if (vramb[tile]>>4)  buf[x+((xx+1)^xf)+xoff]=(vramb[tile]>>4)|col|pri;
                                                        else                 buf[x+((xx+1)^xf)+xoff]=0x80000;
                                                        tile++;
                                                }
                                        }
                                }
                        }
                break;
                case 1:
                                        if (!l) rotozoom.bg2x=lcd.bg2x;
                                        if (!l) rotozoom.bg2y=lcd.bg2y;

//                hline(bx,64,l+64,304,tlook[0]);
//                for (pri=3;pri>=0;pri--)
//                {
                        for (c=2;c>=0;c--)
                        {
                                if (lcd.bgctrl[c]&0x40 && mosaicy) continue;
                                buf=vbuf[c];
                                pri=((lcd.bgctrl[c]&3)<<11)|0x400;
                                if (!(lcd.ctrl&(0x100<<c)))
                                {
                                        for (x=0;x<248;x++) buf[x+64]=0x80000;
                                        continue;
                                }
//                                if ((lcd.bgctrl[c]&3)!=pri) continue;
                                if (disbg & (1<<c))
                                {
                                        for (x=0;x<248;x++) buf[x+64]=0x80000;
                                        continue;
                                }
                                bgaddr=((lcd.bgctrl[c]>>8)&31)*2048;
                                chraddr=((lcd.bgctrl[c]>>2)&3)*16384;
                                if (c==2)
                                {
                                        bgaddr=((lcd.bgctrl[c]>>8)&31)*2048;
                                        chraddr=((lcd.bgctrl[c]>>2)&3)*16384;
                                        xx=rotozoom.bg2x; yy=rotozoom.bg2y;
//                                        if (xx&0x08000000) xx|=0xF0000000;
//                                        if (yy&0x08000000) yy|=0xF0000000;
                                        if (lcd.bgctrl[2]&0x2000)
                                        {
                                                for (x=0;x<240;x++)
                                                {
                                                        addr=bgaddr+((ylookup2[lcd.bgctrl[c]>>14][(yy>>11)&127]+xlookup2[lcd.bgctrl[c]>>14][(xx>>11)&127]));
                                                        tile=((vramb[addr]*64)+chraddr+((xx>>8)&7)+(((yy>>8)&7)*8))&0xFFFF;
                                                        if (vramb[tile]) buf[x+64]=vramb[tile]|pri;
                                                        else             buf[x+64]=0x80000;
                                                        xx+=lcd.dx[0];
                                                        yy+=lcd.dy[0];
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<240;x++)
                                                {
                                                        addr=bgaddr+((ylookup2[lcd.bgctrl[c]>>14][(yy>>11)&127]+xlookup2[lcd.bgctrl[c]>>14][(xx>>11)&127]));
                                                        tile=((vramb[addr]*64)+chraddr+((xx>>8)&7)+(((yy>>8)&7)*8))&0xFFFF;
                                                        if (vramb[tile]) buf[x+64]=vramb[tile]|pri;
                                                        else             buf[x+64]=0x80000;
                                                        if (xx>bgsize[lcd.bgctrl[c]>>14] || xx<0 || yy>bgsize[lcd.bgctrl[c]>>14] || yy<0) buf[x+64]=0x80000;
                                                        xx+=lcd.dx[0];
                                                        yy+=lcd.dy[0];
                                                }
                                        }
                                        rotozoom.bg2x+=lcd.dmx[0];
                                        rotozoom.bg2y+=lcd.dmy[0];
                                }
                                else
                                {
                                        xoff=64-(lcd.xscroll[c]&7);
                                        yoff=lcd.yscroll[c]&7;
                                        if (lcd.bgctrl[c]&0x80)
                                        {
                                                for (x=0;x<248;x+=8)
                                                {
/*                                                        if (lcd.bgctrl[c]&0x40) addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((lastmy+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                        else                    */addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((l+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                        tile=vramb[addr]|(vramb[addr+1]<<8);
                                                        addr+=2;
                                                        xf=(tile&0x400)?7:0;
                                                        yf=(tile&0x800)?7:0;
                                                        tile&=0x3FF;
                                                        tile=((tile*64)+chraddr)&0xFFFF;
/*                                                        if (lcd.bgctrl[c]&0x40) tile+=((((yoff+lastmy)&7)^yf)*8);
                                                        else                    */tile+=((((yoff+l)&7)^yf)*8);
                                                        for (xx=0;xx<8;xx++)
                                                        {
                                                                if (vramb[tile]) buf[x+(xx^xf)+xoff]=vramb[tile]|pri;
                                                                else             buf[x+(xx^xf)+xoff]=0x80000;
                                                                tile++;
                                                        }
                                                }
                                        }
                                        else
                                        {
                                                for (x=0;x<248;x+=8)
                                                {
/*                                                        if (lcd.bgctrl[c]&0x40) addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((lastmy+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                        else                    */addr=bgaddr+((ylookup[lcd.bgctrl[c]>>14][((l+lcd.yscroll[c])>>3)&63]+xlookup[(lcd.bgctrl[c]>>14)&1][((x+lcd.xscroll[c])>>3)&63])<<1);
                                                        tile=vramb[addr]|(vramb[addr+1]<<8);
                                                        addr+=2;
                                                        xf=(tile&0x400)?7:0;
                                                        yf=(tile&0x800)?7:0;
                                                        col=(tile>>8)&0xF0;
                                                        tile&=0x3FF;
                                                        tile=((tile*32)+chraddr)&0xFFFF;
/*                                                        if (lcd.bgctrl[c]&0x40) tile+=((((yoff+lastmy)&7)^yf)*4);
                                                        else                    */tile+=((((yoff+l)&7)^yf)*4);
                                                        for (xx=0;xx<8;xx+=2)
                                                        {
                                                                if (vramb[tile]&0xF) buf[x+(xx^xf)+xoff]=(vramb[tile]&0xF)|col|pri;
                                                                else                 buf[x+(xx^xf)+xoff]=0x80000;
                                                                if (vramb[tile]>>4)  buf[x+((xx+1)^xf)+xoff]=(vramb[tile]>>4)|col|pri;
                                                                else                 buf[x+((xx+1)^xf)+xoff]=0x80000;
                                                                tile++;
                                                        }
                                                }
                                        }
                                }
                        }
//                        drawspritesline(pri,l,bx->line[l+64]);
//                }
                break;
                case 2:
//                hline(bx,64,l+64,304,tlook[0]);
//                for (pri=3;pri>=0;pri--)
//                {
                        for (c=3;c>=2;c--)
                        {
                                if (lcd.bgctrl[c]&0x40 && mosaicy) continue;
                                buf=vbuf[c];
                                pri=((lcd.bgctrl[c]&3)<<11)|0x400;
                                if (!(lcd.ctrl&(0x100<<c)))
                                {
                                        for (x=0;x<248;x++) buf[x+64]=0x80000;
                                        continue;
                                }
//                                if ((lcd.bgctrl[c]&3)!=pri) continue;
                                if (disbg & (1<<c))
                                {
                                        for (x=0;x<248;x++) buf[x+64]=0x80000;
                                        continue;
                                }
                                bgaddr=((lcd.bgctrl[c]>>8)&31)*2048;
                                chraddr=((lcd.bgctrl[c]>>2)&3)*16384;
                                size=lcd.bgctrl[c]>>14;
                                if (c==2)
                                {
                                        bgaddr=((lcd.bgctrl[c]>>8)&31)*2048;
                                        chraddr=((lcd.bgctrl[c]>>2)&3)*16384;
                                        if (!l) rotozoom.bg2x=lcd.bg2x;
                                        if (!l) rotozoom.bg2y=lcd.bg2y;
                                        xx=rotozoom.bg2x; yy=rotozoom.bg2y;
                                        for (x=0;x<240;x++)
                                        {
                                                addr=bgaddr+((ylookup2[size][(yy>>11)&127]+xlookup2[size][(xx>>11)&127]));
                                                tile=((vramb[addr]*64)+chraddr+((xx>>8)&7)+(((yy>>8)&7)*8))&0xFFFF;
                                                if (vramb[tile]) buf[x+64]=vramb[tile]|pri;
                                                else             buf[x+64]=0x80000;
                                                xx+=lcd.dx[0];
                                                yy+=lcd.dy[0];
                                        }
                                        rotozoom.bg2x+=lcd.dmx[0];
                                        rotozoom.bg2y+=lcd.dmy[0];
                                }
                                else
                                {
                                        bgaddr=((lcd.bgctrl[c]>>8)&31)*2048;
                                        chraddr=((lcd.bgctrl[c]>>2)&3)*16384;
                                        if (!l) rotozoom.bg3x=lcd.bg3x;
                                        if (!l) rotozoom.bg3y=lcd.bg3y;
                                        xx=rotozoom.bg3x; yy=rotozoom.bg3y;
                                        for (x=0;x<240;x++)
                                        {
                                                addr=bgaddr+((ylookup2[size][(yy>>11)&127]+xlookup2[size][(xx>>11)&127]));
                                                tile=((vramb[addr]*64)+chraddr+((xx>>8)&7)+(((yy>>8)&7)*8))&0xFFFF;
                                                if (vramb[tile]) buf[x+64]=vramb[tile]|pri;
                                                else             buf[x+64]=0x80000;
                                                xx+=lcd.dx[1];
                                                yy+=lcd.dy[1];
                                        }
//                                        if (!l) printf("Xlookup %i %i %i %i\n",size,xlookup2[1][0],xlookup2[1][8],xlookup2[1][15]);
                                        rotozoom.bg3x+=lcd.dmx[1];
                                        rotozoom.bg3y+=lcd.dmy[1];
                                }
                        }
//                        drawspritesline(pri,l,bx->line[l+64]);
//                }
                break;
                case 3:
                if (lcd.bgctrl[0]&0x40 && mosaicy) break;
                hline(bx,64,l+64,304,tlook[0]);
/*                if (lcd.bgctrl[0]&0x40) addr=lastmy*240;
                else                    */addr=l*240;
                for (x=0;x<240;x++)
                {
                        if (vramw[addr]) ((unsigned short *)bx->line[l+64])[x+64]=look15[vramw[addr]];
                        addr++;
                }
//                drawspritesline(3,l,bx->line[l+64]);
//                drawspritesline(2,l,bx->line[l+64]);
//                drawspritesline(1,l,bx->line[l+64]);
//                drawspritesline(0,l,bx->line[l+64]);
                break;
                case 4:
                if (lcd.bgctrl[0]&0x40 && mosaicy) break;
/*                if (lcd.bgctrl[0]&0x40) addr=lastmy*240;
                else                    */addr=l*240;
                if (lcd.ctrl&0x10) addr+=0xA000;
                pri=((lcd.bgctrl[2]&3)<<11)|0x400;
                for (x=0;x<240;x++) vbuf[0][x+64]=vbuf[1][x+64]=vbuf[3][x+64]=0x80000;
                if (disbg&0x04)
                {
                        for (x=0;x<240;x++) vbuf[2][x+64]=0x80000;
                        addr+=240;
                }
                else
                {
                        for (x=0;x<240;x++)
                        {
                                if (vramb[addr]) vbuf[2][x+64]=vramb[addr]|pri;//((unsigned short *)bx->line[l+64])[x+64]=tlook[vramb[addr]];
                                else             vbuf[2][x+64]=0x80000;
                                addr++;
                        }
                }
                break;
                case 5:
                if (lcd.bgctrl[0]&0x40 && mosaicy) break;
                hline(bx,64,l+64,304,tlook[0]);
                if (l>=16 && l<144)
                {
/*                        if (lcd.bgctrl[0]&0x40) addr=(lastmy-16)*160;
                        else                    */addr=(l-16)*160;
                        if (lcd.ctrl&0x10) addr+=0xA000;
                        addr>>=1;
                        for (x=0;x<160;x++)
                        {
                                if (vramw[addr]) ((unsigned short *)bx->line[l+64])[x+64]=look15[vramw[addr]];
                                addr++;
                        }
                }
//                drawspritesline(3,l,bx->line[l+64]);
//                drawspritesline(2,l,bx->line[l+64]);
//                drawspritesline(1,l,bx->line[l+64]);
//                drawspritesline(0,l,bx->line[l+64]);
                break;
                default:
                hline(bx,64,l+64,304,tlook[0]);
//                drawspritesline(3,l,bx->line[l+64]);
//                drawspritesline(2,l,bx->line[l+64]);
//                drawspritesline(1,l,bx->line[l+64]);
//                drawspritesline(0,l,bx->line[l+64]);
                break;
        }
//        if (!l) printf("%i\n",xlookup2[1][8]);

                        for (x=0;x<248;x++) vbuf[4][x+64]=0x80000;
                        drawspritesline2(l,vbuf[4]);

        if (lcd.ctrl&0xE000)
        {
                for (x=0;x<240;x++) window[x+64]=lcd.winout&63;
                if (lcd.ctrl&0x8000)
                {
                        for (x=0;x<240;x++)
                        {
//                                if (!l && !x) printf("LCD WINOUT %04X\n",lcd.winout);
                                if (objwind[x+64]) window[x+64]=(lcd.winout>>8)&63;
                        }
                }
                                //printf("l %i\n",l);
                if (lcd.ctrl&0x4000)
                {
                        for (x=0;x<240;x++)
                        {
                                if (x>=windows.x1[1] && x<windows.x2[1] && l>=windows.y1[1] && l<windows.y2[1])
                                {
//                                        if (x==128) printf("Here! %i\n",l);
                                        window[x+64]=(lcd.winin>>8)&63;
                                }
//                                if (x==128) printf("Window %04X %i  %i\n",window[x+64],l,windows.y2[1]);
                        }
                }
                if (lcd.ctrl&0x2000)
                {
                        for (x=0;x<240;x++)
                        {
                                if (x>=windows.x1[0] && x<windows.x2[0] && l>=windows.y1[0] && l<windows.y2[0]) window[x+64]=lcd.winin&63;
                        }
                }
/*                printf("Windows! %i,%i - %i,%i  %i,%i - %i,%i %04X\n",windows.x1[0],windows.y1[0],windows.x2[0],windows.y2[0],
                                                                      windows.x1[1],windows.y1[1],windows.x2[1],windows.y2[1],lcd.ctrl);*/
//                for (x=0;x<240;x++) window[x+64]=63;
        }
        else
        {
                for (x=0;x<240;x++) window[x+64]=63;
        }
        
        if (mosaicy) mosaicy--;
        else
        {
                mosaicy=(lcd.mosaic>>4)&0xF;
                lastmy=l;
        }

                hline(bx,64,l+64,304,tlook[0]);
/*                for (x=64;x<304;x++)
                {
                        ((unsigned short *)bx2[0]->line[l+64])[x]=(window[x])?0xFFFF:0;
                }*/
/*                for (x=64;x<304;x++)
                {
                        ((unsigned short *)bx2[1]->line[l+64])[x]=(window[x]&16)?0xFFFF:0;//tlook[vbuf[2][x]&0xFF];
                }
                for (x=64;x<304;x++)
                {
                        ((unsigned short *)bx2[2]->line[l+64])[x]=tlook[vbuf[3][x]&0xFF];
                }*/
//                if (l==63) printf("Wind - %02X %02X %05X %05X %05X\n",window[64],window[43+64],vbuf[2][43+64],vbuf[3][43+64],vbuf[4][43+64]);
                mosaicx=0;
//                if (l) rpclog("Mosaic %02X %02X %02X %02X %02X\n",lcd.mosaic,lcd.bgctrl[0]&0x40,lcd.bgctrl[1]&0x40,lcd.bgctrl[2]&0x40,lcd.bgctrl[3]&0x40);
                for (x=64;x<304;x++)
                {
                        col=0x80000;
                        top=0x20;
                        if (!(lcd.bgctrl[0]&0x40)) vcol[0]=vbuf[0][x];
                        if (!(lcd.bgctrl[1]&0x40)) vcol[1]=vbuf[1][x];
                        if (!(lcd.bgctrl[2]&0x40)) vcol[2]=vbuf[2][x];
                        if (!(lcd.bgctrl[3]&0x40)) vcol[3]=vbuf[3][x];
                        vcol[4]=vbuf[4][x];
                        if (!mosaicx)
                        {
                                vcol[0]=vbuf[0][x];
                                vcol[1]=vbuf[1][x];
                                vcol[2]=vbuf[2][x];
                                vcol[3]=vbuf[3][x];
                                mosaicx=lcd.mosaic&0xF;
                        }
                        else mosaicx--;
                        if ((vcol[0]>>10)<(col>>10) && window[x]&1) { col=vcol[0]; top=0x01; }
                        if ((vcol[1]>>10)<(col>>10) && window[x]&2) { col=vcol[1]; top=0x02; }
                        if ((vcol[2]>>10)<(col>>10) && window[x]&4) { col=vcol[2]; top=0x04; }
                        if ((vcol[3]>>10)<(col>>10) && window[x]&8) { col=vcol[3]; top=0x08; }
                        if ((vcol[4]>>10)<(col>>10) && window[x]&16) { col=vcol[4]; top=0x10; }//if (col&0x200) window[x]=(lcd.winout>>8)&63; }
//                        if (l==0 && x==64) printf("192,16 - %04X %02X ",col,top);
                        if (!(col&0x100))
                        {
//                                if (l==0 && x==64) printf(" %02X %02X %i ",gba.blend,gba.blend&0xC0,window[x]&32);
                                if (top&gba.blend && (gba.blend&0xC0) && (window[x]&32))
                                {
                                        switch (gba.blend&0xC0)
                                        {
                                                case 0x40:
                                                if (top&0x10) { r.r=spal[col&0xFF].r; r.g=spal[col&0xFF].g; r.b=spal[col&0xFF].b; }
                                                else          { r.r=vpal[col&0xFF].r; r.g=vpal[col&0xFF].g; r.b=vpal[col&0xFF].b; }
                                                col2=col;
                                                col=0x80000;
                                                top2=0x20;
                                                if ((vcol[0]>>10)<(col>>10) && top!=0x01 && window[x]&1) { col=vcol[0]; top2=0x01; }
                                                if ((vcol[1]>>10)<(col>>10) && top!=0x02 && window[x]&2) { col=vcol[1]; top2=0x02; }
                                                if ((vcol[2]>>10)<(col>>10) && top!=0x04 && window[x]&4) { col=vcol[2]; top2=0x04; }
                                                if ((vcol[3]>>10)<(col>>10) && top!=0x08 && window[x]&8) { col=vcol[3]; top2=0x08; }
                                                if ((vcol[4]>>10)<(col>>10) && top!=0x10 && window[x]&16) { col=vcol[4]; top2=0x10; }
//                                                if (l==0 && x==64) printf(" %04X %02X ",col,top2);
                                                if (top2&(gba.blend>>8))
                                                {
                                                        if (top2&0x10) { r2.r=spal[col&0xFF].r; r2.g=spal[col&0xFF].g; r2.b=spal[col&0xFF].b; }
                                                        else           { r2.r=vpal[col&0xFF].r; r2.g=vpal[col&0xFF].g; r2.b=vpal[col&0xFF].b; }
//                                                        r2.r=r2.g=r2.b=0;
//                                                        if (l==16 && x==192) printf(" %i,%i,%i %i,%i,%i  %i %i ",r.r,r.g,r.b,r2.r,r2.g,r2.b,gba.bl1,gba.bl2);
                                                        r.r=bllookup[gba.bl1][r.r]+bllookup[gba.bl2][r2.r]; if (r.r>255) r.r=255;
                                                        r.g=bllookup[gba.bl1][r.g]+bllookup[gba.bl2][r2.g]; if (r.g>255) r.g=255;
                                                        r.b=bllookup[gba.bl1][r.b]+bllookup[gba.bl2][r2.b]; if (r.b>255) r.b=255;
//                                                        if (l==16 && x==192) printf("%i,%i,%i ",r.r,r.g,r.b);
                                                        ((unsigned short *)bx->line[l+64])[x]=makecol(r.r,r.g,r.b);
//                                                        if (l==16 && x==192) printf("RGB %04X %04X\n",((unsigned short *)bx->line[l+64])[x],makecol(r.r,r.g,r.b));
                                                }
                                                else
                                                {
//                                                        if (l==0 && x==64) printf("bollocks");
                                                        if (top&0x10) ((unsigned short *)bx->line[l+64])[x]=slook[col2&0xFF];
                                                        else          ((unsigned short *)bx->line[l+64])[x]=tlook[col2&0xFF];
                                                }
                                                break;
                                                case 0x80:
                                                if (top&0x10) { r.r=spal[col&0xFF].r<<2; r.g=spal[col&0xFF].g<<2; r.b=spal[col&0xFF].b<<2; }
                                                else          { r.r=vpal[col&0xFF].r<<2; r.g=vpal[col&0xFF].g<<2; r.b=vpal[col&0xFF].b<<2; }
                                                r.r=r.r+(((255-r.r)*gba.br)/16); if (r.r>255) r.r=255;
                                                r.g=r.g+(((255-r.g)*gba.br)/16); if (r.g>255) r.g=255;
                                                r.b=r.b+(((255-r.b)*gba.br)/16); if (r.b>255) r.b=255;
                                                ((unsigned short *)bx->line[l+64])[x]=makecol(r.r,r.g,r.b);
                                                break;
                                                case 0xC0:
                                                if (top&0x10) { r.r=spal[col&0xFF].r<<2; r.g=spal[col&0xFF].g<<2; r.b=spal[col&0xFF].b<<2; }
                                                else          { r.r=vpal[col&0xFF].r<<2; r.g=vpal[col&0xFF].g<<2; r.b=vpal[col&0xFF].b<<2; }
                                                r.r=r.r-((r.r*gba.br)/16); if (r.r<0) r.r=0;
                                                r.g=r.g-((r.g*gba.br)/16); if (r.g<0) r.g=0;
                                                r.b=r.b-((r.b*gba.br)/16); if (r.b<0) r.b=0;
                                                ((unsigned short *)bx->line[l+64])[x]=makecol(r.r,r.g,r.b);
                                                break;
                                        }
                                }
                                else
                                {
                                        if (top&0x10) ((unsigned short *)bx->line[l+64])[x]=slook[col&0xFF];
                                        else          ((unsigned short *)bx->line[l+64])[x]=tlook[col&0xFF];
                                }
                        }
                        else
                        {
                                col2=col;
                                r.r=spal[col&0xFF].r; r.g=spal[col&0xFF].g; r.b=spal[col&0xFF].b;
                                top2=0x20;
                                col=0x80000;
                                if ((vcol[0]>>10)<(col>>10)) { col=vcol[0]; top2=0x01; }
                                if ((vcol[1]>>10)<(col>>10)) { col=vcol[1]; top2=0x02; }
                                if ((vcol[2]>>10)<(col>>10)) { col=vcol[2]; top2=0x04; }
                                if ((vcol[3]>>10)<(col>>10)) { col=vcol[3]; top2=0x08; }
                                r2.r=vpal[col&0xFF].r; r2.g=vpal[col&0xFF].g; r2.b=vpal[col&0xFF].b;
//                                if (l==16 && x==192) printf("%02X %04X ",top2,col);
                                if (top2&(gba.blend>>8))
                                {
                                        r.r=bllookup[gba.bl1][r.r]+bllookup[gba.bl2][r2.r]; if (r.r>255) r.r=255;
                                        r.g=bllookup[gba.bl1][r.g]+bllookup[gba.bl2][r2.g]; if (r.g>255) r.g=255;
                                        r.b=bllookup[gba.bl1][r.b]+bllookup[gba.bl2][r2.b]; if (r.b>255) r.b=255;
                                        ((unsigned short *)bx->line[l+64])[x]=makecol(r.r,r.g,r.b);
                                }
                                else
                                {
                                        if (top&0x10) ((unsigned short *)bx->line[l+64])[x]=slook[col2&0xFF];
                                        else          ((unsigned short *)bx->line[l+64])[x]=tlook[col2&0xFF];
                                }
                        }
//                        if (l==0 && x==64) printf("\n");
                }

        if (l==159)
        {
//                printf("IT's %04X  ",((unsigned short *)bx->line[16+64])[192]);
//                printf("%08X\n",getpixel(vb,16,128));
/*                blit(vb,screen,0,0,0,0,240,160);
                blit(bx2[0],vb,64,64,0,0,240,160);
                blit(vb,screen,0,0,240,0,240,160);*/
/*                blit(bx2[1],vb,64,64,0,0,240,160);
                blit(vb,screen,0,0,0,160,240,160);
                blit(bx2[2],vb,64,64,0,0,240,160);
                blit(vb,screen,0,0,240,160,240,160);*/
                startblit();
                if (scale<0x80)
                {
                        blit(bx,vb,64,64,0,0,240,160);
                        if (scale==1) blit(vb,screen,0,0,0,0,240,160);
                        else          stretch_blit(vb,screen,0,0,240,160,0,0,240*scale,160*scale);
                }
                else
                {
                        switch (scale)
                        {
                                case 0x80: /*Super 2xSaI*/
                                Super2xSaI(bx,bx2x,64,64,0,0,240,160);
                                blit(bx2x,vb,0,0,0,0,480,320);
                                blit(vb,screen,0,0,0,0,480,320);
                                break;
                                case 0x81: /*Super Eagle*/
                                SuperEagle(bx,bx2x,64,64,0,0,240,160);
                                blit(bx2x,vb,0,0,0,0,480,320);
                                blit(vb,screen,0,0,0,0,480,320);
                                break;
                        }
                }
                endblit();
        }
}

void sprdraw()
{
        int x,y,xx,yy;
        int addr;
        for (y=0;y<32;y++)
        {
                for (x=0;x<8;x++)
                {
                        addr=0x10000+(y*1024)+(x*64);
                        for (yy=0;yy<8;yy++)
                        {
                                for (xx=0;xx<8;xx++)
                                {
                                        ((unsigned short *)bx->line[(y<<3)+yy])[(x<<3)+xx]=tlook[vramb[addr]];
                                        addr++;
                                }
                        }
                }
        }
        blit(bx,screen,0,0,0,0,128,256);
        while (!key[KEY_F1]) sleep(10);
}
