#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "mem.h"
#include "arm.h"
#include "gba.h"

int disbg;
int frames;
//int output;
FILE *rlog;
void rpclog(char *format, ...)
{
   char buf[1024];
   return;
   if (!rlog) rlog=fopen("arclog.txt","wt");
//turn;
   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
   fputs(buf,rlog);
   fflush(rlog);
//   printf("%s",buf);
}

void error(char *format, ...)
{
   char buf[256];
   va_list ap;
   va_start(ap, format);
   vsprintf(buf, format, ap);
   va_end(ap);
        printf("Error : %s\n",buf);
        fflush(stdout);
}

unsigned short readkeystat()
{
        unsigned short temp=0x3FF;
        if (key[KEY_Z])       temp&=~1;
        if (key[KEY_X])       temp&=~2;
        if (key[KEY_0_PAD])   temp&=~1;
        if (key[KEY_DEL_PAD]) temp&=~2;
        if (key[KEY_RSHIFT])  temp&=~4;
        if (key[KEY_ENTER])   temp&=~8;
        if (key[KEY_RIGHT])   temp&=~0x10;
        if (key[KEY_LEFT])    temp&=~0x20;
        if (key[KEY_UP])      temp&=~0x40;
        if (key[KEY_DOWN])    temp&=~0x80;
        if (key[KEY_S])       temp&=~0x100;
        if (key[KEY_A])       temp&=~0x200;
//        if (!(temp&8)) output=1;
        return temp;
}

int fps,frames,updatefps;
void onesec()
{
        fps=frames;
        frames=0;
        updatefps=1;
}

int ins,lastins=0;
int inssec=0;

int drawit=0;
void oneframe()
{
        drawit++;
//        printf("Drawit %i\n",drawit);
}

signed short blank[2048*3];

char savname[1024];

void initgba()
{
        frames=0;
        initalmain(NULL, 0);
        memset(blank,0,2048*3);
        //getromname();
        initmem();
        //loadrom();
        //scaneeprom();
        //scanother();
        resetarm();
        initvideo();
        initeeprom();
        //replace_extension(savname,romname,"sav",1023);
        //loadeeprom(savname);
        install_keyboard();
        install_timer();
        install_int_ex(onesec,MSEC_TO_TIMER(1000));
        install_int_ex(oneframe,BPS_TO_TIMER(60));
        initsound();
}

void loadgba()
{
        getromname();
        loadrom();
        scaneeprom();
        scanother();
        initeeprom();
        replace_extension(savname,romname,"sav",1023);
        loadeeprom(savname);
        resetarm();
        
        memset(&gba,0,sizeof(gba));
        memset(&lcd,0,sizeof(lcd));
        memset(&windows,0,sizeof(windows));
        memset(&dma,0,sizeof(dma));
        memset(&timers,0,sizeof(timers));
        memset(&sound,0,sizeof(sound));
        
        memset(ram,0,32*1024);
        memset(ram2,0,256*1024);
        memset(vram,0,96*1024);
        rpclog("PC now %08X\n",PC);
}

void resetgba()
{
        resetarm();
}

void endgba()
{
        int c,d=0;
/*        output=1;
//        for (d=0;d<10;d++)
//        {
                                for (c=0;c<228;c++)
                        {
                                printf("Line %i,%i\n",c,d);
                                execarm(218);
                                clearhblank();
                                execarm(395);
                                clocktimers();
                                pollsound();
                                execarm(613);
                                clockhblank();
                                clocktimers();
                                hblankdma();
//                                drawline(c);
                                pollsound();
                        }
//        }*/

        saveeeprom(savname);
}

void rungba()
{
        int c;
        static int d;
        char s[256];
                if (drawit>0 || key[KEY_TILDE])
                {
                        if (drawit>0) drawit--;
                        for (c=0;c<228;c++)
                        {
                                execarm(218);
                                clearhblank();
                                execarm(395);
                                clocktimers();
                                pollsound();
                                execarm(613);
                                clockhblank();
                                clocktimers();
                                hblankdma();
//                                drawline(c);
                                pollsound();
                        }
//                        printf("PC %08X %i %i %i\n",PC,ins,rinscount,inscount);
                        frames++;
                        if (updatefps)
                        {
                                sprintf(s,"reasonableGBA v0.2 - %i fps %f MIPS",fps,(float)inssec/1000000.0);
                                set_window_title(s);
                                updatefps=0;
                        }
                        d++;
                        if (d>=60)
                        {
                                d=0;
                                inssec=ins-lastins;
                                lastins=ins;
                                updatefps=1;
//                                printf("Sound freq - A %ihz B %ihz  %02X %02X %02X %02X\n",soundaclocks,soundbclocks,dma[0].dst,dma[1].dst,dma[2].dst,dma[3].dst);
                                soundaclocks=soundbclocks=0;
                        }
                }
                else sleep(1);
//                if (!drawit && !key[KEY_TILDE]) sleep(0);
                if (key[KEY_1])
                {
                        while (key[KEY_1]) sleep(1);
                        disbg^=1;
                }
                if (key[KEY_2])
                {
                        while (key[KEY_2]) sleep(1);
                        disbg^=2;
                }
                if (key[KEY_3])
                {
                        while (key[KEY_3]) sleep(1);
                        disbg^=4;
                }
                if (key[KEY_4])
                {
                        while (key[KEY_4]) sleep(1);
                        disbg^=8;
                }
                if (key[KEY_5])
                {
                        while (key[KEY_5]) sleep(1);
                        disbg^=0x10;
                }
                if (key[KEY_6])
                {
                        while (key[KEY_6]) sleep(1);
                        disbg=0;
                }
                if (key[KEY_F2])
                {
                        while (key[KEY_F2]) sleep(1);
                        sprdraw();
                }
}

/*
int main(int argc, char *argv[])
{
        int c,d=0;
        char s[256];
        frames=0;
        initalmain(&argc, argv);
        memset(blank,0,2048*3);
        getromname();
        initmem();
        loadrom();
        scaneeprom();
        scanother();
        resetarm();
        initvideo();
        initeeprom();
        replace_extension(savname,romname,"sav",1023);
        loadeeprom(savname);
        install_keyboard();
        install_timer();
        install_int_ex(onesec,MSEC_TO_TIMER(1000));
        install_int_ex(oneframe,BPS_TO_TIMER(60));
        initsound();
        while (!key[KEY_ESC])// && !output)
        {
                if (drawit>0 || key[KEY_TILDE])
                {
                        if (drawit>0) drawit--;
                        for (c=0;c<228;c++)
                        {
                                execarm(218);
                                clearhblank();
                                execarm(395);
                                clocktimers();
                                pollsound();
                                execarm(613);
                                clockhblank();
                                clocktimers();
                                hblankdma();
//                                drawline(c);
                                pollsound();
                        }
//                        printf("PC %08X %i %i %i\n",PC,ins,rinscount,inscount);
                        frames++;
                        if (updatefps)
                        {
                                sprintf(s,"GBA - %i fps %f MIPS",fps,(float)inssec/1000000.0);
                                set_window_title(s);
                                updatefps=0;
                        }
                        d++;
                        if (d==60)
                        {
                                d=0;
                                inssec=ins-lastins;
                                lastins=ins;
                                updatefps=1;
                                printf("Sound freq - A %ihz B %ihz  %02X %02X %02X %02X\n",soundaclocks,soundbclocks,dma[0].dst,dma[1].dst,dma[2].dst,dma[3].dst);
                                soundaclocks=soundbclocks=0;
                        }
                }
                if (!drawit && !key[KEY_TILDE]) sleep(0);
                if (key[KEY_1])
                {
                        while (key[KEY_1]) sleep(1);
                        disbg^=1;
                }
                if (key[KEY_2])
                {
                        while (key[KEY_2]) sleep(1);
                        disbg^=2;
                }
                if (key[KEY_3])
                {
                        while (key[KEY_3]) sleep(1);
                        disbg^=4;
                }
                if (key[KEY_4])
                {
                        while (key[KEY_4]) sleep(1);
                        disbg^=8;
                }
                if (key[KEY_5])
                {
                        while (key[KEY_5]) sleep(1);
                        disbg^=0x10;
                }
                if (key[KEY_6])
                {
                        while (key[KEY_6]) sleep(1);
                        disbg=0;
                }
                if (key[KEY_F2])
                {
                        while (key[KEY_F2]) sleep(1);
                        sprdraw();
                }

        }
        saveeeprom(savname);
        dumpregs();
        printf("If were to save, savelen %i\n",savelen);
        return 0;
}

END_OF_MAIN()*/
