#include <stdint.h>
#include "gba.h"
#include "mem.h"

unsigned char eeprom[65536*2];

void writesram(unsigned long addr, unsigned char val)
{
//        printf("Write SRAM %08X %02X\n",addr,val);
        eeprom[(addr)&0x1FFFF]=val;
        savechange=1;
//        printf("SRAM %08X %02X\n",addr,eeprom[(addr>>2)&0x7FFF]);
}

unsigned char readsram(unsigned long addr)
{
//        printf("Read SRAM %08X %02X\n",addr,eeprom[(addr>>2)&0x7FFF]);
        return eeprom[(addr)&0x1FFFF];
}
