﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Data;

namespace SilverlightSpecNix
{
    public partial class ProgressBar : UserControl
    {
        public static DependencyProperty ProgressProperty = DependencyProperty.Register("Progress",
            typeof(Double), typeof(ProgressBar), new PropertyMetadata(OnPropertyChanged));

        public Double Progress
        {
            get { return (Double)GetValue(ProgressProperty); }
            set 
            {
                if (value < 0) value = 0; else if (value > 1) value = 1;
                SetValue(ProgressProperty, value); 
            }
        }

        public ProgressBar()
        {
            InitializeComponent();

        }

        static void OnPropertyChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ProgressBar pb = (ProgressBar)d;
            if (e.Property == ProgressProperty)
            {
                pb.progressBarRectangle.Width = pb.Progress * pb.ActualWidth;
                pb.progressTextBlock.Text = string.Format("{0} %", ((int)(100 * pb.Progress)));
            }
        }
    }
}
