using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows;
#if XBOX360
using Properties = Emulation.Computers.ZxSpectrum360.Properties;
#endif


namespace Emulation.Computers.ZxSpectrum
{
    public sealed class Memory
    {
        private byte[] content = new byte[0x10000];

        public Memory()
        {
            //Cargamos la rom
            byte[] rom48K = null;
            using (BinaryReader reader =
                new BinaryReader(Application.GetResourceStream(new Uri("SilverlightSpecNix;component/Roms/zxs48.rom", UriKind.Relative)).Stream))
            {
                rom48K = reader.ReadBytes((int)reader.BaseStream.Length);
            }
            
            Buffer.BlockCopy(rom48K,
                0, content, 0, rom48K.Length);
        }

        public byte this[UInt16 address]
        {
            get 
            {
                return content[address]; 
            }
            set 
            {
                if (address > 0x3FFF)
                {
                    content[address] = value; 
                }
            }
        }
    }
}
