using System;
using System.Collections.Generic;
using System.Text;
using Emulation.Infrastructure;
using System.Windows;
using System.IO;
#if XBOX360
using Properties = Emulation.Computers.ZxSpectrum360.Properties;
#endif


namespace Emulation.Computers.ZxSpectrum
{
    public class Memory128: IMemory
    {
        private bool disablePaging;
        private bool shadowScreen;

        private int[] rom0 = new int[0x4000];
        private int[] rom1 = new int[0x4000];

        private int[] bank0 = new int[0x4000];
        private int[] bank1 = new int[0x4000];
        private int[] bank2 = new int[0x4000];
        private int[] bank3 = new int[0x4000];
        private int[] bank4 = new int[0x4000];
        private int[] bank5 = new int[0x4000];
        private int[] bank6 = new int[0x4000];
        private int[] bank7 = new int[0x4000];
        private int[][] banks = new int[8][];

        public int[][] memoryConfig = new int[4][];

        public Memory128()
        {
            byte[] rom128Bank0 = null;
            using (BinaryReader reader =
                new BinaryReader(Application.GetResourceStream(new Uri("SilverlightSpecNix;component/Roms/zxs128_0.rom", UriKind.Relative)).Stream))
            {
                rom128Bank0 = reader.ReadBytes((int)reader.BaseStream.Length);
            }
            byte[] rom128Bank1 = null;
            using (BinaryReader reader =
                new BinaryReader(Application.GetResourceStream(new Uri("SilverlightSpecNix;component/Roms/zxs128_1.rom", UriKind.Relative)).Stream))
            {
                rom128Bank1 = reader.ReadBytes((int)reader.BaseStream.Length);
            }

            //Cargamos la rom
            for (int i = 0; i < rom128Bank0.Length; ++i)
            {
                rom0[i] = rom128Bank0[i];
                rom1[i] = rom128Bank1[i];
            }
            //
            banks[0] = bank0;
            banks[1] = bank1;
            banks[2] = bank2;
            banks[3] = bank3;
            banks[4] = bank4;
            banks[5] = bank5;
            banks[6] = bank6;
            banks[7] = bank7;
            //Establecemos la configuracion inicial
            memoryConfig[0] = rom0;
            memoryConfig[1] = bank5;
            memoryConfig[2] = bank2;
            memoryConfig[3] = bank0;
        }

        internal int[] Rom0 { get { return rom0; } }
        internal int[] Rom1 { get { return rom1; } }
        internal int[] Bank0 { get { return bank0; } }
        internal int[] Bank1 { get { return bank1; } }
        internal int[] Bank2 { get { return bank2; } }
        internal int[] Bank3 { get { return bank3; } }
        internal int[] Bank4 { get { return bank4; } }
        internal int[] Bank5 { get { return bank5; } }
        internal int[] Bank6 { get { return bank6; } }
        internal int[] Bank7 { get { return bank7; } }

        public bool ShadowScreen
        {
            get { return shadowScreen; }
        }

        public void SetupBankConfig(int value)
        {
            if (disablePaging == false)
            {
                int c0Page = value & 0x07;
                shadowScreen = (value & 0x08) != 0;
                bool rom1 = (value & 0x10) != 0;
                disablePaging = (value & 0x20) != 0;
                if (disablePaging == true)
                    return;

                memoryConfig[3] = banks[c0Page];
                if (rom1 == false)
                    memoryConfig[0] = this.rom0;
                else
                    memoryConfig[0] = this.rom1;
            }

        }

        #region IMemory Members

        public int Length
        {
            get { return 0xFFFF; }
        }

        public int ReadByte(int address)
        {
            address &= 0xFFFF;
            int bank = address >> 14;
            address &= 0x3FFF;
            return memoryConfig[bank][address];
        }

        public int ReadWord(int address)
        {
            address &= 0xFFFF;
            int bank = address >> 14;
            address &= 0x3FFF;
            if (address != 0x3FFF)
                return (memoryConfig[bank][address + 1] << 8) | memoryConfig[bank][address];
            else if (bank != 3)
                return (memoryConfig[bank + 1][0] << 8) | memoryConfig[bank][address];
            else
                return (memoryConfig[0][0] << 8) | memoryConfig[bank][address];
        }

        public void WriteByte(int address, int value)
        {
            //Rom write does not success
            address &= 0xFFFF;
            if (address < 0x4000)
            {
                return;
#warning
            }
            int bank = address >> 14;
            address &= 0x3FFF;
            memoryConfig[bank][address] = value & 0xFF;
        }

        public void WriteWord(int address, int value)
        {
            //Rom write does not success
            address &= 0xFFFF;
            if (address < 0x4000)
            {
                return;
#warning
            }
            int bank = address >> 14;
            address &= 0x3FFF;
            if (address != 0x3FFF)
            {
                memoryConfig[bank][address] = value&0xFF;
                memoryConfig[bank][address+1] = (value>>8)&0xFF;                
            }
            else if (bank!=3)
            {
                memoryConfig[bank][address] = value&0xFF;
                memoryConfig[bank+1][0] = (value>>8)&0xFF;
            }
            else
            {
                memoryConfig[bank][address] = value & 0xFF;
                memoryConfig[0][0] = (value >> 8) & 0xFF;
            }
        }

        #endregion
    }
}
