using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Emulation.Infrastructure;
using Emulation.Cpu.Z80;

namespace Emulation.Computers.ZxSpectrum
{
    public class SnaLoader
    {
        public SnaLoader()
        {
        }

        public static void Load48(IMemory memory, Z80 z80, Stream stream)
        {
            try
            {
                BinaryReader reader = new BinaryReader(stream);

                z80.SetRegister(Z80Registers.I, reader.ReadByte());

                z80.SetRegister(Z80Registers.AltHL, reader.ReadUInt16());
                z80.SetRegister(Z80Registers.AltDE, reader.ReadUInt16());
                z80.SetRegister(Z80Registers.AltBC, reader.ReadUInt16());
                z80.SetRegister(Z80Registers.AltAF, reader.ReadUInt16());

                z80.SetRegister(Z80Registers.HL, reader.ReadUInt16());
                z80.SetRegister(Z80Registers.DE, reader.ReadUInt16());
                z80.SetRegister(Z80Registers.BC, reader.ReadUInt16());
                z80.SetRegister(Z80Registers.IY, reader.ReadUInt16());
                z80.SetRegister(Z80Registers.IX, reader.ReadUInt16());

                byte interrupt = reader.ReadByte();
                z80.SetRegister(Z80Registers.IFF2, interrupt & 0x04);

                z80.SetRegister(Z80Registers.R, reader.ReadByte());

                z80.SetRegister(Z80Registers.AF, reader.ReadUInt16());
                z80.SetRegister(Z80Registers.SP, reader.ReadUInt16());
                z80.SetRegister(Z80Registers.InterruptMode, reader.ReadByte());
#warning Implementar el color del borde
                reader.ReadByte();

                //Ram dump
                byte[] buffer = new byte[stream.Length];
                stream.Read(buffer, 0, buffer.Length);
                for (int i = 0; i < buffer.Length; ++i)
                {
                    memory.WriteByte(i + 0x4000, buffer[i]);
                }
            }
            catch (Exception ex)
            {
                throw new LoaderException("sna loader exception", ex); 
            }

        }

        /*public void Load(string fileName)
        {
            if (fileName == null)
                throw new ArgumentNullException();

            using (FileStream stream = File.Open(fileName, FileMode.Open))
            {
                Load48(stream);
            }
        }*/
        
        /*public void Load(Stream inputStream)
        {
            BinaryReader reader = new BinaryReader(inputStream);
        
            spectrum.Z80.Registers.I = reader.ReadByte();

            spectrum.Z80.Registers.HL_Alternate = reader.ReadUInt16();
            spectrum.Z80.Registers.DE_Alternate = reader.ReadUInt16();
            spectrum.Z80.Registers.BC_Alternate = reader.ReadUInt16();
            spectrum.Z80.Registers.AF_Alternate = reader.ReadUInt16();

            spectrum.Z80.Registers.HL = reader.ReadUInt16();
            spectrum.Z80.Registers.DE = reader.ReadUInt16();
            spectrum.Z80.Registers.BC = reader.ReadUInt16();
            spectrum.Z80.Registers.IY = reader.ReadUInt16();
            spectrum.Z80.Registers.IX = reader.ReadUInt16();

            byte interrupt = reader.ReadByte();
            spectrum.Z80.Registers.IFF2 = (interrupt & 0x4) != 0;
            spectrum.Z80.Registers.IFF1 = spectrum.Z80.Registers.IFF2;

            spectrum.Z80.Registers.R = reader.ReadByte();
            spectrum.Z80.Registers.AF = reader.ReadUInt16();
            spectrum.Z80.Registers.SP = reader.ReadUInt16();
            spectrum.Z80.Registers.InterruptMode = reader.ReadByte();

            reader.ReadByte();

            for (int i = 16384; i < 65536; ++i)
            {
                spectrum.Z80.Memory[(UInt16)i] = reader.ReadByte();
            }

            UInt16 pc = spectrum.Memory[spectrum.Z80.Registers.SP++];
            pc |= (UInt16)(spectrum.Memory[spectrum.Z80.Registers.SP++] << 8);
            spectrum.Memory[(UInt16)(spectrum.Z80.Registers.SP - 2)] = 0;
            spectrum.Memory[(UInt16)(spectrum.Z80.Registers.SP - 1)] = 0;
            spectrum.Z80.Registers.PC = pc;            
        }*/
    }
}
