using System;
using System.Collections.Generic;
using System.Text;

namespace Emulation.Cpu.Z80
{
	public sealed partial class Z80
	{
        private const int CF = 0x01;
        private const int NF = 0x02;
        private const int PF = 0x04;
        private const int VF = PF;
        private const int XF = 0x08;
        private const int HF = 0x10;
        private const int YF = 0x20;
        private const int ZF = 0x40;
        private const int SF = 0x80;
            
        /*private bool sf; //sign
        private bool zf; //zero
        private bool yf; //
        private bool hf; //half-carry
        private bool xf; //
        private bool pf; //parity
        private bool nf; //negative
        private bool cf; //carry

        public int F
        {
            get
            {
                return ((sf ? 1 : 0) << 7) | ((zf ? 1 : 0) << 6) | ((yf ? 1 : 0) << 5) | ((hf ? 1 : 0) << 4) | ((xf ? 1 : 0) << 3) | ((pf ? 1 : 0) << 2) | ((nf ? 1 : 0) << 1) | (cf ? 1 : 0);
            }
            set
            {
                sf = (value & 0x80) != 0;
                zf = (value & 0x40) != 0;
                yf = (value & 0x20) != 0;
                hf = (value & 0x10) != 0;
                xf = (value & 0x08) != 0;
                pf = (value & 0x04) != 0;
                nf = (value & 0x02) != 0;
                cf = (value & 0x01) != 0;
            }
        }*/

        internal int A, F, B, C, D, E, H, L;
        internal int AltA, AltF, AltB, AltC, AltD, AltE, AltH, AltL;
        internal int PC, IX, IY, I;
        internal int SP = int.MaxValue;
        internal int R, R7;
        internal bool IFF1, IFF2;
        internal int InterruptMode;

        internal int AF
        {
            get { return (A << 8) | F; }
            set { A = (value >> 8) & 0xFF; F = (value & 0xFF); }
        }

        internal int BC
        {
            get { return (B << 8) | C; }
            set { B = (value >> 8) & 0xFF; C = (value & 0xFF); }
        }

        internal int DE
        {
            get { return (D << 8) | E; }
            set { D = (value >> 8) & 0xFF; E = value & 0xFF; }
        }

        internal int HL
        {
            get { return (H << 8) | L; }
            set { H = (value >> 8) & 0xFF; L = value & 0xFF; }
        }

        internal int AltAF
        {
            get { return (AltA << 8) | AltF; }
            set { AltA = (value >> 8) & 0xFF; AltF = (value & 0xFF); }
        }

        internal int AltBC
        {
            get { return (AltB << 8) | AltC; }
            set { AltB = (value >> 8) & 0xFF; AltC = (value & 0xFF); }
        }

        internal int AltDE
        {
            get { return (AltD << 8) | AltE; }
            set { AltD = (value >> 8) & 0xFF; AltE = value & 0xFF; }
        }

        internal int AltHL
        {
            get { return (AltH << 8) | AltL; }
            set { AltH = (value >> 8) & 0xFF; AltL = value & 0xFF; }
        }
	}
}
